/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn;

import com.google.cloud.Timestamp;
import io.opencensus.common.Scope;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.ActionFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.DetectNewPartitionsAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.DaoFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.MapperFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.PartitionMetadataMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.DetectNewPartitionsRangeTracker;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.joda.time.Duration;
import org.joda.time.Instant;

@DoFn.UnboundedPerElement
public class DetectNewPartitionsDoFn
extends DoFn<PartitionMetadata, PartitionMetadata> {
    private static final long serialVersionUID = 1523712495885011374L;
    private static final Duration DEFAULT_RESUME_DURATION = Duration.millis((long)100L);
    private static final Tracer TRACER = Tracing.getTracer();
    private final Duration resumeDuration;
    private final DaoFactory daoFactory;
    private final MapperFactory mapperFactory;
    private final ActionFactory actionFactory;
    private final ChangeStreamMetrics metrics;
    private transient DetectNewPartitionsAction detectNewPartitionsAction;

    public DetectNewPartitionsDoFn(DaoFactory daoFactory, MapperFactory mapperFactory, ActionFactory actionFactory, ChangeStreamMetrics metrics) {
        this.daoFactory = daoFactory;
        this.mapperFactory = mapperFactory;
        this.actionFactory = actionFactory;
        this.metrics = metrics;
        this.resumeDuration = DEFAULT_RESUME_DURATION;
    }

    @DoFn.GetInitialWatermarkEstimatorState
    public Instant getInitialWatermarkEstimatorState(@DoFn.Element PartitionMetadata partition) {
        return new Instant((Object)partition.getStartTimestamp().toSqlTimestamp());
    }

    @DoFn.NewWatermarkEstimator
    public ManualWatermarkEstimator<Instant> newWatermarkEstimator(@DoFn.WatermarkEstimatorState Instant watermarkEstimatorState) {
        return new WatermarkEstimators.Manual(watermarkEstimatorState);
    }

    @DoFn.GetInitialRestriction
    public TimestampRange initialRestriction(@DoFn.Element PartitionMetadata partition) {
        Timestamp createdAt = partition.getCreatedAt();
        return TimestampRange.of(TimestampUtils.previous(createdAt), Timestamp.MAX_VALUE);
    }

    @DoFn.NewTracker
    public DetectNewPartitionsRangeTracker restrictionTracker(@DoFn.Restriction TimestampRange restriction) {
        return new DetectNewPartitionsRangeTracker(restriction);
    }

    @DoFn.Setup
    public void setup() {
        PartitionMetadataDao partitionMetadataDao = this.daoFactory.getPartitionMetadataDao();
        PartitionMetadataMapper partitionMetadataMapper = this.mapperFactory.partitionMetadataMapper();
        this.detectNewPartitionsAction = this.actionFactory.detectNewPartitionsAction(partitionMetadataDao, partitionMetadataMapper, this.metrics, this.resumeDuration);
    }

    @DoFn.ProcessElement
    public DoFn.ProcessContinuation processElement(RestrictionTracker<TimestampRange, Timestamp> tracker, DoFn.OutputReceiver<PartitionMetadata> receiver, ManualWatermarkEstimator<Instant> watermarkEstimator) {
        try (Scope scope = TRACER.spanBuilder("DetectNewPartitionsDoFn.processElement").setRecordEvents(true).startScopedSpan();){
            DoFn.ProcessContinuation processContinuation = this.detectNewPartitionsAction.run(tracker, receiver, watermarkEstimator);
            return processContinuation;
        }
    }
}

