/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableRow;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.gcp.testing.AutoValue_BigqueryMatcher_TableAndQuery;
import org.apache.beam.sdk.io.gcp.testing.BigqueryClient;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
@Experimental
public class BigqueryMatcher
extends TypeSafeMatcher<TableAndQuery>
implements SerializableMatcher<TableAndQuery> {
    private static final Logger LOG = LoggerFactory.getLogger(BigqueryMatcher.class);
    private static final int TOTAL_FORMATTED_ROWS = 20;
    private final String expectedChecksum;
    private String actualChecksum;
    private transient QueryResponse response;
    private BigqueryClient bigqueryClient;

    private BigqueryMatcher(String expectedChecksum) {
        this.validateArgument("expectedChecksum", expectedChecksum);
        this.expectedChecksum = expectedChecksum;
    }

    public static BigqueryMatcher queryResultHasChecksum(String checksum) {
        return new BigqueryMatcher(checksum);
    }

    public static TableAndQuery createQuery(String applicationName, String projectId, String query) {
        return TableAndQuery.create(applicationName, projectId, query, false);
    }

    public static TableAndQuery createQueryUsingStandardSql(String applicationName, String projectId, String query) {
        return TableAndQuery.create(applicationName, projectId, query, true);
    }

    protected boolean matchesSafely(TableAndQuery tableAndQuery) {
        this.bigqueryClient = BigqueryClient.getClient(tableAndQuery.getApplicationName());
        LOG.info("Verifying Bigquery data");
        LOG.debug("Executing query: {}", (Object)tableAndQuery.getQuery());
        try {
            this.response = tableAndQuery.getUsingStandardSql().booleanValue() ? this.bigqueryClient.queryWithRetriesUsingStandardSql(tableAndQuery.getQuery(), tableAndQuery.getProjectId()) : this.bigqueryClient.queryWithRetries(tableAndQuery.getQuery(), tableAndQuery.getProjectId());
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException("Failed to fetch BigQuery data.", e);
        }
        if (!this.response.getJobComplete().booleanValue()) {
            return false;
        }
        this.actualChecksum = this.generateHash(this.response.getRows());
        LOG.debug("Generated a SHA1 checksum based on queried data: {}", (Object)this.actualChecksum);
        return this.expectedChecksum.equals(this.actualChecksum);
    }

    private void validateArgument(String name, String value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (String)"Expected valid %s, but was %s", (Object)name, (Object)value);
    }

    private String generateHash(@Nonnull List<TableRow> rows) {
        ArrayList rowHashes = Lists.newArrayList();
        for (TableRow row : rows) {
            ArrayList cellsInOneRow = Lists.newArrayList();
            for (TableCell cell : row.getF()) {
                cellsInOneRow.add(Objects.toString(cell.getV()));
                Collections.sort(cellsInOneRow);
            }
            rowHashes.add(Hashing.sha1().hashString((CharSequence)((Object)cellsInOneRow).toString(), StandardCharsets.UTF_8));
        }
        return Hashing.combineUnordered((Iterable)rowHashes).toString();
    }

    public void describeTo(Description description) {
        description.appendText("Expected checksum is (").appendText(this.expectedChecksum).appendText(")");
    }

    public void describeMismatchSafely(TableAndQuery tableAndQuery, Description description) {
        String info = this.response.getJobComplete() == false ? String.format("The query job hasn't completed. Got response: %s", this.response) : String.format("was (%s).%n\tTotal number of rows are: %d.%n\tQueried data details:%s", this.actualChecksum, this.response.getTotalRows(), this.formatRows(20));
        description.appendText(info);
    }

    private String formatRows(int totalNumRows) {
        StringBuilder samples = new StringBuilder();
        List rows = this.response.getRows();
        for (int i = 0; i < totalNumRows && i < rows.size(); ++i) {
            samples.append(String.format("%n\t\t", new Object[0]));
            for (TableCell field : ((TableRow)rows.get(i)).getF()) {
                samples.append(String.format("%-10s", field.getV()));
            }
        }
        if (rows.size() > totalNumRows) {
            samples.append(String.format("%n\t\t...", new Object[0]));
        }
        return samples.toString();
    }

    @AutoValue
    public static abstract class TableAndQuery {
        public static TableAndQuery create(String applicationName, String projectId, String query, Boolean usingStandardSql) {
            return new AutoValue_BigqueryMatcher_TableAndQuery(applicationName, projectId, query, usingStandardSql);
        }

        public abstract String getApplicationName();

        public abstract String getProjectId();

        public abstract String getQuery();

        public abstract Boolean getUsingStandardSql();
    }
}

