/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.BoltServerAddress;

public final class ClusterComposition {
    private static final long MAX_TTL = 9223372036854775L;
    private static final Function<Value, BoltServerAddress> OF_BoltServerAddress = value -> new BoltServerAddress(value.asString());
    private final Set<BoltServerAddress> readers = new LinkedHashSet<BoltServerAddress>();
    private final Set<BoltServerAddress> writers = new LinkedHashSet<BoltServerAddress>();
    private final Set<BoltServerAddress> routers = new LinkedHashSet<BoltServerAddress>();
    private final long expirationTimestamp;

    private ClusterComposition(long expirationTimestamp) {
        this.expirationTimestamp = expirationTimestamp;
    }

    public ClusterComposition(long expirationTimestamp, Set<BoltServerAddress> readers, Set<BoltServerAddress> writers, Set<BoltServerAddress> routers) {
        this(expirationTimestamp);
        this.readers.addAll(readers);
        this.writers.addAll(writers);
        this.routers.addAll(routers);
    }

    public boolean hasWriters() {
        return !this.writers.isEmpty();
    }

    public boolean hasRoutersAndReaders() {
        return !this.routers.isEmpty() && !this.readers.isEmpty();
    }

    public Set<BoltServerAddress> readers() {
        return new LinkedHashSet<BoltServerAddress>(this.readers);
    }

    public Set<BoltServerAddress> writers() {
        return new LinkedHashSet<BoltServerAddress>(this.writers);
    }

    public Set<BoltServerAddress> routers() {
        return new LinkedHashSet<BoltServerAddress>(this.routers);
    }

    public long expirationTimestamp() {
        return this.expirationTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterComposition that = (ClusterComposition)o;
        return this.expirationTimestamp == that.expirationTimestamp && Objects.equals(this.readers, that.readers) && Objects.equals(this.writers, that.writers) && Objects.equals(this.routers, that.routers);
    }

    public int hashCode() {
        return Objects.hash(this.readers, this.writers, this.routers, this.expirationTimestamp);
    }

    public String toString() {
        return "ClusterComposition{readers=" + this.readers + ", writers=" + this.writers + ", routers=" + this.routers + ", expirationTimestamp=" + this.expirationTimestamp + '}';
    }

    public static ClusterComposition parse(Record record, long now) {
        if (record == null) {
            return null;
        }
        final ClusterComposition result = new ClusterComposition(ClusterComposition.expirationTimestamp(now, record));
        record.get("servers").asList(new Function<Value, Void>(){

            @Override
            public Void apply(Value value) {
                result.servers(value.get("role").asString()).addAll(value.get("addresses").asList(OF_BoltServerAddress));
                return null;
            }
        });
        return result;
    }

    private static long expirationTimestamp(long now, Record record) {
        long ttl = record.get("ttl").asLong();
        long expirationTimestamp = now + ttl * 1000L;
        if (ttl < 0L || ttl >= 9223372036854775L || expirationTimestamp < 0L) {
            expirationTimestamp = Long.MAX_VALUE;
        }
        return expirationTimestamp;
    }

    private Set<BoltServerAddress> servers(String role) {
        switch (role) {
            case "READ": {
                return this.readers;
            }
            case "WRITE": {
                return this.writers;
            }
            case "ROUTE": {
                return this.routers;
            }
        }
        throw new IllegalArgumentException("invalid server role: " + role);
    }
}

