/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dimensionlookup;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.hash.ByteArrayHashMap;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dimensionlookup.DimensionCache;
import org.apache.hop.pipeline.transforms.dimensionlookup.DimensionLookupData;
import org.apache.hop.pipeline.transforms.dimensionlookup.DimensionLookupMeta;

public class DimensionLookup
extends BaseTransform<DimensionLookupMeta, DimensionLookupData> {
    private static final Class<?> PKG = DimensionLookupMeta.class;
    private static final int CREATION_METHOD_AUTOINC = 1;
    private static final int CREATION_METHOD_SEQUENCE = 2;
    private static final int CREATION_METHOD_TABLEMAX = 3;
    private int techKeyCreation;
    int[] columnLookupArray = null;

    public DimensionLookup(TransformMeta transformMeta, DimensionLookupMeta meta, DimensionLookupData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private void setTechKeyCreation(int method) {
        this.techKeyCreation = method;
    }

    private int getTechKeyCreation() {
        return this.techKeyCreation;
    }

    private void determineTechKeyCreation() {
        String keyCreation = ((DimensionLookupMeta)this.meta).getTechKeyCreation();
        if (((DimensionLookupMeta)this.meta).getDatabaseMeta().supportsAutoinc() && "autoinc".equals(keyCreation)) {
            this.setTechKeyCreation(1);
        } else if (((DimensionLookupMeta)this.meta).getDatabaseMeta().supportsSequences() && "sequence".equals(keyCreation)) {
            this.setTechKeyCreation(2);
        } else {
            this.setTechKeyCreation(3);
        }
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            ((DimensionLookupData)this.data).schemaTable = ((DimensionLookupMeta)this.meta).getDatabaseMeta().getQuotedSchemaTableCombination((IVariables)this, ((DimensionLookupData)this.data).realSchemaName, ((DimensionLookupData)this.data).realTableName);
            ((DimensionLookupData)this.data).inputRowMeta = this.getInputRowMeta().clone();
            ((DimensionLookupData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((DimensionLookupMeta)this.meta).getFields(((DimensionLookupData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((DimensionLookupData)this.data).lazyList = new ArrayList<Integer>();
            for (i = 0; i < ((DimensionLookupData)this.data).inputRowMeta.size(); ++i) {
                IValueMeta valueMeta = ((DimensionLookupData)this.data).inputRowMeta.getValueMeta(i);
                if (!valueMeta.isStorageBinaryString()) continue;
                ((DimensionLookupData)this.data).lazyList.add(i);
                valueMeta.setStorageType(0);
            }
            ((DimensionLookupData)this.data).startDateFieldIndex = -1;
            if (((DimensionLookupData)this.data).startDateChoice == 4) {
                ((DimensionLookupData)this.data).startDateFieldIndex = ((DimensionLookupData)this.data).inputRowMeta.indexOfValue(((DimensionLookupMeta)this.meta).getStartDateFieldName());
                if (((DimensionLookupData)this.data).startDateFieldIndex < 0) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookup.Exception.StartDateValueColumnNotFound", (String[])new String[]{((DimensionLookupMeta)this.meta).getStartDateFieldName()}));
                }
            }
            ((DimensionLookupData)this.data).keynrs = new int[((DimensionLookupMeta)this.meta).getKeyStream().length];
            for (i = 0; i < ((DimensionLookupMeta)this.meta).getKeyStream().length; ++i) {
                ((DimensionLookupData)this.data).keynrs[i] = ((DimensionLookupData)this.data).inputRowMeta.indexOfValue(((DimensionLookupMeta)this.meta).getKeyStream()[i]);
                if (((DimensionLookupData)this.data).keynrs[i] >= 0) continue;
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookup.Exception.KeyFieldNotFound", (String[])new String[]{((DimensionLookupMeta)this.meta).getKeyStream()[i]}));
            }
            ((DimensionLookupData)this.data).fieldnrs = new int[((DimensionLookupMeta)this.meta).getFieldStream().length];
            for (i = 0; ((DimensionLookupMeta)this.meta).getFieldStream() != null && i < ((DimensionLookupMeta)this.meta).getFieldStream().length; ++i) {
                if (!DimensionLookupMeta.isUpdateTypeWithoutArgument(((DimensionLookupMeta)this.meta).isUpdate(), ((DimensionLookupMeta)this.meta).getFieldUpdate()[i])) {
                    ((DimensionLookupData)this.data).fieldnrs[i] = ((DimensionLookupData)this.data).outputRowMeta.indexOfValue(((DimensionLookupMeta)this.meta).getFieldStream()[i]);
                    if (((DimensionLookupData)this.data).fieldnrs[i] >= 0) continue;
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookup.Exception.KeyFieldNotFound", (String[])new String[]{((DimensionLookupMeta)this.meta).getFieldStream()[i]}));
                }
                ((DimensionLookupData)this.data).fieldnrs[i] = -1;
            }
            if (!((DimensionLookupMeta)this.meta).isUpdate() && ((DimensionLookupMeta)this.meta).isPreloadingCache()) {
                this.preloadCache();
            } else if (((DimensionLookupData)this.data).cacheKeyRowMeta == null) {
                ((DimensionLookupData)this.data).cacheKeyRowMeta = new RowMeta();
                for (i = 0; i < ((DimensionLookupData)this.data).keynrs.length; ++i) {
                    IValueMeta key = ((DimensionLookupData)this.data).inputRowMeta.getValueMeta(((DimensionLookupData)this.data).keynrs[i]);
                    ((DimensionLookupData)this.data).cacheKeyRowMeta.addValueMeta(key.clone());
                }
                ((DimensionLookupData)this.data).cache = new ByteArrayHashMap(((DimensionLookupMeta)this.meta).getCacheSize() > 0 ? ((DimensionLookupMeta)this.meta).getCacheSize() : 5000, ((DimensionLookupData)this.data).cacheKeyRowMeta);
            }
            ((DimensionLookupData)this.data).datefieldnr = !Utils.isEmpty((CharSequence)((DimensionLookupMeta)this.meta).getDateField()) ? ((DimensionLookupData)this.data).inputRowMeta.indexOfValue(((DimensionLookupMeta)this.meta).getDateField()) : -1;
            ((DimensionLookupData)this.data).valueDateNow = this.determineDimensionUpdatedDate(r);
            this.determineTechKeyCreation();
            ((DimensionLookupData)this.data).notFoundTk = ((DimensionLookupMeta)this.meta).getDatabaseMeta().getNotFoundTK(this.isAutoIncrement());
            if (this.getCopy() == 0) {
                this.checkDimZero();
            }
            this.setDimLookup(((DimensionLookupData)this.data).outputRowMeta);
        }
        for (int lazyFieldIndex : ((DimensionLookupData)this.data).lazyList) {
            IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(lazyFieldIndex);
            r[lazyFieldIndex] = valueMeta.convertToNormalStorageType(r[lazyFieldIndex]);
        }
        try {
            Object[] outputRow = this.lookupValues(((DimensionLookupData)this.data).inputRowMeta, r);
            this.putRow(((DimensionLookupData)this.data).outputRowMeta, outputRow);
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
            }
        }
        catch (HopException e) {
            this.logError(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.TransformCanNotContinueForErrors", (String[])new String[]{e.getMessage()}));
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private Date determineDimensionUpdatedDate(Object[] row) throws HopException {
        if (((DimensionLookupData)this.data).datefieldnr < 0) {
            return this.getPipeline().getExecutionStartDate();
        }
        Date rtn = ((DimensionLookupData)this.data).inputRowMeta.getDate(row, ((DimensionLookupData)this.data).datefieldnr);
        if (rtn != null) {
            return rtn;
        }
        String inputRowMetaStringMeta = null;
        try {
            inputRowMetaStringMeta = ((DimensionLookupData)this.data).inputRowMeta.toStringMeta();
        }
        catch (Exception ex) {
            inputRowMetaStringMeta = "No row input meta";
        }
        throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookup.Exception.NullDimensionUpdatedDate", (String[])new String[]{inputRowMetaStringMeta}));
    }

    private void preloadCache() throws HopException {
        try {
            int i;
            int i2;
            DatabaseMeta databaseMeta = ((DimensionLookupMeta)this.meta).getDatabaseMeta();
            String sql = "SELECT " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getKeyField());
            for (i2 = 0; i2 < ((DimensionLookupMeta)this.meta).getKeyLookup().length; ++i2) {
                sql = sql + ", " + ((DimensionLookupMeta)this.meta).getKeyLookup()[i2];
            }
            for (i2 = 0; i2 < ((DimensionLookupMeta)this.meta).getFieldLookup().length; ++i2) {
                sql = sql + ", " + ((DimensionLookupMeta)this.meta).getFieldLookup()[i2];
            }
            sql = sql + ", " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getDateFrom());
            sql = sql + ", " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getDateTo());
            sql = sql + " FROM " + ((DimensionLookupData)this.data).schemaTable;
            this.logDetailed("Pre-loading cache by reading from database with: " + Const.CR + sql + Const.CR);
            List rows = ((DimensionLookupData)this.data).db.getRows(sql, -1);
            IRowMeta rowMeta = ((DimensionLookupData)this.data).db.getReturnRowMeta();
            ((DimensionLookupData)this.data).preloadKeyIndexes = new int[((DimensionLookupMeta)this.meta).getKeyLookup().length];
            for (i = 0; i < ((DimensionLookupData)this.data).preloadKeyIndexes.length; ++i) {
                ((DimensionLookupData)this.data).preloadKeyIndexes[i] = rowMeta.indexOfValue(((DimensionLookupMeta)this.meta).getKeyLookup()[i]);
            }
            ((DimensionLookupData)this.data).preloadFromDateIndex = rowMeta.indexOfValue(((DimensionLookupMeta)this.meta).getDateFrom());
            ((DimensionLookupData)this.data).preloadToDateIndex = rowMeta.indexOfValue(((DimensionLookupMeta)this.meta).getDateTo());
            ((DimensionLookupData)this.data).preloadCache = new DimensionCache(rowMeta, ((DimensionLookupData)this.data).preloadKeyIndexes, ((DimensionLookupData)this.data).preloadFromDateIndex, ((DimensionLookupData)this.data).preloadToDateIndex);
            ((DimensionLookupData)this.data).preloadCache.setRowCache(rows);
            this.logDetailed("Sorting the cache rows...");
            ((DimensionLookupData)this.data).preloadCache.sortRows();
            this.logDetailed("Sorting of cached rows finished.");
            ((DimensionLookupData)this.data).preloadIndexes = new ArrayList<Integer>();
            for (i = 0; i < ((DimensionLookupMeta)this.meta).getKeyStream().length; ++i) {
                int index = ((DimensionLookupData)this.data).inputRowMeta.indexOfValue(((DimensionLookupMeta)this.meta).getKeyStream()[i]);
                if (index < 0) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookup.Exception.KeyFieldNotFound", (String[])new String[]{((DimensionLookupMeta)this.meta).getFieldStream()[i]}));
                }
                ((DimensionLookupData)this.data).preloadIndexes.add(index);
            }
        }
        catch (Exception e) {
            throw new HopException("Error encountered during cache pre-load", (Throwable)e);
        }
    }

    private synchronized Object[] lookupValues(IRowMeta rowMeta, Object[] row) throws HopException {
        Long technicalKey;
        Long valueVersion;
        Object[] lookupRow;
        IRowMeta lookupRowMeta;
        Object[] outputRow = new Object[((DimensionLookupData)this.data).outputRowMeta.size()];
        Object returnRow = null;
        Date valueDate = null;
        Date valueDateFrom = null;
        Date valueDateTo = null;
        valueDate = this.determineDimensionUpdatedDate(row);
        if (!((DimensionLookupMeta)this.meta).isUpdate() && ((DimensionLookupMeta)this.meta).isPreloadingCache()) {
            IRowMeta preloadRowMeta = ((DimensionLookupData)this.data).preloadCache.getRowMeta();
            ((DimensionLookupData)this.data).returnRowMeta = ((DimensionLookupData)this.data).preloadCache.getRowMeta();
            lookupRowMeta = preloadRowMeta;
            lookupRow = new Object[preloadRowMeta.size()];
            for (int i = 0; i < ((DimensionLookupData)this.data).preloadIndexes.size(); ++i) {
                Object toData;
                int from = ((DimensionLookupData)this.data).preloadIndexes.get(i);
                int to = ((DimensionLookupData)this.data).preloadCache.getKeyIndexes()[i];
                IValueMeta fromValueMeta = rowMeta.getValueMeta(from);
                IValueMeta toValueMeta = ((DimensionLookupData)this.data).preloadCache.getRowMeta().getValueMeta(to);
                Object fromData = row[from];
                lookupRow[to] = toData = toValueMeta.convertData(fromValueMeta, fromData);
            }
            lookupRow[((DimensionLookupData)this.data).preloadFromDateIndex] = valueDate;
            int index = ((DimensionLookupData)this.data).preloadCache.lookupRow(lookupRow);
            returnRow = index >= 0 ? ((DimensionLookupData)this.data).preloadCache.getRow(index) : null;
        } else {
            lookupRow = new Object[((DimensionLookupData)this.data).lookupRowMeta.size()];
            lookupRowMeta = ((DimensionLookupData)this.data).lookupRowMeta;
            for (int i = 0; i < ((DimensionLookupMeta)this.meta).getKeyStream().length; ++i) {
                try {
                    lookupRow[i] = row[((DimensionLookupData)this.data).keynrs[i]];
                    continue;
                }
                catch (Exception e) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookup.Exception.ErrorDetectedInGettingKey", (String[])new String[]{"" + i, ((DimensionLookupData)this.data).keynrs[i] + "/" + rowMeta.size(), rowMeta.getString(row)}));
                }
            }
            lookupRow[((DimensionLookupMeta)this.meta).getKeyStream().length] = valueDate;
            lookupRow[((DimensionLookupMeta)this.meta).getKeyStream().length + 1] = valueDate;
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.LookupRow", (String[])new String[0]) + ((DimensionLookupData)this.data).lookupRowMeta.getString(lookupRow));
            }
            if (((DimensionLookupMeta)this.meta).getCacheSize() >= 0) {
                returnRow = this.getFromCache(lookupRow, valueDate);
            }
            if (returnRow == null) {
                ((DimensionLookupData)this.data).db.setValues(((DimensionLookupData)this.data).lookupRowMeta, lookupRow, ((DimensionLookupData)this.data).prepStatementLookup);
                returnRow = ((DimensionLookupData)this.data).db.getLookup(((DimensionLookupData)this.data).prepStatementLookup);
                ((DimensionLookupData)this.data).returnRowMeta = ((DimensionLookupData)this.data).db.getReturnRowMeta();
                this.incrementLinesInput();
                if (returnRow != null && ((DimensionLookupMeta)this.meta).getCacheSize() >= 0) {
                    this.addToCache(lookupRow, (Object[])returnRow);
                }
            }
        }
        if (!((DimensionLookupMeta)this.meta).isUpdate()) {
            if (returnRow == null) {
                returnRow = new Object[((DimensionLookupData)this.data).returnRowMeta.size()];
                returnRow[0] = ((DimensionLookupData)this.data).notFoundTk;
                if (((DimensionLookupMeta)this.meta).getCacheSize() >= 0) {
                    returnRow[((Object[])returnRow).length - 2] = ((DimensionLookupData)this.data).minDate;
                    returnRow[((Object[])returnRow).length - 1] = ((DimensionLookupData)this.data).maxDate;
                }
            }
        } else if (returnRow == null) {
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.NoDimensionEntryFound", (String[])new String[0]) + lookupRowMeta.getString(lookupRow) + ")");
            }
            valueDateFrom = ((DimensionLookupData)this.data).startDateChoice == 1 ? valueDate : ((DimensionLookupData)this.data).minDate;
            valueDateTo = ((DimensionLookupData)this.data).maxDate;
            valueVersion = 1L;
            technicalKey = null;
            switch (this.getTechKeyCreation()) {
                case 3: {
                    technicalKey = ((DimensionLookupData)this.data).db.getNextValue(((DimensionLookupData)this.data).realSchemaName, ((DimensionLookupData)this.data).realTableName, ((DimensionLookupMeta)this.meta).getKeyField());
                    break;
                }
                case 1: {
                    technicalKey = null;
                    break;
                }
                case 2: {
                    technicalKey = ((DimensionLookupData)this.data).db.getNextSequenceValue(((DimensionLookupData)this.data).realSchemaName, ((DimensionLookupMeta)this.meta).getSequenceName(), ((DimensionLookupMeta)this.meta).getKeyField());
                    if (technicalKey == null || !this.isRowLevel()) break;
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.FoundNextSequence", (String[])new String[0]) + technicalKey.toString());
                    break;
                }
            }
            technicalKey = this.dimInsert(((DimensionLookupData)this.data).inputRowMeta, row, technicalKey, true, valueVersion, valueDateFrom, valueDateTo);
            this.incrementLinesOutput();
            returnRow = new Object[((DimensionLookupData)this.data).returnRowMeta.size()];
            int returnIndex = 0;
            returnRow[returnIndex] = technicalKey;
            ++returnIndex;
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.AddedDimensionEntry", (String[])new String[0]) + ((DimensionLookupData)this.data).returnRowMeta.getString(returnRow));
            }
        } else {
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.DimensionEntryFound", (String[])new String[0]) + ((DimensionLookupData)this.data).returnRowMeta.getString(returnRow));
            }
            technicalKey = ((DimensionLookupData)this.data).returnRowMeta.getInteger(returnRow, 0);
            valueVersion = ((DimensionLookupData)this.data).returnRowMeta.getInteger(returnRow, 1);
            valueDateFrom = ((DimensionLookupMeta)this.meta).getMinDate();
            valueDateTo = ((DimensionLookupMeta)this.meta).getMaxDate();
            boolean insert = false;
            boolean identical = true;
            boolean punch = false;
            if (this.columnLookupArray == null) {
                this.columnLookupArray = new int[((DimensionLookupMeta)this.meta).getFieldStream().length];
                for (int i = 0; i < this.columnLookupArray.length; ++i) {
                    this.columnLookupArray[i] = -1;
                }
            }
            int returnRowColNum = -1;
            String findColumn = null;
            for (int i = 0; i < ((DimensionLookupMeta)this.meta).getFieldStream().length; ++i) {
                if (((DimensionLookupData)this.data).fieldnrs[i] < 0) continue;
                IValueMeta v1 = ((DimensionLookupData)this.data).outputRowMeta.getValueMeta(((DimensionLookupData)this.data).fieldnrs[i]);
                Object valueData1 = row[((DimensionLookupData)this.data).fieldnrs[i]];
                findColumn = ((DimensionLookupMeta)this.meta).getFieldStream()[i];
                IValueMeta v2 = null;
                Object valueData2 = null;
                returnRowColNum = this.columnLookupArray[i];
                if (returnRowColNum == -1) {
                    for (int j = 2; j < ((DimensionLookupData)this.data).returnRowMeta.size(); ++j) {
                        v2 = ((DimensionLookupData)this.data).returnRowMeta.getValueMeta(j);
                        if (v2.getName() != null && v2.getName().equalsIgnoreCase(findColumn)) {
                            this.columnLookupArray[i] = j;
                            valueData2 = returnRow[j];
                            break;
                        }
                        v2 = null;
                    }
                } else {
                    v2 = ((DimensionLookupData)this.data).returnRowMeta.getValueMeta(returnRowColNum);
                    valueData2 = returnRow[returnRowColNum];
                }
                if (v2 == null) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookup.Exception.ErrorDetectedInComparingFields", (String[])new String[]{((DimensionLookupMeta)this.meta).getFieldStream()[i]}));
                }
                int cmp = v1.compare(valueData1, v2, valueData2);
                if (cmp != 0) {
                    identical = false;
                }
                if (cmp != 0 && ((DimensionLookupMeta)this.meta).getFieldUpdate()[i] == 0) {
                    insert = true;
                }
                if (cmp != 0 && ((DimensionLookupMeta)this.meta).getFieldUpdate()[i] == 2) {
                    punch = true;
                }
                if (!this.isRowLevel()) continue;
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.ComparingValues", (String[])new String[]{"" + v1, "" + v2, String.valueOf(cmp), String.valueOf(identical), String.valueOf(insert), String.valueOf(punch)}));
            }
            if (!insert) {
                if (!identical) {
                    if (this.isRowLevel()) {
                        this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.UpdateRowWithValues", (String[])new String[0]) + ((DimensionLookupData)this.data).inputRowMeta.getString(row));
                    }
                    this.dimUpdate(rowMeta, row, technicalKey, valueDate);
                    this.incrementLinesUpdated();
                    if (((DimensionLookupMeta)this.meta).getCacheSize() >= 0) {
                        Object[] values = this.getCacheValues(rowMeta, row, technicalKey, valueVersion, valueDateFrom, valueDateTo);
                        this.addToCache(lookupRow, values);
                    }
                } else {
                    if (this.isRowLevel()) {
                        this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.SkipLine", (String[])new String[0]));
                    }
                    this.incrementLinesSkipped();
                }
            } else {
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.InsertNewVersion", (String[])new String[0]) + technicalKey.toString());
                }
                Long valueNewVersion = valueVersion + 1L;
                valueDateFrom = valueDate;
                valueDateTo = ((DimensionLookupData)this.data).maxDate;
                if (((DimensionLookupMeta)this.meta).getDatabaseMeta().supportsAutoinc() && this.isAutoIncrement()) {
                    technicalKey = null;
                } else if (((DimensionLookupMeta)this.meta).getDatabaseMeta().supportsSequences() && ((DimensionLookupMeta)this.meta).getSequenceName() != null && ((DimensionLookupMeta)this.meta).getSequenceName().length() > 0) {
                    technicalKey = ((DimensionLookupData)this.data).db.getNextSequenceValue(((DimensionLookupData)this.data).realSchemaName, ((DimensionLookupMeta)this.meta).getSequenceName(), ((DimensionLookupMeta)this.meta).getKeyField());
                    if (technicalKey != null && this.isRowLevel()) {
                        this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.FoundNextSequence2", (String[])new String[0]) + technicalKey.toString());
                    }
                } else {
                    technicalKey = ((DimensionLookupData)this.data).db.getNextValue(((DimensionLookupData)this.data).realSchemaName, ((DimensionLookupData)this.data).realTableName, ((DimensionLookupMeta)this.meta).getKeyField());
                }
                technicalKey = this.dimInsert(rowMeta, row, technicalKey, false, valueNewVersion, valueDateFrom, valueDateTo);
                this.incrementLinesOutput();
                if (((DimensionLookupMeta)this.meta).getCacheSize() >= 0) {
                    Object[] values = this.getCacheValues(rowMeta, row, technicalKey, valueNewVersion, valueDateFrom, valueDateTo);
                    this.addToCache(lookupRow, values);
                }
            }
            if (punch) {
                this.dimPunchThrough(rowMeta, row);
                this.incrementLinesUpdated();
            }
            returnRow = new Object[((DimensionLookupData)this.data).returnRowMeta.size()];
            returnRow[0] = technicalKey;
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.TechnicalKey", (String[])new String[0]) + technicalKey);
            }
        }
        if (this.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.AddValuesToRow", (String[])new String[0]) + ((DimensionLookupData)this.data).returnRowMeta.getString(returnRow));
        }
        for (int i = 0; i < rowMeta.size(); ++i) {
            outputRow[i] = row[i];
        }
        int outputIndex = rowMeta.size();
        int inputIndex = 0;
        if (((DimensionLookupData)this.data).returnRowMeta.getValueMeta(0).isBigNumber() && returnRow[0] instanceof Long) {
            if (this.isDebug()) {
                this.log.logDebug("Changing the type of the technical key from TYPE_BIGNUMBER to an TYPE_INTEGER");
            }
            IValueMeta tkValueMeta = ((DimensionLookupData)this.data).returnRowMeta.getValueMeta(0);
            ((DimensionLookupData)this.data).returnRowMeta.setValueMeta(0, ValueMetaFactory.cloneValueMeta((IValueMeta)tkValueMeta, (int)5));
        }
        outputRow[outputIndex++] = ((DimensionLookupData)this.data).returnRowMeta.getInteger(returnRow, inputIndex++);
        ++inputIndex;
        while (inputIndex < ((Object[])returnRow).length && outputIndex < outputRow.length) {
            outputRow[outputIndex] = returnRow[inputIndex];
            ++outputIndex;
            ++inputIndex;
        }
        return outputRow;
    }

    private void setDimLookup(IRowMeta rowMeta) throws HopDatabaseException {
        int i;
        DatabaseMeta databaseMeta = ((DimensionLookupMeta)this.meta).getDatabaseMeta();
        ((DimensionLookupData)this.data).lookupRowMeta = new RowMeta();
        String sql = "SELECT " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getKeyField()) + ", " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getVersionField());
        if (!Utils.isEmpty((CharSequence[])((DimensionLookupMeta)this.meta).getFieldLookup())) {
            for (i = 0; i < ((DimensionLookupMeta)this.meta).getFieldLookup().length; ++i) {
                if (Utils.isEmpty((CharSequence)((DimensionLookupMeta)this.meta).getFieldLookup()[i]) || DimensionLookupMeta.isUpdateTypeWithoutArgument(((DimensionLookupMeta)this.meta).isUpdate(), ((DimensionLookupMeta)this.meta).getFieldUpdate()[i])) continue;
                sql = sql + ", " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getFieldLookup()[i]);
                if (Utils.isEmpty((CharSequence)((DimensionLookupMeta)this.meta).getFieldStream()[i]) || ((DimensionLookupMeta)this.meta).getFieldLookup()[i].equals(((DimensionLookupMeta)this.meta).getFieldStream()[i])) continue;
                sql = sql + " AS " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getFieldStream()[i]);
            }
        }
        if (((DimensionLookupMeta)this.meta).getCacheSize() >= 0) {
            sql = sql + ", " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getDateFrom()) + ", " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getDateTo());
        }
        sql = sql + " FROM " + ((DimensionLookupData)this.data).schemaTable + " WHERE ";
        for (i = 0; i < ((DimensionLookupMeta)this.meta).getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + " AND ";
            }
            sql = sql + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getKeyLookup()[i]) + " = ? ";
            ((DimensionLookupData)this.data).lookupRowMeta.addValueMeta(rowMeta.getValueMeta(((DimensionLookupData)this.data).keynrs[i]));
        }
        String dateFromField = databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getDateFrom());
        String dateToField = databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getDateTo());
        if (((DimensionLookupMeta)this.meta).isUsingStartDateAlternative() && ((DimensionLookupMeta)this.meta).getStartDateAlternative() == 3 || ((DimensionLookupMeta)this.meta).getStartDateAlternative() == 4) {
            sql = sql + " AND ( " + dateFromField + " IS NULL OR " + dateFromField + " <= ? )" + Const.CR;
            sql = sql + " AND " + dateToField + " > ?" + Const.CR;
            ((DimensionLookupData)this.data).lookupRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(((DimensionLookupMeta)this.meta).getDateFrom()));
            ((DimensionLookupData)this.data).lookupRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(((DimensionLookupMeta)this.meta).getDateTo()));
        } else {
            sql = sql + " AND ? >= " + dateFromField + Const.CR;
            sql = sql + " AND ? < " + dateToField + Const.CR;
            ((DimensionLookupData)this.data).lookupRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(((DimensionLookupMeta)this.meta).getDateFrom()));
            ((DimensionLookupData)this.data).lookupRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(((DimensionLookupMeta)this.meta).getDateTo()));
        }
        try {
            this.logDetailed("Dimension Lookup setting preparedStatement to [" + sql + "]");
            ((DimensionLookupData)this.data).prepStatementLookup = ((DimensionLookupData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
            if (databaseMeta.supportsSetMaxRows()) {
                ((DimensionLookupData)this.data).prepStatementLookup.setMaxRows(1);
            }
            if (databaseMeta.getIDatabase().isMySqlVariant()) {
                ((DimensionLookupData)this.data).prepStatementLookup.setFetchSize(0);
            }
            this.logDetailed("Finished preparing dimension lookup statement.");
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Unable to prepare dimension lookup", (Throwable)ex);
        }
    }

    protected boolean isAutoIncrement() {
        return this.techKeyCreation == 1;
    }

    public Long dimInsert(IRowMeta inputRowMeta, Object[] row, Long technicalKey, boolean newEntry, Long versionNr, Date dateFrom, Date dateTo) throws HopException {
        int i;
        int i2;
        DatabaseMeta databaseMeta = ((DimensionLookupMeta)this.meta).getDatabaseMeta();
        if (((DimensionLookupData)this.data).prepStatementInsert == null && ((DimensionLookupData)this.data).prepStatementUpdate == null) {
            int i3;
            RowMeta insertRowMeta = new RowMeta();
            String sql = "INSERT INTO " + ((DimensionLookupData)this.data).schemaTable + "( ";
            if (!this.isAutoIncrement()) {
                sql = sql + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getKeyField()) + ", ";
                insertRowMeta.addValueMeta(((DimensionLookupData)this.data).outputRowMeta.getValueMeta(inputRowMeta.size()));
            } else if (databaseMeta.needsPlaceHolder()) {
                sql = sql + "0, ";
            }
            sql = sql + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getVersionField()) + ", " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getDateFrom()) + ", " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getDateTo());
            insertRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger(((DimensionLookupMeta)this.meta).getVersionField()));
            insertRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(((DimensionLookupMeta)this.meta).getDateFrom()));
            insertRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(((DimensionLookupMeta)this.meta).getDateTo()));
            for (i3 = 0; i3 < ((DimensionLookupMeta)this.meta).getKeyLookup().length; ++i3) {
                sql = sql + ", " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getKeyLookup()[i3]);
                insertRowMeta.addValueMeta(inputRowMeta.getValueMeta(((DimensionLookupData)this.data).keynrs[i3]));
            }
            for (i3 = 0; i3 < ((DimensionLookupMeta)this.meta).getFieldLookup().length; ++i3) {
                if (DimensionLookupMeta.isUpdateTypeWithoutArgument(((DimensionLookupMeta)this.meta).isUpdate(), ((DimensionLookupMeta)this.meta).getFieldUpdate()[i3])) continue;
                sql = sql + ", " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getFieldLookup()[i3]);
                insertRowMeta.addValueMeta(inputRowMeta.getValueMeta(((DimensionLookupData)this.data).fieldnrs[i3]));
            }
            for (i3 = 0; i3 < ((DimensionLookupMeta)this.meta).getFieldUpdate().length; ++i3) {
                ValueMetaDate valueMeta = null;
                switch (((DimensionLookupMeta)this.meta).getFieldUpdate()[i3]) {
                    case 3: 
                    case 4: {
                        valueMeta = new ValueMetaDate(((DimensionLookupMeta)this.meta).getFieldLookup()[i3]);
                        break;
                    }
                    case 6: {
                        valueMeta = new ValueMetaBoolean(((DimensionLookupMeta)this.meta).getFieldLookup()[i3]);
                        break;
                    }
                }
                if (valueMeta == null) continue;
                sql = sql + ", " + databaseMeta.quoteField(valueMeta.getName());
                insertRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
            sql = sql + ") VALUES (";
            if (!this.isAutoIncrement()) {
                sql = sql + "?, ";
            }
            sql = sql + "?, ?, ?";
            for (i3 = 0; i3 < ((DimensionLookupData)this.data).keynrs.length; ++i3) {
                sql = sql + ", ?";
            }
            for (i3 = 0; i3 < ((DimensionLookupMeta)this.meta).getFieldLookup().length; ++i3) {
                if (DimensionLookupMeta.isUpdateTypeWithoutArgument(((DimensionLookupMeta)this.meta).isUpdate(), ((DimensionLookupMeta)this.meta).getFieldUpdate()[i3])) continue;
                sql = sql + ", ?";
            }
            block45: for (i3 = 0; i3 < ((DimensionLookupMeta)this.meta).getFieldUpdate().length; ++i3) {
                switch (((DimensionLookupMeta)this.meta).getFieldUpdate()[i3]) {
                    case 3: 
                    case 4: 
                    case 6: {
                        sql = sql + ", ?";
                        continue block45;
                    }
                }
            }
            sql = sql + " )";
            try {
                if (technicalKey == null && databaseMeta.supportsAutoGeneratedKeys()) {
                    this.logDetailed("SQL w/ return keys=[" + sql + "]");
                    ((DimensionLookupData)this.data).prepStatementInsert = ((DimensionLookupData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR(sql), 1);
                } else {
                    this.logDetailed("SQL=[" + sql + "]");
                    ((DimensionLookupData)this.data).prepStatementInsert = ((DimensionLookupData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
                }
            }
            catch (SQLException ex) {
                throw new HopDatabaseException("Unable to prepare dimension insert :" + Const.CR + sql, (Throwable)ex);
            }
            RowMeta updateRowMeta = new RowMeta();
            String sqlUpdate = "UPDATE " + ((DimensionLookupData)this.data).schemaTable + Const.CR;
            sqlUpdate = sqlUpdate + "SET " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getDateTo()) + " = ?" + Const.CR;
            updateRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(((DimensionLookupMeta)this.meta).getDateTo()));
            for (i2 = 0; i2 < ((DimensionLookupMeta)this.meta).getFieldUpdate().length; ++i2) {
                ValueMetaDate valueMeta = null;
                switch (((DimensionLookupMeta)this.meta).getFieldUpdate()[i2]) {
                    case 3: 
                    case 5: {
                        valueMeta = new ValueMetaDate(((DimensionLookupMeta)this.meta).getFieldLookup()[i2]);
                        break;
                    }
                    case 6: {
                        valueMeta = new ValueMetaBoolean(((DimensionLookupMeta)this.meta).getFieldLookup()[i2]);
                        break;
                    }
                }
                if (valueMeta == null) continue;
                sqlUpdate = sqlUpdate + ", " + databaseMeta.quoteField(valueMeta.getName()) + " = ?" + Const.CR;
                updateRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
            sqlUpdate = sqlUpdate + "WHERE ";
            for (i2 = 0; i2 < ((DimensionLookupMeta)this.meta).getKeyLookup().length; ++i2) {
                if (i2 > 0) {
                    sqlUpdate = sqlUpdate + "AND   ";
                }
                sqlUpdate = sqlUpdate + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getKeyLookup()[i2]) + " = ?" + Const.CR;
                updateRowMeta.addValueMeta(inputRowMeta.getValueMeta(((DimensionLookupData)this.data).keynrs[i2]));
            }
            sqlUpdate = sqlUpdate + "AND   " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getVersionField()) + " = ? ";
            updateRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger(((DimensionLookupMeta)this.meta).getVersionField()));
            try {
                this.logDetailed("Preparing update: " + Const.CR + sqlUpdate + Const.CR);
                ((DimensionLookupData)this.data).prepStatementUpdate = ((DimensionLookupData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR(sqlUpdate));
            }
            catch (SQLException ex) {
                throw new HopDatabaseException("Unable to prepare dimension update :" + Const.CR + sqlUpdate, (Throwable)ex);
            }
            ((DimensionLookupData)this.data).insertRowMeta = insertRowMeta;
            ((DimensionLookupData)this.data).updateRowMeta = updateRowMeta;
        }
        Object[] insertRow = new Object[((DimensionLookupData)this.data).insertRowMeta.size()];
        int insertIndex = 0;
        if (!this.isAutoIncrement()) {
            insertRow[insertIndex++] = technicalKey;
        }
        insertRow[insertIndex++] = versionNr;
        switch (((DimensionLookupData)this.data).startDateChoice) {
            case 0: {
                insertRow[insertIndex++] = dateFrom;
                break;
            }
            case 1: {
                insertRow[insertIndex++] = dateFrom;
                break;
            }
            case 2: {
                insertRow[insertIndex++] = this.getPipeline().getExecutionStartDate();
                break;
            }
            case 3: {
                insertRow[insertIndex++] = null;
                break;
            }
            case 4: {
                insertRow[insertIndex++] = inputRowMeta.getDate(row, ((DimensionLookupData)this.data).startDateFieldIndex);
                break;
            }
            default: {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookup.Exception.IllegalStartDateSelection", (String[])new String[]{Integer.toString(((DimensionLookupData)this.data).startDateChoice)}));
            }
        }
        insertRow[insertIndex++] = dateTo;
        for (i = 0; i < ((DimensionLookupData)this.data).keynrs.length; ++i) {
            insertRow[insertIndex++] = row[((DimensionLookupData)this.data).keynrs[i]];
        }
        for (i = 0; i < ((DimensionLookupData)this.data).fieldnrs.length; ++i) {
            if (((DimensionLookupData)this.data).fieldnrs[i] < 0) continue;
            insertRow[insertIndex++] = row[((DimensionLookupData)this.data).fieldnrs[i]];
        }
        block50: for (i = 0; i < ((DimensionLookupMeta)this.meta).getFieldUpdate().length; ++i) {
            switch (((DimensionLookupMeta)this.meta).getFieldUpdate()[i]) {
                case 3: 
                case 4: {
                    insertRow[insertIndex++] = new Date();
                    continue block50;
                }
                case 6: {
                    insertRow[insertIndex++] = Boolean.TRUE;
                    continue block50;
                }
            }
        }
        if (this.isDebug()) {
            this.logDebug("rins, size=" + ((DimensionLookupData)this.data).insertRowMeta.size() + ", values=" + ((DimensionLookupData)this.data).insertRowMeta.getString(insertRow));
        }
        ((DimensionLookupData)this.data).db.setValues(((DimensionLookupData)this.data).insertRowMeta, insertRow, ((DimensionLookupData)this.data).prepStatementInsert);
        ((DimensionLookupData)this.data).db.insertRow(((DimensionLookupData)this.data).prepStatementInsert);
        if (this.isDebug()) {
            this.logDebug("Row inserted!");
        }
        if (technicalKey == null && databaseMeta.supportsAutoGeneratedKeys()) {
            try {
                RowMetaAndData keys = ((DimensionLookupData)this.data).db.getGeneratedKeys(((DimensionLookupData)this.data).prepStatementInsert);
                if (keys.getRowMeta().size() <= 0) {
                    throw new HopDatabaseException("Unable to retrieve value of auto-generated technical key : no value found!");
                }
                technicalKey = keys.getRowMeta().getInteger(keys.getData(), 0);
            }
            catch (Exception e) {
                throw new HopDatabaseException("Unable to retrieve value of auto-generated technical key : unexpected error: ", (Throwable)e);
            }
        }
        if (!newEntry) {
            Object[] updateRow = new Object[((DimensionLookupData)this.data).updateRowMeta.size()];
            int updateIndex = 0;
            switch (((DimensionLookupData)this.data).startDateChoice) {
                case 0: {
                    updateRow[updateIndex++] = dateFrom;
                    break;
                }
                case 1: {
                    updateRow[updateIndex++] = new Date();
                    break;
                }
                case 2: {
                    updateRow[updateIndex++] = this.getPipeline().getExecutionStartDate();
                    break;
                }
                case 3: {
                    updateRow[updateIndex++] = null;
                    break;
                }
                case 4: {
                    updateRow[updateIndex++] = inputRowMeta.getDate(row, ((DimensionLookupData)this.data).startDateFieldIndex);
                    break;
                }
                default: {
                    throw new HopTransformException(BaseMessages.getString((String)"DimensionLookup.Exception.IllegalStartDateSelection", (String)Integer.toString(((DimensionLookupData)this.data).startDateChoice)));
                }
            }
            block51: for (i2 = 0; i2 < ((DimensionLookupMeta)this.meta).getFieldUpdate().length; ++i2) {
                switch (((DimensionLookupMeta)this.meta).getFieldUpdate()[i2]) {
                    case 3: {
                        updateRow[updateIndex++] = new Date();
                        continue block51;
                    }
                    case 6: {
                        updateRow[updateIndex++] = Boolean.FALSE;
                        continue block51;
                    }
                    case 5: {
                        updateRow[updateIndex++] = new Date();
                        continue block51;
                    }
                }
            }
            for (i2 = 0; i2 < ((DimensionLookupData)this.data).keynrs.length; ++i2) {
                updateRow[updateIndex++] = row[((DimensionLookupData)this.data).keynrs[i2]];
            }
            updateRow[updateIndex++] = versionNr - 1L;
            if (this.isRowLevel()) {
                this.logRowlevel("UPDATE using rupd=" + ((DimensionLookupData)this.data).updateRowMeta.getString(updateRow));
            }
            ((DimensionLookupData)this.data).db.setValues(((DimensionLookupData)this.data).updateRowMeta, updateRow, ((DimensionLookupData)this.data).prepStatementUpdate);
            if (this.isDebug()) {
                this.logDebug("Values set for update (" + ((DimensionLookupData)this.data).updateRowMeta.size() + ")");
            }
            ((DimensionLookupData)this.data).db.insertRow(((DimensionLookupData)this.data).prepStatementUpdate);
            if (this.isDebug()) {
                this.logDebug("Row updated!");
            }
        }
        return technicalKey;
    }

    public boolean isRowLevel() {
        return this.log.isRowLevel();
    }

    public boolean isDebug() {
        return this.log.isDebug();
    }

    public void dimUpdate(IRowMeta rowMeta, Object[] row, Long dimkey, Date valueDate) throws HopDatabaseException {
        int i;
        if (((DimensionLookupData)this.data).prepStatementDimensionUpdate == null) {
            ((DimensionLookupData)this.data).dimensionUpdateRowMeta = new RowMeta();
            String sql = "UPDATE " + ((DimensionLookupData)this.data).schemaTable + Const.CR + "SET ";
            boolean comma = false;
            for (i = 0; i < ((DimensionLookupMeta)this.meta).getFieldLookup().length; ++i) {
                if (DimensionLookupMeta.isUpdateTypeWithoutArgument(((DimensionLookupMeta)this.meta).isUpdate(), ((DimensionLookupMeta)this.meta).getFieldUpdate()[i])) continue;
                sql = comma ? sql + ", " : sql + "  ";
                comma = true;
                sql = sql + ((DimensionLookupMeta)this.meta).getDatabaseMeta().quoteField(((DimensionLookupMeta)this.meta).getFieldLookup()[i]) + " = ?" + Const.CR;
                ((DimensionLookupData)this.data).dimensionUpdateRowMeta.addValueMeta(rowMeta.getValueMeta(((DimensionLookupData)this.data).fieldnrs[i]));
            }
            for (i = 0; i < ((DimensionLookupMeta)this.meta).getFieldUpdate().length; ++i) {
                ValueMetaDate valueMeta = null;
                switch (((DimensionLookupMeta)this.meta).getFieldUpdate()[i]) {
                    case 3: 
                    case 5: {
                        valueMeta = new ValueMetaDate(((DimensionLookupMeta)this.meta).getFieldLookup()[i]);
                        break;
                    }
                }
                if (valueMeta == null) continue;
                sql = comma ? sql + ", " : sql + "  ";
                comma = true;
                sql = sql + ((DimensionLookupMeta)this.meta).getDatabaseMeta().quoteField(valueMeta.getName()) + " = ?" + Const.CR;
                ((DimensionLookupData)this.data).dimensionUpdateRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
            sql = sql + "WHERE  " + ((DimensionLookupMeta)this.meta).getDatabaseMeta().quoteField(((DimensionLookupMeta)this.meta).getKeyField()) + " = ?";
            ((DimensionLookupData)this.data).dimensionUpdateRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger(((DimensionLookupMeta)this.meta).getKeyField()));
            try {
                if (this.isDebug()) {
                    this.logDebug("Preparing statement: [" + sql + "]");
                }
                ((DimensionLookupData)this.data).prepStatementDimensionUpdate = ((DimensionLookupData)this.data).db.getConnection().prepareStatement(((DimensionLookupMeta)this.meta).getDatabaseMeta().stripCR(sql));
            }
            catch (SQLException ex) {
                throw new HopDatabaseException("Couldn't prepare statement :" + Const.CR + sql, (Throwable)ex);
            }
        }
        Object[] dimensionUpdateRow = new Object[((DimensionLookupData)this.data).dimensionUpdateRowMeta.size()];
        int updateIndex = 0;
        for (i = 0; i < ((DimensionLookupData)this.data).fieldnrs.length; ++i) {
            if (((DimensionLookupData)this.data).fieldnrs[i] < 0) continue;
            dimensionUpdateRow[updateIndex++] = row[((DimensionLookupData)this.data).fieldnrs[i]];
        }
        block11: for (i = 0; i < ((DimensionLookupMeta)this.meta).getFieldUpdate().length; ++i) {
            switch (((DimensionLookupMeta)this.meta).getFieldUpdate()[i]) {
                case 3: 
                case 5: {
                    dimensionUpdateRow[updateIndex++] = valueDate;
                    continue block11;
                }
            }
        }
        dimensionUpdateRow[updateIndex++] = dimkey;
        ((DimensionLookupData)this.data).db.setValues(((DimensionLookupData)this.data).dimensionUpdateRowMeta, dimensionUpdateRow, ((DimensionLookupData)this.data).prepStatementDimensionUpdate);
        ((DimensionLookupData)this.data).db.insertRow(((DimensionLookupData)this.data).prepStatementDimensionUpdate);
    }

    public void dimPunchThrough(IRowMeta rowMeta, Object[] row) throws HopDatabaseException {
        int i;
        if (((DimensionLookupData)this.data).prepStatementPunchThrough == null) {
            int i2;
            DatabaseMeta databaseMeta = ((DimensionLookupMeta)this.meta).getDatabaseMeta();
            ((DimensionLookupData)this.data).punchThroughRowMeta = new RowMeta();
            String sqlUpdate = "UPDATE " + ((DimensionLookupData)this.data).schemaTable + Const.CR;
            sqlUpdate = sqlUpdate + "SET ";
            boolean first = true;
            for (i2 = 0; i2 < ((DimensionLookupMeta)this.meta).getFieldLookup().length; ++i2) {
                if (((DimensionLookupMeta)this.meta).getFieldUpdate()[i2] != 2) continue;
                sqlUpdate = !first ? sqlUpdate + ", " : sqlUpdate + "  ";
                first = false;
                sqlUpdate = sqlUpdate + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getFieldLookup()[i2]) + " = ?" + Const.CR;
                ((DimensionLookupData)this.data).punchThroughRowMeta.addValueMeta(rowMeta.getValueMeta(((DimensionLookupData)this.data).fieldnrs[i2]));
            }
            for (i2 = 0; i2 < ((DimensionLookupMeta)this.meta).getFieldUpdate().length; ++i2) {
                ValueMetaDate valueMeta = null;
                switch (((DimensionLookupMeta)this.meta).getFieldUpdate()[i2]) {
                    case 3: 
                    case 5: {
                        valueMeta = new ValueMetaDate(((DimensionLookupMeta)this.meta).getFieldLookup()[i2]);
                        break;
                    }
                }
                if (valueMeta == null) continue;
                sqlUpdate = sqlUpdate + ", " + databaseMeta.quoteField(valueMeta.getName()) + " = ?" + Const.CR;
                ((DimensionLookupData)this.data).punchThroughRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
            sqlUpdate = sqlUpdate + "WHERE ";
            for (i2 = 0; i2 < ((DimensionLookupMeta)this.meta).getKeyLookup().length; ++i2) {
                if (i2 > 0) {
                    sqlUpdate = sqlUpdate + "AND   ";
                }
                sqlUpdate = sqlUpdate + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getKeyLookup()[i2]) + " = ?" + Const.CR;
                ((DimensionLookupData)this.data).punchThroughRowMeta.addValueMeta(rowMeta.getValueMeta(((DimensionLookupData)this.data).keynrs[i2]));
            }
            try {
                ((DimensionLookupData)this.data).prepStatementPunchThrough = ((DimensionLookupData)this.data).db.getConnection().prepareStatement(((DimensionLookupMeta)this.meta).getDatabaseMeta().stripCR(sqlUpdate));
            }
            catch (SQLException ex) {
                throw new HopDatabaseException("Unable to prepare dimension punchThrough update statement : " + Const.CR + sqlUpdate, (Throwable)ex);
            }
        }
        Object[] punchThroughRow = new Object[((DimensionLookupData)this.data).punchThroughRowMeta.size()];
        int punchIndex = 0;
        for (i = 0; i < ((DimensionLookupMeta)this.meta).getFieldLookup().length; ++i) {
            if (((DimensionLookupMeta)this.meta).getFieldUpdate()[i] != 2) continue;
            punchThroughRow[punchIndex++] = row[((DimensionLookupData)this.data).fieldnrs[i]];
        }
        block12: for (i = 0; i < ((DimensionLookupMeta)this.meta).getFieldUpdate().length; ++i) {
            switch (((DimensionLookupMeta)this.meta).getFieldUpdate()[i]) {
                case 3: 
                case 5: {
                    punchThroughRow[punchIndex++] = new Date();
                    continue block12;
                }
            }
        }
        for (i = 0; i < ((DimensionLookupData)this.data).keynrs.length; ++i) {
            punchThroughRow[punchIndex++] = row[((DimensionLookupData)this.data).keynrs[i]];
        }
        ((DimensionLookupData)this.data).db.setValues(((DimensionLookupData)this.data).punchThroughRowMeta, punchThroughRow, ((DimensionLookupData)this.data).prepStatementPunchThrough);
        ((DimensionLookupData)this.data).db.insertRow(((DimensionLookupData)this.data).prepStatementPunchThrough);
    }

    private Object[] getCacheValues(IRowMeta rowMeta, Object[] row, Long technicalKey, Long valueVersion, Date valueDateFrom, Date valueDateTo) {
        if (((DimensionLookupData)this.data).cacheValueRowMeta == null) {
            return null;
        }
        Object[] cacheValues = new Object[((DimensionLookupData)this.data).cacheValueRowMeta.size()];
        int cacheIndex = 0;
        cacheValues[cacheIndex++] = technicalKey;
        cacheValues[cacheIndex++] = valueVersion;
        for (int i = 0; i < ((DimensionLookupData)this.data).fieldnrs.length; ++i) {
            if (((DimensionLookupData)this.data).fieldnrs[i] < 0) continue;
            cacheValues[cacheIndex++] = row[((DimensionLookupData)this.data).fieldnrs[i]];
        }
        cacheValues[cacheIndex++] = valueDateFrom;
        cacheValues[cacheIndex++] = valueDateTo;
        return cacheValues;
    }

    private void addToCache(Object[] keyValues, Object[] returnValues) throws HopValueException {
        if (((DimensionLookupData)this.data).cacheValueRowMeta == null) {
            ((DimensionLookupData)this.data).cacheValueRowMeta = this.assembleCacheValueRowMeta();
        }
        byte[] keyPart = RowMeta.extractData((IRowMeta)((DimensionLookupData)this.data).cacheKeyRowMeta, (Object[])keyValues);
        byte[] valuePart = RowMeta.extractData((IRowMeta)((DimensionLookupData)this.data).cacheValueRowMeta, (Object[])returnValues);
        ((DimensionLookupData)this.data).cache.put(keyPart, valuePart);
        int tenPercent = ((DimensionLookupMeta)this.meta).getCacheSize() / 10;
        if (((DimensionLookupMeta)this.meta).getCacheSize() > 0 && ((DimensionLookupData)this.data).cache.size() > ((DimensionLookupMeta)this.meta).getCacheSize() + tenPercent) {
            Object[] values;
            byte[] value;
            byte[] key;
            int i;
            List keys = ((DimensionLookupData)this.data).cache.getKeys();
            int sizeBefore = keys.size();
            ArrayList<Long> samples = new ArrayList<Long>();
            int transformsize = keys.size() / 5;
            if (transformsize < 1) {
                transformsize = 1;
            }
            for (i = 0; i < keys.size(); i += transformsize) {
                key = (byte[])keys.get(i);
                value = ((DimensionLookupData)this.data).cache.get(key);
                if (value == null) continue;
                values = RowMeta.getRow((IRowMeta)((DimensionLookupData)this.data).cacheValueRowMeta, (byte[])value);
                Long tk = ((DimensionLookupData)this.data).cacheValueRowMeta.getInteger(values, 0);
                samples.add(tk);
            }
            Collections.sort(samples);
            if (samples.size() > 1) {
                ((DimensionLookupData)this.data).smallestCacheKey = (Long)samples.get(1);
            } else if (!samples.isEmpty()) {
                ((DimensionLookupData)this.data).smallestCacheKey = (Long)samples.get(0);
            } else {
                return;
            }
            for (i = 0; i < keys.size(); ++i) {
                long tk;
                key = (byte[])keys.get(i);
                value = ((DimensionLookupData)this.data).cache.get(key);
                if (value == null || (tk = ((DimensionLookupData)this.data).cacheValueRowMeta.getInteger(values = RowMeta.getRow((IRowMeta)((DimensionLookupData)this.data).cacheValueRowMeta, (byte[])value), 0).longValue()) > ((DimensionLookupData)this.data).smallestCacheKey) continue;
                ((DimensionLookupData)this.data).cache.remove((Object)key);
            }
            int sizeAfter = ((DimensionLookupData)this.data).cache.size();
            this.logDetailed("Reduced the lookup cache from " + sizeBefore + " to " + sizeAfter + " rows.");
        }
        if (this.isRowLevel()) {
            this.logRowlevel("Cache store: key=" + Arrays.toString(keyValues) + "    values=" + Arrays.toString(returnValues));
        }
    }

    private IRowMeta assembleCacheValueRowMeta() {
        IRowMeta cacheRowMeta = ((DimensionLookupData)this.data).returnRowMeta.clone();
        return cacheRowMeta;
    }

    private Object[] getFromCache(Object[] keyValues, Date dateValue) throws HopValueException {
        byte[] key;
        byte[] value;
        if (((DimensionLookupData)this.data).cacheValueRowMeta == null) {
            if (((DimensionLookupData)this.data).returnRowMeta == null) {
                return null;
            }
            ((DimensionLookupData)this.data).cacheValueRowMeta = this.assembleCacheValueRowMeta();
        }
        if ((value = ((DimensionLookupData)this.data).cache.get(key = RowMeta.extractData((IRowMeta)((DimensionLookupData)this.data).cacheKeyRowMeta, (Object[])keyValues))) != null) {
            Object[] row = RowMeta.getRow((IRowMeta)((DimensionLookupData)this.data).cacheValueRowMeta, (byte[])value);
            long time = dateValue.getTime();
            long from = ((Date)row[row.length - 2]).getTime();
            long to = ((Date)row[row.length - 1]).getTime();
            if (time >= from && time < to) {
                if (this.isRowLevel()) {
                    this.logRowlevel("Cache hit: key=" + ((DimensionLookupData)this.data).cacheKeyRowMeta.getString(keyValues) + "  values=" + ((DimensionLookupData)this.data).cacheValueRowMeta.getString(row));
                }
                return row;
            }
        }
        return null;
    }

    public void checkDimZero() throws HopException {
        String sql;
        RowMetaAndData r;
        Long count;
        if (!((DimensionLookupMeta)this.meta).isUpdate()) {
            return;
        }
        DatabaseMeta databaseMeta = ((DimensionLookupMeta)this.meta).getDatabaseMeta();
        int startTechnicalKey = databaseMeta.getNotFoundTK(this.isAutoIncrement());
        if (((DimensionLookupMeta)this.meta).isAutoIncrement() && (count = (r = ((DimensionLookupData)this.data).db.getOneRow(sql = "SELECT count(*) FROM " + ((DimensionLookupData)this.data).schemaTable + " WHERE " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getKeyField()) + " = " + startTechnicalKey)).getRowMeta().getInteger(r.getData(), 0)) != 0L) {
            return;
        }
        sql = "SELECT count(*) FROM " + ((DimensionLookupData)this.data).schemaTable + " WHERE " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getKeyField()) + " = " + startTechnicalKey;
        r = ((DimensionLookupData)this.data).db.getOneRow(sql);
        count = r.getRowMeta().getInteger(r.getData(), 0);
        if (count == 0L) {
            Object isql = null;
            try {
                isql = !databaseMeta.supportsAutoinc() || !this.isAutoIncrement() ? "insert into " + ((DimensionLookupData)this.data).schemaTable + "(" + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getKeyField()) + ", " + databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getVersionField()) + ") values (0, 1)" : databaseMeta.getSqlInsertAutoIncUnknownDimensionRow(((DimensionLookupData)this.data).schemaTable, databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getKeyField()), databaseMeta.quoteField(((DimensionLookupMeta)this.meta).getVersionField()));
                ((DimensionLookupData)this.data).db.execStatement(databaseMeta.stripCR((String)isql));
            }
            catch (HopException e) {
                throw new HopDatabaseException("Error inserting 'unknown' row in dimension [" + ((DimensionLookupData)this.data).schemaTable + "] : " + isql, (Throwable)e);
            }
        }
    }

    public boolean init() {
        if (super.init()) {
            ((DimensionLookupMeta)this.meta).actualizeWithInjectedValues();
            ((DimensionLookupData)this.data).minDate = ((DimensionLookupMeta)this.meta).getMinDate();
            ((DimensionLookupData)this.data).maxDate = ((DimensionLookupMeta)this.meta).getMaxDate();
            ((DimensionLookupData)this.data).realSchemaName = this.resolve(((DimensionLookupMeta)this.meta).getSchemaName());
            ((DimensionLookupData)this.data).realTableName = this.resolve(((DimensionLookupMeta)this.meta).getTableName());
            ((DimensionLookupData)this.data).startDateChoice = 0;
            if (((DimensionLookupMeta)this.meta).isUsingStartDateAlternative()) {
                ((DimensionLookupData)this.data).startDateChoice = ((DimensionLookupMeta)this.meta).getStartDateAlternative();
            }
            if (((DimensionLookupMeta)this.meta).getDatabaseMeta() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"DimensionLookup.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                return false;
            }
            ((DimensionLookupData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, ((DimensionLookupMeta)this.meta).getDatabaseMeta());
            try {
                ((DimensionLookupData)this.data).db.connect();
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.ConnectedToDB", (String[])new String[0]));
                }
                ((DimensionLookupData)this.data).db.setCommit(((DimensionLookupMeta)this.meta).getCommitSize());
                return true;
            }
            catch (HopException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.ErrorOccurredInProcessing", (String[])new String[0]) + ke.getMessage());
            }
        }
        return false;
    }

    public void dispose() {
        if (((DimensionLookupData)this.data).db != null) {
            try {
                if (!((DimensionLookupData)this.data).db.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        ((DimensionLookupData)this.data).db.commit();
                    } else {
                        ((DimensionLookupData)this.data).db.rollback();
                    }
                }
            }
            catch (HopDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"DimensionLookup.Log.ErrorOccurredInProcessing", (String[])new String[0]) + e.getMessage());
            }
            finally {
                ((DimensionLookupData)this.data).db.disconnect();
            }
        }
        super.dispose();
    }
}

