/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import java.util.function.BiConsumer;
import org.apache.beam.sdk.fn.data.CompletableFutureInboundDataClient;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.fn.data.InboundDataClient;
import org.apache.beam.sdk.fn.data.LogicalEndpoint;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BeamFnDataInboundObserver
implements BiConsumer<ByteString, Boolean>,
InboundDataClient {
    private static final Logger LOG = LoggerFactory.getLogger(BeamFnDataInboundObserver.class);
    private final LogicalEndpoint endpoint;
    private final FnDataReceiver<ByteString> consumer;
    private final InboundDataClient readFuture;
    private long byteCounter;

    public static BeamFnDataInboundObserver forConsumer(LogicalEndpoint endpoint, FnDataReceiver<ByteString> receiver) {
        return new BeamFnDataInboundObserver(endpoint, receiver, CompletableFutureInboundDataClient.create());
    }

    public BeamFnDataInboundObserver(LogicalEndpoint endpoint, FnDataReceiver<ByteString> consumer, InboundDataClient readFuture) {
        this.endpoint = endpoint;
        this.consumer = consumer;
        this.readFuture = readFuture;
    }

    @Override
    public void accept(ByteString payload, Boolean isLast) {
        if (this.readFuture.isDone()) {
            return;
        }
        try {
            if (isLast.booleanValue()) {
                LOG.debug("Closing stream for {} having consumed {} bytes", (Object)this.endpoint, (Object)this.byteCounter);
                this.readFuture.complete();
                return;
            }
            this.byteCounter += (long)payload.size();
            this.consumer.accept(payload);
        }
        catch (Exception e) {
            this.readFuture.fail(e);
        }
    }

    @Override
    public void awaitCompletion() throws Exception {
        this.readFuture.awaitCompletion();
    }

    @Override
    public void runWhenComplete(Runnable completeRunnable) {
        this.readFuture.runWhenComplete(completeRunnable);
    }

    @Override
    public boolean isDone() {
        return this.readFuture.isDone();
    }

    @Override
    public void cancel() {
        this.readFuture.cancel();
    }

    @Override
    public void complete() {
        this.readFuture.complete();
    }

    @Override
    public void fail(Throwable t) {
        this.readFuture.fail(t);
    }
}

