/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse.copy;

import cc.blynk.clickhouse.ClickHouseConnection;
import cc.blynk.clickhouse.ClickHousePreparedStatement;
import cc.blynk.clickhouse.copy.CopyManager;
import cc.blynk.clickhouse.copy.ReaderInputStream;
import cc.blynk.clickhouse.copy.WriterOutputStream;
import cc.blynk.clickhouse.settings.ClickHouseQueryParam;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;

final class CopyManagerImpl
implements CopyManager {
    private final ClickHouseConnection connection;
    private final Map<ClickHouseQueryParam, String> additionalDBParams;

    CopyManagerImpl(Connection connection) throws SQLException {
        this(connection, null);
    }

    CopyManagerImpl(Connection connection, Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        this.connection = connection.unwrap(ClickHouseConnection.class);
        this.additionalDBParams = additionalDBParams;
    }

    @Override
    public void copyToDb(String sql, InputStream from) throws SQLException {
        CopyManagerImpl.validate(sql, from);
        this.connection.createStatement().sendStreamSQL(from, sql, this.additionalDBParams);
    }

    @Override
    public void copyToDb(String sql, Path from) throws IOException, SQLException {
        CopyManagerImpl.validate(sql, from);
        try (InputStream inputStream = Files.newInputStream(from, new OpenOption[0]);){
            this.copyToDb(sql, inputStream);
        }
    }

    @Override
    public void copyToDb(String sql, File file) throws IOException, SQLException {
        CopyManagerImpl.validate(sql, file);
        this.copyToDb(sql, file.toPath());
    }

    @Override
    public void copyToDb(String sql, InputStream from, int bufferSize) throws SQLException {
        CopyManagerImpl.validate(sql, from);
        BufferedInputStream bufferedStream = new BufferedInputStream(from, Math.max(32, bufferSize));
        this.connection.createStatement().sendStreamSQL(bufferedStream, sql, this.additionalDBParams);
    }

    @Override
    public void copyToDb(String sql, Reader from) throws SQLException {
        CopyManagerImpl.validate(sql, from);
        ReaderInputStream inputStream = new ReaderInputStream(from);
        this.connection.createStatement().sendStreamSQL(inputStream, sql, this.additionalDBParams);
    }

    @Override
    public void copyToDb(String sql, Reader from, int bufferSize) throws SQLException {
        CopyManagerImpl.validate(sql, from);
        ReaderInputStream inputStream = new ReaderInputStream(from);
        BufferedInputStream bufferedStream = new BufferedInputStream(inputStream, Math.max(32, bufferSize));
        this.connection.createStatement().sendStreamSQL(bufferedStream, sql, this.additionalDBParams);
    }

    @Override
    public void copyFromDb(String sql, OutputStream to) throws SQLException {
        CopyManagerImpl.validate(sql, to);
        this.connection.createStatement().sendStreamSQL(sql, to, this.additionalDBParams);
    }

    @Override
    public void copyFromDb(String sql, Writer to) throws SQLException {
        CopyManagerImpl.validate(sql, to);
        WriterOutputStream outputStream = new WriterOutputStream(to);
        this.connection.createStatement().sendStreamSQL(sql, outputStream, this.additionalDBParams);
    }

    @Override
    public void copyFromDb(String sql, Path to) throws IOException, SQLException {
        CopyManagerImpl.validate(sql, to);
        try (OutputStream os = Files.newOutputStream(to, StandardOpenOption.TRUNCATE_EXISTING);){
            this.copyFromDb(sql, os);
        }
    }

    @Override
    public void copyFromDb(String sql, File to) throws IOException, SQLException {
        CopyManagerImpl.validate(sql, to);
        this.copyFromDb(sql, to.toPath());
    }

    @Override
    public void copyToDb(PreparedStatement preparedStatement, InputStream from) throws SQLException {
        this.copyToDb(this.getSql(preparedStatement), from);
    }

    @Override
    public void copyToDb(PreparedStatement preparedStatement, Path path) throws IOException, SQLException {
        this.copyToDb(this.getSql(preparedStatement), path);
    }

    @Override
    public void copyToDb(PreparedStatement preparedStatement, File file) throws IOException, SQLException {
        this.copyToDb(this.getSql(preparedStatement), file);
    }

    @Override
    public void copyToDb(PreparedStatement preparedStatement, InputStream from, int bufferSize) throws SQLException {
        this.copyToDb(this.getSql(preparedStatement), from, bufferSize);
    }

    @Override
    public void copyToDb(PreparedStatement preparedStatement, Reader from) throws SQLException {
        this.copyToDb(this.getSql(preparedStatement), from);
    }

    @Override
    public void copyToDb(PreparedStatement preparedStatement, Reader from, int bufferSize) throws SQLException {
        this.copyToDb(this.getSql(preparedStatement), from, bufferSize);
    }

    @Override
    public void copyFromDb(PreparedStatement preparedStatement, OutputStream to) throws SQLException {
        this.copyFromDb(this.getSql(preparedStatement), to);
    }

    @Override
    public void copyFromDb(PreparedStatement preparedStatement, Writer to) throws SQLException {
        this.copyFromDb(this.getSql(preparedStatement), to);
    }

    @Override
    public void copyFromDb(PreparedStatement preparedStatement, Path to) throws IOException, SQLException {
        this.copyFromDb(this.getSql(preparedStatement), to);
    }

    @Override
    public void copyFromDb(PreparedStatement preparedStatement, File to) throws IOException, SQLException {
        this.copyFromDb(this.getSql(preparedStatement), to);
    }

    private String getSql(PreparedStatement ps) throws SQLException {
        ClickHousePreparedStatement clickHouseStatement = ps.unwrap(ClickHousePreparedStatement.class);
        return clickHouseStatement.asSql();
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    private static void validate(String sql, Object stream) throws SQLException {
        if (sql == null) {
            throw new SQLException("SQL query is null.");
        }
        if (stream == null) {
            throw new SQLException("Stream is null.");
        }
    }
}

