/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.auth.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.auth.core.AuthenticationFactoryException;
import org.apache.hop.core.auth.core.IAuthenticationConsumer;
import org.apache.hop.core.auth.core.IAuthenticationConsumerFactory;
import org.apache.hop.core.auth.core.IAuthenticationPerformer;
import org.apache.hop.core.auth.core.IAuthenticationPerformerFactory;
import org.apache.hop.core.auth.core.IAuthenticationProvider;
import org.apache.hop.core.auth.core.impl.DefaultAuthenticationConsumerFactory;
import org.apache.hop.core.auth.core.impl.DefaultAuthenticationPerformerFactory;
import org.apache.hop.i18n.BaseMessages;

public class AuthenticationManager {
    private static final Class<?> PKG = AuthenticationManager.class;
    private final Map<Class<?>, Map<Class<?>, Map<Class<?>, IAuthenticationConsumerFactory<?, ?, ?>>>> factoryMap = new HashMap();
    private IAuthenticationPerformerFactory authenticationPerformerFactory = new DefaultAuthenticationPerformerFactory();
    private final List<IAuthenticationProvider> authenticationProviders = new ArrayList<IAuthenticationProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAuthenticationProvider(IAuthenticationProvider authenticationProvider) {
        List<IAuthenticationProvider> list = this.authenticationProviders;
        synchronized (list) {
            this.authenticationProviders.add(authenticationProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterAuthenticationProvider(IAuthenticationProvider authenticationProvider) {
        List<IAuthenticationProvider> list = this.authenticationProviders;
        synchronized (list) {
            return this.authenticationProviders.remove(authenticationProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType, CreateArgType, ConsumedType> void registerConsumerFactory(IAuthenticationConsumerFactory<ReturnType, CreateArgType, ConsumedType> factory) throws AuthenticationFactoryException {
        Map<Class<?>, IAuthenticationConsumerFactory<?, ?, ?>> createTypeMap;
        if (!factory.getConsumedType().isInterface() && !IAuthenticationProvider.class.isAssignableFrom(factory.getConsumedType())) {
            throw new AuthenticationFactoryException(BaseMessages.getString(PKG, (String)"AuthenticationManager.ConsumedTypeError", (Object[])new Object[]{factory}));
        }
        Map<Class<?>, IAuthenticationConsumerFactory<?, ?, ?>> map = createTypeMap = this.getRelevantConsumerFactoryMap(factory.getReturnType(), factory.getCreateArgType());
        synchronized (map) {
            createTypeMap.put(factory.getConsumedType(), factory);
        }
    }

    public <ReturnType, ConsumedType> void registerConsumerClass(Class<? extends IAuthenticationConsumer<? extends ReturnType, ? extends ConsumedType>> consumerClass) throws AuthenticationFactoryException {
        this.registerConsumerFactory(new DefaultAuthenticationConsumerFactory(consumerClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType, CreateArgType, ConsumedType> List<IAuthenticationPerformer<ReturnType, CreateArgType>> getSupportedAuthenticationPerformers(Class<ReturnType> returnType, Class<CreateArgType> createArgType) {
        ArrayList<IAuthenticationProvider> authenticationProviders;
        Map<Class<?>, IAuthenticationConsumerFactory<?, ?, ?>> createTypeMap;
        Map<Class<?>, IAuthenticationConsumerFactory<?, ?, ?>> map = createTypeMap = this.getRelevantConsumerFactoryMap(returnType, createArgType);
        synchronized (map) {
            createTypeMap = new HashMap(createTypeMap);
        }
        List<IAuthenticationProvider> list = this.authenticationProviders;
        synchronized (list) {
            authenticationProviders = new ArrayList<IAuthenticationProvider>(this.authenticationProviders);
        }
        ArrayList<IAuthenticationPerformer<ReturnType, CreateArgType>> result = new ArrayList<IAuthenticationPerformer<ReturnType, CreateArgType>>();
        for (Map.Entry<Class<?>, IAuthenticationConsumerFactory<?, ?, ?>> entry : createTypeMap.entrySet()) {
            for (IAuthenticationProvider provider : authenticationProviders) {
                IAuthenticationPerformer<?, ?> authenticationPerformer = this.authenticationPerformerFactory.create(provider, entry.getValue());
                if (authenticationPerformer == null || authenticationPerformer.getDisplayName() == null) continue;
                result.add(authenticationPerformer);
            }
        }
        Collections.sort(result, (o1, o2) -> o1.getDisplayName().toUpperCase().compareTo(o2.getDisplayName().toUpperCase()));
        return result;
    }

    public <ReturnType, CreateArgType, ConsumedType> IAuthenticationPerformer<ReturnType, CreateArgType> getAuthenticationPerformer(Class<ReturnType> returnType, Class<CreateArgType> createArgType, String providerId) {
        List<IAuthenticationPerformer<ReturnType, CreateArgType>> performers = this.getSupportedAuthenticationPerformers(returnType, createArgType);
        for (IAuthenticationPerformer<ReturnType, CreateArgType> candidatePerformer : performers) {
            if (!candidatePerformer.getAuthenticationProvider().getId().equals(providerId)) continue;
            return candidatePerformer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ReturnType, CreateArgType> Map<Class<?>, IAuthenticationConsumerFactory<?, ?, ?>> getRelevantConsumerFactoryMap(Class<ReturnType> returnType, Class<CreateArgType> createArgType) {
        Map<Class<?>, Map<Class<?>, Map<Class<?>, IAuthenticationConsumerFactory<?, ?, ?>>>> map = this.factoryMap;
        synchronized (map) {
            Map<Class<?>, IAuthenticationConsumerFactory<?, ?, ?>> createTypeMap;
            Map<Class<?>, Map<Class<?>, IAuthenticationConsumerFactory<?, ?, ?>>> returnTypeMap = this.factoryMap.get(returnType);
            if (returnTypeMap == null) {
                returnTypeMap = new HashMap();
                this.factoryMap.put(returnType, returnTypeMap);
            }
            if ((createTypeMap = returnTypeMap.get(createArgType)) == null) {
                createTypeMap = new HashMap();
                returnTypeMap.put(createArgType, createTypeMap);
            }
            return createTypeMap;
        }
    }

    protected void setAuthenticationPerformerFactory(IAuthenticationPerformerFactory authenticationPerformerFactory) {
        this.authenticationPerformerFactory = authenticationPerformerFactory;
    }
}

