/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.history.local;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.history.AuditEvent;
import org.apache.hop.history.AuditList;
import org.apache.hop.history.AuditState;
import org.apache.hop.history.AuditStateMap;
import org.apache.hop.history.IAuditManager;

public class LocalAuditManager
implements IAuditManager {
    private String rootFolder;

    public LocalAuditManager() {
        this.rootFolder = Const.HOP_AUDIT_FOLDER;
    }

    public LocalAuditManager(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    @Override
    public void storeEvent(AuditEvent event) throws HopException {
        this.validateEvent(event);
        this.writeEvent(event);
    }

    private void writeEvent(AuditEvent event) throws HopException {
        String filename = this.calculateEventFilename(event);
        try {
            File file = new File(filename);
            File parentFolder = file.getParentFile();
            if (!parentFolder.exists()) {
                parentFolder.mkdirs();
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(new File(filename), (Object)event);
        }
        catch (IOException e) {
            throw new HopException("Unable to write event to filename '" + filename + "'", (Throwable)e);
        }
    }

    private String calculateEventFilename(AuditEvent event) {
        String typePath = this.calculateTypePath(event.getGroup(), event.getType());
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS");
        String filename = format.format(event.getDate()) + "-" + event.getOperation() + ".event";
        return typePath + File.separator + filename;
    }

    private String calculateGroupPath(String group) {
        return this.rootFolder + File.separator + group;
    }

    private String calculateTypePath(String group, String type) {
        return this.calculateGroupPath(group) + File.separator + type;
    }

    @Override
    public List<AuditEvent> findEvents(String group, String type, boolean unique) throws HopException {
        File[] eventFiles;
        if (StringUtils.isEmpty((String)group)) {
            throw new HopException("You need to specify a group to find events");
        }
        if (StringUtils.isEmpty((String)type)) {
            throw new HopException("You need to specify a type to find events");
        }
        ArrayList<AuditEvent> events = new ArrayList<AuditEvent>();
        HashMap<String, AuditEvent> eventsMap = new HashMap<String, AuditEvent>();
        String folderPath = this.calculateTypePath(group, type);
        File folder = new File(folderPath);
        if (!folder.exists()) {
            return events;
        }
        ObjectMapper mapper = new ObjectMapper();
        for (File eventFile : eventFiles = folder.listFiles((dir, name) -> name.endsWith("event"))) {
            try {
                AuditEvent event = (AuditEvent)mapper.readValue(eventFile, AuditEvent.class);
                if (unique) {
                    AuditEvent existing = (AuditEvent)eventsMap.get(event.getName());
                    if (existing != null && existing.getDate().compareTo(event.getDate()) >= 0) continue;
                    eventsMap.put(event.getName(), event);
                    continue;
                }
                events.add(event);
            }
            catch (IOException e) {
                throw new HopException("Error reading event file '" + eventFile.toString() + "'", (Throwable)e);
            }
        }
        if (unique) {
            events.addAll(eventsMap.values());
        }
        Collections.sort(events, Comparator.comparing(AuditEvent::getDate).reversed());
        return events;
    }

    @Override
    public void storeList(String group, String type, AuditList auditList) throws HopException {
        this.validateList(group, type, auditList);
        String filename = this.calculateGroupPath(group) + File.separator + type + ".list";
        this.checkFileAndFolder(filename);
        try {
            new ObjectMapper().writeValue(new File(filename), (Object)auditList);
        }
        catch (IOException e) {
            throw new HopException("It was not possible to write to audit list file '" + filename + "'", (Throwable)e);
        }
    }

    @Override
    public AuditList retrieveList(String group, String type) throws HopException {
        if (StringUtils.isEmpty((String)group)) {
            throw new HopException("You need a group before you can retrieve an audit list");
        }
        if (StringUtils.isEmpty((String)type)) {
            throw new HopException("To retrieve an audit list you need to specify the type");
        }
        String filename = this.calculateGroupPath(group) + File.separator + type + ".list";
        if (!this.checkFileAndFolder(filename)) {
            return new AuditList();
        }
        try {
            return (AuditList)new ObjectMapper().readValue(new File(filename), AuditList.class);
        }
        catch (IOException e) {
            throw new HopException("It was not possible to read audit list file '" + filename + "'", (Throwable)e);
        }
    }

    @Override
    public void storeState(String group, String type, AuditState auditState) throws HopException {
        if (StringUtils.isEmpty((String)group)) {
            throw new HopException("The audit state needs a group to be able to store it");
        }
        if (StringUtils.isEmpty((String)type)) {
            throw new HopException("The audit state needs a type to be able to store it");
        }
        AuditStateMap auditStateMap = this.loadAuditStateMap(group, type);
        auditStateMap.add(auditState);
        this.saveAuditStateMap(group, type, auditStateMap);
    }

    private String calculateStateFilename(String group, String type) {
        return this.calculateTypePath(group, type) + "-state.json";
    }

    private boolean checkFileAndFolder(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            File parent = file.getParentFile();
            parent.mkdirs();
            return false;
        }
        return true;
    }

    @Override
    public AuditStateMap loadAuditStateMap(String group, String type) {
        String filename = this.calculateStateFilename(group, type);
        try {
            if (!this.checkFileAndFolder(filename)) {
                return new AuditStateMap();
            }
            return (AuditStateMap)new ObjectMapper().readValue(new File(filename), AuditStateMap.class);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error loading state map from file '" + filename + "'", (Throwable)e);
            return new AuditStateMap();
        }
    }

    @Override
    public void saveAuditStateMap(String group, String type, AuditStateMap auditStateMap) throws HopException {
        String filename = this.calculateStateFilename(group, type);
        try {
            this.checkFileAndFolder(filename);
            new ObjectMapper().writeValue(new File(filename), (Object)auditStateMap);
        }
        catch (Exception e) {
            throw new HopException("Error saving state map to file '" + filename + "'", (Throwable)e);
        }
    }

    @Override
    public AuditState retrieveState(String group, String type, String name) throws HopException {
        if (StringUtils.isEmpty((String)group)) {
            throw new HopException("To retrieve audit state you need to specify a group");
        }
        if (StringUtils.isEmpty((String)type)) {
            throw new HopException("To retrieve audit state you need to specify a type");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new HopException("Please specify the name of the object you which to retrieve the audit state for");
        }
        AuditStateMap auditStateMap = this.loadAuditStateMap(group, type);
        return auditStateMap.get(name);
    }

    private void validateEvent(AuditEvent event) throws HopException {
        if (StringUtils.isEmpty((String)event.getGroup())) {
            throw new HopException("Audit events need to belong to a group");
        }
        if (StringUtils.isEmpty((String)event.getType())) {
            throw new HopException("Audit events need to have a type");
        }
        if (StringUtils.isEmpty((String)event.getName())) {
            throw new HopException("Audit events need to have a name");
        }
        if (StringUtils.isEmpty((String)event.getOperation())) {
            throw new HopException("Audit events need to have an operation");
        }
        if (event.getDate() == null) {
            throw new HopException("Audit events need to have a date");
        }
    }

    private void validateList(String group, String type, AuditList auditList) throws HopException {
        if (StringUtils.isEmpty((String)group)) {
            throw new HopException("An audit list needs to belong to a group");
        }
        if (StringUtils.isEmpty((String)type)) {
            throw new HopException("An audit list needs to have a type");
        }
        if (auditList.getNames() == null) {
            throw new HopException("The audit list of names can't be null");
        }
    }

    private String calculateMapFilename(String group, String type) {
        return this.calculateTypePath(group, type) + "-map.json";
    }

    @Override
    public Map<String, String> loadMap(String group, String type) {
        String filename = this.calculateMapFilename(group, type);
        try {
            if (!this.checkFileAndFolder(filename)) {
                return new HashMap<String, String>();
            }
            return (Map)new ObjectMapper().readValue(new File(filename), Map.class);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error loading strings map from file '" + filename + "'", (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    @Override
    public void saveMap(String group, String type, Map<String, String> map) throws HopException {
        String filename = this.calculateMapFilename(group, type);
        try {
            this.checkFileAndFolder(filename);
            new ObjectMapper().writeValue(new File(filename), map);
        }
        catch (Exception e) {
            throw new HopException("Error saving strings map to file '" + filename + "'", (Throwable)e);
        }
    }

    @Override
    public void clearEvents() throws HopException {
        try {
            FileUtils.deleteDirectory((File)Paths.get(this.rootFolder, new String[0]).toFile());
        }
        catch (IOException e) {
            throw new HopException((Throwable)e);
        }
    }
}

