/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.pipeline.PipelineConfiguration;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.service.WebService;

@HopServerServlet(id="webService", name="Output the content of a field in a transform")
public class WebServiceServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = WebServiceServlet.class;
    private static final long serialVersionUID = 3634806745373343432L;
    public static final String CONTEXT_PATH = "/hop/webService";

    public WebServiceServlet() {
    }

    public WebServiceServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"WebServiceServlet.Log.WebServiceRequested", (String[])new String[0]));
        }
        IVariables variables = this.pipelineMap.getHopServerConfig().getVariables();
        MultiMetadataProvider metadataProvider = this.pipelineMap.getHopServerConfig().getMetadataProvider();
        String webServiceName = request.getParameter("service");
        if (StringUtils.isEmpty((String)webServiceName)) {
            throw new ServletException("Please specify a service parameter pointing to the name of the web service object");
        }
        try {
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(WebService.class);
            WebService webService = (WebService)serializer.load(webServiceName);
            if (webService == null) {
                throw new HopException("Unable to find web service '" + webServiceName + "'.  You can set the metadata_folder in the Hop server XML configuration");
            }
            if (!webService.isEnabled()) {
                throw new HopException("Web service '" + webServiceName + "' is disabled.");
            }
            String filename = variables.resolve(webService.getFilename());
            String transformName = variables.resolve(webService.getTransformName());
            final String fieldName = variables.resolve(webService.getFieldName());
            String contentType = variables.resolve(webService.getContentType());
            if (StringUtils.isEmpty((String)contentType)) {
                response.setContentType("text/plain");
            } else {
                response.setContentType(contentType);
            }
            response.setCharacterEncoding("UTF-8");
            String serverObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.HOP_SERVER, null);
            servletLoggingObject.setContainerObjectId(serverObjectId);
            PipelineMeta pipelineMeta = new PipelineMeta(filename, (IHopMetadataProvider)metadataProvider, true, variables);
            LocalPipelineEngine pipeline = new LocalPipelineEngine(pipelineMeta, variables, (ILoggingObject)servletLoggingObject);
            pipeline.setContainerId(serverObjectId);
            String[] pipelineParameters = pipelineMeta.listParameters();
            pipeline.copyParametersFromDefinitions(pipelineMeta);
            for (String requestParameter : request.getParameterMap().keySet()) {
                if ("service".equals(requestParameter)) continue;
                String requestParameterValue = request.getParameter(requestParameter);
                if (Const.indexOfString((String)requestParameter, (String[])pipelineParameters) < 0) {
                    pipeline.setVariable(requestParameter, Const.NVL((String)requestParameterValue, (String)""));
                    continue;
                }
                pipeline.setParameterValue(requestParameter, Const.NVL((String)requestParameterValue, (String)""));
            }
            pipeline.activateParameters(pipeline);
            if (webService.isListingStatus()) {
                PipelineExecutionConfiguration pipelineExecutionConfiguration = new PipelineExecutionConfiguration();
                PipelineConfiguration pipelineConfiguration = new PipelineConfiguration(pipelineMeta, pipelineExecutionConfiguration, new SerializableMetadataProvider((IHopMetadataProvider)metadataProvider));
                this.getPipelineMap().addPipeline(pipelineMeta.getName(), serverObjectId, pipeline, pipelineConfiguration);
            }
            pipeline.prepareExecution();
            ServletOutputStream outputStream = response.getOutputStream();
            IEngineComponent component = pipeline.findComponent(transformName, 0);
            component.addRowListener(new RowAdapter((OutputStream)outputStream){
                final /* synthetic */ OutputStream val$outputStream;
                {
                    this.val$outputStream = outputStream;
                }

                @Override
                public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                    try {
                        String outputString = rowMeta.getString(row, fieldName, "");
                        this.val$outputStream.write(outputString.getBytes(StandardCharsets.UTF_8));
                        this.val$outputStream.flush();
                    }
                    catch (HopValueException e) {
                        throw new HopTransformException("Error getting output field '" + fieldName + " from row: " + rowMeta.toStringMeta(), (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new HopTransformException("Error writing output of '" + fieldName + "'", (Throwable)e);
                    }
                }
            });
            pipeline.startThreads();
            pipeline.waitUntilFinished();
            response.setStatus(200);
        }
        catch (Exception e) {
            throw new ServletException("Error producing web service output", (Throwable)e);
        }
    }

    public String toString() {
        return "Web Service Servlet";
    }

    @Override
    public String getService() {
        return "/hop/webService (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

