/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getvariable;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.getvariable.GetVariableMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class GetVariableDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = GetVariableMeta.class;
    private Text wTransformName;
    private TableView wFields;
    private final GetVariableMeta input;

    public GetVariableDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (GetVariableMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GetVariableDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        boolean isReceivingInput = this.pipelineMeta.findPreviousTransforms(this.transformMeta).size() > 0;
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(middle, -margin);
        fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment(middle, 0);
        fdTransformName.top = new FormAttachment(0, margin);
        fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetVariables", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.grabVariables());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wPreview.setEnabled(!isReceivingInput);
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wGet, this.wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"GetVariableDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int fieldsRows = this.input.getFieldDefinitions().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"GetVariableDialog.NameColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetVariableDialog.VariableColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Format", (String[])new String[0]), 5, 3), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Currency", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Decimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Group", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetVariableDialog.TrimType.Column", (String[])new String[0]), 2, ValueMetaString.getTrimTypeDescriptions())};
        colinf[1].setToolTip(BaseMessages.getString(PKG, (String)"GetVariableDialog.VariableColumn.Tooltip", (String[])new String[0]));
        colinf[1].setUsingVariables(true);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, fieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        for (int i = 0; i < this.input.getFieldDefinitions().length; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            int index = 1;
            GetVariableMeta.FieldDefinition currentField = this.input.getFieldDefinitions()[i];
            item.setText(index++, Const.NVL((String)currentField.getFieldName(), (String)""));
            item.setText(index++, Const.NVL((String)currentField.getVariableString(), (String)""));
            item.setText(index++, ValueMetaFactory.getValueMetaName((int)currentField.getFieldType()));
            item.setText(index++, Const.NVL((String)currentField.getFieldFormat(), (String)""));
            item.setText(index++, (String)(currentField.getFieldLength() < 0 ? "" : "" + currentField.getFieldLength()));
            item.setText(index++, (String)(currentField.getFieldPrecision() < 0 ? "" : "" + currentField.getFieldPrecision()));
            item.setText(index++, Const.NVL((String)currentField.getCurrency(), (String)""));
            item.setText(index++, Const.NVL((String)currentField.getDecimal(), (String)""));
            item.setText(index++, Const.NVL((String)currentField.getGroup(), (String)""));
            item.setText(index++, ValueMetaString.getTrimTypeDesc((int)currentField.getTrimType()));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(GetVariableMeta input) throws HopException {
        this.transformName = this.wTransformName.getText();
        int count = this.wFields.nrNonEmpty();
        input.allocate(count);
        for (int i = 0; i < count; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            GetVariableMeta.FieldDefinition currentField = input.getFieldDefinitions()[i];
            int index = 1;
            currentField.setFieldName(item.getText(index++));
            currentField.setVariableString(item.getText(index++));
            currentField.setFieldType(ValueMetaFactory.getIdForValueMeta((String)item.getText(index++)));
            currentField.setFieldFormat(item.getText(index++));
            currentField.setFieldLength(Const.toInt((String)item.getText(index++), (int)-1));
            currentField.setFieldPrecision(Const.toInt((String)item.getText(index++), (int)-1));
            currentField.setCurrency(item.getText(index++));
            currentField.setDecimal(item.getText(index++));
            currentField.setGroup(item.getText(index++));
            currentField.setTrimType(ValueMetaString.getTrimTypeByDesc((String)item.getText(index++)));
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        try {
            this.getInfo(this.input);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, "Error", "Error saving transform information", (Exception)((Object)e));
        }
        this.dispose();
    }

    private void preview() {
        try {
            GetVariableMeta oneMeta = new GetVariableMeta();
            this.getInfo(oneMeta);
            PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{1});
            progressDialog.open();
            if (!progressDialog.isCancelled()) {
                Pipeline pipeline = progressDialog.getPipeline();
                String loggingText = progressDialog.getLoggingText();
                if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                }
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                prd.open();
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetVariableDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetVariableDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void grabVariables() {
        if (this.pipelineMeta == null) {
            return;
        }
        String[] key = this.variables.getVariableNames();
        int size = key.length;
        String[] val = new String[size];
        this.wFields.removeAll();
        for (int i = 0; i < size; ++i) {
            val[i] = this.variables.resolve(key[i]);
            TableItem tableItem = new TableItem(this.wFields.table, 0);
            tableItem.setText(1, key[i]);
            tableItem.setText(2, "${" + key[i] + "}");
            tableItem.setText(3, "String");
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }
}

