/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.janino;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.janino.Janino;
import org.apache.hop.pipeline.transforms.janino.JaninoData;
import org.apache.hop.pipeline.transforms.janino.JaninoMetaFunction;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="Janino.Injection.", groups={"FORMULA"})
@Transform(id="Janino", image="janino.svg", name="i18n::Janino.Name", description="i18n::Janino.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Scripting", keywords={"i18n::JaninoMeta.keyword"}, documentationUrl="/pipeline/transforms/userdefinedjavaexpression.html")
public class JaninoMeta
extends BaseTransformMeta<Janino, JaninoData> {
    private static final Class<?> PKG = JaninoMeta.class;
    @InjectionDeep
    private JaninoMetaFunction[] formula;

    public JaninoMetaFunction[] getFormula() {
        return this.formula;
    }

    public void setFormula(JaninoMetaFunction[] calcTypes) {
        this.formula = calcTypes;
    }

    public void allocate(int nrCalcs) {
        this.formula = new JaninoMetaFunction[nrCalcs];
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        int nrCalcs = XmlHandler.countNodes((Node)transformNode, (String)"formula");
        this.allocate(nrCalcs);
        for (int i = 0; i < nrCalcs; ++i) {
            Node calcnode = XmlHandler.getSubNodeByNr((Node)transformNode, (String)"formula", (int)i);
            this.formula[i] = new JaninoMetaFunction(calcnode);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        if (this.formula != null) {
            for (int i = 0; i < this.formula.length; ++i) {
                retval.append("       " + this.formula[i].getXml() + Const.CR);
            }
        }
        return retval.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(((Object)((Object)this)).getClass())) {
            JaninoMeta m = (JaninoMeta)((Object)obj);
            return Objects.equals(this.getXml(), m.getXml());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.formula);
    }

    public Object clone() {
        JaninoMeta retval = (JaninoMeta)((Object)super.clone());
        if (this.formula != null) {
            retval.allocate(this.formula.length);
            for (int i = 0; i < this.formula.length; ++i) {
                retval.getFormula()[i] = (JaninoMetaFunction)this.formula[i].clone();
            }
        } else {
            retval.allocate(0);
        }
        return retval;
    }

    public void setDefault() {
        this.formula = new JaninoMetaFunction[0];
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.formula.length; ++i) {
            JaninoMetaFunction fn = this.formula[i];
            if (Utils.isEmpty((CharSequence)fn.getReplaceField())) {
                if (Utils.isEmpty((CharSequence)fn.getFieldName())) continue;
                try {
                    IValueMeta v = ValueMetaFactory.createValueMeta((String)fn.getFieldName(), (int)fn.getValueType());
                    v.setLength(fn.getValueLength(), fn.getValuePrecision());
                    v.setOrigin(name);
                    row.addValueMeta(v);
                    continue;
                }
                catch (Exception e) {
                    throw new HopTransformException((Throwable)e);
                }
            }
            int index = row.indexOfValue(fn.getReplaceField());
            if (index < 0) {
                throw new HopTransformException("Unknown field specified to replace with a formula result: [" + fn.getReplaceField() + "]");
            }
            IValueMeta v = row.getValueMeta(index).clone();
            v.setLength(fn.getValueLength(), fn.getValuePrecision());
            v.setOrigin(name);
            row.setValueMeta(index, v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"JaninoMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JaninoMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JaninoMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JaninoMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

