/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.split;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.neo4j.transforms.split.SplitGraphMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SplitGraphDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = SplitGraphMeta.class;
    private Text wTransformName;
    private CCombo wGraphField;
    private TextVar wTypeField;
    private TextVar wIdField;
    private TextVar wPropertySetField;
    private SplitGraphMeta input;

    public SplitGraphDialog(Shell parent, IVariables variables, Object inputMetadata, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)inputMetadata, pipelineMeta, transformName);
        this.input = (SplitGraphMeta)((Object)inputMetadata);
        this.metadataProvider = HopGui.getInstance().getMetadataProvider();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout shellLayout = new FormLayout();
        this.shell.setLayout((Layout)shellLayout);
        this.shell.setText("Neo4j SplitGraph");
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        ScrolledComposite wScrolledComposite = new ScrolledComposite((Composite)this.shell, 768);
        FormLayout scFormLayout = new FormLayout();
        wScrolledComposite.setLayout((Layout)scFormLayout);
        FormData fdSComposite = new FormData();
        fdSComposite.left = new FormAttachment(0, 0);
        fdSComposite.right = new FormAttachment(100, 0);
        fdSComposite.top = new FormAttachment(0, 0);
        fdSComposite.bottom = new FormAttachment(100, 0);
        wScrolledComposite.setLayoutData((Object)fdSComposite);
        Composite wComposite = new Composite((Composite)wScrolledComposite, 0);
        this.props.setLook((Control)wComposite);
        FormData fdComposite = new FormData();
        fdComposite.left = new FormAttachment(0, 0);
        fdComposite.right = new FormAttachment(100, 0);
        fdComposite.top = new FormAttachment(0, 0);
        fdComposite.bottom = new FormAttachment(100, 0);
        wComposite.setLayoutData((Object)fdComposite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        wComposite.setLayout((Layout)formLayout);
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Label wlTransformName = new Label(wComposite, 131072);
        wlTransformName.setText("Transform name");
        this.props.setLook((Control)wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text(wComposite, 18436);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        String[] fieldnames = new String[]{};
        try {
            fieldnames = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta).getFieldNames();
        }
        catch (HopTransformException e2) {
            this.log.logError("error getting input field names: ", (Throwable)e2);
        }
        Label wlGraphField = new Label(wComposite, 131072);
        wlGraphField.setText("Graph field ");
        this.props.setLook((Control)wlGraphField);
        FormData fdlGraphField = new FormData();
        fdlGraphField.left = new FormAttachment(0, 0);
        fdlGraphField.right = new FormAttachment(middle, -margin);
        fdlGraphField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlGraphField.setLayoutData((Object)fdlGraphField);
        this.wGraphField = new CCombo(wComposite, 2080);
        this.wGraphField.setItems(fieldnames);
        this.props.setLook((Control)this.wGraphField);
        FormData fdGraphField = new FormData();
        fdGraphField.left = new FormAttachment(middle, 0);
        fdGraphField.right = new FormAttachment(100, 0);
        fdGraphField.top = new FormAttachment((Control)wlGraphField, 0, 0x1000000);
        this.wGraphField.setLayoutData((Object)fdGraphField);
        lastControl = this.wGraphField;
        Label wlTypeField = new Label(wComposite, 131072);
        wlTypeField.setText("Type output field (Node/Relationship) ");
        this.props.setLook((Control)wlTypeField);
        FormData fdlTypeField = new FormData();
        fdlTypeField.left = new FormAttachment(0, 0);
        fdlTypeField.right = new FormAttachment(middle, -margin);
        fdlTypeField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlTypeField.setLayoutData((Object)fdlTypeField);
        this.wTypeField = new TextVar(this.variables, wComposite, 2080);
        this.props.setLook((Control)this.wTypeField);
        FormData fdTypeField = new FormData();
        fdTypeField.left = new FormAttachment(middle, 0);
        fdTypeField.right = new FormAttachment(100, 0);
        fdTypeField.top = new FormAttachment((Control)wlTypeField, 0, 0x1000000);
        this.wTypeField.setLayoutData((Object)fdTypeField);
        lastControl = this.wTypeField;
        Label wlIdField = new Label(wComposite, 131072);
        wlIdField.setText("ID output field ");
        this.props.setLook((Control)wlIdField);
        FormData fdlIdField = new FormData();
        fdlIdField.left = new FormAttachment(0, 0);
        fdlIdField.right = new FormAttachment(middle, -margin);
        fdlIdField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlIdField.setLayoutData((Object)fdlIdField);
        this.wIdField = new TextVar(this.variables, wComposite, 18436);
        this.props.setLook((Control)this.wIdField);
        this.wIdField.addModifyListener(lsMod);
        FormData fdIdField = new FormData();
        fdIdField.left = new FormAttachment(middle, 0);
        fdIdField.right = new FormAttachment(100, 0);
        fdIdField.top = new FormAttachment((Control)wlIdField, 0, 0x1000000);
        this.wIdField.setLayoutData((Object)fdIdField);
        lastControl = this.wIdField;
        Label wlPropertySetField = new Label(wComposite, 131072);
        wlPropertySetField.setText("Property set output field ");
        this.props.setLook((Control)wlPropertySetField);
        FormData fdlPropertySetField = new FormData();
        fdlPropertySetField.left = new FormAttachment(0, 0);
        fdlPropertySetField.right = new FormAttachment(middle, -margin);
        fdlPropertySetField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlPropertySetField.setLayoutData((Object)fdlPropertySetField);
        this.wPropertySetField = new TextVar(this.variables, wComposite, 18436);
        this.props.setLook((Control)this.wPropertySetField);
        this.wPropertySetField.addModifyListener(lsMod);
        FormData fdPropertySetField = new FormData();
        fdPropertySetField.left = new FormAttachment(middle, 0);
        fdPropertySetField.right = new FormAttachment(100, 0);
        fdPropertySetField.top = new FormAttachment((Control)wlPropertySetField, 0, 0x1000000);
        this.wPropertySetField.setLayoutData((Object)fdPropertySetField);
        lastControl = this.wPropertySetField;
        this.wOk = new Button(wComposite, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button(wComposite, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)lastControl);
        wComposite.pack();
        Rectangle bounds = wComposite.getBounds();
        wScrolledComposite.setContent((Control)wComposite);
        wScrolledComposite.setExpandHorizontal(true);
        wScrolledComposite.setExpandVertical(true);
        wScrolledComposite.setMinWidth(bounds.width);
        wScrolledComposite.setMinHeight(bounds.height);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    public void getData() {
        this.wTransformName.setText(Const.NVL((String)this.transformName, (String)""));
        this.wGraphField.setText(Const.NVL((String)this.input.getGraphField(), (String)""));
        this.wTypeField.setText(Const.NVL((String)this.input.getTypeField(), (String)""));
        this.wIdField.setText(Const.NVL((String)this.input.getIdField(), (String)""));
        this.wPropertySetField.setText(Const.NVL((String)this.input.getPropertySetField(), (String)""));
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(SplitGraphMeta meta) {
        meta.setGraphField(this.wGraphField.getText());
        meta.setTypeField(this.wTypeField.getText());
        meta.setIdField(this.wIdField.getText());
        meta.setPropertySetField(this.wPropertySetField.getText());
    }
}

