/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.ApiErrorResponse;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.LocalizedText;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.stone.StoneSerializer;
import com.dropbox.core.v2.callbacks.DbxGlobalCallbackFactory;
import com.dropbox.core.v2.callbacks.DbxRouteErrorCallback;
import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class DbxWrappedException
extends Exception {
    private static final long serialVersionUID = 0L;
    private final Object errValue;
    private final String requestId;
    private final LocalizedText userMessage;

    public DbxWrappedException(Object errValue, String requestId, LocalizedText userMessage) {
        this.errValue = errValue;
        this.requestId = requestId;
        this.userMessage = userMessage;
    }

    public Object getErrorValue() {
        return this.errValue;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public LocalizedText getUserMessage() {
        return this.userMessage;
    }

    public static <T> DbxWrappedException fromResponse(StoneSerializer<T> errSerializer, HttpRequestor.Response response, String userId) throws IOException, JsonParseException {
        String requestId = DbxRequestUtil.getRequestId(response);
        ApiErrorResponse apiResponse = (ApiErrorResponse)new ApiErrorResponse.Serializer<T>(errSerializer).deserialize(response.getBody());
        Object routeError = apiResponse.getError();
        DbxGlobalCallbackFactory factory = DbxRequestUtil.sharedCallbackFactory;
        DbxWrappedException.executeBlockForObject(factory, userId, routeError);
        DbxWrappedException.executeOtherBlocks(factory, userId, routeError);
        return new DbxWrappedException(routeError, requestId, apiResponse.getUserMessage());
    }

    public static void executeOtherBlocks(DbxGlobalCallbackFactory factory, String userId, Object routeError) {
        try {
            Method m = routeError.getClass().getMethod("tag", new Class[0]);
            Object result = m.invoke(routeError, new Object[0]);
            String fName = result.toString().toLowerCase() + "value";
            for (Field f : routeError.getClass().getDeclaredFields()) {
                if (!f.getName().equalsIgnoreCase(fName)) continue;
                f.setAccessible(true);
                Object fieldValue = f.get(routeError);
                DbxWrappedException.executeBlockForObject(factory, userId, fieldValue);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> void executeBlockForObject(DbxGlobalCallbackFactory factory, String userId, T routeError) {
        DbxRouteErrorCallback<T> callback;
        if (factory != null && (callback = factory.createRouteErrorCallback(userId, routeError)) != null) {
            callback.setRouteError(routeError);
            callback.run();
        }
    }
}

