/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ColumnWriter;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ColumnChunkPageWriteStore;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class ColumnMasker {
    public void processBlocks(CompressionConverter.TransParquetFileReader reader, ParquetFileWriter writer, ParquetMetadata meta, MessageType schema, List<String> paths, MaskMode maskMode) throws IOException {
        Set<ColumnPath> nullifyColumns = ColumnMasker.convertToColumnPaths(paths);
        int blockIndex = 0;
        PageReadStore store = reader.readNextRowGroup();
        while (store != null) {
            writer.startBlock(store.getRowCount());
            List<ColumnChunkMetaData> columnsInOrder = meta.getBlocks().get(blockIndex).getColumns();
            Map<ColumnPath, ColumnDescriptor> descriptorsMap = schema.getColumns().stream().collect(Collectors.toMap(x -> ColumnPath.get((String[])x.getPath()), x -> x));
            ColumnReadStoreImpl crStore = new ColumnReadStoreImpl(store, (GroupConverter)new DummyGroupConverter(), schema, meta.getFileMetaData().getCreatedBy());
            for (int i = 0; i < columnsInOrder.size(); ++i) {
                ColumnChunkMetaData chunk = columnsInOrder.get(i);
                ColumnDescriptor descriptor = descriptorsMap.get(chunk.getPath());
                this.processChunk(descriptor, chunk, crStore, reader, writer, schema, nullifyColumns, maskMode);
            }
            writer.endBlock();
            store = reader.readNextRowGroup();
            ++blockIndex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processChunk(ColumnDescriptor descriptor, ColumnChunkMetaData chunk, ColumnReadStoreImpl crStore, CompressionConverter.TransParquetFileReader reader, ParquetFileWriter writer, MessageType schema, Set<ColumnPath> paths, MaskMode maskMode) throws IOException {
        reader.setStreamPosition(chunk.getStartingPos());
        if (paths.contains(chunk.getPath())) {
            if (!maskMode.equals((Object)MaskMode.NULLIFY)) throw new UnsupportedOperationException("Only nullify is supported for now");
            Type.Repetition repetition = descriptor.getPrimitiveType().getRepetition();
            if (repetition.equals((Object)Type.Repetition.REQUIRED)) {
                throw new IOException("Required column [" + descriptor.getPrimitiveType().getName() + "] cannot be nullified");
            }
            this.nullifyColumn(descriptor, chunk, crStore, writer, schema);
            return;
        } else {
            BloomFilter bloomFilter = reader.readBloomFilter(chunk);
            ColumnIndex columnIndex = reader.readColumnIndex(chunk);
            OffsetIndex offsetIndex = reader.readOffsetIndex(chunk);
            writer.appendColumnChunk(descriptor, reader.getStream(), chunk, bloomFilter, columnIndex, offsetIndex);
        }
    }

    private void nullifyColumn(ColumnDescriptor descriptor, ColumnChunkMetaData chunk, ColumnReadStoreImpl crStore, ParquetFileWriter writer, MessageType schema) throws IOException {
        long totalChunkValues = chunk.getValueCount();
        int dMax = descriptor.getMaxDefinitionLevel();
        ColumnReader cReader = crStore.getColumnReader(descriptor);
        ParquetProperties.WriterVersion writerVersion = chunk.getEncodingStats().usesV2Pages() ? ParquetProperties.WriterVersion.PARQUET_2_0 : ParquetProperties.WriterVersion.PARQUET_1_0;
        ParquetProperties props = ParquetProperties.builder().withWriterVersion(writerVersion).build();
        CodecFactory codecFactory = new CodecFactory(new Configuration(), props.getPageSizeThreshold());
        CodecFactory.BytesCompressor compressor = codecFactory.getCompressor(chunk.getCodec());
        MessageType newSchema = this.newSchema(schema, descriptor);
        ColumnChunkPageWriteStore cPageStore = new ColumnChunkPageWriteStore(compressor, newSchema, props.getAllocator(), props.getColumnIndexTruncateLength());
        ColumnWriteStore cStore = props.newColumnWriteStore(newSchema, (PageWriteStore)cPageStore);
        ColumnWriter cWriter = cStore.getColumnWriter(descriptor);
        int i = 0;
        while ((long)i < totalChunkValues) {
            int rlvl = cReader.getCurrentRepetitionLevel();
            int dlvl = cReader.getCurrentDefinitionLevel();
            if (dlvl == dMax) {
                if (dlvl == 0) {
                    throw new IOException("definition level is detected to be 0 for column " + chunk.getPath().toDotString() + " to be nullified");
                }
                if (rlvl == 0) {
                    cWriter.writeNull(rlvl, dlvl - 1);
                }
            } else {
                cWriter.writeNull(rlvl, dlvl);
            }
            cStore.endRecord();
            ++i;
        }
        cStore.flush();
        cPageStore.flushToFileWriter(writer);
        cStore.close();
        cWriter.close();
    }

    private MessageType newSchema(MessageType schema, ColumnDescriptor descriptor) {
        String[] path = descriptor.getPath();
        Type type = schema.getType(path);
        if (path.length == 1) {
            return new MessageType(schema.getName(), new Type[]{type});
        }
        for (Type field : schema.getFields()) {
            Type newType;
            if (field.isPrimitive() || (newType = this.extractField(field.asGroupType(), type)) == null) continue;
            return new MessageType(schema.getName(), new Type[]{newType});
        }
        throw new RuntimeException("No field is found");
    }

    private Type extractField(GroupType candidate, Type targetField) {
        if (targetField.equals((Object)candidate)) {
            return targetField;
        }
        for (Type field : candidate.asGroupType().getFields()) {
            if (field.isPrimitive()) {
                if (!field.equals((Object)targetField)) continue;
                return new GroupType(candidate.getRepetition(), candidate.getName(), new Type[]{targetField});
            }
            Type tempField = this.extractField(field.asGroupType(), targetField);
            if (tempField == null) continue;
            return tempField;
        }
        return null;
    }

    public static Set<ColumnPath> convertToColumnPaths(List<String> cols) {
        HashSet<ColumnPath> prunePaths = new HashSet<ColumnPath>();
        for (String col : cols) {
            prunePaths.add(ColumnPath.fromDotString((String)col));
        }
        return prunePaths;
    }

    private static final class DummyConverter
    extends PrimitiveConverter {
        private DummyConverter() {
        }

        public GroupConverter asGroupConverter() {
            return new DummyGroupConverter();
        }
    }

    private static final class DummyGroupConverter
    extends GroupConverter {
        private DummyGroupConverter() {
        }

        public void start() {
        }

        public void end() {
        }

        public Converter getConverter(int fieldIndex) {
            return new DummyConverter();
        }
    }

    public static enum MaskMode {
        NULLIFY("nullify"),
        HASH("hash"),
        REDACT("redact");

        private String mode;

        private MaskMode(String text) {
            this.mode = text;
        }

        public String getMode() {
            return this.mode;
        }

        public static MaskMode fromString(String mode) {
            for (MaskMode b : MaskMode.values()) {
                if (!b.mode.equalsIgnoreCase(mode)) continue;
                return b;
            }
            return null;
        }
    }
}

