/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.ftpput;

import org.apache.commons.net.ftp.FTPClient;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.ftpput.ActionFtpPut;
import org.apache.hop.workflow.actions.util.FtpClientUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActionFtpPutDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionFtpPut.class;
    private Text wName;
    private TextVar wServerName;
    private TextVar wServerPort;
    private TextVar wUserName;
    private TextVar wPassword;
    private TextVar wLocalDirectory;
    private TextVar wRemoteDirectory;
    private TextVar wWildcard;
    private Button wRemove;
    private ActionFtpPut action;
    private Shell shell;
    private boolean changed;
    private Button wBinaryMode;
    private TextVar wTimeout;
    private Button wOnlyNew;
    private Button wActive;
    private Combo wControlEncoding;
    private LabelTextVar wProxyPort;
    private LabelTextVar wProxyUsername;
    private LabelTextVar wProxyPassword;
    private LabelTextVar wProxyHost;
    private LabelTextVar wSocksProxyHost;
    private LabelTextVar wSocksProxyPort;
    private LabelTextVar wSocksProxyUsername;
    private LabelTextVar wSocksProxyPassword;
    private static final String[] encodings = new String[]{"US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16"};
    private FTPClient ftpclient = null;
    private String pwdFolder = null;

    public ActionFtpPutDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionFtpPut)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionFtpPut.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        WorkflowMeta workflowMeta = this.getWorkflowMeta();
        ModifyListener lsMod = e -> {
            this.ftpclient = null;
            this.pwdFolder = null;
            this.action.setChanged();
        };
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Tab.General.Label", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wServerSettings = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wServerSettings);
        wServerSettings.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.ServerSettings.Group.Label", (String[])new String[0]));
        FormLayout serverSettingsgroupLayout = new FormLayout();
        serverSettingsgroupLayout.marginWidth = 10;
        serverSettingsgroupLayout.marginHeight = 10;
        wServerSettings.setLayout((Layout)serverSettingsgroupLayout);
        Label wlServerName = new Label((Composite)wServerSettings, 131072);
        wlServerName.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Server.Label", (String[])new String[0]));
        this.props.setLook((Control)wlServerName);
        FormData fdlServerName = new FormData();
        fdlServerName.left = new FormAttachment(0, 0);
        fdlServerName.top = new FormAttachment((Control)this.wName, margin);
        fdlServerName.right = new FormAttachment(middle, 0);
        wlServerName.setLayoutData((Object)fdlServerName);
        this.wServerName = new TextVar(this.variables, (Composite)wServerSettings, 18436);
        this.props.setLook((Control)this.wServerName);
        this.wServerName.addModifyListener(lsMod);
        FormData fdServerName = new FormData();
        fdServerName.left = new FormAttachment(middle, margin);
        fdServerName.top = new FormAttachment((Control)this.wName, margin);
        fdServerName.right = new FormAttachment(100, 0);
        this.wServerName.setLayoutData((Object)fdServerName);
        Label wlServerPort = new Label((Composite)wServerSettings, 131072);
        wlServerPort.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Port.Label", (String[])new String[0]));
        this.props.setLook((Control)wlServerPort);
        FormData fdlServerPort = new FormData();
        fdlServerPort.left = new FormAttachment(0, 0);
        fdlServerPort.top = new FormAttachment((Control)this.wServerName, margin);
        fdlServerPort.right = new FormAttachment(middle, 0);
        wlServerPort.setLayoutData((Object)fdlServerPort);
        this.wServerPort = new TextVar(this.variables, (Composite)wServerSettings, 18436);
        this.props.setLook((Control)this.wServerPort);
        this.wServerPort.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Port.Tooltip", (String[])new String[0]));
        this.wServerPort.addModifyListener(lsMod);
        FormData fdServerPort = new FormData();
        fdServerPort.left = new FormAttachment(middle, margin);
        fdServerPort.top = new FormAttachment((Control)this.wServerName, margin);
        fdServerPort.right = new FormAttachment(100, 0);
        this.wServerPort.setLayoutData((Object)fdServerPort);
        Label wlUserName = new Label((Composite)wServerSettings, 131072);
        wlUserName.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Username.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUserName);
        FormData fdlUserName = new FormData();
        fdlUserName.left = new FormAttachment(0, 0);
        fdlUserName.top = new FormAttachment((Control)this.wServerPort, margin);
        fdlUserName.right = new FormAttachment(middle, 0);
        wlUserName.setLayoutData((Object)fdlUserName);
        this.wUserName = new TextVar(this.variables, (Composite)wServerSettings, 18436);
        this.props.setLook((Control)this.wUserName);
        this.wUserName.addModifyListener(lsMod);
        FormData fdUserName = new FormData();
        fdUserName.left = new FormAttachment(middle, margin);
        fdUserName.top = new FormAttachment((Control)this.wServerPort, margin);
        fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData((Object)fdUserName);
        Label wlPassword = new Label((Composite)wServerSettings, 131072);
        wlPassword.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Password.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPassword);
        FormData fdlPassword = new FormData();
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdlPassword.right = new FormAttachment(middle, 0);
        wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new PasswordTextVar(this.variables, (Composite)wServerSettings, 18436);
        this.props.setLook((Control)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(middle, margin);
        fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        this.wProxyHost = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpPut.ProxyHost.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpPut.ProxyHost.Tooltip", (String[])new String[0]), false, false);
        this.props.setLook((Control)this.wProxyHost);
        this.wProxyHost.addModifyListener(lsMod);
        FormData fdProxyHost = new FormData();
        fdProxyHost.left = new FormAttachment(0, 0);
        fdProxyHost.top = new FormAttachment((Control)this.wPassword, 2 * margin);
        fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData((Object)fdProxyHost);
        this.wProxyPort = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpPut.ProxyPort.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpPut.ProxyPort.Tooltip", (String[])new String[0]), false, false);
        this.props.setLook((Control)this.wProxyPort);
        this.wProxyPort.addModifyListener(lsMod);
        FormData fdProxyPort = new FormData();
        fdProxyPort.left = new FormAttachment(0, 0);
        fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData((Object)fdProxyPort);
        this.wProxyUsername = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpPut.ProxyUsername.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpPut.ProxyUsername.Tooltip", (String[])new String[0]), false, false);
        this.props.setLook((Control)this.wProxyUsername);
        this.wProxyUsername.addModifyListener(lsMod);
        FormData fdProxyUsername = new FormData();
        fdProxyUsername.left = new FormAttachment(0, 0);
        fdProxyUsername.top = new FormAttachment((Control)this.wProxyPort, margin);
        fdProxyUsername.right = new FormAttachment(100, 0);
        this.wProxyUsername.setLayoutData((Object)fdProxyUsername);
        this.wProxyPassword = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionFtpPut.ProxyPassword.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpPut.ProxyPassword.Tooltip", (String[])new String[0]), true, false);
        this.props.setLook((Control)this.wProxyPassword);
        this.wProxyPassword.addModifyListener(lsMod);
        FormData fdProxyPasswd = new FormData();
        fdProxyPasswd.left = new FormAttachment(0, 0);
        fdProxyPasswd.top = new FormAttachment((Control)this.wProxyUsername, margin);
        fdProxyPasswd.right = new FormAttachment(100, 0);
        this.wProxyPassword.setLayoutData((Object)fdProxyPasswd);
        Button wTest = new Button((Composite)wServerSettings, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.TestConnection.Label", (String[])new String[0]));
        this.props.setLook((Control)wTest);
        FormData fdTest = new FormData();
        wTest.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpPut.TestConnection.Tooltip", (String[])new String[0]));
        fdTest.top = new FormAttachment((Control)this.wProxyPassword, margin);
        fdTest.right = new FormAttachment(100, 0);
        wTest.setLayoutData((Object)fdTest);
        wTest.addListener(13, e -> this.test());
        FormData fdServerSettings = new FormData();
        fdServerSettings.left = new FormAttachment(0, margin);
        fdServerSettings.top = new FormAttachment((Control)this.wName, margin);
        fdServerSettings.right = new FormAttachment(100, -margin);
        wServerSettings.setLayoutData((Object)fdServerSettings);
        Group wAdvancedSettings = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wAdvancedSettings);
        wAdvancedSettings.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.AdvancedSettings.Group.Label", (String[])new String[0]));
        FormLayout advancedSettingsgroupLayout = new FormLayout();
        advancedSettingsgroupLayout.marginWidth = 10;
        advancedSettingsgroupLayout.marginHeight = 10;
        wAdvancedSettings.setLayout((Layout)advancedSettingsgroupLayout);
        Label wlBinaryMode = new Label((Composite)wAdvancedSettings, 131072);
        wlBinaryMode.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.BinaryMode.Label", (String[])new String[0]));
        this.props.setLook((Control)wlBinaryMode);
        FormData fdlBinaryMode = new FormData();
        fdlBinaryMode.left = new FormAttachment(0, 0);
        fdlBinaryMode.top = new FormAttachment((Control)wServerSettings, margin);
        fdlBinaryMode.right = new FormAttachment(middle, 0);
        wlBinaryMode.setLayoutData((Object)fdlBinaryMode);
        this.wBinaryMode = new Button((Composite)wAdvancedSettings, 32);
        this.props.setLook((Control)this.wBinaryMode);
        this.wBinaryMode.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpPut.BinaryMode.Tooltip", (String[])new String[0]));
        FormData fdBinaryMode = new FormData();
        fdBinaryMode.left = new FormAttachment(middle, 0);
        fdBinaryMode.top = new FormAttachment((Control)wlBinaryMode, 0, 0x1000000);
        fdBinaryMode.right = new FormAttachment(100, 0);
        this.wBinaryMode.setLayoutData((Object)fdBinaryMode);
        Label wlTimeout = new Label((Composite)wAdvancedSettings, 131072);
        wlTimeout.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Timeout.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTimeout);
        FormData fdlTimeout = new FormData();
        fdlTimeout.left = new FormAttachment(0, 0);
        fdlTimeout.top = new FormAttachment((Control)wlBinaryMode, 2 * margin);
        fdlTimeout.right = new FormAttachment(middle, 0);
        wlTimeout.setLayoutData((Object)fdlTimeout);
        this.wTimeout = new TextVar(this.variables, (Composite)wAdvancedSettings, 18436, BaseMessages.getString(PKG, (String)"ActionFtpPut.Timeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTimeout);
        this.wTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Timeout.Tooltip", (String[])new String[0]));
        FormData fdTimeout = new FormData();
        fdTimeout.left = new FormAttachment(middle, 0);
        fdTimeout.top = new FormAttachment((Control)this.wBinaryMode, margin);
        fdTimeout.right = new FormAttachment(100, 0);
        this.wTimeout.setLayoutData((Object)fdTimeout);
        Label wlActive = new Label((Composite)wAdvancedSettings, 131072);
        wlActive.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.ActiveConns.Label", (String[])new String[0]));
        this.props.setLook((Control)wlActive);
        FormData fdlActive = new FormData();
        fdlActive.left = new FormAttachment(0, 0);
        fdlActive.top = new FormAttachment((Control)this.wTimeout, margin);
        fdlActive.right = new FormAttachment(middle, 0);
        wlActive.setLayoutData((Object)fdlActive);
        this.wActive = new Button((Composite)wAdvancedSettings, 32);
        this.wActive.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpPut.ActiveConns.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wActive);
        FormData fdActive = new FormData();
        fdActive.left = new FormAttachment(middle, 0);
        fdActive.top = new FormAttachment((Control)wlActive, 0, 0x1000000);
        fdActive.right = new FormAttachment(100, 0);
        this.wActive.setLayoutData((Object)fdActive);
        Label wlControlEncoding = new Label((Composite)wAdvancedSettings, 131072);
        wlControlEncoding.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.ControlEncoding.Label", (String[])new String[0]));
        this.props.setLook((Control)wlControlEncoding);
        FormData fdlControlEncoding = new FormData();
        fdlControlEncoding.left = new FormAttachment(0, 0);
        fdlControlEncoding.top = new FormAttachment((Control)wlActive, 2 * margin);
        fdlControlEncoding.right = new FormAttachment(middle, 0);
        wlControlEncoding.setLayoutData((Object)fdlControlEncoding);
        this.wControlEncoding = new Combo((Composite)wAdvancedSettings, 18436);
        this.wControlEncoding.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpPut.ControlEncoding.Tooltip", (String[])new String[0]));
        this.wControlEncoding.setItems(encodings);
        this.props.setLook((Control)this.wControlEncoding);
        FormData fdControlEncoding = new FormData();
        fdControlEncoding.left = new FormAttachment(middle, 0);
        fdControlEncoding.top = new FormAttachment((Control)wlControlEncoding, 0, 0x1000000);
        fdControlEncoding.right = new FormAttachment(100, 0);
        this.wControlEncoding.setLayoutData((Object)fdControlEncoding);
        FormData fdAdvancedSettings = new FormData();
        fdAdvancedSettings.left = new FormAttachment(0, margin);
        fdAdvancedSettings.top = new FormAttachment((Control)wServerSettings, margin);
        fdAdvancedSettings.right = new FormAttachment(100, -margin);
        wAdvancedSettings.setLayoutData((Object)fdAdvancedSettings);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        this.props.setLook((Control)wGeneralComp);
        CTabItem wFilesTab = new CTabItem(wTabFolder, 0);
        wFilesTab.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Tab.Files.Label", (String[])new String[0]));
        Composite wFilesComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wFilesComp);
        FormLayout filesLayout = new FormLayout();
        filesLayout.marginWidth = 3;
        filesLayout.marginHeight = 3;
        wFilesComp.setLayout((Layout)filesLayout);
        Group wSourceSettings = new Group(wFilesComp, 32);
        this.props.setLook((Control)wSourceSettings);
        wSourceSettings.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.SourceSettings.Group.Label", (String[])new String[0]));
        FormLayout sourceSettinsgroupLayout = new FormLayout();
        sourceSettinsgroupLayout.marginWidth = 10;
        sourceSettinsgroupLayout.marginHeight = 10;
        wSourceSettings.setLayout((Layout)sourceSettinsgroupLayout);
        Label wlLocalDirectory = new Label((Composite)wSourceSettings, 131072);
        wlLocalDirectory.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.LocalDir.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLocalDirectory);
        FormData fdlLocalDirectory = new FormData();
        fdlLocalDirectory.left = new FormAttachment(0, 0);
        fdlLocalDirectory.top = new FormAttachment(0, margin);
        fdlLocalDirectory.right = new FormAttachment(middle, -margin);
        wlLocalDirectory.setLayoutData((Object)fdlLocalDirectory);
        Button wbLocalDirectory = new Button((Composite)wSourceSettings, 0x1000008);
        this.props.setLook((Control)wbLocalDirectory);
        wbLocalDirectory.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.BrowseFolders.Label", (String[])new String[0]));
        FormData fdbLocalDirectory = new FormData();
        fdbLocalDirectory.right = new FormAttachment(100, 0);
        fdbLocalDirectory.top = new FormAttachment(0, margin);
        wbLocalDirectory.setLayoutData((Object)fdbLocalDirectory);
        wbLocalDirectory.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wLocalDirectory, (IVariables)this.variables));
        this.wLocalDirectory = new TextVar(this.variables, (Composite)wSourceSettings, 18436, BaseMessages.getString(PKG, (String)"ActionFtpPut.LocalDir.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLocalDirectory);
        this.wLocalDirectory.addModifyListener(lsMod);
        FormData fdLocalDirectory = new FormData();
        fdLocalDirectory.left = new FormAttachment(middle, 0);
        fdLocalDirectory.top = new FormAttachment(0, margin);
        fdLocalDirectory.right = new FormAttachment((Control)wbLocalDirectory, -margin);
        this.wLocalDirectory.setLayoutData((Object)fdLocalDirectory);
        Label wlWildcard = new Label((Composite)wSourceSettings, 131072);
        wlWildcard.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Wildcard.Label", (String[])new String[0]));
        this.props.setLook((Control)wlWildcard);
        FormData fdlWildcard = new FormData();
        fdlWildcard.left = new FormAttachment(0, 0);
        fdlWildcard.top = new FormAttachment((Control)this.wLocalDirectory, margin);
        fdlWildcard.right = new FormAttachment(middle, -margin);
        wlWildcard.setLayoutData((Object)fdlWildcard);
        this.wWildcard = new TextVar(this.variables, (Composite)wSourceSettings, 18436, BaseMessages.getString(PKG, (String)"ActionFtpPut.Wildcard.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wWildcard);
        this.wWildcard.addModifyListener(lsMod);
        FormData fdWildcard = new FormData();
        fdWildcard.left = new FormAttachment(middle, 0);
        fdWildcard.top = new FormAttachment((Control)this.wLocalDirectory, margin);
        fdWildcard.right = new FormAttachment(100, 0);
        this.wWildcard.setLayoutData((Object)fdWildcard);
        Label wlRemove = new Label((Composite)wSourceSettings, 131072);
        wlRemove.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.RemoveFiles.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRemove);
        FormData fdlRemove = new FormData();
        fdlRemove.left = new FormAttachment(0, 0);
        fdlRemove.top = new FormAttachment((Control)this.wWildcard, 2 * margin);
        fdlRemove.right = new FormAttachment(middle, -margin);
        wlRemove.setLayoutData((Object)fdlRemove);
        this.wRemove = new Button((Composite)wSourceSettings, 32);
        this.props.setLook((Control)this.wRemove);
        this.wRemove.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpPut.RemoveFiles.Tooltip", (String[])new String[0]));
        FormData fdRemove = new FormData();
        fdRemove.left = new FormAttachment(middle, 0);
        fdRemove.top = new FormAttachment((Control)wlRemove, 0, 0x1000000);
        fdRemove.right = new FormAttachment(100, 0);
        this.wRemove.setLayoutData((Object)fdRemove);
        Label wlOnlyNew = new Label((Composite)wSourceSettings, 131072);
        wlOnlyNew.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.DontOverwrite.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOnlyNew);
        FormData fdlOnlyNew = new FormData();
        fdlOnlyNew.left = new FormAttachment(0, 0);
        fdlOnlyNew.top = new FormAttachment((Control)wlRemove, 2 * margin);
        fdlOnlyNew.right = new FormAttachment(middle, 0);
        wlOnlyNew.setLayoutData((Object)fdlOnlyNew);
        this.wOnlyNew = new Button((Composite)wSourceSettings, 32);
        this.wOnlyNew.setToolTipText(BaseMessages.getString(PKG, (String)"ActionFtpPut.DontOverwrite.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wOnlyNew);
        FormData fdOnlyNew = new FormData();
        fdOnlyNew.left = new FormAttachment(middle, 0);
        fdOnlyNew.top = new FormAttachment((Control)wlOnlyNew, 0, 0x1000000);
        fdOnlyNew.right = new FormAttachment(100, 0);
        this.wOnlyNew.setLayoutData((Object)fdOnlyNew);
        FormData fdSourceSettings = new FormData();
        fdSourceSettings.left = new FormAttachment(0, margin);
        fdSourceSettings.top = new FormAttachment(0, 2 * margin);
        fdSourceSettings.right = new FormAttachment(100, -margin);
        wSourceSettings.setLayoutData((Object)fdSourceSettings);
        Group wTargetSettings = new Group(wFilesComp, 32);
        this.props.setLook((Control)wTargetSettings);
        wTargetSettings.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.TargetSettings.Group.Label", (String[])new String[0]));
        FormLayout targetSettinsgroupLayout = new FormLayout();
        targetSettinsgroupLayout.marginWidth = 10;
        targetSettinsgroupLayout.marginHeight = 10;
        wTargetSettings.setLayout((Layout)targetSettinsgroupLayout);
        Label wlRemoteDirectory = new Label((Composite)wTargetSettings, 131072);
        wlRemoteDirectory.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.RemoteDir.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRemoteDirectory);
        FormData fdlRemoteDirectory = new FormData();
        fdlRemoteDirectory.left = new FormAttachment(0, 0);
        fdlRemoteDirectory.top = new FormAttachment((Control)wSourceSettings, margin);
        fdlRemoteDirectory.right = new FormAttachment(middle, -margin);
        wlRemoteDirectory.setLayoutData((Object)fdlRemoteDirectory);
        Button wbTestRemoteDirectoryExists = new Button((Composite)wTargetSettings, 0x1000008);
        this.props.setLook((Control)wbTestRemoteDirectoryExists);
        wbTestRemoteDirectoryExists.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.TestFolderExists.Label", (String[])new String[0]));
        FormData fdbTestRemoteDirectoryExists = new FormData();
        fdbTestRemoteDirectoryExists.right = new FormAttachment(100, 0);
        fdbTestRemoteDirectoryExists.top = new FormAttachment((Control)wSourceSettings, margin);
        wbTestRemoteDirectoryExists.setLayoutData((Object)fdbTestRemoteDirectoryExists);
        wbTestRemoteDirectoryExists.addListener(13, e -> this.checkRemoteFolder(this.variables.resolve(this.wRemoteDirectory.getText())));
        this.wRemoteDirectory = new TextVar(this.variables, (Composite)wTargetSettings, 18436, BaseMessages.getString(PKG, (String)"ActionFtpPut.RemoteDir.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wRemoteDirectory);
        this.wRemoteDirectory.addModifyListener(lsMod);
        FormData fdRemoteDirectory = new FormData();
        fdRemoteDirectory.left = new FormAttachment(middle, 0);
        fdRemoteDirectory.top = new FormAttachment((Control)wSourceSettings, margin);
        fdRemoteDirectory.right = new FormAttachment((Control)wbTestRemoteDirectoryExists, -margin);
        this.wRemoteDirectory.setLayoutData((Object)fdRemoteDirectory);
        FormData fdTargetSettings = new FormData();
        fdTargetSettings.left = new FormAttachment(0, margin);
        fdTargetSettings.top = new FormAttachment((Control)wSourceSettings, margin);
        fdTargetSettings.right = new FormAttachment(100, -margin);
        wTargetSettings.setLayoutData((Object)fdTargetSettings);
        FormData fdFilesComp = new FormData();
        fdFilesComp.left = new FormAttachment(0, 0);
        fdFilesComp.top = new FormAttachment(0, 0);
        fdFilesComp.right = new FormAttachment(100, 0);
        fdFilesComp.bottom = new FormAttachment(100, 0);
        wFilesComp.setLayoutData((Object)fdFilesComp);
        wFilesComp.layout();
        wFilesTab.setControl((Control)wFilesComp);
        this.props.setLook((Control)wFilesComp);
        CTabItem wSocksProxyTab = new CTabItem(wTabFolder, 0);
        wSocksProxyTab.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Tab.Socks.Label", (String[])new String[0]));
        Composite wSocksProxyComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wSocksProxyComp);
        FormLayout soxProxyLayout = new FormLayout();
        soxProxyLayout.marginWidth = 3;
        soxProxyLayout.marginHeight = 3;
        wSocksProxyComp.setLayout((Layout)soxProxyLayout);
        Group wSocksProxy = new Group(wSocksProxyComp, 32);
        this.props.setLook((Control)wSocksProxy);
        wSocksProxy.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.SocksProxy.Group.Label", (String[])new String[0]));
        FormLayout socksProxyGroupLayout = new FormLayout();
        socksProxyGroupLayout.marginWidth = 10;
        socksProxyGroupLayout.marginHeight = 10;
        wSocksProxy.setLayout((Layout)socksProxyGroupLayout);
        this.wSocksProxyHost = new LabelTextVar(this.variables, (Composite)wSocksProxy, 0, BaseMessages.getString(PKG, (String)"ActionFtpPut.SocksProxyHost.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpPut.SocksProxyHost.Tooltip", (String[])new String[0]), false, false);
        this.props.setLook((Control)this.wSocksProxyHost);
        this.wSocksProxyHost.addModifyListener(lsMod);
        FormData fdSocksProxyHost = new FormData();
        fdSocksProxyHost.left = new FormAttachment(0, 0);
        fdSocksProxyHost.top = new FormAttachment((Control)this.wName, margin);
        fdSocksProxyHost.right = new FormAttachment(100, margin);
        this.wSocksProxyHost.setLayoutData((Object)fdSocksProxyHost);
        this.wSocksProxyPort = new LabelTextVar(this.variables, (Composite)wSocksProxy, 0, BaseMessages.getString(PKG, (String)"ActionFtpPut.SocksProxyPort.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpPut.SocksProxyPort.Tooltip", (String[])new String[0]), false, false);
        this.props.setLook((Control)this.wSocksProxyPort);
        this.wSocksProxyPort.addModifyListener(lsMod);
        FormData fdSocksProxyPort = new FormData();
        fdSocksProxyPort.left = new FormAttachment(0, 0);
        fdSocksProxyPort.top = new FormAttachment((Control)this.wSocksProxyHost, margin);
        fdSocksProxyPort.right = new FormAttachment(100, margin);
        this.wSocksProxyPort.setLayoutData((Object)fdSocksProxyPort);
        this.wSocksProxyUsername = new LabelTextVar(this.variables, (Composite)wSocksProxy, 0, BaseMessages.getString(PKG, (String)"ActionFtpPut.SocksProxyUsername.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpPut.SocksProxyPassword.Tooltip", (String[])new String[0]), false, false);
        this.props.setLook((Control)this.wSocksProxyUsername);
        this.wSocksProxyUsername.addModifyListener(lsMod);
        FormData fdSocksProxyUsername = new FormData();
        fdSocksProxyUsername.left = new FormAttachment(0, 0);
        fdSocksProxyUsername.top = new FormAttachment((Control)this.wSocksProxyPort, margin);
        fdSocksProxyUsername.right = new FormAttachment(100, margin);
        this.wSocksProxyUsername.setLayoutData((Object)fdSocksProxyUsername);
        this.wSocksProxyPassword = new LabelTextVar(this.variables, (Composite)wSocksProxy, 0, BaseMessages.getString(PKG, (String)"ActionFtpPut.SocksProxyPassword.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionFtpPut.SocksProxyPassword.Tooltip", (String[])new String[0]), true, false);
        this.props.setLook((Control)this.wSocksProxyPort);
        this.wSocksProxyPassword.addModifyListener(lsMod);
        FormData fdSocksProxyPassword = new FormData();
        fdSocksProxyPassword.left = new FormAttachment(0, 0);
        fdSocksProxyPassword.top = new FormAttachment((Control)this.wSocksProxyUsername, margin);
        fdSocksProxyPassword.right = new FormAttachment(100, margin);
        this.wSocksProxyPassword.setLayoutData((Object)fdSocksProxyPassword);
        FormData fdSocksProxyComp = new FormData();
        fdSocksProxyComp.left = new FormAttachment(0, margin);
        fdSocksProxyComp.top = new FormAttachment(0, margin);
        fdSocksProxyComp.right = new FormAttachment(100, -margin);
        wSocksProxy.setLayoutData((Object)fdSocksProxyComp);
        wSocksProxyComp.layout();
        wSocksProxyTab.setControl((Control)wSocksProxyComp);
        this.props.setLook((Control)wSocksProxyComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void closeFtpConnection() {
        if (this.ftpclient != null && this.ftpclient.isConnected()) {
            try {
                this.ftpclient.quit();
                this.ftpclient = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FtpClientUtil.clearSocksJvmSettings();
    }

    private void test() {
        if (this.connectToFtp(false, null)) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionFtpPut.Connected.OK", (String[])new String[]{this.wServerName.getText()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        }
        this.closeFtpConnection();
    }

    private void checkRemoteFolder(String remoteFoldername) {
        if (!Utils.isEmpty((CharSequence)remoteFoldername) && this.connectToFtp(true, remoteFoldername)) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionFtpPut.FolderExists.OK", (String[])new String[]{remoteFoldername}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.FolderExists.Title.Ok", (String[])new String[0]));
            mb.open();
        }
    }

    private boolean connectToFtp(boolean checkFolder, String remoteFolderName) {
        boolean retval = false;
        Object realServername = null;
        try {
            WorkflowMeta workflowMeta = this.getWorkflowMeta();
            ActionFtpPut actionFtpPut = new ActionFtpPut();
            this.getInfo(actionFtpPut);
            if (this.ftpclient == null || !this.ftpclient.isConnected()) {
                this.ftpclient = FtpClientUtil.connectAndLogin(LogChannel.UI, this.variables, actionFtpPut, actionFtpPut.getName());
                this.pwdFolder = this.ftpclient.printWorkingDirectory();
            }
            if (checkFolder) {
                if (this.pwdFolder != null) {
                    this.ftpclient.changeWorkingDirectory(this.pwdFolder);
                }
                if (!Utils.isEmpty((CharSequence)remoteFolderName)) {
                    String realFtpDirectory = this.variables.resolve(remoteFolderName);
                    this.ftpclient.changeWorkingDirectory(realFtpDirectory);
                }
            }
            retval = true;
        }
        catch (Exception e) {
            if (this.ftpclient != null) {
                try {
                    this.ftpclient.quit();
                }
                catch (Exception actionFtpPut) {
                    // empty catch block
                }
                this.ftpclient = null;
                FtpClientUtil.clearSocksJvmSettings();
            }
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionFtpPut.ErrorConnect.NOK", (String[])new String[]{realServername, e.getMessage()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionFtpPut.ErrorConnect.Title.Bad", (String[])new String[0]));
            mb.open();
        }
        return retval;
    }

    public void dispose() {
        this.closeFtpConnection();
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        if (this.action.getName() != null) {
            this.wName.setText(this.action.getName());
        }
        this.wServerName.setText(Const.NVL((String)this.action.getServerName(), (String)""));
        this.wServerPort.setText(Const.NVL((String)this.action.getServerPort(), (String)""));
        this.wUserName.setText(Const.NVL((String)this.action.getUserName(), (String)""));
        this.wPassword.setText(Const.NVL((String)this.action.getPassword(), (String)""));
        this.wRemoteDirectory.setText(Const.NVL((String)this.action.getRemoteDirectory(), (String)""));
        this.wLocalDirectory.setText(Const.NVL((String)this.action.getLocalDirectory(), (String)""));
        this.wWildcard.setText(Const.NVL((String)this.action.getWildcard(), (String)""));
        this.wRemove.setSelection(this.action.getRemove());
        this.wBinaryMode.setSelection(this.action.isBinaryMode());
        this.wTimeout.setText("" + this.action.getTimeout());
        this.wOnlyNew.setSelection(this.action.isOnlyPuttingNewFiles());
        this.wActive.setSelection(this.action.isActiveConnection());
        this.wControlEncoding.setText(this.action.getControlEncoding());
        this.wProxyHost.setText(Const.NVL((String)this.action.getProxyHost(), (String)""));
        this.wProxyPort.setText(Const.NVL((String)this.action.getProxyPort(), (String)""));
        this.wProxyUsername.setText(Const.NVL((String)this.action.getProxyUsername(), (String)""));
        this.wProxyPassword.setText(Const.NVL((String)this.action.getProxyPassword(), (String)""));
        this.wSocksProxyHost.setText(Const.NVL((String)this.action.getSocksProxyHost(), (String)""));
        this.wSocksProxyPort.setText(Const.NVL((String)this.action.getSocksProxyPort(), (String)"1080"));
        this.wSocksProxyUsername.setText(Const.NVL((String)this.action.getSocksProxyUsername(), (String)""));
        this.wSocksProxyPassword.setText(Const.NVL((String)this.action.getSocksProxyPassword(), (String)""));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.getInfo(this.action);
        this.dispose();
    }

    private void getInfo(ActionFtpPut actionFtpPut) {
        actionFtpPut.setName(this.wName.getText());
        actionFtpPut.setServerName(this.wServerName.getText());
        actionFtpPut.setServerPort(this.wServerPort.getText());
        actionFtpPut.setUserName(this.wUserName.getText());
        actionFtpPut.setPassword(this.wPassword.getText());
        actionFtpPut.setRemoteDirectory(this.wRemoteDirectory.getText());
        actionFtpPut.setLocalDirectory(this.wLocalDirectory.getText());
        actionFtpPut.setWildcard(this.wWildcard.getText());
        actionFtpPut.setRemove(this.wRemove.getSelection());
        actionFtpPut.setBinaryMode(this.wBinaryMode.getSelection());
        actionFtpPut.setTimeout(Const.toInt((String)this.wTimeout.getText(), (int)10000));
        actionFtpPut.setOnlyPuttingNewFiles(this.wOnlyNew.getSelection());
        actionFtpPut.setActiveConnection(this.wActive.getSelection());
        actionFtpPut.setControlEncoding(this.wControlEncoding.getText());
        actionFtpPut.setProxyHost(this.wProxyHost.getText());
        actionFtpPut.setProxyPort(this.wProxyPort.getText());
        actionFtpPut.setProxyUsername(this.wProxyUsername.getText());
        actionFtpPut.setProxyPassword(this.wProxyPassword.getText());
        actionFtpPut.setSocksProxyHost(this.wSocksProxyHost.getText());
        actionFtpPut.setSocksProxyPort(this.wSocksProxyPort.getText());
        actionFtpPut.setSocksProxyUsername(this.wSocksProxyUsername.getText());
        actionFtpPut.setSocksProxyPassword(this.wSocksProxyPassword.getText());
    }
}

