/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.sftp;

import com.google.common.annotations.VisibleForTesting;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileUtil;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopWorkflowException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.vfs.HopVfs;

public class SftpClient {
    private static final String COMPRESSION_S2C = "compression.s2c";
    private static final String COMPRESSION_C2S = "compression.c2s";
    public static final String PROXY_TYPE_SOCKS5 = "SOCKS5";
    public static final String PROXY_TYPE_HTTP = "HTTP";
    public static final String HTTP_DEFAULT_PORT = "80";
    public static final String SOCKS5_DEFAULT_PORT = "1080";
    public static final int SSH_DEFAULT_PORT = 22;
    static final String ENV_PARAM_USERAUTH_GSSAPI = "userauth.gssapi.enabled";
    private static final String PREFERRED_AUTH_CONFIG_NAME = "PreferredAuthentications";
    private static final String PREFERRED_AUTH_DEFAULT = "publickey,keyboard-interactive,password";
    private static final String PREFERRED_AUTH_WITH_GSSAPI = "publickey,keyboard-interactive,password,gssapi-with-mic";
    private InetAddress serverIP;
    private int serverPort;
    private String userName;
    private String password;
    private String prvkey = null;
    private String passphrase = null;
    private String compression = null;
    private Session s;
    private ChannelSftp c;

    public SftpClient(InetAddress serverIP, int serverPort, String userName) throws HopWorkflowException {
        this(serverIP, serverPort, userName, null, null);
    }

    public SftpClient(InetAddress serverIP, int serverPort, String userName, String privateKeyFilename) throws HopWorkflowException {
        this(serverIP, serverPort, userName, privateKeyFilename, null);
    }

    public SftpClient(InetAddress serverIP, int serverPort, String userName, String privateKeyFilename, String passPhrase) throws HopWorkflowException {
        if (serverIP == null || serverPort < 0 || userName == null || userName.equals("")) {
            throw new HopWorkflowException("For a SFTP connection server name and username must be set and server port must be greater than zero.");
        }
        this.serverIP = serverIP;
        this.serverPort = serverPort;
        this.userName = userName;
        JSch jsch = this.createJSch();
        try {
            if (!Utils.isEmpty((CharSequence)privateKeyFilename)) {
                this.prvkey = privateKeyFilename;
                byte[] passphrasebytes = new byte[]{};
                if (!Utils.isEmpty((CharSequence)passPhrase)) {
                    this.passphrase = passPhrase;
                    passphrasebytes = this.GetPrivateKeyPassPhrase().getBytes();
                }
                jsch.addIdentity(this.getUserName(), FileUtil.getContent((FileObject)HopVfs.getFileObject((String)this.prvkey)), null, passphrasebytes);
            }
            this.s = jsch.getSession(userName, serverIP.getHostAddress(), serverPort);
            this.s.setConfig(PREFERRED_AUTH_CONFIG_NAME, this.getPreferredAuthentications());
        }
        catch (IOException e) {
            throw new HopWorkflowException((Throwable)e);
        }
        catch (HopFileException e) {
            throw new HopWorkflowException((Throwable)e);
        }
        catch (JSchException e) {
            throw new HopWorkflowException((Throwable)e);
        }
    }

    public void login(String password) throws HopWorkflowException {
        this.password = password;
        this.s.setPassword(this.getPassword());
        try {
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            String compress = this.getCompression();
            if (compress != null) {
                config.put(COMPRESSION_S2C, compress);
                config.put(COMPRESSION_C2S, compress);
            }
            this.s.setConfig(config);
            this.s.connect();
            Channel channel = this.s.openChannel("sftp");
            channel.connect();
            this.c = (ChannelSftp)channel;
        }
        catch (JSchException e) {
            throw new HopWorkflowException((Throwable)e);
        }
    }

    public void chdir(String dirToChangeTo) throws HopWorkflowException {
        try {
            this.c.cd(dirToChangeTo.replace("\\\\", "/").replace("\\", "/"));
        }
        catch (SftpException e) {
            throw new HopWorkflowException((Throwable)e);
        }
    }

    public String[] dir() throws HopWorkflowException {
        Object[] fileList = null;
        try {
            Vector v = this.c.ls(".");
            Vector<String> o = new Vector<String>();
            if (v != null) {
                for (int i = 0; i < v.size(); ++i) {
                    ChannelSftp.LsEntry lse;
                    Object obj = v.elementAt(i);
                    if (obj == null || !(obj instanceof ChannelSftp.LsEntry) || (lse = (ChannelSftp.LsEntry)obj).getAttrs().isDir()) continue;
                    o.add(lse.getFilename());
                }
            }
            if (o.size() > 0) {
                fileList = new String[o.size()];
                o.copyInto(fileList);
            }
        }
        catch (SftpException e) {
            throw new HopWorkflowException((Throwable)e);
        }
        return fileList;
    }

    public void get(FileObject localFile, String remoteFile) throws HopWorkflowException {
        OutputStream localStream = null;
        try {
            localStream = HopVfs.getOutputStream((FileObject)localFile, (boolean)false);
            this.c.get(remoteFile, localStream);
        }
        catch (SftpException e) {
            throw new HopWorkflowException((Throwable)e);
        }
        catch (IOException e) {
            throw new HopWorkflowException((Throwable)e);
        }
        finally {
            if (localStream != null) {
                try {
                    localStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String pwd() throws HopWorkflowException {
        try {
            return this.c.pwd();
        }
        catch (SftpException e) {
            throw new HopWorkflowException((Throwable)e);
        }
    }

    public void put(FileObject fileObject, String remoteFile) throws HopWorkflowException {
        int mode = 0;
        InputStream inputStream = null;
        try {
            inputStream = HopVfs.getInputStream((FileObject)fileObject);
            this.c.put(inputStream, remoteFile, null, mode);
        }
        catch (Exception e) {
            throw new HopWorkflowException((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new HopWorkflowException((Throwable)e);
                }
            }
        }
    }

    public void put(InputStream inputStream, String remoteFile) throws HopWorkflowException {
        int mode = 0;
        try {
            this.c.put(inputStream, remoteFile, null, mode);
        }
        catch (Exception e) {
            throw new HopWorkflowException((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new HopWorkflowException((Throwable)e);
                }
            }
        }
    }

    public void delete(String file) throws HopWorkflowException {
        try {
            this.c.rm(file);
        }
        catch (SftpException e) {
            throw new HopWorkflowException((Throwable)e);
        }
    }

    public void createFolder(String path) throws HopWorkflowException {
        try {
            String[] folders = path.split("/");
            folders[0] = (String)(path.charAt(0) != '/' ? this.pwd() + "/" : "") + folders[0];
            for (int i = 1; i < folders.length; ++i) {
                folders[i] = folders[i - 1] + "/" + folders[i];
            }
            for (String f : folders) {
                if (f.length() == 0 || this.folderExists(f)) continue;
                this.c.mkdir(f);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new HopWorkflowException((Throwable)e);
        }
        catch (SftpException e) {
            throw new HopWorkflowException((Throwable)e);
        }
    }

    public void renameFile(String sourcefilename, String destinationfilename) throws HopWorkflowException {
        try {
            this.c.rename(sourcefilename, destinationfilename);
        }
        catch (SftpException e) {
            throw new HopWorkflowException((Throwable)e);
        }
    }

    public FileType getFileType(String filename) throws HopWorkflowException {
        try {
            SftpATTRS attrs = this.c.stat(filename);
            if (attrs == null) {
                return FileType.IMAGINARY;
            }
            if ((attrs.getFlags() & 4) == 0) {
                throw new HopWorkflowException("Unknown permissions error");
            }
            if (attrs.isDir()) {
                return FileType.FOLDER;
            }
            return FileType.FILE;
        }
        catch (Exception e) {
            throw new HopWorkflowException((Throwable)e);
        }
    }

    public boolean folderExists(String folderName) {
        boolean retval = false;
        try {
            SftpATTRS attrs = this.c.stat(folderName);
            if (attrs == null) {
                return false;
            }
            if ((attrs.getFlags() & 4) == 0) {
                throw new HopWorkflowException("Unknown permissions error");
            }
            retval = attrs.isDir();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public void setProxy(String host, String port, String user, String pass, String proxyType) throws HopWorkflowException {
        if (Utils.isEmpty((CharSequence)host) || Const.toInt((String)port, (int)0) == 0) {
            throw new HopWorkflowException("Proxy server name must be set and server port must be greater than zero.");
        }
        ProxyHTTP proxy = null;
        String proxyhost = host + ":" + port;
        if (proxyType.equals(PROXY_TYPE_HTTP)) {
            proxy = new ProxyHTTP(proxyhost);
            if (!Utils.isEmpty((CharSequence)user)) {
                proxy.setUserPasswd(user, pass);
            }
        } else if (proxyType.equals(PROXY_TYPE_SOCKS5)) {
            proxy = new ProxySOCKS5(proxyhost);
            if (!Utils.isEmpty((CharSequence)user)) {
                ((ProxySOCKS5)proxy).setUserPasswd(user, pass);
            }
        }
        this.s.setProxy((Proxy)proxy);
    }

    public void disconnect() {
        if (this.c != null) {
            this.c.disconnect();
        }
        if (this.s != null) {
            this.s.disconnect();
        }
    }

    public String GetPrivateKeyFileName() {
        return this.prvkey;
    }

    public String GetPrivateKeyPassPhrase() {
        return this.passphrase;
    }

    public String getPassword() {
        return this.password;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getUserName() {
        return this.userName;
    }

    public InetAddress getServerIP() {
        return this.serverIP;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getCompression() {
        if (this.compression == null) {
            return null;
        }
        if (this.compression.equals("zlib")) {
            return "zlib@openssh.com,zlib";
        }
        if (this.compression.equals("none")) {
            return null;
        }
        return this.compression;
    }

    @VisibleForTesting
    JSch createJSch() {
        return new JSch();
    }

    private String getPreferredAuthentications() {
        String param = Const.getEnvironmentVariable((String)ENV_PARAM_USERAUTH_GSSAPI, null);
        return Boolean.valueOf(param) != false ? PREFERRED_AUTH_WITH_GSSAPI : PREFERRED_AUTH_DEFAULT;
    }
}

