/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.runners;

import com.google.auto.value.AutoValue;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.runners.AutoValue_AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValues;
import org.apache.beam.sdk.values.TupleTag;

@Internal
@AutoValue
public abstract class AppliedPTransform<InputT extends PInput, OutputT extends POutput, TransformT extends PTransform<? super InputT, OutputT>> {
    AppliedPTransform() {
    }

    public static <InputT extends PInput, OutputT extends POutput, TransformT extends PTransform<? super InputT, OutputT>> AppliedPTransform<InputT, OutputT, TransformT> of(String fullName, Map<TupleTag<?>, PCollection<?>> input, Map<TupleTag<?>, PCollection<?>> output, TransformT transform, ResourceHints resourceHints, Pipeline p) {
        return new AutoValue_AppliedPTransform(fullName, input, output, transform, resourceHints, p);
    }

    public abstract String getFullName();

    public abstract Map<TupleTag<?>, PCollection<?>> getInputs();

    public abstract Map<TupleTag<?>, PCollection<?>> getOutputs();

    public abstract TransformT getTransform();

    public abstract ResourceHints getResourceHints();

    public abstract Pipeline getPipeline();

    public Map<TupleTag<?>, PCollection<?>> getMainInputs() {
        Map<TupleTag<?>, PCollection<?>> sideInputs = PValues.fullyExpand(((PTransform)this.getTransform()).getAdditionalInputs());
        return this.getInputs().entrySet().stream().filter(e -> !sideInputs.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

