/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

@Internal
public class CombineFnBase {

    @Internal
    static abstract class AbstractGlobalCombineFn<InputT, AccumT, OutputT>
    implements GlobalCombineFn<InputT, AccumT, OutputT>,
    Serializable {
        private static final String INCOMPATIBLE_GLOBAL_WINDOW_ERROR_MESSAGE = "Default values are not supported in Combine.globally() if the input PCollection is not windowed by GlobalWindows. Instead, use Combine.globally().withoutDefaults() to output an empty PCollection if the input PCollection is empty, or Combine.globally().asSingletonView() to get the default output of the CombineFn if the input PCollection is empty.";

        AbstractGlobalCombineFn() {
        }

        @Override
        public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return registry.getCoder(this.getClass(), AbstractGlobalCombineFn.class, (Map<Type, ? extends Coder<?>>)ImmutableMap.of(this.getInputTVariable(), inputCoder), this.getAccumTVariable());
        }

        @Override
        public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return registry.getCoder(this.getClass(), AbstractGlobalCombineFn.class, (Map<Type, ? extends Coder<?>>)ImmutableMap.of(this.getInputTVariable(), inputCoder, this.getAccumTVariable(), this.getAccumulatorCoder(registry, inputCoder)), this.getOutputTVariable());
        }

        @Override
        public String getIncompatibleGlobalWindowErrorMessage() {
            return INCOMPATIBLE_GLOBAL_WINDOW_ERROR_MESSAGE;
        }

        public TypeVariable<?> getInputTVariable() {
            return (TypeVariable)new TypeDescriptor<InputT>(AbstractGlobalCombineFn.class){}.getType();
        }

        public TypeVariable<?> getAccumTVariable() {
            return (TypeVariable)new TypeDescriptor<AccumT>(AbstractGlobalCombineFn.class){}.getType();
        }

        public TypeVariable<?> getOutputTVariable() {
            return (TypeVariable)new TypeDescriptor<OutputT>(AbstractGlobalCombineFn.class){}.getType();
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
        }
    }

    @Internal
    public static interface GlobalCombineFn<InputT, AccumT, OutputT>
    extends Serializable,
    HasDisplayData {
        public Coder<AccumT> getAccumulatorCoder(CoderRegistry var1, Coder<InputT> var2) throws CannotProvideCoderException;

        public Coder<OutputT> getDefaultOutputCoder(CoderRegistry var1, Coder<InputT> var2) throws CannotProvideCoderException;

        public String getIncompatibleGlobalWindowErrorMessage();

        public OutputT defaultValue();
    }
}

