/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.Iterator;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Count {
    private Count() {
    }

    public static <T> Combine.CombineFn<T, ?, Long> combineFn() {
        return new CountFn();
    }

    public static <T> PTransform<PCollection<T>, PCollection<Long>> globally() {
        return Combine.globally(new CountFn());
    }

    public static <K, V> PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Long>>> perKey() {
        return Combine.perKey(new CountFn());
    }

    public static <T> PTransform<PCollection<T>, PCollection<KV<T, Long>>> perElement() {
        return new PerElement();
    }

    private static class CountFn<T>
    extends Combine.CombineFn<T, long[], Long> {
        private CountFn() {
        }

        @Override
        public long[] createAccumulator() {
            return new long[]{0L};
        }

        @Override
        public long[] addInput(long[] accumulator, T input) {
            accumulator[0] = accumulator[0] + 1L;
            return accumulator;
        }

        @Override
        public long[] mergeAccumulators(Iterable<long[]> accumulators) {
            Iterator<long[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            long[] running = iter.next();
            while (iter.hasNext()) {
                running[0] = running[0] + iter.next()[0];
            }
            return running;
        }

        @Override
        public Long extractOutput(long[] accumulator) {
            return accumulator[0];
        }

        @Override
        public Coder<long[]> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return new AtomicCoder<long[]>(){

                @Override
                public void encode(long[] value, OutputStream outStream) throws IOException {
                    VarInt.encode(value[0], outStream);
                }

                @Override
                public long[] decode(InputStream inStream) throws IOException, CoderException {
                    try {
                        return new long[]{VarInt.decodeLong(inStream)};
                    }
                    catch (EOFException | UTFDataFormatException exn) {
                        throw new CoderException(exn);
                    }
                }

                @Override
                public boolean isRegisterByteSizeObserverCheap(long[] value) {
                    return true;
                }

                @Override
                protected long getEncodedElementByteSize(long[] value) {
                    return VarInt.getLength(value[0]);
                }
            };
        }

        public boolean equals(@Nullable Object other) {
            return other != null && this.getClass().equals(other.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public String getIncompatibleGlobalWindowErrorMessage() {
            return "If the input collection uses a windowing strategy other than GlobalWindows, use Combine.globally(Count.<T>combineFn()).withoutDefaults() instead.";
        }
    }

    private static class PerElement<T>
    extends PTransform<PCollection<T>, PCollection<KV<T, Long>>> {
        private PerElement() {
        }

        @Override
        public PCollection<KV<T, Long>> expand(PCollection<T> input) {
            return ((PCollection)input.apply("Init", MapElements.via(new SimpleFunction<T, KV<T, Void>>(){

                @Override
                public KV<T, Void> apply(T element) {
                    return KV.of(element, null);
                }
            }))).apply(Count.perKey());
        }
    }
}

