/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerMap;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.joda.time.Instant;

@Internal
public interface DoFnInvoker<InputT, OutputT> {
    public void invokeSetup(ArgumentProvider<InputT, OutputT> var1);

    public void invokeStartBundle(ArgumentProvider<InputT, OutputT> var1);

    public void invokeFinishBundle(ArgumentProvider<InputT, OutputT> var1);

    public void invokeTeardown();

    public void invokeOnWindowExpiration(ArgumentProvider<InputT, OutputT> var1);

    public DoFn.ProcessContinuation invokeProcessElement(ArgumentProvider<InputT, OutputT> var1);

    public void invokeOnTimer(String var1, String var2, ArgumentProvider<InputT, OutputT> var3);

    public <RestrictionT> RestrictionT invokeGetInitialRestriction(ArgumentProvider<InputT, OutputT> var1);

    public <RestrictionT> Coder<RestrictionT> invokeGetRestrictionCoder(CoderRegistry var1);

    public void invokeSplitRestriction(ArgumentProvider<InputT, OutputT> var1);

    public <RestrictionT> RestrictionTracker.TruncateResult<RestrictionT> invokeTruncateRestriction(ArgumentProvider<InputT, OutputT> var1);

    public double invokeGetSize(ArgumentProvider<InputT, OutputT> var1);

    public <RestrictionT, PositionT> RestrictionTracker<RestrictionT, PositionT> invokeNewTracker(ArgumentProvider<InputT, OutputT> var1);

    public <WatermarkEstimatorStateT> WatermarkEstimator<WatermarkEstimatorStateT> invokeNewWatermarkEstimator(ArgumentProvider<InputT, OutputT> var1);

    public <WatermarkEstimatorStateT> WatermarkEstimatorStateT invokeGetInitialWatermarkEstimatorState(ArgumentProvider<InputT, OutputT> var1);

    public <WatermarkEstimatorStateT> Coder<WatermarkEstimatorStateT> invokeGetWatermarkEstimatorStateCoder(CoderRegistry var1);

    public DoFn<InputT, OutputT> getFn();

    @VisibleForTesting
    @Internal
    public static class FakeArgumentProvider<InputT, OutputT>
    extends BaseArgumentProvider<InputT, OutputT> {
        @Override
        public String getErrorContext() {
            return "TestContext";
        }
    }

    @Internal
    public static class DelegatingArgumentProvider<InputT, OutputT>
    extends BaseArgumentProvider<InputT, OutputT> {
        private final ArgumentProvider<InputT, OutputT> delegate;
        private final String errorContext;

        public DelegatingArgumentProvider(ArgumentProvider<InputT, OutputT> delegate, String errorContext) {
            this.delegate = delegate;
            this.errorContext = errorContext;
        }

        @Override
        public BoundedWindow window() {
            return this.delegate.window();
        }

        @Override
        public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
            return this.delegate.paneInfo(doFn);
        }

        @Override
        public PipelineOptions pipelineOptions() {
            return this.delegate.pipelineOptions();
        }

        @Override
        public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
            return this.delegate.startBundleContext(doFn);
        }

        @Override
        public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
            return this.delegate.finishBundleContext(doFn);
        }

        @Override
        public DoFn.ProcessContext processContext(DoFn<InputT, OutputT> doFn) {
            return this.delegate.processContext(doFn);
        }

        @Override
        public DoFn.OnTimerContext onTimerContext(DoFn<InputT, OutputT> doFn) {
            return this.delegate.onTimerContext(doFn);
        }

        @Override
        public InputT element(DoFn<InputT, OutputT> doFn) {
            return this.delegate.element(doFn);
        }

        @Override
        public Object key() {
            return this.delegate.key();
        }

        @Override
        public Object sideInput(String tagId) {
            return this.delegate.sideInput(tagId);
        }

        @Override
        public Object schemaElement(int index) {
            return this.delegate.schemaElement(index);
        }

        @Override
        public Instant timestamp(DoFn<InputT, OutputT> doFn) {
            return this.delegate.timestamp(doFn);
        }

        @Override
        public TimeDomain timeDomain(DoFn<InputT, OutputT> doFn) {
            return this.delegate.timeDomain(doFn);
        }

        @Override
        public DoFn.OutputReceiver<OutputT> outputReceiver(DoFn<InputT, OutputT> doFn) {
            return this.delegate.outputReceiver(doFn);
        }

        @Override
        public DoFn.OutputReceiver<Row> outputRowReceiver(DoFn<InputT, OutputT> doFn) {
            return this.delegate.outputRowReceiver(doFn);
        }

        @Override
        public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn<InputT, OutputT> doFn) {
            return this.delegate.taggedOutputReceiver(doFn);
        }

        @Override
        public Object restriction() {
            return this.delegate.restriction();
        }

        @Override
        public RestrictionTracker<?, ?> restrictionTracker() {
            return this.delegate.restrictionTracker();
        }

        @Override
        public Object watermarkEstimatorState() {
            return this.delegate.watermarkEstimatorState();
        }

        @Override
        public WatermarkEstimator<?> watermarkEstimator() {
            return this.delegate.watermarkEstimator();
        }

        @Override
        public State state(String stateId, boolean alwaysFetch) {
            return this.delegate.state(stateId, alwaysFetch);
        }

        @Override
        public Timer timer(String timerId) {
            return this.delegate.timer(timerId);
        }

        @Override
        public TimerMap timerFamily(String timerFamilyId) {
            return this.delegate.timerFamily(timerFamilyId);
        }

        @Override
        public String timerId(DoFn<InputT, OutputT> doFn) {
            return this.delegate.timerId(doFn);
        }

        @Override
        public DoFn.BundleFinalizer bundleFinalizer() {
            return this.delegate.bundleFinalizer();
        }

        @Override
        public String getErrorContext() {
            return this.errorContext;
        }
    }

    @Internal
    public static abstract class BaseArgumentProvider<InputT, OutputT>
    implements ArgumentProvider<InputT, OutputT> {
        @Override
        public DoFn.ProcessContext processContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("ProcessContext unsupported in %s", this.getErrorContext()));
        }

        @Override
        public InputT element(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("Element unsupported in %s", this.getErrorContext()));
        }

        @Override
        public Object key() {
            throw new UnsupportedOperationException("Cannot access key as parameter outside of @OnTimer method.");
        }

        @Override
        public Object sideInput(String tagId) {
            throw new UnsupportedOperationException(String.format("SideInput unsupported in %s", this.getErrorContext()));
        }

        @Override
        public TimerMap timerFamily(String tagId) {
            throw new UnsupportedOperationException(String.format("TimerFamily unsupported in %s", this.getErrorContext()));
        }

        @Override
        public Object schemaElement(int index) {
            throw new UnsupportedOperationException(String.format("Schema element unsupported in %s", this.getErrorContext()));
        }

        @Override
        public Instant timestamp(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("Timestamp unsupported in %s", this.getErrorContext()));
        }

        @Override
        public String timerId(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("TimerId unsupported in %s", this.getErrorContext()));
        }

        @Override
        public TimeDomain timeDomain(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("TimeDomain unsupported in %s", this.getErrorContext()));
        }

        @Override
        public DoFn.OutputReceiver<OutputT> outputReceiver(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("OutputReceiver unsupported in %s", this.getErrorContext()));
        }

        @Override
        public DoFn.OutputReceiver<Row> outputRowReceiver(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("Row OutputReceiver unsupported in %s", this.getErrorContext()));
        }

        @Override
        public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("MultiOutputReceiver unsupported in %s", this.getErrorContext()));
        }

        @Override
        public Object restriction() {
            throw new UnsupportedOperationException(String.format("Restriction unsupported in %s", this.getErrorContext()));
        }

        @Override
        public BoundedWindow window() {
            throw new UnsupportedOperationException(String.format("BoundedWindow unsupported in %s", this.getErrorContext()));
        }

        @Override
        public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("PaneInfo unsupported in %s", this.getErrorContext()));
        }

        @Override
        public PipelineOptions pipelineOptions() {
            throw new UnsupportedOperationException(String.format("PipelineOptions unsupported in %s", this.getErrorContext()));
        }

        @Override
        public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("StartBundleContext unsupported in %s", this.getErrorContext()));
        }

        @Override
        public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("FinishBundleContext unsupported in %s", this.getErrorContext()));
        }

        @Override
        public DoFn.OnTimerContext onTimerContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("OnTimerContext unsupported in %s", this.getErrorContext()));
        }

        @Override
        public State state(String stateId, boolean alwaysFetched) {
            throw new UnsupportedOperationException(String.format("State unsupported in %s", this.getErrorContext()));
        }

        @Override
        public Timer timer(String timerId) {
            throw new UnsupportedOperationException(String.format("Timer unsupported in %s", this.getErrorContext()));
        }

        @Override
        public RestrictionTracker<?, ?> restrictionTracker() {
            throw new UnsupportedOperationException(String.format("RestrictionTracker unsupported in %s", this.getErrorContext()));
        }

        @Override
        public Object watermarkEstimatorState() {
            throw new UnsupportedOperationException(String.format("WatermarkEstimatorState unsupported in %s", this.getErrorContext()));
        }

        @Override
        public WatermarkEstimator<?> watermarkEstimator() {
            throw new UnsupportedOperationException(String.format("WatermarkEstimator unsupported in %s", this.getErrorContext()));
        }

        @Override
        public DoFn.BundleFinalizer bundleFinalizer() {
            throw new UnsupportedOperationException(String.format("BundleFinalizer unsupported in %s", this.getErrorContext()));
        }

        public abstract String getErrorContext();
    }

    @Internal
    public static interface ArgumentProvider<InputT, OutputT> {
        public BoundedWindow window();

        public PaneInfo paneInfo(DoFn<InputT, OutputT> var1);

        public PipelineOptions pipelineOptions();

        public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> var1);

        public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> var1);

        public DoFn.ProcessContext processContext(DoFn<InputT, OutputT> var1);

        public DoFn.OnTimerContext onTimerContext(DoFn<InputT, OutputT> var1);

        public InputT element(DoFn<InputT, OutputT> var1);

        public Object key();

        public Object sideInput(String var1);

        public Object schemaElement(int var1);

        public Instant timestamp(DoFn<InputT, OutputT> var1);

        public TimeDomain timeDomain(DoFn<InputT, OutputT> var1);

        public DoFn.OutputReceiver<OutputT> outputReceiver(DoFn<InputT, OutputT> var1);

        public DoFn.OutputReceiver<Row> outputRowReceiver(DoFn<InputT, OutputT> var1);

        public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn<InputT, OutputT> var1);

        public DoFn.BundleFinalizer bundleFinalizer();

        public Object restriction();

        public RestrictionTracker<?, ?> restrictionTracker();

        public Object watermarkEstimatorState();

        public WatermarkEstimator<?> watermarkEstimator();

        public State state(String var1, boolean var2);

        public Timer timer(String var1);

        public TimerMap timerFamily(String var1);

        public String timerId(DoFn<InputT, OutputT> var1);
    }
}

