/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.Objects;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.IllegalMutationException;
import org.apache.beam.sdk.util.MutationDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MutationDetectors {
    private static final Logger LOG = LoggerFactory.getLogger(MutationDetectors.class);

    private MutationDetectors() {
    }

    public static <T> MutationDetector forValueWithCoder(T value, Coder<T> coder) throws CoderException {
        if (value == null) {
            return MutationDetectors.noopMutationDetector();
        }
        return new CodedValueMutationDetector<T>(value, coder);
    }

    public static MutationDetector noopMutationDetector() {
        return new NoopMutationDetector();
    }

    private static class CodedValueMutationDetector<T>
    implements MutationDetector {
        private final Coder<T> coder;
        private final T clonedOriginalValue;
        private final T possiblyModifiedObject;
        private final byte[] encodedOriginalObject;
        private final T clonedOriginalObject;
        private final Object originalStructuralValue;

        public CodedValueMutationDetector(T value, Coder<T> coder) throws CoderException {
            this.coder = coder;
            this.clonedOriginalValue = CoderUtils.clone(coder, value);
            this.originalStructuralValue = coder.structuralValue(this.clonedOriginalValue);
            this.possiblyModifiedObject = value;
            this.encodedOriginalObject = CoderUtils.encodeToByteArray(coder, value);
            this.clonedOriginalObject = CoderUtils.decodeFromByteArray(coder, this.encodedOriginalObject);
        }

        @Override
        public void verifyUnmodified() {
            try {
                this.verifyUnmodifiedThrowingCheckedExceptions();
            }
            catch (CoderException exn) {
                throw new RuntimeException(exn);
            }
        }

        private void verifyUnmodifiedThrowingCheckedExceptions() throws CoderException {
            T possiblyModifiedClonedValue = CoderUtils.clone(this.coder, this.possiblyModifiedObject);
            Object newStructuralValue = this.coder.structuralValue(possiblyModifiedClonedValue);
            if (this.originalStructuralValue.equals(newStructuralValue)) {
                return;
            }
            if (Objects.deepEquals(this.encodedOriginalObject, CoderUtils.encodeToByteArray(this.coder, this.possiblyModifiedObject))) {
                LOG.warn("{} of type {} has a #structuralValue method which does not return true when the encoding of the elements is equal. Element {}", new Object[]{Coder.class.getSimpleName(), this.coder.getClass(), this.possiblyModifiedObject});
                return;
            }
            this.illegalMutation(this.clonedOriginalObject, possiblyModifiedClonedValue);
        }

        private void illegalMutation(T previousValue, T newValue) throws CoderException {
            throw new IllegalMutationException(String.format("Value %s mutated illegally, new value was %s. Encoding was %s, now %s.", previousValue, newValue, CoderUtils.encodeToBase64(this.coder, previousValue), CoderUtils.encodeToBase64(this.coder, newValue)), previousValue, newValue);
        }

        @Override
        public void close() {
            this.verifyUnmodified();
        }
    }

    private static class NoopMutationDetector
    implements MutationDetector {
        private NoopMutationDetector() {
        }

        @Override
        public void verifyUnmodified() {
        }

        @Override
        public void close() {
        }
    }
}

