/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.util.RowJson;
import org.apache.beam.sdk.values.Row;

@Internal
public class RowJsonUtils {
    public static ObjectMapper newObjectMapperWith(RowJson.RowJsonDeserializer deserializer) {
        SimpleModule module = new SimpleModule("rowDeserializationModule");
        module.addDeserializer(Row.class, (JsonDeserializer)deserializer);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    public static ObjectMapper newObjectMapperWith(RowJson.RowJsonSerializer serializer) {
        SimpleModule module = new SimpleModule("rowSerializationModule");
        module.addSerializer(Row.class, (JsonSerializer)serializer);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    public static Row jsonToRow(ObjectMapper objectMapper, String jsonString) {
        try {
            return (Row)objectMapper.readValue(jsonString, Row.class);
        }
        catch (JsonParseException | JsonMappingException jsonException) {
            throw new RowJson.UnsupportedRowJsonException("Unable to parse Row", jsonException);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse json object: " + jsonString, e);
        }
    }

    public static String rowToJson(ObjectMapper objectMapper, Row row) {
        try {
            return objectMapper.writeValueAsString((Object)row);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to serialize row: " + row, e);
        }
    }
}

