/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.WordUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.TableListing;
import org.apache.hadoop.tracing.TraceUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
public class FsShell
extends Configured
implements Tool {
    static final Log LOG = LogFactory.getLog(FsShell.class);
    private static final int MAX_LINE_WIDTH = 80;
    private FileSystem fs;
    private Trash trash;
    protected CommandFactory commandFactory;
    private final String usagePrefix = "Usage: hadoop fs [generic options]";
    private Tracer tracer;
    static final String SHELL_HTRACE_PREFIX = "fs.shell.htrace.";

    public FsShell() {
        this(null);
    }

    public FsShell(Configuration conf) {
        super(conf);
    }

    protected FileSystem getFS() throws IOException {
        if (this.fs == null) {
            this.fs = FileSystem.get(this.getConf());
        }
        return this.fs;
    }

    protected Trash getTrash() throws IOException {
        if (this.trash == null) {
            this.trash = new Trash(this.getConf());
        }
        return this.trash;
    }

    protected void init() throws IOException {
        this.getConf().setQuietMode(true);
        UserGroupInformation.setConfiguration(this.getConf());
        if (this.commandFactory == null) {
            this.commandFactory = new CommandFactory(this.getConf());
            this.commandFactory.addObject(new Help(), "-help");
            this.commandFactory.addObject(new Usage(), "-usage");
            this.registerCommands(this.commandFactory);
        }
        this.tracer = new Tracer.Builder("FsShell").conf(TraceUtils.wrapHadoopConf(SHELL_HTRACE_PREFIX, this.getConf())).build();
    }

    protected void registerCommands(CommandFactory factory) {
        if (this.getClass().equals(FsShell.class)) {
            factory.registerCommands(FsCommand.class);
        }
    }

    public Path getCurrentTrashDir() throws IOException {
        return this.getTrash().getCurrentTrashDir();
    }

    public Path getCurrentTrashDir(Path path) throws IOException {
        return this.getTrash().getCurrentTrashDir(path);
    }

    private void printUsage(PrintStream out) {
        this.printInfo(out, null, false);
    }

    private void printUsage(PrintStream out, String cmd) {
        this.printInfo(out, cmd, false);
    }

    private void printHelp(PrintStream out) {
        this.printInfo(out, null, true);
    }

    private void printHelp(PrintStream out, String cmd) {
        this.printInfo(out, cmd, true);
    }

    private void printInfo(PrintStream out, String cmd, boolean showHelp) {
        if (cmd != null) {
            Command instance = this.commandFactory.getInstance("-" + cmd);
            if (instance == null) {
                throw new UnknownCommandException(cmd);
            }
            if (showHelp) {
                this.printInstanceHelp(out, instance);
            } else {
                this.printInstanceUsage(out, instance);
            }
        } else {
            out.println("Usage: hadoop fs [generic options]");
            ArrayList<Command> instances = new ArrayList<Command>();
            for (String name : this.commandFactory.getNames()) {
                Command instance = this.commandFactory.getInstance(name);
                if (instance.isDeprecated()) continue;
                out.println("\t[" + instance.getUsage() + "]");
                instances.add(instance);
            }
            if (showHelp) {
                for (Command instance : instances) {
                    out.println();
                    this.printInstanceHelp(out, instance);
                }
            }
            out.println();
            ToolRunner.printGenericCommandUsage(out);
        }
    }

    private void printInstanceUsage(PrintStream out, Command instance) {
        out.println("Usage: hadoop fs [generic options] " + instance.getUsage());
    }

    private void printInstanceHelp(PrintStream out, Command instance) {
        out.println(instance.getUsage() + " :");
        TableListing listing = null;
        String prefix = "  ";
        for (String line : instance.getDescription().split("\n")) {
            String[] segments;
            if (line.matches("^[ \t]*[-<].*$") && (segments = line.split(":")).length == 2) {
                if (listing == null) {
                    listing = this.createOptionTableListing();
                }
                listing.addRow(segments[0].trim(), segments[1].trim());
                continue;
            }
            if (listing != null) {
                for (String listingLine : listing.toString().split("\n")) {
                    out.println("  " + listingLine);
                }
                listing = null;
            }
            for (String descLine : WordUtils.wrap(line, 80, "\n", true).split("\n")) {
                out.println("  " + descLine);
            }
        }
        if (listing != null) {
            for (String listingLine : listing.toString().split("\n")) {
                out.println("  " + listingLine);
            }
        }
    }

    private TableListing createOptionTableListing() {
        return new TableListing.Builder().addField("").addField("", true).wrapWidth(80).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] argv) throws Exception {
        this.init();
        int exitCode = -1;
        if (argv.length < 1) {
            this.printUsage(System.err);
        } else {
            String cmd = argv[0];
            Command instance = null;
            try {
                instance = this.commandFactory.getInstance(cmd);
                if (instance == null) {
                    throw new UnknownCommandException();
                }
                TraceScope scope = this.tracer.newScope(instance.getCommandName());
                if (scope.getSpan() != null) {
                    String args = StringUtils.join((CharSequence)" ", argv);
                    if (args.length() > 2048) {
                        args = args.substring(0, 2048);
                    }
                    scope.getSpan().addKVAnnotation("args", args);
                }
                try {
                    exitCode = instance.run(Arrays.copyOfRange(argv, 1, argv.length));
                }
                finally {
                    scope.close();
                }
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage() == null) {
                    this.displayError(cmd, "Null exception message");
                    e.printStackTrace(System.err);
                } else {
                    this.displayError(cmd, e.getLocalizedMessage());
                }
                this.printUsage(System.err);
                if (instance != null) {
                    this.printInstanceUsage(System.err, instance);
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"Error", (Throwable)e);
                this.displayError(cmd, "Fatal internal error");
                e.printStackTrace(System.err);
            }
        }
        this.tracer.close();
        return exitCode;
    }

    private void displayError(String cmd, String message) {
        for (String line : message.split("\n")) {
            System.err.println(cmd + ": " + line);
            if (cmd.charAt(0) == '-') continue;
            Command instance = null;
            instance = this.commandFactory.getInstance("-" + cmd);
            if (instance == null) continue;
            System.err.println("Did you mean -" + cmd + "?  This command " + "begins with a dash.");
        }
    }

    public void close() throws IOException {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        int res;
        FsShell shell = FsShell.newShellInstance();
        Configuration conf = new Configuration();
        conf.setQuietMode(false);
        shell.setConf(conf);
        try {
            res = ToolRunner.run(shell, argv);
        }
        finally {
            shell.close();
        }
        System.exit(res);
    }

    protected static FsShell newShellInstance() {
        return new FsShell();
    }

    static class UnknownCommandException
    extends IllegalArgumentException {
        private final String cmd;

        UnknownCommandException() {
            this((String)null);
        }

        UnknownCommandException(String cmd) {
            this.cmd = cmd;
        }

        @Override
        public String getMessage() {
            return (this.cmd != null ? "`" + this.cmd + "': " : "") + "Unknown command";
        }
    }

    protected class Help
    extends FsCommand {
        public static final String NAME = "help";
        public static final String USAGE = "[cmd ...]";
        public static final String DESCRIPTION = "Displays help for given command or all commands if none is specified.";

        protected Help() {
        }

        @Override
        protected void processRawArguments(LinkedList<String> args) {
            if (args.isEmpty()) {
                FsShell.this.printHelp(System.out);
            } else {
                for (String arg : args) {
                    FsShell.this.printHelp(System.out, arg);
                }
            }
        }
    }

    protected class Usage
    extends FsCommand {
        public static final String NAME = "usage";
        public static final String USAGE = "[cmd ...]";
        public static final String DESCRIPTION = "Displays the usage for given command or all commands if none is specified.";

        protected Usage() {
        }

        @Override
        protected void processRawArguments(LinkedList<String> args) {
            if (args.isEmpty()) {
                FsShell.this.printUsage(System.out);
            } else {
                for (String arg : args) {
                    FsShell.this.printUsage(System.out, arg);
                }
            }
        }
    }
}

