/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.RetryImmediatelyException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.DelayingRunner;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.MultiServerCallable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.NeedUnmanagedConnectionException;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.PayloadCarryingServerCallable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.ResultStatsUtil;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RetryingTimeTracker;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowAccess;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.htrace.Trace;

@InterfaceAudience.Private
@SuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="Synchronization on tasks in progress counter is intended")
class AsyncProcess {
    private static final Log LOG = LogFactory.getLog(AsyncProcess.class);
    protected static final AtomicLong COUNTER = new AtomicLong();
    public static final String PRIMARY_CALL_TIMEOUT_KEY = "hbase.client.primaryCallTimeout.multiget";
    public static final String START_LOG_ERRORS_AFTER_COUNT_KEY = "hbase.client.start.log.errors.counter";
    public static final int DEFAULT_START_LOG_ERRORS_AFTER_COUNT = 9;
    public static final String LOG_DETAILS_FOR_BATCH_ERROR = "hbase.client.log.batcherrors.details";
    private final int thresholdToLogUndoneTaskDetails;
    private static final String THRESHOLD_TO_LOG_UNDONE_TASK_DETAILS = "hbase.client.threshold.log.details";
    private static final int DEFAULT_THRESHOLD_TO_LOG_UNDONE_TASK_DETAILS = 10;
    private final int THRESHOLD_TO_LOG_REGION_DETAILS = 2;
    public static final String HBASE_CLIENT_MAX_PERREQUEST_HEAPSIZE = "hbase.client.max.perrequest.heapsize";
    public static final long DEFAULT_HBASE_CLIENT_MAX_PERREQUEST_HEAPSIZE = 0x400000L;
    public static final String HBASE_CLIENT_MAX_SUBMIT_HEAPSIZE = "hbase.client.max.submit.heapsize";
    public static final long DEFAULT_HBASE_CLIENT_MAX_SUBMIT_HEAPSIZE = 0x400000L;
    private static final AsyncRequestFuture NO_REQS_RESULT = new AsyncRequestFuture(){
        final Object[] result = new Object[0];

        @Override
        public boolean hasError() {
            return false;
        }

        @Override
        public RetriesExhaustedWithDetailsException getErrors() {
            return null;
        }

        @Override
        public List<? extends Row> getFailedOperations() {
            return null;
        }

        @Override
        public Object[] getResults() {
            return this.result;
        }

        @Override
        public void waitUntilDone() throws InterruptedIOException {
        }
    };
    protected final long id;
    protected final ClusterConnection connection;
    protected final RpcRetryingCallerFactory rpcCallerFactory;
    protected final RpcControllerFactory rpcFactory;
    protected final BatchErrors globalErrors;
    protected final ExecutorService pool;
    protected final AtomicLong tasksInProgress = new AtomicLong(0L);
    protected final ConcurrentMap<byte[], AtomicInteger> taskCounterPerRegion = new ConcurrentSkipListMap<byte[], AtomicInteger>(Bytes.BYTES_COMPARATOR);
    protected final ConcurrentMap<ServerName, AtomicInteger> taskCounterPerServer = new ConcurrentHashMap<ServerName, AtomicInteger>();
    private final int startLogErrorsCnt;
    protected final int maxTotalConcurrentTasks;
    protected final long maxHeapSizePerRequest;
    protected final long maxHeapSizeSubmit;
    protected final int maxConcurrentTasksPerRegion;
    protected final int maxConcurrentTasksPerServer;
    protected final long pause;
    protected final long pauseForCQTBE;
    protected int numTries;
    protected int serverTrackerTimeout;
    protected int rpcTimeout;
    protected int operationTimeout;
    protected long primaryCallTimeoutMicroseconds;
    private final boolean logBatchErrorDetails;

    public AsyncProcess(ClusterConnection hc, Configuration conf, ExecutorService pool, RpcRetryingCallerFactory rpcCaller, boolean useGlobalErrors, RpcControllerFactory rpcFactory, int rpcTimeout) {
        ConnectionConfiguration connConf;
        if (hc == null) {
            throw new IllegalArgumentException("HConnection cannot be null.");
        }
        this.connection = hc;
        this.pool = pool;
        this.globalErrors = useGlobalErrors ? new BatchErrors() : null;
        this.id = COUNTER.incrementAndGet();
        ConnectionConfiguration connectionConfiguration = connConf = hc.getConfiguration() == conf ? hc.getConnectionConfiguration() : new ConnectionConfiguration(conf);
        if (connConf == null) {
            connConf = new ConnectionConfiguration(conf);
        }
        this.pause = connConf.getPause();
        this.pauseForCQTBE = connConf.getPauseForCQTBE();
        this.numTries = connConf.getRetriesNumber();
        this.rpcTimeout = rpcTimeout;
        this.operationTimeout = connConf.getOperationTimeout();
        AsyncProcess globalAsyncProcess = hc.getConfiguration() == conf ? hc.getAsyncProcess() : null;
        this.primaryCallTimeoutMicroseconds = globalAsyncProcess == null ? (long)conf.getInt(PRIMARY_CALL_TIMEOUT_KEY, 10000) : globalAsyncProcess.primaryCallTimeoutMicroseconds;
        this.maxTotalConcurrentTasks = globalAsyncProcess == null ? conf.getInt("hbase.client.max.total.tasks", 100) : globalAsyncProcess.maxTotalConcurrentTasks;
        this.maxConcurrentTasksPerServer = globalAsyncProcess == null ? conf.getInt("hbase.client.max.perserver.tasks", 2) : globalAsyncProcess.maxConcurrentTasksPerServer;
        this.maxConcurrentTasksPerRegion = globalAsyncProcess == null ? conf.getInt("hbase.client.max.perregion.tasks", 1) : globalAsyncProcess.maxConcurrentTasksPerRegion;
        this.maxHeapSizePerRequest = globalAsyncProcess == null ? conf.getLong(HBASE_CLIENT_MAX_PERREQUEST_HEAPSIZE, 0x400000L) : globalAsyncProcess.maxHeapSizePerRequest;
        this.maxHeapSizeSubmit = globalAsyncProcess == null ? conf.getLong(HBASE_CLIENT_MAX_SUBMIT_HEAPSIZE, 0x400000L) : globalAsyncProcess.maxHeapSizeSubmit;
        int n = this.startLogErrorsCnt = globalAsyncProcess == null ? conf.getInt(START_LOG_ERRORS_AFTER_COUNT_KEY, 9) : globalAsyncProcess.startLogErrorsCnt;
        if (this.maxTotalConcurrentTasks <= 0) {
            throw new IllegalArgumentException("maxTotalConcurrentTasks=" + this.maxTotalConcurrentTasks);
        }
        if (this.maxConcurrentTasksPerServer <= 0) {
            throw new IllegalArgumentException("maxConcurrentTasksPerServer=" + this.maxConcurrentTasksPerServer);
        }
        if (this.maxConcurrentTasksPerRegion <= 0) {
            throw new IllegalArgumentException("maxConcurrentTasksPerRegion=" + this.maxConcurrentTasksPerRegion);
        }
        if (this.maxHeapSizePerRequest <= 0L) {
            throw new IllegalArgumentException("maxHeapSizePerServer=" + this.maxHeapSizePerRequest);
        }
        if (this.maxHeapSizeSubmit <= 0L) {
            throw new IllegalArgumentException("maxHeapSizeSubmit=" + this.maxHeapSizeSubmit);
        }
        this.serverTrackerTimeout = 0;
        for (int i = 0; i < this.numTries; ++i) {
            this.serverTrackerTimeout = (int)((long)this.serverTrackerTimeout + ConnectionUtils.getPauseTime(this.pause, i));
        }
        this.rpcCallerFactory = rpcCaller;
        this.rpcFactory = rpcFactory;
        this.logBatchErrorDetails = globalAsyncProcess == null ? conf.getBoolean(LOG_DETAILS_FOR_BATCH_ERROR, false) : globalAsyncProcess.logBatchErrorDetails;
        this.thresholdToLogUndoneTaskDetails = globalAsyncProcess == null ? conf.getInt(THRESHOLD_TO_LOG_UNDONE_TASK_DETAILS, 10) : globalAsyncProcess.thresholdToLogUndoneTaskDetails;
    }

    public void setRpcTimeout(int rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    ExecutorService getPool(ExecutorService pool) {
        if (pool != null) {
            return pool;
        }
        if (this.pool != null) {
            return this.pool;
        }
        throw new RuntimeException("Neither AsyncProcess nor request have ExecutorService");
    }

    public <CResult> AsyncRequestFuture submit(TableName tableName, List<? extends Row> rows, boolean atLeastOne, Batch.Callback<CResult> callback, boolean needResults) throws InterruptedIOException {
        return this.submit(null, tableName, rows, atLeastOne, callback, needResults);
    }

    public <CResult> AsyncRequestFuture submit(TableName tableName, RowAccess<? extends Row> rows, boolean atLeastOne, Batch.Callback<CResult> callback, boolean needResults) throws InterruptedIOException {
        return this.submit(null, tableName, rows, atLeastOne, callback, needResults);
    }

    public <CResult> AsyncRequestFuture submit(ExecutorService pool, TableName tableName, List<? extends Row> rows, boolean atLeastOne, Batch.Callback<CResult> callback, boolean needResults) throws InterruptedIOException {
        return this.submit(pool, tableName, new ListRowAccess<Row>(rows), atLeastOne, callback, needResults);
    }

    public <CResult> AsyncRequestFuture submit(ExecutorService pool, TableName tableName, RowAccess<? extends Row> rows, boolean atLeastOne, Batch.Callback<CResult> callback, boolean needResults) throws InterruptedIOException {
        if (rows.isEmpty()) {
            return NO_REQS_RESULT;
        }
        HashMap<ServerName, MultiAction<Row>> actionsByServer = new HashMap<ServerName, MultiAction<Row>>();
        ArrayList<Action<Row>> retainedActions = new ArrayList<Action<Row>>(rows.size());
        NonceGenerator ng = this.connection.getNonceGenerator();
        long nonceGroup = ng.getNonceGroup();
        ArrayList<Exception> locationErrors = null;
        ArrayList<Integer> locationErrorRows = null;
        RowCheckerHost checker = this.createRowCheckerHost();
        boolean firstIter = true;
        do {
            this.waitForMaximumCurrentTasks(this.maxTotalConcurrentTasks - 1, tableName.getNameAsString());
            int posInList = -1;
            if (!firstIter) {
                checker.reset();
            }
            Iterator it = rows.iterator();
            while (it.hasNext()) {
                HRegionLocation loc;
                Row r = (Row)it.next();
                try {
                    if (r == null) {
                        throw new IllegalArgumentException("#" + this.id + ", row cannot be null");
                    }
                    RegionLocations locs = this.connection.locateRegion(tableName, r.getRow(), true, true, 0);
                    if (locs == null || locs.isEmpty() || locs.getDefaultRegionLocation() == null) {
                        throw new IOException("#" + this.id + ", no location found, aborting submit for" + " tableName=" + tableName + " rowkey=" + Bytes.toStringBinary(r.getRow()));
                    }
                    loc = locs.getDefaultRegionLocation();
                }
                catch (IOException ex) {
                    locationErrors = new ArrayList<Exception>();
                    locationErrorRows = new ArrayList<Integer>();
                    LOG.error((Object)"Failed to get region location ", (Throwable)ex);
                    int priority = 0;
                    if (r instanceof Mutation) {
                        priority = ((Mutation)r).getPriority();
                    }
                    retainedActions.add(new Action(r, ++posInList, priority));
                    locationErrors.add(ex);
                    locationErrorRows.add(posInList);
                    it.remove();
                    break;
                }
                long rowSize = r instanceof Mutation ? ((Mutation)r).heapSize() : 0L;
                RowChecker.ReturnCode code = checker.canTakeOperation(loc, rowSize);
                if (code == RowChecker.ReturnCode.END) break;
                if (code != RowChecker.ReturnCode.INCLUDE) continue;
                int priority = 0;
                if (r instanceof Mutation) {
                    priority = ((Mutation)r).getPriority();
                }
                Action<Row> action = new Action<Row>(r, ++posInList, priority);
                AsyncProcess.setNonce(ng, r, action);
                retainedActions.add(action);
                byte[] regionName = loc.getRegionInfo().getRegionName();
                AsyncProcess.addAction(loc.getServerName(), regionName, action, actionsByServer, nonceGroup);
                it.remove();
            }
            firstIter = false;
        } while (retainedActions.isEmpty() && atLeastOne && locationErrors == null);
        if (retainedActions.isEmpty()) {
            return NO_REQS_RESULT;
        }
        return this.submitMultiActions(tableName, retainedActions, nonceGroup, callback, null, needResults, locationErrors, locationErrorRows, actionsByServer, pool);
    }

    private RowCheckerHost createRowCheckerHost() {
        return new RowCheckerHost(Arrays.asList(new TaskCountChecker(this.maxTotalConcurrentTasks, this.maxConcurrentTasksPerServer, this.maxConcurrentTasksPerRegion, this.tasksInProgress, this.taskCounterPerServer, this.taskCounterPerRegion), new RequestSizeChecker(this.maxHeapSizePerRequest), new SubmittedSizeChecker(this.maxHeapSizeSubmit)));
    }

    <CResult> AsyncRequestFuture submitMultiActions(TableName tableName, List<Action<Row>> retainedActions, long nonceGroup, Batch.Callback<CResult> callback, Object[] results, boolean needResults, List<Exception> locationErrors, List<Integer> locationErrorRows, Map<ServerName, MultiAction<Row>> actionsByServer, ExecutorService pool) {
        AsyncRequestFutureImpl<CResult> ars = this.createAsyncRequestFuture(tableName, retainedActions, nonceGroup, pool, callback, results, needResults, null, this.operationTimeout, this.rpcTimeout);
        if (locationErrors != null) {
            for (int i = 0; i < locationErrors.size(); ++i) {
                int originalIndex = locationErrorRows.get(i);
                Row row = retainedActions.get(originalIndex).getAction();
                ars.manageError(originalIndex, row, Retry.NO_LOCATION_PROBLEM, locationErrors.get(i), null);
            }
        }
        ((AsyncRequestFutureImpl)ars).sendMultiAction(actionsByServer, 1, null, false);
        return ars;
    }

    private static void addAction(ServerName server, byte[] regionName, Action<Row> action, Map<ServerName, MultiAction<Row>> actionsByServer, long nonceGroup) {
        MultiAction<Row> multiAction = actionsByServer.get(server);
        if (multiAction == null) {
            multiAction = new MultiAction();
            actionsByServer.put(server, multiAction);
        }
        if (action.hasNonce() && !multiAction.hasNonceGroup()) {
            multiAction.setNonceGroup(nonceGroup);
        }
        multiAction.add(regionName, action);
    }

    public <CResult> AsyncRequestFuture submitAll(TableName tableName, List<? extends Row> rows, Batch.Callback<CResult> callback, Object[] results) {
        return this.submitAll(null, tableName, rows, callback, results, null, this.operationTimeout, this.rpcTimeout);
    }

    public <CResult> AsyncRequestFuture submitAll(ExecutorService pool, TableName tableName, List<? extends Row> rows, Batch.Callback<CResult> callback, Object[] results) {
        return this.submitAll(pool, tableName, rows, callback, results, null, this.operationTimeout, this.rpcTimeout);
    }

    public <CResult> AsyncRequestFuture submitAll(ExecutorService pool, TableName tableName, List<? extends Row> rows, Batch.Callback<CResult> callback, Object[] results, PayloadCarryingServerCallable callable, int operationTimeout, int rpcTimeout) {
        ArrayList<Action<Row>> actions = new ArrayList<Action<Row>>(rows.size());
        int posInList = -1;
        NonceGenerator ng = this.connection.getNonceGenerator();
        int highestPriority = -1;
        for (Row row : rows) {
            ++posInList;
            if (row instanceof Put) {
                Put put = (Put)row;
                if (put.isEmpty()) {
                    throw new IllegalArgumentException("No columns to insert for #" + (posInList + 1) + " item");
                }
                highestPriority = Math.max(put.getPriority(), highestPriority);
            }
            Action<Row> action = new Action<Row>(row, posInList, highestPriority);
            AsyncProcess.setNonce(ng, row, action);
            actions.add(action);
        }
        AsyncRequestFutureImpl<CResult> ars = this.createAsyncRequestFuture(tableName, actions, ng.getNonceGroup(), this.getPool(pool), callback, results, results != null, callable, operationTimeout, rpcTimeout);
        ((AsyncRequestFutureImpl)ars).groupAndSendMultiAction(actions, 1);
        return ars;
    }

    private static void setNonce(NonceGenerator ng, Row r, Action<Row> action) {
        if (!(r instanceof Append) && !(r instanceof Increment)) {
            return;
        }
        action.setNonce(ng.newNonce());
    }

    protected void updateStats(ServerName server, Map<byte[], MultiResponse.RegionResult> results) {
        boolean stats;
        boolean metrics = this.connection.getConnectionMetrics() != null;
        boolean bl = stats = this.connection.getStatisticsTracker() != null;
        if (!stats && !metrics) {
            return;
        }
        for (Map.Entry<byte[], MultiResponse.RegionResult> regionStats : results.entrySet()) {
            byte[] regionName = regionStats.getKey();
            ClientProtos.RegionLoadStats stat = regionStats.getValue().getStat();
            ResultStatsUtil.updateStats(this.connection.getStatisticsTracker(), server, regionName, stat);
            ResultStatsUtil.updateStats(this.connection.getConnectionMetrics(), server, regionName, stat);
        }
    }

    <CResult> AsyncRequestFutureImpl<CResult> createAsyncRequestFuture(TableName tableName, List<Action<Row>> actions, long nonceGroup, ExecutorService pool, Batch.Callback<CResult> callback, Object[] results, boolean needResults, PayloadCarryingServerCallable callable, int operationTimeout, int rpcTimeout) {
        return new AsyncRequestFutureImpl<CResult>(tableName, actions, nonceGroup, this.getPool(pool), needResults, results, callback, callable, operationTimeout, rpcTimeout);
    }

    protected RpcRetryingCaller<MultiResponse> createCaller(PayloadCarryingServerCallable callable, int rpcTimeout) {
        return this.rpcCallerFactory.newCaller(rpcTimeout);
    }

    void waitUntilDone() throws InterruptedIOException {
        this.waitForMaximumCurrentTasks(0, null);
    }

    private void waitForMaximumCurrentTasks(int max, String tableName) throws InterruptedIOException {
        this.waitForMaximumCurrentTasks(max, this.tasksInProgress, this.id, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForMaximumCurrentTasks(int max, AtomicLong tasksInProgress, long id, String tableName) throws InterruptedIOException {
        long currentInProgress;
        long lastLog = EnvironmentEdgeManager.currentTime();
        long oldInProgress = Long.MAX_VALUE;
        while ((currentInProgress = tasksInProgress.get()) > (long)max) {
            long now2;
            if (oldInProgress != currentInProgress && (now2 = EnvironmentEdgeManager.currentTime()) > lastLog + 10000L) {
                lastLog = now2;
                LOG.info((Object)("#" + id + ", waiting for some tasks to finish. Expected max=" + max + ", tasksInProgress=" + currentInProgress + " hasError=" + this.hasError() + (tableName == null ? "" : ", tableName=" + tableName)));
                if (currentInProgress <= (long)this.thresholdToLogUndoneTaskDetails) {
                    this.logDetailsOfUndoneTasks(currentInProgress);
                }
            }
            oldInProgress = currentInProgress;
            try {
                AtomicLong now2 = tasksInProgress;
                synchronized (now2) {
                    if (tasksInProgress.get() == oldInProgress) {
                        tasksInProgress.wait(10L);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("#" + id + ", interrupted." + " currentNumberOfTask=" + currentInProgress);
            }
        }
    }

    private void logDetailsOfUndoneTasks(long taskInProgress) {
        ArrayList servers = new ArrayList();
        for (Map.Entry entry : this.taskCounterPerServer.entrySet()) {
            if (((AtomicInteger)entry.getValue()).get() <= 0) continue;
            servers.add(entry.getKey());
        }
        LOG.info((Object)("Left over " + taskInProgress + " task(s) are processed on server(s): " + servers));
        if (taskInProgress <= 2L) {
            ArrayList<String> regions = new ArrayList<String>();
            for (Map.Entry entry : this.taskCounterPerRegion.entrySet()) {
                if (((AtomicInteger)entry.getValue()).get() <= 0) continue;
                regions.add(Bytes.toString((byte[])entry.getKey()));
            }
            LOG.info((Object)("Regions against which left over task(s) are processed: " + regions));
        }
    }

    public boolean hasError() {
        return this.globalErrors.hasErrors();
    }

    public RetriesExhaustedWithDetailsException waitForAllPreviousOpsAndReset(List<Row> failedRows, String tableName) throws InterruptedIOException {
        this.waitForMaximumCurrentTasks(0, tableName);
        if (!this.globalErrors.hasErrors()) {
            return null;
        }
        if (failedRows != null) {
            failedRows.addAll(this.globalErrors.actions);
        }
        RetriesExhaustedWithDetailsException result = this.globalErrors.makeException(this.logBatchErrorDetails);
        this.globalErrors.clear();
        return result;
    }

    protected void incTaskCounters(Collection<byte[]> regions, ServerName sn) {
        this.tasksInProgress.incrementAndGet();
        AtomicInteger serverCnt = (AtomicInteger)this.taskCounterPerServer.get(sn);
        if (serverCnt == null) {
            this.taskCounterPerServer.putIfAbsent(sn, new AtomicInteger());
            serverCnt = (AtomicInteger)this.taskCounterPerServer.get(sn);
        }
        serverCnt.incrementAndGet();
        for (byte[] regBytes : regions) {
            AtomicInteger oldCnt;
            AtomicInteger regionCnt = (AtomicInteger)this.taskCounterPerRegion.get(regBytes);
            if (regionCnt == null && (oldCnt = this.taskCounterPerRegion.putIfAbsent(regBytes, regionCnt = new AtomicInteger())) != null) {
                regionCnt = oldCnt;
            }
            regionCnt.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decTaskCounters(Collection<byte[]> regions, ServerName sn) {
        for (byte[] regBytes : regions) {
            AtomicInteger regionCnt = (AtomicInteger)this.taskCounterPerRegion.get(regBytes);
            regionCnt.decrementAndGet();
        }
        ((AtomicInteger)this.taskCounterPerServer.get(sn)).decrementAndGet();
        this.tasksInProgress.decrementAndGet();
        AtomicLong atomicLong = this.tasksInProgress;
        synchronized (atomicLong) {
            this.tasksInProgress.notifyAll();
        }
    }

    protected ConnectionManager.ServerErrorTracker createServerErrorTracker() {
        return new ConnectionManager.ServerErrorTracker(this.serverTrackerTimeout, this.numTries);
    }

    private static boolean isReplicaGet(Row row) {
        return row instanceof Get && ((Get)row).getConsistency() == Consistency.TIMELINE;
    }

    public static class ListRowAccess<T>
    implements RowAccess<T> {
        private final List<T> data;

        ListRowAccess(List<T> data) {
            this.data = data;
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.data.iterator();
        }
    }

    static class RequestSizeChecker
    implements RowChecker {
        private final long maxHeapSizePerRequest;
        private final Map<ServerName, Long> serverRequestSizes = new HashMap<ServerName, Long>();

        RequestSizeChecker(long maxHeapSizePerRequest) {
            this.maxHeapSizePerRequest = maxHeapSizePerRequest;
        }

        @Override
        public void reset() {
            this.serverRequestSizes.clear();
        }

        @Override
        public RowChecker.ReturnCode canTakeOperation(HRegionLocation loc, long rowSize) {
            long currentRequestSize;
            long l = currentRequestSize = this.serverRequestSizes.containsKey(loc.getServerName()) ? this.serverRequestSizes.get(loc.getServerName()) : 0L;
            if (currentRequestSize == 0L || currentRequestSize + rowSize <= this.maxHeapSizePerRequest) {
                return RowChecker.ReturnCode.INCLUDE;
            }
            return RowChecker.ReturnCode.SKIP;
        }

        @Override
        public void notifyFinal(RowChecker.ReturnCode code, HRegionLocation loc, long rowSize) {
            if (code == RowChecker.ReturnCode.INCLUDE) {
                long currentRequestSize = this.serverRequestSizes.containsKey(loc.getServerName()) ? this.serverRequestSizes.get(loc.getServerName()) : 0L;
                this.serverRequestSizes.put(loc.getServerName(), currentRequestSize + rowSize);
            }
        }
    }

    static class TaskCountChecker
    implements RowChecker {
        private static final long MAX_WAITING_TIME = 1000L;
        private final Set<HRegionInfo> regionsIncluded = new HashSet<HRegionInfo>();
        private final Set<ServerName> serversIncluded = new HashSet<ServerName>();
        private final int maxConcurrentTasksPerRegion;
        private final int maxTotalConcurrentTasks;
        private final int maxConcurrentTasksPerServer;
        private final Map<byte[], AtomicInteger> taskCounterPerRegion;
        private final Map<ServerName, AtomicInteger> taskCounterPerServer;
        private final Set<byte[]> busyRegions = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        private final AtomicLong tasksInProgress;

        TaskCountChecker(int maxTotalConcurrentTasks, int maxConcurrentTasksPerServer, int maxConcurrentTasksPerRegion, AtomicLong tasksInProgress, Map<ServerName, AtomicInteger> taskCounterPerServer, Map<byte[], AtomicInteger> taskCounterPerRegion) {
            this.maxTotalConcurrentTasks = maxTotalConcurrentTasks;
            this.maxConcurrentTasksPerRegion = maxConcurrentTasksPerRegion;
            this.maxConcurrentTasksPerServer = maxConcurrentTasksPerServer;
            this.taskCounterPerRegion = taskCounterPerRegion;
            this.taskCounterPerServer = taskCounterPerServer;
            this.tasksInProgress = tasksInProgress;
        }

        @Override
        public void reset() throws InterruptedIOException {
            this.waitForRegion();
            this.regionsIncluded.clear();
            this.serversIncluded.clear();
            this.busyRegions.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForRegion() throws InterruptedIOException {
            if (this.busyRegions.isEmpty()) {
                return;
            }
            EnvironmentEdge ee = EnvironmentEdgeManager.getDelegate();
            long start = ee.currentTime();
            while (ee.currentTime() - start <= 1000L) {
                for (byte[] region : this.busyRegions) {
                    AtomicInteger count = this.taskCounterPerRegion.get(region);
                    if (count != null && count.get() >= this.maxConcurrentTasksPerRegion) continue;
                    return;
                }
                try {
                    AtomicLong i$ = this.tasksInProgress;
                    synchronized (i$) {
                        this.tasksInProgress.wait(10L);
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("Interrupted. tasksInProgress=" + this.tasksInProgress);
                }
            }
        }

        @Override
        public RowChecker.ReturnCode canTakeOperation(HRegionLocation loc, long rowSize) {
            HRegionInfo regionInfo = loc.getRegionInfo();
            if (this.regionsIncluded.contains(regionInfo)) {
                return RowChecker.ReturnCode.INCLUDE;
            }
            AtomicInteger regionCnt = this.taskCounterPerRegion.get(loc.getRegionInfo().getRegionName());
            if (regionCnt != null && regionCnt.get() >= this.maxConcurrentTasksPerRegion) {
                return RowChecker.ReturnCode.SKIP;
            }
            int newServers = this.serversIncluded.size() + (this.serversIncluded.contains(loc.getServerName()) ? 0 : 1);
            if ((long)newServers + this.tasksInProgress.get() > (long)this.maxTotalConcurrentTasks) {
                return RowChecker.ReturnCode.SKIP;
            }
            AtomicInteger serverCnt = this.taskCounterPerServer.get(loc.getServerName());
            if (serverCnt != null && serverCnt.get() >= this.maxConcurrentTasksPerServer) {
                return RowChecker.ReturnCode.SKIP;
            }
            return RowChecker.ReturnCode.INCLUDE;
        }

        @Override
        public void notifyFinal(RowChecker.ReturnCode code, HRegionLocation loc, long rowSize) {
            if (code == RowChecker.ReturnCode.INCLUDE) {
                this.regionsIncluded.add(loc.getRegionInfo());
                this.serversIncluded.add(loc.getServerName());
            }
            this.busyRegions.add(loc.getRegionInfo().getRegionName());
        }
    }

    static class SubmittedSizeChecker
    implements RowChecker {
        private final long maxHeapSizeSubmit;
        private long heapSize = 0L;

        SubmittedSizeChecker(long maxHeapSizeSubmit) {
            this.maxHeapSizeSubmit = maxHeapSizeSubmit;
        }

        @Override
        public RowChecker.ReturnCode canTakeOperation(HRegionLocation loc, long rowSize) {
            if (this.heapSize >= this.maxHeapSizeSubmit) {
                return RowChecker.ReturnCode.END;
            }
            return RowChecker.ReturnCode.INCLUDE;
        }

        @Override
        public void notifyFinal(RowChecker.ReturnCode code, HRegionLocation loc, long rowSize) {
            if (code == RowChecker.ReturnCode.INCLUDE) {
                this.heapSize += rowSize;
            }
        }

        @Override
        public void reset() {
            this.heapSize = 0L;
        }
    }

    static interface RowChecker {
        public ReturnCode canTakeOperation(HRegionLocation var1, long var2);

        public void notifyFinal(ReturnCode var1, HRegionLocation var2, long var3);

        public void reset() throws InterruptedIOException;

        public static enum ReturnCode {
            INCLUDE,
            SKIP,
            END;

        }
    }

    static class RowCheckerHost {
        private final List<RowChecker> checkers;
        private boolean isEnd = false;

        RowCheckerHost(List<RowChecker> checkers) {
            this.checkers = checkers;
        }

        void reset() throws InterruptedIOException {
            this.isEnd = false;
            InterruptedIOException e = null;
            for (RowChecker checker : this.checkers) {
                try {
                    checker.reset();
                }
                catch (InterruptedIOException ex) {
                    e = ex;
                }
            }
            if (e != null) {
                throw e;
            }
        }

        RowChecker.ReturnCode canTakeOperation(HRegionLocation loc, long rowSize) {
            if (this.isEnd) {
                return RowChecker.ReturnCode.END;
            }
            RowChecker.ReturnCode code = RowChecker.ReturnCode.INCLUDE;
            for (RowChecker checker : this.checkers) {
                switch (checker.canTakeOperation(loc, rowSize)) {
                    case END: {
                        this.isEnd = true;
                        code = RowChecker.ReturnCode.END;
                        break;
                    }
                    case SKIP: {
                        code = RowChecker.ReturnCode.SKIP;
                        break;
                    }
                }
                if (code != RowChecker.ReturnCode.END) continue;
                break;
            }
            for (RowChecker checker : this.checkers) {
                checker.notifyFinal(code, loc, rowSize);
            }
            return code;
        }
    }

    private static enum Retry {
        YES,
        NO_LOCATION_PROBLEM,
        NO_NOT_RETRIABLE,
        NO_RETRIES_EXHAUSTED,
        NO_OTHER_SUCCEEDED;

    }

    protected class AsyncRequestFutureImpl<CResult>
    implements AsyncRequestFuture {
        private final Batch.Callback<CResult> callback;
        private final BatchErrors errors;
        private final ConnectionManager.ServerErrorTracker errorsByServer;
        private final ExecutorService pool;
        private final Set<PayloadCarryingServerCallable> callsInProgress;
        private final TableName tableName;
        private final AtomicLong actionsInProgress = new AtomicLong(-1L);
        private final Object replicaResultLock = new Object();
        private final Object[] results;
        private final int[] replicaGetIndices;
        private final boolean hasAnyReplicaGets;
        private final long nonceGroup;
        private PayloadCarryingServerCallable currentCallable;
        private int operationTimeout;
        private int rpcTimeout;
        private RetryingTimeTracker tracker;

        public AsyncRequestFutureImpl(TableName tableName, List<Action<Row>> actions, long nonceGroup, ExecutorService pool, boolean needResults, Object[] results, Batch.Callback<CResult> callback, PayloadCarryingServerCallable callable, int operationTimeout, int rpcTimeout) {
            this.pool = pool;
            this.callback = callback;
            this.nonceGroup = nonceGroup;
            this.tableName = tableName;
            this.actionsInProgress.set(actions.size());
            if (results != null) {
                assert (needResults);
                if (results.length != actions.size()) {
                    throw new AssertionError((Object)"results.length");
                }
                this.results = results;
                for (int i = 0; i != this.results.length; ++i) {
                    results[i] = null;
                }
            } else {
                this.results = needResults ? new Object[actions.size()] : null;
            }
            ArrayList<Integer> replicaGetIndices = null;
            boolean hasAnyReplicaGets = false;
            if (needResults) {
                boolean hasAnyNonReplicaReqs = false;
                int posInList = 0;
                for (Action<Row> action : actions) {
                    boolean isReplicaGet = AsyncProcess.isReplicaGet(action.getAction());
                    if (isReplicaGet) {
                        hasAnyReplicaGets = true;
                        if (hasAnyNonReplicaReqs) {
                            if (replicaGetIndices == null) {
                                replicaGetIndices = new ArrayList<Integer>(actions.size() - 1);
                            }
                            replicaGetIndices.add(posInList);
                        }
                    } else if (!hasAnyNonReplicaReqs) {
                        hasAnyNonReplicaReqs = true;
                        if (posInList > 0) {
                            replicaGetIndices = new ArrayList(actions.size() - 1);
                            for (int i = 0; i < posInList; ++i) {
                                replicaGetIndices.add(i);
                            }
                        }
                    }
                    ++posInList;
                }
            }
            this.hasAnyReplicaGets = hasAnyReplicaGets;
            if (replicaGetIndices != null) {
                this.replicaGetIndices = new int[replicaGetIndices.size()];
                int i = 0;
                for (Integer el : replicaGetIndices) {
                    this.replicaGetIndices[i++] = el;
                }
            } else {
                this.replicaGetIndices = null;
            }
            this.callsInProgress = !hasAnyReplicaGets ? null : Collections.newSetFromMap(new ConcurrentHashMap());
            this.errorsByServer = AsyncProcess.this.createServerErrorTracker();
            this.errors = AsyncProcess.this.globalErrors != null ? AsyncProcess.this.globalErrors : new BatchErrors();
            this.currentCallable = callable;
            this.operationTimeout = operationTimeout;
            this.rpcTimeout = rpcTimeout;
            if (callable == null) {
                this.tracker = new RetryingTimeTracker();
                this.tracker.start();
            }
        }

        public Set<PayloadCarryingServerCallable> getCallsInProgress() {
            return this.callsInProgress;
        }

        SingleServerRequestRunnable createSingleServerRequest(MultiAction<Row> multiAction, int numAttempt, ServerName server, Set<PayloadCarryingServerCallable> callsInProgress) {
            return new SingleServerRequestRunnable(multiAction, numAttempt, server, callsInProgress);
        }

        private void groupAndSendMultiAction(List<Action<Row>> currentActions, int numAttempt) {
            boolean hasUnknown;
            byte[] regionName;
            HRegionLocation loc;
            HashMap<ServerName, MultiAction<Row>> actionsByServer = new HashMap<ServerName, MultiAction<Row>>();
            boolean isReplica = false;
            ArrayList<Action<Row>> unknownReplicaActions = null;
            for (Action<Row> action : currentActions) {
                boolean bl;
                RegionLocations locs = this.findAllLocationsOrFail(action, true);
                if (locs == null) continue;
                boolean bl2 = bl = !RegionReplicaUtil.isDefaultReplica(action.getReplicaId());
                if (isReplica && !bl) {
                    throw new AssertionError((Object)"Replica and non-replica actions in the same retry");
                }
                isReplica = bl;
                loc = locs.getRegionLocation(action.getReplicaId());
                if (loc == null || loc.getServerName() == null) {
                    if (isReplica) {
                        if (unknownReplicaActions == null) {
                            unknownReplicaActions = new ArrayList<Action<Row>>();
                        }
                        unknownReplicaActions.add(action);
                        continue;
                    }
                    this.manageLocationError(action, null);
                    continue;
                }
                regionName = loc.getRegionInfo().getRegionName();
                AsyncProcess.addAction(loc.getServerName(), regionName, action, actionsByServer, this.nonceGroup);
            }
            boolean doStartReplica = numAttempt == 1 && !isReplica && this.hasAnyReplicaGets;
            boolean bl = hasUnknown = unknownReplicaActions != null && !unknownReplicaActions.isEmpty();
            if (!actionsByServer.isEmpty()) {
                this.sendMultiAction(actionsByServer, numAttempt, doStartReplica && !hasUnknown ? currentActions : null, numAttempt > 1 && !hasUnknown);
            }
            if (hasUnknown) {
                actionsByServer = new HashMap();
                for (Action action : unknownReplicaActions) {
                    loc = this.getReplicaLocationOrFail(action);
                    if (loc == null) continue;
                    regionName = loc.getRegionInfo().getRegionName();
                    AsyncProcess.addAction(loc.getServerName(), regionName, action, actionsByServer, this.nonceGroup);
                }
                if (!actionsByServer.isEmpty()) {
                    this.sendMultiAction(actionsByServer, numAttempt, doStartReplica ? currentActions : null, true);
                }
            }
        }

        private HRegionLocation getReplicaLocationOrFail(Action<Row> action) {
            int replicaId = action.getReplicaId();
            RegionLocations locs = this.findAllLocationsOrFail(action, true);
            if (locs == null) {
                return null;
            }
            HRegionLocation loc = locs.getRegionLocation(replicaId);
            if (loc == null || loc.getServerName() == null) {
                locs = this.findAllLocationsOrFail(action, false);
                if (locs == null) {
                    return null;
                }
                loc = locs.getRegionLocation(replicaId);
            }
            if (loc == null || loc.getServerName() == null) {
                this.manageLocationError(action, null);
                return null;
            }
            return loc;
        }

        private void manageLocationError(Action<Row> action, Exception ex) {
            String msg = "Cannot get replica " + action.getReplicaId() + " location for " + action.getAction();
            LOG.error((Object)msg);
            if (ex == null) {
                ex = new IOException(msg);
            }
            this.manageError(action.getOriginalIndex(), action.getAction(), Retry.NO_LOCATION_PROBLEM, ex, null);
        }

        private RegionLocations findAllLocationsOrFail(Action<Row> action, boolean useCache) {
            if (action.getAction() == null) {
                throw new IllegalArgumentException("#" + AsyncProcess.this.id + ", row cannot be null");
            }
            RegionLocations loc = null;
            try {
                loc = AsyncProcess.this.connection.locateRegion(this.tableName, action.getAction().getRow(), useCache, true, action.getReplicaId());
            }
            catch (IOException ex) {
                this.manageLocationError(action, ex);
            }
            return loc;
        }

        private void sendMultiAction(Map<ServerName, MultiAction<Row>> actionsByServer, int numAttempt, List<Action<Row>> actionsForReplicaThread, boolean reuseThread) {
            int actionsRemaining = actionsByServer.size();
            for (Map.Entry<ServerName, MultiAction<Row>> e : actionsByServer.entrySet()) {
                MultiAction<Row> multiAction;
                ServerName server = e.getKey();
                Collection<Runnable> runnables = this.getNewMultiActionRunnable(server, multiAction = e.getValue(), numAttempt);
                if (runnables.size() > actionsRemaining) {
                    actionsRemaining = runnables.size();
                }
                for (Runnable runnable : runnables) {
                    if (--actionsRemaining == 0 && reuseThread && numAttempt % 31 != 0) {
                        runnable.run();
                        continue;
                    }
                    try {
                        this.pool.submit(runnable);
                    }
                    catch (Throwable t) {
                        if (t instanceof RejectedExecutionException) {
                            LOG.warn((Object)("#" + AsyncProcess.this.id + ", the task was rejected by the pool. This is unexpected." + " Server is " + server.getServerName()), t);
                        } else {
                            LOG.warn((Object)"Caught unexpected exception/error: ", t);
                        }
                        AsyncProcess.this.decTaskCounters(multiAction.getRegions(), server);
                        this.receiveGlobalFailure(multiAction, server, numAttempt, t);
                    }
                }
            }
            if (actionsForReplicaThread != null) {
                this.startWaitingForReplicaCalls(actionsForReplicaThread);
            }
        }

        private Collection<? extends Runnable> getNewMultiActionRunnable(ServerName server, MultiAction<Row> multiAction, int numAttempt) {
            if (AsyncProcess.this.connection.getStatisticsTracker() == null) {
                if (AsyncProcess.this.connection.getConnectionMetrics() != null) {
                    AsyncProcess.this.connection.getConnectionMetrics().incrNormalRunners();
                }
                AsyncProcess.this.incTaskCounters(multiAction.getRegions(), server);
                SingleServerRequestRunnable runnable = this.createSingleServerRequest(multiAction, numAttempt, server, this.callsInProgress);
                return Collections.singletonList(Trace.wrap((String)"AsyncProcess.sendMultiAction", (Runnable)runnable));
            }
            HashMap actions = new HashMap(multiAction.size());
            for (Map.Entry entry : multiAction.actions.entrySet()) {
                Long backoff = this.getBackoff(server, entry.getKey());
                DelayingRunner runner = (DelayingRunner)actions.get(backoff);
                if (runner == null) {
                    actions.put(backoff, new DelayingRunner(backoff, entry));
                    continue;
                }
                runner.add(entry);
            }
            ArrayList<SingleServerRequestRunnable> toReturn = new ArrayList<SingleServerRequestRunnable>(actions.size());
            for (DelayingRunner runner : actions.values()) {
                AsyncProcess.this.incTaskCounters(runner.getActions().getRegions(), server);
                String traceText = "AsyncProcess.sendMultiAction";
                Runnable runnable = this.createSingleServerRequest(runner.getActions(), numAttempt, server, this.callsInProgress);
                if (runner.getSleepTime() > 0L) {
                    runner.setRunner(runnable);
                    traceText = "AsyncProcess.clientBackoff.sendMultiAction";
                    runnable = runner;
                    if (AsyncProcess.this.connection.getConnectionMetrics() != null) {
                        AsyncProcess.this.connection.getConnectionMetrics().incrDelayRunners();
                        AsyncProcess.this.connection.getConnectionMetrics().updateDelayInterval(runner.getSleepTime());
                    }
                } else if (AsyncProcess.this.connection.getConnectionMetrics() != null) {
                    AsyncProcess.this.connection.getConnectionMetrics().incrNormalRunners();
                }
                runnable = Trace.wrap((String)traceText, (Runnable)runnable);
                toReturn.add((SingleServerRequestRunnable)runnable);
            }
            return toReturn;
        }

        private Long getBackoff(ServerName server, byte[] regionName) {
            ServerStatisticTracker tracker = AsyncProcess.this.connection.getStatisticsTracker();
            ServerStatistics stats = tracker.getStats(server);
            return AsyncProcess.this.connection.getBackoffPolicy().getBackoffTime(server, regionName, stats);
        }

        private void startWaitingForReplicaCalls(List<Action<Row>> actionsForReplicaThread) {
            long startTime = EnvironmentEdgeManager.currentTime();
            ReplicaCallIssuingRunnable replicaRunnable = new ReplicaCallIssuingRunnable(actionsForReplicaThread, startTime);
            if (AsyncProcess.this.primaryCallTimeoutMicroseconds == 0L) {
                replicaRunnable.run();
            } else {
                try {
                    this.pool.submit(replicaRunnable);
                }
                catch (RejectedExecutionException ree) {
                    LOG.warn((Object)("#" + AsyncProcess.this.id + ", replica task was rejected by the pool - no replica calls"), (Throwable)ree);
                }
            }
        }

        public Retry manageError(int originalIndex, Row row, Retry canRetry, Throwable throwable, ServerName server) {
            if (canRetry == Retry.YES && throwable != null && (throwable instanceof DoNotRetryIOException || throwable instanceof NeedUnmanagedConnectionException)) {
                canRetry = Retry.NO_NOT_RETRIABLE;
            }
            if (canRetry != Retry.YES) {
                this.setError(originalIndex, row, throwable, server);
            } else if (this.isActionComplete(originalIndex, row)) {
                canRetry = Retry.NO_OTHER_SUCCEEDED;
            }
            return canRetry;
        }

        private void receiveGlobalFailure(MultiAction<Row> rsActions, ServerName server, int numAttempt, Throwable t) {
            Retry canRetry;
            this.errorsByServer.reportServerError(server);
            Retry retry = canRetry = this.errorsByServer.canRetryMore(numAttempt) ? Retry.YES : Retry.NO_RETRIES_EXHAUSTED;
            if (this.tableName == null && ClientExceptionsUtil.isMetaClearingException(t)) {
                AsyncProcess.this.connection.clearCaches(server);
            }
            int failed = 0;
            int stopped = 0;
            ArrayList<Action<Row>> toReplay = new ArrayList<Action<Row>>();
            for (Map.Entry e : rsActions.actions.entrySet()) {
                byte[] regionName = e.getKey();
                byte[] row = e.getValue().iterator().next().getAction().getRow();
                try {
                    if (this.tableName != null) {
                        AsyncProcess.this.connection.updateCachedLocations(this.tableName, regionName, row, ClientExceptionsUtil.isMetaClearingException(t) ? null : t, server);
                    }
                }
                catch (Throwable ex) {
                    LOG.error((Object)("Couldn't update cached region locations: " + ex));
                }
                for (Action action : e.getValue()) {
                    Retry retry2 = this.manageError(action.getOriginalIndex(), action.getAction(), canRetry, t, server);
                    if (retry2 == Retry.YES) {
                        toReplay.add(action);
                        continue;
                    }
                    if (retry2 == Retry.NO_OTHER_SUCCEEDED) {
                        ++stopped;
                        continue;
                    }
                    ++failed;
                }
            }
            if (toReplay.isEmpty()) {
                this.logNoResubmit(server, numAttempt, rsActions.size(), t, failed, stopped);
            } else {
                this.resubmit(server, toReplay, numAttempt, rsActions.size(), t);
            }
        }

        private void resubmit(ServerName oldServer, List<Action<Row>> toReplay, int numAttempt, int failureCount, Throwable throwable) {
            int nextAttemptNumber;
            boolean retryImmediately = throwable instanceof RetryImmediatelyException;
            int n = nextAttemptNumber = retryImmediately ? numAttempt : numAttempt + 1;
            long backOffTime = retryImmediately ? 0L : (throwable instanceof CallQueueTooBigException ? this.errorsByServer.calculateBackoffTime(oldServer, AsyncProcess.this.pauseForCQTBE) : this.errorsByServer.calculateBackoffTime(oldServer, AsyncProcess.this.pause));
            if (numAttempt > AsyncProcess.this.startLogErrorsCnt) {
                LOG.info((Object)this.createLog(numAttempt, failureCount, toReplay.size(), oldServer, throwable, backOffTime, true, null, -1, -1));
            }
            try {
                if (backOffTime > 0L) {
                    Thread.sleep(backOffTime);
                }
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("#" + AsyncProcess.this.id + ", not sent: " + toReplay.size() + " operations, " + oldServer), (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
            this.groupAndSendMultiAction(toReplay, nextAttemptNumber);
        }

        private void logNoResubmit(ServerName oldServer, int numAttempt, int failureCount, Throwable throwable, int failed, int stopped) {
            if (failureCount != 0 || numAttempt > AsyncProcess.this.startLogErrorsCnt + 1) {
                String timeStr = new Date(this.errorsByServer.getStartTrackingTime()).toString();
                String logMessage = this.createLog(numAttempt, failureCount, 0, oldServer, throwable, -1L, false, timeStr, failed, stopped);
                if (failed != 0) {
                    LOG.warn((Object)logMessage);
                } else {
                    LOG.info((Object)logMessage);
                }
            }
        }

        long getActionsInProgress() {
            return this.actionsInProgress.get();
        }

        private void receiveMultiAction(MultiAction<Row> multiAction, ServerName server, MultiResponse responses, int numAttempt) {
            assert (responses != null);
            ArrayList<Action<Row>> toReplay = new ArrayList<Action<Row>>();
            Throwable throwable = null;
            int failureCount = 0;
            Retry retry = null;
            Map<byte[], MultiResponse.RegionResult> results = responses.getResults();
            AsyncProcess.this.updateStats(server, results);
            int failed = 0;
            int stopped = 0;
            for (Map.Entry regionEntry : multiAction.actions.entrySet()) {
                byte[] regionName = regionEntry.getKey();
                Throwable regionException = responses.getExceptions().get(regionName);
                if (this.tableName == null && regionException != null && ClientExceptionsUtil.isMetaClearingException(regionException)) {
                    AsyncProcess.this.connection.clearCaches(server);
                }
                Map<Object, Object> regionResults = results.containsKey(regionName) ? results.get((Object)regionName).result : Collections.emptyMap();
                boolean regionFailureRegistered = false;
                for (Action<Row> action : regionEntry.getValue()) {
                    Object result = regionResults.get(action.getOriginalIndex());
                    if (result == null) {
                        if (regionException == null) {
                            LOG.error((Object)("Server sent us neither results nor exceptions for " + Bytes.toStringBinary(regionName) + ", numAttempt:" + numAttempt));
                            regionException = new RuntimeException("Invalid response");
                        }
                        result = regionException;
                    }
                    if (result instanceof Throwable) {
                        Row row = action.getAction();
                        Throwable throwable2 = throwable = regionException != null ? regionException : ClientExceptionsUtil.findException(result);
                        if (!regionFailureRegistered) {
                            regionFailureRegistered = true;
                            try {
                                AsyncProcess.this.connection.updateCachedLocations(this.tableName, regionName, row.getRow(), result, server);
                            }
                            catch (Throwable ex) {
                                LOG.error((Object)("Couldn't update cached region locations: " + ex));
                            }
                        }
                        if (retry == null) {
                            this.errorsByServer.reportServerError(server);
                            retry = this.errorsByServer.canRetryMore(numAttempt) ? Retry.YES : Retry.NO_RETRIES_EXHAUSTED;
                        }
                        ++failureCount;
                        switch (this.manageError(action.getOriginalIndex(), row, retry, (Throwable)result, server)) {
                            case YES: {
                                toReplay.add(action);
                                break;
                            }
                            case NO_OTHER_SUCCEEDED: {
                                ++stopped;
                                break;
                            }
                            default: {
                                ++failed;
                                break;
                            }
                        }
                        continue;
                    }
                    if (this.callback != null) {
                        try {
                            this.callback.update(regionName, action.getAction().getRow(), result);
                        }
                        catch (Throwable t) {
                            LOG.error((Object)("User callback threw an exception for " + Bytes.toStringBinary(regionName) + ", ignoring"), t);
                        }
                    }
                    this.setResult(action, result);
                }
            }
            if (toReplay.isEmpty()) {
                this.logNoResubmit(server, numAttempt, failureCount, throwable, failed, stopped);
            } else {
                this.resubmit(server, toReplay, numAttempt, failureCount, throwable);
            }
        }

        private String createLog(int numAttempt, int failureCount, int replaySize, ServerName sn, Throwable error, long backOffTime, boolean willRetry, String startTime, int failed, int stopped) {
            StringBuilder sb = new StringBuilder();
            sb.append("#").append(AsyncProcess.this.id).append(", table=").append(this.tableName).append(", ").append("attempt=").append(numAttempt).append("/").append(AsyncProcess.this.numTries).append(" ");
            if (failureCount > 0 || error != null) {
                sb.append("failed=").append(failureCount).append("ops").append(", last exception: ").append(error == null ? "null" : error);
            } else {
                sb.append("succeeded");
            }
            sb.append(" on ").append(sn).append(", tracking started ").append(startTime);
            if (willRetry) {
                sb.append(", retrying after=").append(backOffTime).append("ms").append(", replay=").append(replaySize).append("ops");
            } else if (failureCount > 0) {
                if (stopped > 0) {
                    sb.append("; not retrying ").append(stopped).append(" due to success from other replica");
                }
                if (failed > 0) {
                    sb.append("; not retrying ").append(failed).append(" - final failure");
                }
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setResult(Action<Row> action, Object result) {
            if (result == null) {
                throw new RuntimeException("Result cannot be null");
            }
            ReplicaResultState state = null;
            boolean isStale = !RegionReplicaUtil.isDefaultReplica(action.getReplicaId());
            int index = action.getOriginalIndex();
            if (this.results == null) {
                this.decActionCounter(index);
                return;
            }
            state = this.trySetResultSimple(index, action.getAction(), false, result, null, isStale);
            if (state == null) {
                return;
            }
            assert (state != null);
            Object object = state;
            synchronized (object) {
                if (state.callCount == 0) {
                    return;
                }
                state.callCount = 0;
            }
            object = this.replicaResultLock;
            synchronized (object) {
                if (this.results[index] != state) {
                    throw new AssertionError((Object)"We set the callCount but someone else replaced the result");
                }
                this.results[index] = result;
            }
            this.decActionCounter(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setError(int index, Row row, Throwable throwable, ServerName server) {
            ReplicaResultState state = null;
            if (this.results == null) {
                this.errors.add(throwable, row, server);
                this.decActionCounter(index);
                return;
            }
            state = this.trySetResultSimple(index, row, true, throwable, server, false);
            if (state == null) {
                return;
            }
            assert (state != null);
            BatchErrors target = null;
            boolean isActionDone = false;
            Object object = state;
            synchronized (object) {
                switch (state.callCount) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        target = this.errors;
                        isActionDone = true;
                        break;
                    }
                    default: {
                        assert (state.callCount > 1);
                        if (state.replicaErrors == null) {
                            state.replicaErrors = new BatchErrors();
                        }
                        target = state.replicaErrors;
                    }
                }
                --state.callCount;
            }
            target.add(throwable, row, server);
            if (isActionDone) {
                if (state.replicaErrors != null) {
                    this.errors.merge(state.replicaErrors);
                }
                object = this.replicaResultLock;
                synchronized (object) {
                    if (this.results[index] != state) {
                        throw new AssertionError((Object)"We set the callCount but someone else replaced the result");
                    }
                    this.results[index] = throwable;
                }
                this.decActionCounter(index);
            }
        }

        private boolean isActionComplete(int index, Row row) {
            if (!AsyncProcess.isReplicaGet(row)) {
                return false;
            }
            Object resObj = this.results[index];
            return resObj != null && (!(resObj instanceof ReplicaResultState) || ((ReplicaResultState)resObj).callCount == 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ReplicaResultState trySetResultSimple(int index, Row row, boolean isError, Object result, ServerName server, boolean isFromReplica) {
            ReplicaResultState rrs;
            Object resObj = null;
            if (!AsyncProcess.isReplicaGet(row)) {
                if (isFromReplica) {
                    throw new AssertionError((Object)("Unexpected stale result for " + row));
                }
                this.results[index] = result;
            } else {
                Object object = this.replicaResultLock;
                synchronized (object) {
                    resObj = this.results[index];
                    if (resObj == null) {
                        if (isFromReplica) {
                            throw new AssertionError((Object)("Unexpected stale result for " + row));
                        }
                        this.results[index] = result;
                    }
                }
            }
            ReplicaResultState replicaResultState = rrs = resObj instanceof ReplicaResultState ? (ReplicaResultState)resObj : null;
            if (rrs == null && isError) {
                this.errors.add((Throwable)result, row, server);
            }
            if (resObj == null) {
                this.decActionCounter(index);
                return null;
            }
            return rrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decActionCounter(int index) {
            long actionsRemaining = this.actionsInProgress.decrementAndGet();
            if (actionsRemaining < 0L) {
                String error = this.buildDetailedErrorMsg("Incorrect actions in progress", index);
                throw new AssertionError((Object)error);
            }
            if (actionsRemaining == 0L) {
                AtomicLong atomicLong = this.actionsInProgress;
                synchronized (atomicLong) {
                    this.actionsInProgress.notifyAll();
                }
            }
        }

        private String buildDetailedErrorMsg(String string, int index) {
            int i;
            StringBuilder error = new StringBuilder(string);
            error.append("; called for ").append(index).append(", actionsInProgress ").append(this.actionsInProgress.get()).append("; replica gets: ");
            if (this.replicaGetIndices != null) {
                for (i = 0; i < this.replicaGetIndices.length; ++i) {
                    error.append(this.replicaGetIndices[i]).append(", ");
                }
            } else {
                error.append(this.hasAnyReplicaGets ? "all" : "none");
            }
            error.append("; results ");
            if (this.results != null) {
                for (i = 0; i < this.results.length; ++i) {
                    Object o = this.results[i];
                    error.append(o == null ? "null" : o.toString()).append(", ");
                }
            }
            return error.toString();
        }

        @Override
        public void waitUntilDone() throws InterruptedIOException {
            try {
                this.waitUntilDone(Long.MAX_VALUE);
            }
            catch (InterruptedException iex) {
                throw new InterruptedIOException(iex.getMessage());
            }
            finally {
                if (this.callsInProgress != null) {
                    for (PayloadCarryingServerCallable clb : this.callsInProgress) {
                        clb.cancel();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitUntilDone(long cutoff) throws InterruptedException {
            long currentInProgress;
            boolean hasWait = cutoff != Long.MAX_VALUE;
            long lastLog = EnvironmentEdgeManager.currentTime();
            while (0L != (currentInProgress = this.actionsInProgress.get())) {
                long now = EnvironmentEdgeManager.currentTime();
                if (hasWait && now * 1000L > cutoff) {
                    return false;
                }
                if (!hasWait && now > lastLog + 10000L) {
                    lastLog = now;
                    LOG.info((Object)("#" + AsyncProcess.this.id + ", waiting for " + currentInProgress + "  actions to finish on table: " + this.tableName));
                    if (currentInProgress <= (long)AsyncProcess.this.thresholdToLogUndoneTaskDetails) {
                        AsyncProcess.this.logDetailsOfUndoneTasks(currentInProgress);
                    }
                }
                AtomicLong atomicLong = this.actionsInProgress;
                synchronized (atomicLong) {
                    if (this.actionsInProgress.get() == 0L) {
                        break;
                    }
                    if (!hasWait) {
                        this.actionsInProgress.wait(10L);
                    } else {
                        long waitMicroSecond = Math.min(100000L, cutoff - now * 1000L);
                        TimeUnit.MICROSECONDS.timedWait(this.actionsInProgress, waitMicroSecond);
                    }
                }
            }
            return true;
        }

        @Override
        public boolean hasError() {
            return this.errors.hasErrors();
        }

        @Override
        public List<? extends Row> getFailedOperations() {
            return this.errors.actions;
        }

        @Override
        public RetriesExhaustedWithDetailsException getErrors() {
            return this.errors.makeException(AsyncProcess.this.logBatchErrorDetails);
        }

        @Override
        public Object[] getResults() throws InterruptedIOException {
            this.waitUntilDone();
            return this.results;
        }

        protected MultiServerCallable<Row> createCallable(ServerName server, TableName tableName, MultiAction<Row> multi) {
            return new MultiServerCallable<Row>(AsyncProcess.this.connection, tableName, server, AsyncProcess.this.rpcFactory, multi, this.rpcTimeout, this.tracker, multi.getPriority());
        }

        class SingleServerRequestRunnable
        implements Runnable {
            private final MultiAction<Row> multiAction;
            private final int numAttempt;
            private final ServerName server;
            private final Set<PayloadCarryingServerCallable> callsInProgress;

            SingleServerRequestRunnable(MultiAction<Row> multiAction, int numAttempt, ServerName server, Set<PayloadCarryingServerCallable> callsInProgress) {
                this.multiAction = multiAction;
                this.numAttempt = numAttempt;
                this.server = server;
                this.callsInProgress = callsInProgress;
            }

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                block16: {
                    MultiResponse res = null;
                    MultiServerCallable<Row> callable = AsyncRequestFutureImpl.this.currentCallable;
                    try {
                        if (callable == null) {
                            callable = AsyncRequestFutureImpl.this.createCallable(this.server, AsyncRequestFutureImpl.this.tableName, this.multiAction);
                        }
                        RpcRetryingCaller<MultiResponse> caller = AsyncProcess.this.createCaller(callable, AsyncRequestFutureImpl.this.rpcTimeout);
                        try {
                            if (this.callsInProgress != null) {
                                this.callsInProgress.add(callable);
                            }
                            if ((res = caller.callWithoutRetries(callable, AsyncRequestFutureImpl.this.operationTimeout)) == null) {
                                return;
                            }
                        }
                        catch (IOException e) {
                            AsyncRequestFutureImpl.this.receiveGlobalFailure(this.multiAction, this.server, this.numAttempt, e);
                            return;
                        }
                        catch (Throwable t) {
                            block15: {
                                LOG.error((Object)("#" + AsyncProcess.this.id + ", Caught throwable while calling. This is unexpected." + " Retrying. Server is " + this.server + ", tableName=" + AsyncRequestFutureImpl.this.tableName), t);
                                AsyncRequestFutureImpl.this.receiveGlobalFailure(this.multiAction, this.server, this.numAttempt, t);
                                AsyncProcess.this.decTaskCounters(this.multiAction.getRegions(), this.server);
                                if (this.callsInProgress == null || callable == null || res == null) break block15;
                                this.callsInProgress.remove(callable);
                            }
                            return;
                        }
                        AsyncRequestFutureImpl.this.receiveMultiAction(this.multiAction, this.server, res, this.numAttempt);
                        break block16;
                        {
                            catch (Throwable t) {
                                LOG.error((Object)("Internal AsyncProcess #" + AsyncProcess.this.id + " error for " + AsyncRequestFutureImpl.this.tableName + " processing for " + this.server), t);
                                throw new RuntimeException(t);
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        AsyncProcess.this.decTaskCounters(this.multiAction.getRegions(), this.server);
                        if (this.callsInProgress != null && callable != null && res != null) {
                            this.callsInProgress.remove(callable);
                        }
                    }
                }
            }
        }

        private final class ReplicaCallIssuingRunnable
        implements Runnable {
            private final long startTime;
            private final List<Action<Row>> initialActions;

            public ReplicaCallIssuingRunnable(List<Action<Row>> initialActions, long startTime) {
                this.initialActions = initialActions;
                this.startTime = startTime;
            }

            @Override
            public void run() {
                boolean done = false;
                if (AsyncProcess.this.primaryCallTimeoutMicroseconds > 0L) {
                    try {
                        done = AsyncRequestFutureImpl.this.waitUntilDone(this.startTime * 1000L + AsyncProcess.this.primaryCallTimeoutMicroseconds);
                    }
                    catch (InterruptedException ex) {
                        LOG.error((Object)("Replica thread was interrupted - no replica calls: " + ex.getMessage()));
                        return;
                    }
                }
                if (done) {
                    return;
                }
                HashMap<ServerName, MultiAction<Row>> actionsByServer = new HashMap<ServerName, MultiAction<Row>>();
                ArrayList<Action<Row>> unknownLocActions = new ArrayList<Action<Row>>();
                if (AsyncRequestFutureImpl.this.replicaGetIndices == null) {
                    for (int i = 0; i < AsyncRequestFutureImpl.this.results.length; ++i) {
                        this.addReplicaActions(i, actionsByServer, unknownLocActions);
                    }
                } else {
                    for (int replicaGetIndice : AsyncRequestFutureImpl.this.replicaGetIndices) {
                        this.addReplicaActions(replicaGetIndice, actionsByServer, unknownLocActions);
                    }
                }
                if (!actionsByServer.isEmpty()) {
                    AsyncRequestFutureImpl.this.sendMultiAction(actionsByServer, 1, null, unknownLocActions.isEmpty());
                }
                if (!unknownLocActions.isEmpty()) {
                    actionsByServer = new HashMap();
                    for (Action action : unknownLocActions) {
                        this.addReplicaActionsAgain(action, actionsByServer);
                    }
                    if (!actionsByServer.isEmpty()) {
                        AsyncRequestFutureImpl.this.sendMultiAction(actionsByServer, 1, null, true);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void addReplicaActions(int index, Map<ServerName, MultiAction<Row>> actionsByServer, List<Action<Row>> unknownReplicaActions) {
                if (AsyncRequestFutureImpl.this.results[index] != null) {
                    return;
                }
                Action<Row> action = this.initialActions.get(index);
                RegionLocations loc = AsyncRequestFutureImpl.this.findAllLocationsOrFail(action, true);
                if (loc == null) {
                    return;
                }
                HRegionLocation[] locs = loc.getRegionLocations();
                if (locs.length == 1) {
                    LOG.warn((Object)("No replicas found for " + action.getAction()));
                    return;
                }
                Object object = AsyncRequestFutureImpl.this.replicaResultLock;
                synchronized (object) {
                    if (AsyncRequestFutureImpl.this.results[index] != null) {
                        return;
                    }
                    ((AsyncRequestFutureImpl)AsyncRequestFutureImpl.this).results[index] = new ReplicaResultState(locs.length);
                }
                for (int i = 1; i < locs.length; ++i) {
                    Action<Row> replicaAction = new Action<Row>(action, i);
                    if (locs[i] != null) {
                        AsyncProcess.addAction(locs[i].getServerName(), locs[i].getRegionInfo().getRegionName(), replicaAction, actionsByServer, AsyncRequestFutureImpl.this.nonceGroup);
                        continue;
                    }
                    unknownReplicaActions.add(replicaAction);
                }
            }

            private void addReplicaActionsAgain(Action<Row> action, Map<ServerName, MultiAction<Row>> actionsByServer) {
                if (action.getReplicaId() == 0) {
                    throw new AssertionError((Object)"Cannot have default replica here");
                }
                HRegionLocation loc = AsyncRequestFutureImpl.this.getReplicaLocationOrFail(action);
                if (loc == null) {
                    return;
                }
                AsyncProcess.addAction(loc.getServerName(), loc.getRegionInfo().getRegionName(), action, actionsByServer, AsyncRequestFutureImpl.this.nonceGroup);
            }
        }
    }

    protected static class BatchErrors {
        private final List<Throwable> throwables = new ArrayList<Throwable>();
        private final List<Row> actions = new ArrayList<Row>();
        private final List<String> addresses = new ArrayList<String>();

        protected BatchErrors() {
        }

        public synchronized void add(Throwable ex, Row row, ServerName serverName) {
            if (row == null) {
                throw new IllegalArgumentException("row cannot be null. location=" + serverName);
            }
            this.throwables.add(ex);
            this.actions.add(row);
            this.addresses.add(serverName != null ? serverName.toString() : "null");
        }

        public boolean hasErrors() {
            return !this.throwables.isEmpty();
        }

        private synchronized RetriesExhaustedWithDetailsException makeException(boolean logDetails) {
            if (logDetails) {
                LOG.error((Object)("Exception occurred! Exception details: " + this.throwables + ";\nActions: " + this.actions));
            }
            return new RetriesExhaustedWithDetailsException(new ArrayList<Throwable>(this.throwables), new ArrayList<Row>(this.actions), new ArrayList<String>(this.addresses));
        }

        public synchronized void clear() {
            this.throwables.clear();
            this.actions.clear();
            this.addresses.clear();
        }

        public synchronized void merge(BatchErrors other) {
            this.throwables.addAll(other.throwables);
            this.actions.addAll(other.actions);
            this.addresses.addAll(other.addresses);
        }
    }

    private static class ReplicaResultState {
        int callCount;
        BatchErrors replicaErrors = null;

        public ReplicaResultState(int callCount) {
            this.callCount = callCount;
        }

        public String toString() {
            return "[call count " + this.callCount + "; errors " + this.replicaErrors + "]";
        }
    }

    public static interface AsyncRequestFuture {
        public boolean hasError();

        public RetriesExhaustedWithDetailsException getErrors();

        public List<? extends Row> getFailedOperations();

        public Object[] getResults() throws InterruptedIOException;

        public void waitUntilDone() throws InterruptedIOException;
    }
}

