/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RowFilter
extends CompareFilter {
    private boolean filterOutRow = false;

    public RowFilter(CompareFilter.CompareOp rowCompareOp, ByteArrayComparable rowComparator) {
        super(rowCompareOp, rowComparator);
    }

    @Override
    public void reset() {
        this.filterOutRow = false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        if (this.filterOutRow) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public boolean filterRowKey(byte[] data, int offset, int length) {
        if (this.doCompare(this.compareOp, this.comparator, data, offset, length)) {
            this.filterOutRow = true;
        }
        return this.filterOutRow;
    }

    @Override
    public boolean filterRow() {
        return this.filterOutRow;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        ArrayList<Object> arguments = CompareFilter.extractArguments(filterArguments);
        CompareFilter.CompareOp compareOp = (CompareFilter.CompareOp)((Object)arguments.get(0));
        ByteArrayComparable comparator = (ByteArrayComparable)arguments.get(1);
        return new RowFilter(compareOp, comparator);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.RowFilter.Builder builder = FilterProtos.RowFilter.newBuilder();
        builder.setCompareFilter(super.convert());
        return builder.build().toByteArray();
    }

    public static RowFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.RowFilter proto;
        try {
            proto = FilterProtos.RowFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        CompareFilter.CompareOp valueCompareOp = CompareFilter.CompareOp.valueOf(proto.getCompareFilter().getCompareOp().name());
        ByteArrayComparable valueComparator = null;
        try {
            if (proto.getCompareFilter().hasComparator()) {
                valueComparator = ProtobufUtil.toComparator(proto.getCompareFilter().getComparator());
            }
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
        return new RowFilter(valueCompareOp, valueComparator);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RowFilter)) {
            return false;
        }
        return super.areSerializedFieldsEqual(o);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

