/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.avro.reflect;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.shaded.com.thoughtworks.paranamer.CachingParanamer;
import org.apache.hadoop.hbase.shaded.com.thoughtworks.paranamer.Paranamer;
import org.apache.hadoop.hbase.shaded.org.apache.avro.AvroRemoteException;
import org.apache.hadoop.hbase.shaded.org.apache.avro.AvroRuntimeException;
import org.apache.hadoop.hbase.shaded.org.apache.avro.AvroTypeException;
import org.apache.hadoop.hbase.shaded.org.apache.avro.Protocol;
import org.apache.hadoop.hbase.shaded.org.apache.avro.Schema;
import org.apache.hadoop.hbase.shaded.org.apache.avro.generic.GenericContainer;
import org.apache.hadoop.hbase.shaded.org.apache.avro.generic.GenericFixed;
import org.apache.hadoop.hbase.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.hbase.shaded.org.apache.avro.io.BinaryData;
import org.apache.hadoop.hbase.shaded.org.apache.avro.io.DatumReader;
import org.apache.hadoop.hbase.shaded.org.apache.avro.io.DatumWriter;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.AvroAlias;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.AvroDefault;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.AvroEncode;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.AvroIgnore;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.AvroMeta;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.AvroName;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.AvroSchema;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.FieldAccessor;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.Nullable;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.ReflectDatumReader;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.ReflectionUtil;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.Stringable;
import org.apache.hadoop.hbase.shaded.org.apache.avro.reflect.Union;
import org.apache.hadoop.hbase.shaded.org.apache.avro.specific.FixedSize;
import org.apache.hadoop.hbase.shaded.org.apache.avro.specific.SpecificData;
import org.apache.hadoop.hbase.shaded.org.apache.avro.util.ClassUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;

public class ReflectData
extends SpecificData {
    private static final ReflectData INSTANCE = new ReflectData();
    static final ConcurrentHashMap<Class<?>, ClassAccessorData> ACCESSOR_CACHE = new ConcurrentHashMap();
    @Deprecated
    static final String CLASS_PROP = "java-class";
    @Deprecated
    static final String KEY_CLASS_PROP = "java-key-class";
    @Deprecated
    static final String ELEMENT_PROP = "java-element-class";
    private static final Map<String, Class> CLASS_CACHE = new ConcurrentHashMap<String, Class>();
    private static final Class BYTES_CLASS = new byte[0].getClass();
    private static final IdentityHashMap<Class, Class> ARRAY_CLASSES = new IdentityHashMap();
    private static final Schema THROWABLE_MESSAGE;
    private static final Map<Class<?>, Field[]> FIELDS_CACHE;
    private final Paranamer paranamer = new CachingParanamer();

    public ReflectData() {
    }

    public ReflectData(ClassLoader classLoader) {
        super(classLoader);
    }

    public static ReflectData get() {
        return INSTANCE;
    }

    public ReflectData addStringable(Class c) {
        this.stringableClasses.add(c);
        return this;
    }

    @Override
    public DatumReader createDatumReader(Schema schema) {
        return new ReflectDatumReader(schema, schema, this);
    }

    @Override
    public DatumReader createDatumReader(Schema writer, Schema reader) {
        return new ReflectDatumReader(writer, reader, this);
    }

    @Override
    public DatumWriter createDatumWriter(Schema schema) {
        return new ReflectDatumWriter(schema, this);
    }

    @Override
    public void setField(Object record, String name, int position, Object o) {
        this.setField(record, name, position, o, null);
    }

    @Override
    protected void setField(Object record, String name, int pos, Object o, Object state) {
        if (record instanceof IndexedRecord) {
            super.setField(record, name, pos, o);
            return;
        }
        try {
            this.getAccessorForField(record, name, pos, state).set(record, o);
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException(e);
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    public Object getField(Object record, String name, int position) {
        return this.getField(record, name, position, null);
    }

    @Override
    protected Object getField(Object record, String name, int pos, Object state) {
        if (record instanceof IndexedRecord) {
            return super.getField(record, name, pos);
        }
        try {
            return this.getAccessorForField(record, name, pos, state).get(record);
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException(e);
        }
    }

    private FieldAccessor getAccessorForField(Object record, String name, int pos, Object optionalState) {
        if (optionalState != null) {
            return ((FieldAccessor[])optionalState)[pos];
        }
        return this.getFieldAccessor(record.getClass(), name);
    }

    @Override
    protected boolean isRecord(Object datum) {
        if (datum == null) {
            return false;
        }
        if (super.isRecord(datum)) {
            return true;
        }
        if (datum instanceof Collection) {
            return false;
        }
        if (datum instanceof Map) {
            return false;
        }
        if (datum instanceof GenericFixed) {
            return false;
        }
        return this.getSchema(datum.getClass()).getType() == Schema.Type.RECORD;
    }

    @Override
    protected boolean isArray(Object datum) {
        if (datum == null) {
            return false;
        }
        return datum instanceof Collection || datum.getClass().isArray();
    }

    @Override
    protected boolean isBytes(Object datum) {
        if (datum == null) {
            return false;
        }
        if (super.isBytes(datum)) {
            return true;
        }
        Class<?> c = datum.getClass();
        return c.isArray() && c.getComponentType() == Byte.TYPE;
    }

    @Override
    protected Schema getRecordSchema(Object record) {
        if (record instanceof GenericContainer) {
            return super.getRecordSchema(record);
        }
        return this.getSchema(record.getClass());
    }

    @Override
    public boolean validate(Schema schema, Object datum) {
        switch (schema.getType()) {
            case ARRAY: {
                if (!datum.getClass().isArray()) {
                    return super.validate(schema, datum);
                }
                int length = Array.getLength(datum);
                for (int i = 0; i < length; ++i) {
                    if (this.validate(schema.getElementType(), Array.get(datum, i))) continue;
                    return false;
                }
                return true;
            }
        }
        return super.validate(schema, datum);
    }

    private ClassAccessorData getClassAccessorData(Class<?> c) {
        ClassAccessorData newData;
        ClassAccessorData data = ACCESSOR_CACHE.get(c);
        if (data == null && !IndexedRecord.class.isAssignableFrom(c) && null == (data = ACCESSOR_CACHE.putIfAbsent(c, newData = new ClassAccessorData(c)))) {
            data = newData;
        }
        return data;
    }

    private FieldAccessor[] getFieldAccessors(Class<?> c, Schema s) {
        ClassAccessorData data = this.getClassAccessorData(c);
        if (data != null) {
            return data.getAccessorsFor(s);
        }
        return null;
    }

    private FieldAccessor getFieldAccessor(Class<?> c, String fieldName) {
        ClassAccessorData data = this.getClassAccessorData(c);
        if (data != null) {
            return data.getAccessorFor(fieldName);
        }
        return null;
    }

    static Class getClassProp(Schema schema, String prop) {
        String name = schema.getProp(prop);
        if (name == null) {
            return null;
        }
        Class<?> c = CLASS_CACHE.get(name);
        if (c != null) {
            return c;
        }
        try {
            c = ClassUtils.forName(name);
            CLASS_CACHE.put(name, c);
        }
        catch (ClassNotFoundException e) {
            throw new AvroRuntimeException(e);
        }
        return c;
    }

    @Override
    public Class getClass(Schema schema) {
        switch (schema.getType()) {
            case ARRAY: {
                Class collectionClass = ReflectData.getClassProp(schema, CLASS_PROP);
                if (collectionClass != null) {
                    return collectionClass;
                }
                Class elementClass = this.getClass(schema.getElementType());
                if (elementClass.isPrimitive()) {
                    return ARRAY_CLASSES.get(elementClass);
                }
                return Array.newInstance(elementClass, 0).getClass();
            }
            case STRING: {
                Class stringClass = ReflectData.getClassProp(schema, CLASS_PROP);
                if (stringClass != null) {
                    return stringClass;
                }
                return String.class;
            }
            case BYTES: {
                return BYTES_CLASS;
            }
            case INT: {
                String intClass = schema.getProp(CLASS_PROP);
                if (Byte.class.getName().equals(intClass)) {
                    return Byte.TYPE;
                }
                if (Short.class.getName().equals(intClass)) {
                    return Short.TYPE;
                }
                if (!Character.class.getName().equals(intClass)) break;
                return Character.TYPE;
            }
        }
        return super.getClass(schema);
    }

    @Override
    protected Schema createSchema(Type type, Map<String, Schema> names) {
        if (type instanceof GenericArrayType) {
            Type component = ((GenericArrayType)type).getGenericComponentType();
            if (component == Byte.TYPE) {
                return Schema.create(Schema.Type.BYTES);
            }
            Schema result = Schema.createArray(this.createSchema(component, names));
            this.setElement(result, component);
            return result;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Class raw = (Class)ptype.getRawType();
            Type[] params = ptype.getActualTypeArguments();
            if (Map.class.isAssignableFrom(raw)) {
                Schema schema = Schema.createMap(this.createSchema(params[1], names));
                Class key = (Class)params[0];
                if (this.isStringable(key)) {
                    schema.addProp(KEY_CLASS_PROP, key.getName());
                } else if (key != String.class) {
                    throw new AvroTypeException("Map key class not String: " + key);
                }
                return schema;
            }
            if (Collection.class.isAssignableFrom(raw)) {
                if (params.length != 1) {
                    throw new AvroTypeException("No array type specified.");
                }
                Schema schema = Schema.createArray(this.createSchema(params[0], names));
                schema.addProp(CLASS_PROP, raw.getName());
                return schema;
            }
        } else {
            if (type == Byte.class || type == Byte.TYPE) {
                Schema result = Schema.create(Schema.Type.INT);
                result.addProp(CLASS_PROP, Byte.class.getName());
                return result;
            }
            if (type == Short.class || type == Short.TYPE) {
                Schema result = Schema.create(Schema.Type.INT);
                result.addProp(CLASS_PROP, Short.class.getName());
                return result;
            }
            if (type == Character.class || type == Character.TYPE) {
                Schema result = Schema.create(Schema.Type.INT);
                result.addProp(CLASS_PROP, Character.class.getName());
                return result;
            }
            if (type instanceof Class) {
                Class c = (Class)type;
                if (c.isPrimitive() || c == Void.class || c == Boolean.class || c == Integer.class || c == Long.class || c == Float.class || c == Double.class || c == Byte.class || c == Short.class || c == Character.class) {
                    return super.createSchema(type, names);
                }
                if (c.isArray()) {
                    Class<?> component = c.getComponentType();
                    if (component == Byte.TYPE) {
                        Schema result = Schema.create(Schema.Type.BYTES);
                        result.addProp(CLASS_PROP, c.getName());
                        return result;
                    }
                    Schema result = Schema.createArray(this.createSchema(component, names));
                    result.addProp(CLASS_PROP, c.getName());
                    this.setElement(result, component);
                    return result;
                }
                AvroSchema explicit = c.getAnnotation(AvroSchema.class);
                if (explicit != null) {
                    return Schema.parse(explicit.value());
                }
                if (CharSequence.class.isAssignableFrom(c)) {
                    return Schema.create(Schema.Type.STRING);
                }
                if (ByteBuffer.class.isAssignableFrom(c)) {
                    return Schema.create(Schema.Type.BYTES);
                }
                if (Collection.class.isAssignableFrom(c)) {
                    throw new AvroRuntimeException("Can't find element type of Collection");
                }
                String fullName = c.getName();
                Schema schema = names.get(fullName);
                if (schema == null) {
                    Union union;
                    String space;
                    String name = c.getSimpleName();
                    String string = space = c.getPackage() == null ? "" : c.getPackage().getName();
                    if (c.getEnclosingClass() != null) {
                        space = c.getEnclosingClass().getName() + "$";
                    }
                    if ((union = c.getAnnotation(Union.class)) != null) {
                        return this.getAnnotatedUnion(union, names);
                    }
                    if (this.isStringable(c)) {
                        Schema result = Schema.create(Schema.Type.STRING);
                        result.addProp(CLASS_PROP, c.getName());
                        return result;
                    }
                    if (c.isEnum()) {
                        ArrayList<String> symbols = new ArrayList<String>();
                        Enum[] constants = (Enum[])c.getEnumConstants();
                        for (int i = 0; i < constants.length; ++i) {
                            symbols.add(constants[i].name());
                        }
                        schema = Schema.createEnum(name, null, space, symbols);
                        this.consumeAvroAliasAnnotation(c, schema);
                    } else if (GenericFixed.class.isAssignableFrom(c)) {
                        int size = c.getAnnotation(FixedSize.class).value();
                        schema = Schema.createFixed(name, null, space, size);
                        this.consumeAvroAliasAnnotation(c, schema);
                    } else {
                        if (IndexedRecord.class.isAssignableFrom(c)) {
                            return super.createSchema(type, names);
                        }
                        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                        boolean error = Throwable.class.isAssignableFrom(c);
                        schema = Schema.createRecord(name, null, space, error);
                        this.consumeAvroAliasAnnotation(c, schema);
                        names.put(c.getName(), schema);
                        for (Field field : ReflectData.getCachedFields(c)) {
                            AvroName annotatedName;
                            Schema defaultType;
                            JsonNode defaultValue;
                            if ((field.getModifiers() & 0x88) != 0 || field.isAnnotationPresent(AvroIgnore.class)) continue;
                            Schema fieldSchema = this.createFieldSchema(field, names);
                            AvroDefault defaultAnnotation = field.getAnnotation(AvroDefault.class);
                            JsonNode jsonNode = defaultValue = defaultAnnotation == null ? null : Schema.parseJson(defaultAnnotation.value());
                            if (defaultValue == null && fieldSchema.getType() == Schema.Type.UNION && (defaultType = fieldSchema.getTypes().get(0)).getType() == Schema.Type.NULL) {
                                defaultValue = NullNode.getInstance();
                            }
                            String fieldName = (annotatedName = field.getAnnotation(AvroName.class)) != null ? annotatedName.value() : field.getName();
                            Schema.Field recordField = new Schema.Field(fieldName, fieldSchema, null, defaultValue);
                            AvroMeta meta = field.getAnnotation(AvroMeta.class);
                            if (meta != null) {
                                recordField.addProp(meta.key(), meta.value());
                            }
                            for (Schema.Field f : fields) {
                                if (!f.name().equals(fieldName)) continue;
                                throw new AvroTypeException("double field entry: " + fieldName);
                            }
                            fields.add(recordField);
                        }
                        if (error) {
                            fields.add(new Schema.Field("detailMessage", THROWABLE_MESSAGE, null, null));
                        }
                        schema.setFields(fields);
                        AvroMeta meta = c.getAnnotation(AvroMeta.class);
                        if (meta != null) {
                            schema.addProp(meta.key(), meta.value());
                        }
                    }
                    names.put(fullName, schema);
                }
                return schema;
            }
        }
        return super.createSchema(type, names);
    }

    @Override
    protected boolean isStringable(Class<?> c) {
        return c.isAnnotationPresent(Stringable.class) || super.isStringable(c);
    }

    private void setElement(Schema schema, Type element) {
        if (!(element instanceof Class)) {
            return;
        }
        Class c = (Class)element;
        Union union = c.getAnnotation(Union.class);
        if (union != null) {
            schema.addProp(ELEMENT_PROP, c.getName());
        }
    }

    private Schema getAnnotatedUnion(Union union, Map<String, Schema> names) {
        ArrayList<Schema> branches = new ArrayList<Schema>();
        for (Class branch : union.value()) {
            branches.add(this.createSchema(branch, names));
        }
        return Schema.createUnion(branches);
    }

    public static Schema makeNullable(Schema schema) {
        return Schema.createUnion(Arrays.asList(Schema.create(Schema.Type.NULL), schema));
    }

    private static Field[] getCachedFields(Class<?> recordClass) {
        Field[] fieldsList = FIELDS_CACHE.get(recordClass);
        if (fieldsList != null) {
            return fieldsList;
        }
        fieldsList = ReflectData.getFields(recordClass, true);
        FIELDS_CACHE.put(recordClass, fieldsList);
        return fieldsList;
    }

    private static Field[] getFields(Class<?> recordClass, boolean excludeJava) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        Class<?> c = recordClass;
        while (!excludeJava || c.getPackage() == null || !c.getPackage().getName().startsWith("java.")) {
            for (Field field : c.getDeclaredFields()) {
                if ((field.getModifiers() & 0x88) != 0 || fields.put(field.getName(), field) == null) continue;
                throw new AvroTypeException(c + " contains two fields named: " + field);
            }
            if ((c = c.getSuperclass()) != null) continue;
        }
        Field[] fieldsList = fields.values().toArray(new Field[0]);
        return fieldsList;
    }

    protected Schema createFieldSchema(Field field, Map<String, Schema> names) {
        AvroEncode enc = field.getAnnotation(AvroEncode.class);
        if (enc != null) {
            try {
                return enc.using().newInstance().getSchema();
            }
            catch (Exception e) {
                throw new AvroRuntimeException("Could not create schema from custom serializer for " + field.getName());
            }
        }
        AvroSchema explicit = field.getAnnotation(AvroSchema.class);
        if (explicit != null) {
            return Schema.parse(explicit.value());
        }
        Schema schema = this.createSchema(field.getGenericType(), names);
        if (field.isAnnotationPresent(Stringable.class)) {
            schema = Schema.create(Schema.Type.STRING);
        }
        if (field.isAnnotationPresent(Nullable.class)) {
            schema = ReflectData.makeNullable(schema);
        }
        return schema;
    }

    @Override
    public Protocol getProtocol(Class iface) {
        Protocol protocol = new Protocol(iface.getSimpleName(), iface.getPackage() == null ? "" : iface.getPackage().getName());
        LinkedHashMap<String, Schema> names = new LinkedHashMap<String, Schema>();
        Map<String, Protocol.Message> messages = protocol.getMessages();
        for (Method method : iface.getMethods()) {
            if ((method.getModifiers() & 8) != 0) continue;
            String name = method.getName();
            if (messages.containsKey(name)) {
                throw new AvroTypeException("Two methods with same name: " + name);
            }
            messages.put(name, this.getMessage(method, protocol, names));
        }
        ArrayList<Schema> types = new ArrayList<Schema>();
        types.addAll(names.values());
        Collections.reverse(types);
        protocol.setTypes(types);
        return protocol;
    }

    private Protocol.Message getMessage(Method method, Protocol protocol, Map<String, Schema> names) {
        AvroSchema explicit;
        Schema response;
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        String[] paramNames = this.paranamer.lookupParameterNames(method);
        Type[] paramTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < paramTypes.length; ++i) {
            Schema paramSchema = this.getSchema(paramTypes[i], names);
            for (int j = 0; j < annotations[i].length; ++j) {
                Annotation annotation = annotations[i][j];
                if (annotation instanceof AvroSchema) {
                    paramSchema = Schema.parse(((AvroSchema)annotation).value());
                    continue;
                }
                if (annotation instanceof Union) {
                    paramSchema = this.getAnnotatedUnion((Union)annotation, names);
                    continue;
                }
                if (!(annotation instanceof Nullable)) continue;
                paramSchema = ReflectData.makeNullable(paramSchema);
            }
            String paramName = paramNames.length == paramTypes.length ? paramNames[i] : paramSchema.getName() + i;
            fields.add(new Schema.Field(paramName, paramSchema, null, null));
        }
        Schema request = Schema.createRecord(fields);
        Union union = method.getAnnotation(Union.class);
        Schema schema = response = union == null ? this.getSchema(method.getGenericReturnType(), names) : this.getAnnotatedUnion(union, names);
        if (method.isAnnotationPresent(Nullable.class)) {
            response = ReflectData.makeNullable(response);
        }
        if ((explicit = method.getAnnotation(AvroSchema.class)) != null) {
            response = Schema.parse(explicit.value());
        }
        ArrayList<Schema> errs = new ArrayList<Schema>();
        errs.add(Protocol.SYSTEM_ERROR);
        for (Type err : method.getGenericExceptionTypes()) {
            if (err == AvroRemoteException.class) continue;
            errs.add(this.getSchema(err, names));
        }
        Schema errors = Schema.createUnion(errs);
        return protocol.createMessage(method.getName(), null, request, response, errors);
    }

    private Schema getSchema(Type type, Map<String, Schema> names) {
        try {
            return this.createSchema(type, names);
        }
        catch (AvroTypeException e) {
            throw new AvroTypeException("Error getting schema for " + type + ": " + e.getMessage(), e);
        }
    }

    @Override
    protected int compare(Object o1, Object o2, Schema s, boolean equals) {
        switch (s.getType()) {
            case ARRAY: {
                if (!o1.getClass().isArray()) break;
                Schema elementType = s.getElementType();
                int l1 = Array.getLength(o1);
                int l2 = Array.getLength(o2);
                int l = Math.min(l1, l2);
                for (int i = 0; i < l; ++i) {
                    int compare = this.compare(Array.get(o1, i), Array.get(o2, i), elementType, equals);
                    if (compare == 0) continue;
                    return compare;
                }
                return l1 - l2;
            }
            case BYTES: {
                if (!o1.getClass().isArray()) break;
                byte[] b1 = (byte[])o1;
                byte[] b2 = (byte[])o2;
                return BinaryData.compareBytes(b1, 0, b1.length, b2, 0, b2.length);
            }
        }
        return super.compare(o1, o2, s, equals);
    }

    @Override
    protected Object getRecordState(Object record, Schema schema) {
        return this.getFieldAccessors(record.getClass(), schema);
    }

    private void consumeAvroAliasAnnotation(Class<?> c, Schema schema) {
        AvroAlias alias = c.getAnnotation(AvroAlias.class);
        if (alias != null) {
            String space = alias.space();
            if ("NOT A VALID NAMESPACE".equals(space)) {
                space = null;
            }
            schema.addAlias(alias.alias(), space);
        }
    }

    static {
        ARRAY_CLASSES.put(Byte.TYPE, byte[].class);
        ARRAY_CLASSES.put(Character.TYPE, char[].class);
        ARRAY_CLASSES.put(Short.TYPE, short[].class);
        ARRAY_CLASSES.put(Integer.TYPE, int[].class);
        ARRAY_CLASSES.put(Long.TYPE, long[].class);
        ARRAY_CLASSES.put(Float.TYPE, float[].class);
        ARRAY_CLASSES.put(Double.TYPE, double[].class);
        ARRAY_CLASSES.put(Boolean.TYPE, boolean[].class);
        THROWABLE_MESSAGE = ReflectData.makeNullable(Schema.create(Schema.Type.STRING));
        FIELDS_CACHE = new ConcurrentHashMap();
    }

    private static class ClassAccessorData {
        private final Class<?> clazz;
        private final Map<String, FieldAccessor> byName = new HashMap<String, FieldAccessor>();
        private final IdentityHashMap<Schema, FieldAccessor[]> bySchema = new IdentityHashMap();

        private ClassAccessorData(Class<?> c) {
            this.clazz = c;
            for (Field f : ReflectData.getFields(c, false)) {
                if (f.isAnnotationPresent(AvroIgnore.class)) continue;
                FieldAccessor accessor = ReflectionUtil.getFieldAccess().getAccessor(f);
                AvroName avroname = f.getAnnotation(AvroName.class);
                this.byName.put(avroname != null ? avroname.value() : f.getName(), accessor);
            }
        }

        private synchronized FieldAccessor[] getAccessorsFor(Schema schema) {
            FieldAccessor[] result = this.bySchema.get(schema);
            if (result == null) {
                result = this.createAccessorsFor(schema);
                this.bySchema.put(schema, result);
            }
            return result;
        }

        private FieldAccessor[] createAccessorsFor(Schema schema) {
            List<Schema.Field> avroFields = schema.getFields();
            FieldAccessor[] result = new FieldAccessor[avroFields.size()];
            for (Schema.Field avroField : schema.getFields()) {
                result[avroField.pos()] = this.byName.get(avroField.name());
            }
            return result;
        }

        private FieldAccessor getAccessorFor(String fieldName) {
            FieldAccessor result = this.byName.get(fieldName);
            if (result == null) {
                throw new AvroRuntimeException("No field named " + fieldName + " in: " + this.clazz);
            }
            return result;
        }
    }

    public static class AllowNull
    extends ReflectData {
        private static final AllowNull INSTANCE = new AllowNull();

        public static AllowNull get() {
            return INSTANCE;
        }

        @Override
        protected Schema createFieldSchema(Field field, Map<String, Schema> names) {
            Schema schema = super.createFieldSchema(field, names);
            return AllowNull.makeNullable(schema);
        }
    }
}

