/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;

public class StreamConnection {
    private BidiStreamingCallable<AppendRowsRequest, AppendRowsResponse> bidiStreamingCallable;
    private ClientStream<AppendRowsRequest> clientStream;
    private RequestCallback requestCallback;
    private DoneCallback doneCallback;

    public StreamConnection(BigQueryWriteClient client, RequestCallback requestCallback, DoneCallback doneCallback) {
        this.requestCallback = requestCallback;
        this.doneCallback = doneCallback;
        this.bidiStreamingCallable = client.appendRowsCallable();
        this.clientStream = this.bidiStreamingCallable.splitCall((ResponseObserver)new ResponseObserver<AppendRowsResponse>(){

            public void onStart(StreamController controller) {
            }

            public void onResponse(AppendRowsResponse response) {
                StreamConnection.this.requestCallback.run(response);
            }

            public void onError(Throwable t) {
                StreamConnection.this.doneCallback.run(t);
            }

            public void onComplete() {
                StreamConnection.this.doneCallback.run((Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.CANCELLED).withDescription("Stream is closed by user.")));
            }
        });
    }

    public void send(AppendRowsRequest request) {
        this.clientStream.send((Object)request);
    }

    public void close() {
        this.clientStream.closeSend();
    }

    public static interface DoneCallback {
        public void run(Throwable var1);
    }

    public static interface RequestCallback {
        public void run(AppendRowsResponse var1);
    }
}

