/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class LocalDateComparator
extends TypeComparator<LocalDate>
implements Serializable {
    private transient LocalDate reference;
    protected final boolean ascendingComparison;
    private final LocalDateComparator[] comparators = new LocalDateComparator[]{this};

    public LocalDateComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    @Override
    public int hash(LocalDate value) {
        return value.hashCode();
    }

    @Override
    public void setReference(LocalDate toCompare) {
        this.reference = toCompare;
    }

    @Override
    public boolean equalToReference(LocalDate candidate) {
        return candidate.equals(this.reference);
    }

    @Override
    public int compareToReference(TypeComparator<LocalDate> referencedComparator) {
        int comp = ((LocalDateComparator)referencedComparator).reference.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compare(LocalDate first, LocalDate second) {
        int cmp = first.compareTo(second);
        return this.ascendingComparison ? cmp : -cmp;
    }

    @Override
    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public void writeWithKeyNormalization(LocalDate record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    @Override
    public TypeComparator[] getFlatComparators() {
        return this.comparators;
    }

    @Override
    public LocalDate readWithKeyDenormalization(LocalDate reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        return LocalDateComparator.compareSerializedLocalDate(firstSource, secondSource, this.ascendingComparison);
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 6;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    @Override
    public void putNormalizedKey(LocalDate record, MemorySegment target, int offset, int numBytes) {
        LocalDateComparator.putNormalizedKeyLocalDate(record, target, offset, numBytes);
    }

    public LocalDateComparator duplicate() {
        return new LocalDateComparator(this.ascendingComparison);
    }

    public static int compareSerializedLocalDate(DataInputView firstSource, DataInputView secondSource, boolean ascendingComparison) throws IOException {
        int cmp = firstSource.readInt() - secondSource.readInt();
        if (cmp == 0 && (cmp = firstSource.readByte() - secondSource.readByte()) == 0) {
            cmp = firstSource.readByte() - secondSource.readByte();
        }
        return ascendingComparison ? cmp : -cmp;
    }

    public static void putNormalizedKeyLocalDate(LocalDate record, MemorySegment target, int offset, int numBytes) {
        int year = record.getYear();
        int unsignedYear = year - Integer.MIN_VALUE;
        if (numBytes >= 4) {
            target.putIntBigEndian(offset, unsignedYear);
            numBytes -= 4;
            offset += 4;
        } else if (numBytes > 0) {
            int i = 0;
            while (numBytes > 0) {
                target.put(offset + i, (byte)(unsignedYear >>> (3 - i << 3)));
                --numBytes;
                ++i;
            }
            return;
        }
        int month = record.getMonthValue();
        if (numBytes > 0) {
            target.put(offset, (byte)(month & 0x17F));
            --numBytes;
            ++offset;
        }
        int day = record.getDayOfMonth();
        if (numBytes > 0) {
            target.put(offset, (byte)(day & 0x17F));
            --numBytes;
            ++offset;
        }
        for (int i = 0; i < numBytes; ++i) {
            target.put(offset + i, (byte)0);
        }
    }
}

