/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.BooleanValueComparator;
import org.apache.flink.api.common.typeutils.base.BooleanValueSerializer;
import org.apache.flink.api.common.typeutils.base.ByteValueComparator;
import org.apache.flink.api.common.typeutils.base.ByteValueSerializer;
import org.apache.flink.api.common.typeutils.base.CharValueComparator;
import org.apache.flink.api.common.typeutils.base.CharValueSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleValueComparator;
import org.apache.flink.api.common.typeutils.base.DoubleValueSerializer;
import org.apache.flink.api.common.typeutils.base.FloatValueComparator;
import org.apache.flink.api.common.typeutils.base.FloatValueSerializer;
import org.apache.flink.api.common.typeutils.base.IntValueComparator;
import org.apache.flink.api.common.typeutils.base.IntValueSerializer;
import org.apache.flink.api.common.typeutils.base.LongValueComparator;
import org.apache.flink.api.common.typeutils.base.LongValueSerializer;
import org.apache.flink.api.common.typeutils.base.NullValueComparator;
import org.apache.flink.api.common.typeutils.base.NullValueSerializer;
import org.apache.flink.api.common.typeutils.base.ShortValueComparator;
import org.apache.flink.api.common.typeutils.base.ShortValueSerializer;
import org.apache.flink.api.common.typeutils.base.StringValueComparator;
import org.apache.flink.api.common.typeutils.base.StringValueSerializer;
import org.apache.flink.api.java.typeutils.runtime.CopyableValueComparator;
import org.apache.flink.api.java.typeutils.runtime.CopyableValueSerializer;
import org.apache.flink.api.java.typeutils.runtime.ValueComparator;
import org.apache.flink.api.java.typeutils.runtime.ValueSerializer;
import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.Preconditions;

@Public
public class ValueTypeInfo<T extends Value>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = 1L;
    public static final ValueTypeInfo<BooleanValue> BOOLEAN_VALUE_TYPE_INFO = new ValueTypeInfo<BooleanValue>(BooleanValue.class);
    public static final ValueTypeInfo<ByteValue> BYTE_VALUE_TYPE_INFO = new ValueTypeInfo<ByteValue>(ByteValue.class);
    public static final ValueTypeInfo<CharValue> CHAR_VALUE_TYPE_INFO = new ValueTypeInfo<CharValue>(CharValue.class);
    public static final ValueTypeInfo<DoubleValue> DOUBLE_VALUE_TYPE_INFO = new ValueTypeInfo<DoubleValue>(DoubleValue.class);
    public static final ValueTypeInfo<FloatValue> FLOAT_VALUE_TYPE_INFO = new ValueTypeInfo<FloatValue>(FloatValue.class);
    public static final ValueTypeInfo<IntValue> INT_VALUE_TYPE_INFO = new ValueTypeInfo<IntValue>(IntValue.class);
    public static final ValueTypeInfo<LongValue> LONG_VALUE_TYPE_INFO = new ValueTypeInfo<LongValue>(LongValue.class);
    public static final ValueTypeInfo<NullValue> NULL_VALUE_TYPE_INFO = new ValueTypeInfo<NullValue>(NullValue.class);
    public static final ValueTypeInfo<ShortValue> SHORT_VALUE_TYPE_INFO = new ValueTypeInfo<ShortValue>(ShortValue.class);
    public static final ValueTypeInfo<StringValue> STRING_VALUE_TYPE_INFO = new ValueTypeInfo<StringValue>(StringValue.class);
    private final Class<T> type;

    @PublicEvolving
    public ValueTypeInfo(Class<T> type) {
        this.type = Preconditions.checkNotNull(type);
        Preconditions.checkArgument(Value.class.isAssignableFrom(type) || type.equals(Value.class), "ValueTypeInfo can only be used for subclasses of %s", Value.class.getName());
    }

    @Override
    @PublicEvolving
    public int getArity() {
        return 1;
    }

    @Override
    @PublicEvolving
    public int getTotalFields() {
        return 1;
    }

    @Override
    @PublicEvolving
    public Class<T> getTypeClass() {
        return this.type;
    }

    @Override
    @PublicEvolving
    public boolean isBasicType() {
        return false;
    }

    @PublicEvolving
    public boolean isBasicValueType() {
        return this.type.equals(StringValue.class) || this.type.equals(ByteValue.class) || this.type.equals(ShortValue.class) || this.type.equals(CharValue.class) || this.type.equals(DoubleValue.class) || this.type.equals(FloatValue.class) || this.type.equals(IntValue.class) || this.type.equals(LongValue.class) || this.type.equals(NullValue.class) || this.type.equals(BooleanValue.class);
    }

    @Override
    @PublicEvolving
    public boolean isTupleType() {
        return false;
    }

    @Override
    @PublicEvolving
    public boolean isKeyType() {
        return Comparable.class.isAssignableFrom(this.type);
    }

    @Override
    @PublicEvolving
    public TypeSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        if (BooleanValue.class.isAssignableFrom(this.type)) {
            return BooleanValueSerializer.INSTANCE;
        }
        if (ByteValue.class.isAssignableFrom(this.type)) {
            return ByteValueSerializer.INSTANCE;
        }
        if (CharValue.class.isAssignableFrom(this.type)) {
            return CharValueSerializer.INSTANCE;
        }
        if (DoubleValue.class.isAssignableFrom(this.type)) {
            return DoubleValueSerializer.INSTANCE;
        }
        if (FloatValue.class.isAssignableFrom(this.type)) {
            return FloatValueSerializer.INSTANCE;
        }
        if (IntValue.class.isAssignableFrom(this.type)) {
            return IntValueSerializer.INSTANCE;
        }
        if (LongValue.class.isAssignableFrom(this.type)) {
            return LongValueSerializer.INSTANCE;
        }
        if (NullValue.class.isAssignableFrom(this.type)) {
            return NullValueSerializer.INSTANCE;
        }
        if (ShortValue.class.isAssignableFrom(this.type)) {
            return ShortValueSerializer.INSTANCE;
        }
        if (StringValue.class.isAssignableFrom(this.type)) {
            return StringValueSerializer.INSTANCE;
        }
        if (CopyableValue.class.isAssignableFrom(this.type)) {
            return ValueTypeInfo.createCopyableValueSerializer(this.type.asSubclass(CopyableValue.class));
        }
        return new ValueSerializer<T>(this.type);
    }

    @Override
    @PublicEvolving
    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        if (!this.isKeyType()) {
            throw new RuntimeException("The type " + this.type.getName() + " is not Comparable.");
        }
        if (BooleanValue.class.isAssignableFrom(this.type)) {
            return new BooleanValueComparator(sortOrderAscending);
        }
        if (ByteValue.class.isAssignableFrom(this.type)) {
            return new ByteValueComparator(sortOrderAscending);
        }
        if (CharValue.class.isAssignableFrom(this.type)) {
            return new CharValueComparator(sortOrderAscending);
        }
        if (DoubleValue.class.isAssignableFrom(this.type)) {
            return new DoubleValueComparator(sortOrderAscending);
        }
        if (FloatValue.class.isAssignableFrom(this.type)) {
            return new FloatValueComparator(sortOrderAscending);
        }
        if (IntValue.class.isAssignableFrom(this.type)) {
            return new IntValueComparator(sortOrderAscending);
        }
        if (LongValue.class.isAssignableFrom(this.type)) {
            return new LongValueComparator(sortOrderAscending);
        }
        if (NullValue.class.isAssignableFrom(this.type)) {
            return NullValueComparator.getInstance();
        }
        if (ShortValue.class.isAssignableFrom(this.type)) {
            return new ShortValueComparator(sortOrderAscending);
        }
        if (StringValue.class.isAssignableFrom(this.type)) {
            return new StringValueComparator(sortOrderAscending);
        }
        if (CopyableValue.class.isAssignableFrom(this.type)) {
            return new CopyableValueComparator<T>(sortOrderAscending, this.type);
        }
        return new ValueComparator<T>(sortOrderAscending, this.type);
    }

    private static <X extends CopyableValue<X>> CopyableValueSerializer<X> createCopyableValueSerializer(Class<X> clazz) {
        return new CopyableValueSerializer<X>(clazz);
    }

    @Override
    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ValueTypeInfo) {
            ValueTypeInfo valueTypeInfo = (ValueTypeInfo)obj;
            return valueTypeInfo.canEqual(this) && this.type == valueTypeInfo.type;
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof ValueTypeInfo;
    }

    @Override
    public String toString() {
        return "ValueType<" + this.type.getSimpleName() + ">";
    }

    @PublicEvolving
    static <X extends Value> TypeInformation<X> getValueTypeInfo(Class<X> typeClass) {
        if (Value.class.isAssignableFrom(typeClass) && !typeClass.equals(Value.class)) {
            return new ValueTypeInfo<X>(typeClass);
        }
        throw new InvalidTypesException("The given class is no subclass of " + Value.class.getName());
    }
}

