/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www.async;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.action.GuiContextActionFilter;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.context.HopGuiWorkflowActionContext;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.www.async.AsyncWebService;

@GuiPlugin
public class AsyncGuiPlugin {
    public static final String ACTION_ID_WORKFLOW_GRAPH_ENABLE_ASYNC_LOGGING = "workflow-graph-action-30000-enable-async-logging";
    public static final String ACTION_ID_WORKFLOW_GRAPH_DISABLE_ASYNC_LOGGING = "workflow-graph-action-30100-disable-async-logging";
    private static AsyncGuiPlugin instance = null;

    public static AsyncGuiPlugin getInstance() {
        if (instance == null) {
            instance = new AsyncGuiPlugin();
        }
        return instance;
    }

    @GuiContextAction(id="workflow-graph-action-30000-enable-async-logging", parentId="HopGuiWorkflowActionContext", type=GuiActionType.Custom, name="i18n::AsyncGuiPlugin.EnableAsyncLogging.Name", tooltip="i18n::AsyncGuiPlugin.EnableAsyncLogging.ToolTip", image="ui/images/log.svg", category="i18n::AsyncGuiPlugin.EnableAsyncLogging.Category", categoryOrder="9")
    public void enableAsyncLogging(HopGuiWorkflowActionContext context) {
        HopGui hopGui = context.getWorkflowGraph().getHopGui();
        try {
            ActionMeta actionMeta = context.getActionMeta();
            if (!actionMeta.isPipeline()) {
                return;
            }
            Map asyncMap = actionMeta.getAttributesMap().computeIfAbsent("ASYNC_STATUS_GROUP", k -> new HashMap());
            MultiMetadataProvider metadataProvider = hopGui.getMetadataProvider();
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(AsyncWebService.class);
            List serviceNames = serializer.listObjectNames();
            EnterSelectionDialog dialog = new EnterSelectionDialog(hopGui.getShell(), serviceNames.toArray(new String[0]), "Select async service", "Select the asynchronous service to report to");
            String serviceName = dialog.open();
            if (serviceName == null) {
                return;
            }
            asyncMap.put("enable-asynchronous-pipeline-service-name", serviceName);
            actionMeta.setChanged();
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), "Error", "Error enabling asynchronous status reporting of a pipeline", e);
        }
        context.getWorkflowGraph().redraw();
    }

    @GuiContextAction(id="workflow-graph-action-30100-disable-async-logging", parentId="HopGuiWorkflowActionContext", type=GuiActionType.Custom, name="i18n::AsyncGuiPlugin.DisableAsyncLogging.Name", tooltip="i18n::AsyncGuiPlugin.DisableAsyncLogging.ToolTip", image="ui/images/log.svg", category="i18n::AsyncGuiPlugin.DisableAsyncLogging.Category", categoryOrder="9")
    public void disableAsyncLogging(HopGuiWorkflowActionContext context) {
        ActionMeta actionMeta = context.getActionMeta();
        if (!actionMeta.isPipeline()) {
            return;
        }
        Map asyncMap = (Map)actionMeta.getAttributesMap().get("ASYNC_STATUS_GROUP");
        if (asyncMap == null) {
            return;
        }
        asyncMap.remove("enable-asynchronous-pipeline-service-name");
        actionMeta.setChanged();
        context.getWorkflowGraph().redraw();
    }

    @GuiContextActionFilter(parentId="HopGuiWorkflowActionContext")
    public boolean filterAsyncActions(String contextActionId, HopGuiWorkflowActionContext context) {
        ActionMeta actionMeta = context.getActionMeta();
        boolean isPipeline = actionMeta.isPipeline();
        Map asyncMap = (Map)actionMeta.getAttributesMap().get("ASYNC_STATUS_GROUP");
        boolean enabled = false;
        if (asyncMap != null) {
            boolean bl = enabled = asyncMap.get("enable-asynchronous-pipeline-service-name") != null;
        }
        if (contextActionId.equals(ACTION_ID_WORKFLOW_GRAPH_ENABLE_ASYNC_LOGGING)) {
            return isPipeline && !enabled;
        }
        if (contextActionId.equals(ACTION_ID_WORKFLOW_GRAPH_DISABLE_ASYNC_LOGGING)) {
            return isPipeline && enabled;
        }
        return true;
    }
}

