/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.selectvalues;

import org.apache.hop.core.Const;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class SelectMetadataChange
implements Cloneable {
    public static final String XML_TAG = "meta";
    @Injection(name="META_NAME", group="METAS")
    private String name;
    @Injection(name="META_RENAME", group="METAS")
    private String rename;
    private int type;
    @Injection(name="META_LENGTH", group="METAS")
    private int length = -1;
    @Injection(name="META_PRECISION", group="METAS")
    private int precision = -1;
    private int storageType = -1;
    @Injection(name="META_CONVERSION_MASK", group="METAS")
    private String conversionMask;
    @Injection(name="META_DATE_FORMAT_LENIENT", group="METAS")
    private boolean dateFormatLenient;
    @Injection(name="META_DATE_FORMAT_LOCALE", group="METAS")
    private String dateFormatLocale;
    @Injection(name="META_DATE_FORMAT_TIMEZONE", group="METAS")
    private String dateFormatTimeZone;
    @Injection(name="META_LENIENT_STRING_TO_NUMBER", group="METAS")
    private boolean lenientStringToNumber;
    @Injection(name="META_DECIMAL", group="METAS")
    private String decimalSymbol;
    @Injection(name="META_GROUPING", group="METAS")
    private String groupingSymbol;
    @Injection(name="META_CURRENCY", group="METAS")
    private String currencySymbol;
    @Injection(name="META_ENCODING", group="METAS")
    private String encoding;

    public SelectMetadataChange() {
    }

    public SelectMetadataChange(String name, String rename, int type, int length, int precision, int storageType, String conversionMask, boolean dateFormatLenient, String dateFormatLocale, String dateFormatTimeZone, boolean lenientStringToNumber, String decimalSymbol, String groupingSymbol, String currencySymbol) {
        this();
        this.name = name;
        this.rename = rename;
        this.type = type;
        this.length = length;
        this.precision = precision;
        this.storageType = storageType;
        this.conversionMask = conversionMask;
        this.dateFormatLenient = dateFormatLenient;
        this.dateFormatLocale = dateFormatLocale;
        this.dateFormatTimeZone = dateFormatTimeZone;
        this.lenientStringToNumber = lenientStringToNumber;
        this.decimalSymbol = decimalSymbol;
        this.groupingSymbol = groupingSymbol;
        this.currencySymbol = currencySymbol;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("      ").append(XmlHandler.openTag((String)XML_TAG));
        xml.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.name));
        xml.append("        ").append(XmlHandler.addTagValue((String)"rename", (String)this.rename));
        xml.append("        ").append(XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.type)));
        xml.append("        ").append(XmlHandler.addTagValue((String)"length", (int)this.length));
        xml.append("        ").append(XmlHandler.addTagValue((String)"precision", (int)this.precision));
        xml.append("        ").append(XmlHandler.addTagValue((String)"conversion_mask", (String)this.conversionMask));
        xml.append("        ").append(XmlHandler.addTagValue((String)"date_format_lenient", (String)Boolean.toString(this.dateFormatLenient)));
        xml.append("        ").append(XmlHandler.addTagValue((String)"date_format_locale", (String)this.dateFormatLocale));
        xml.append("        ").append(XmlHandler.addTagValue((String)"date_format_timezone", (String)this.dateFormatTimeZone));
        xml.append("        ").append(XmlHandler.addTagValue((String)"lenient_string_to_number", (String)Boolean.toString(this.lenientStringToNumber)));
        xml.append("        ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        xml.append("        ").append(XmlHandler.addTagValue((String)"decimal_symbol", (String)this.decimalSymbol));
        xml.append("        ").append(XmlHandler.addTagValue((String)"grouping_symbol", (String)this.groupingSymbol));
        xml.append("        ").append(XmlHandler.addTagValue((String)"currency_symbol", (String)this.currencySymbol));
        xml.append("        ").append(XmlHandler.addTagValue((String)"storage_type", (String)ValueMetaBase.getStorageTypeCode((int)this.storageType)));
        xml.append("      ").append(XmlHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public void loadXml(Node metaNode) {
        this.name = XmlHandler.getTagValue((Node)metaNode, (String)"name");
        this.rename = XmlHandler.getTagValue((Node)metaNode, (String)"rename");
        this.type = ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)metaNode, (String)"type"));
        this.length = Const.toInt((String)XmlHandler.getTagValue((Node)metaNode, (String)"length"), (int)-2);
        this.precision = Const.toInt((String)XmlHandler.getTagValue((Node)metaNode, (String)"precision"), (int)-2);
        this.storageType = ValueMetaBase.getStorageType((String)XmlHandler.getTagValue((Node)metaNode, (String)"storage_type"));
        this.conversionMask = XmlHandler.getTagValue((Node)metaNode, (String)"conversion_mask");
        this.dateFormatLenient = Boolean.parseBoolean(XmlHandler.getTagValue((Node)metaNode, (String)"date_format_lenient"));
        this.dateFormatLocale = XmlHandler.getTagValue((Node)metaNode, (String)"date_format_locale");
        this.dateFormatTimeZone = XmlHandler.getTagValue((Node)metaNode, (String)"date_format_timezone");
        this.encoding = XmlHandler.getTagValue((Node)metaNode, (String)"encoding");
        this.lenientStringToNumber = Boolean.parseBoolean(XmlHandler.getTagValue((Node)metaNode, (String)"lenient_string_to_number"));
        this.decimalSymbol = XmlHandler.getTagValue((Node)metaNode, (String)"decimal_symbol");
        this.groupingSymbol = XmlHandler.getTagValue((Node)metaNode, (String)"grouping_symbol");
        this.currencySymbol = XmlHandler.getTagValue((Node)metaNode, (String)"currency_symbol");
    }

    public SelectMetadataChange clone() {
        try {
            return (SelectMetadataChange)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRename() {
        return this.rename;
    }

    public void setRename(String rename) {
        this.rename = rename;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Injection(name="META_TYPE", group="METAS")
    public void setType(String value) {
        this.type = ValueMetaFactory.getIdForValueMeta((String)value);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setStorageType(int storageType) {
        this.storageType = storageType;
    }

    @Injection(name="META_STORAGE_TYPE", group="METAS")
    public void setStorageType(String storageType) {
        this.storageType = ValueMetaBase.getStorageType((String)storageType);
    }

    public String getConversionMask() {
        return this.conversionMask;
    }

    public void setConversionMask(String conversionMask) {
        this.conversionMask = conversionMask;
    }

    public boolean isDateFormatLenient() {
        return this.dateFormatLenient;
    }

    public void setDateFormatLenient(boolean dateFormatLenient) {
        this.dateFormatLenient = dateFormatLenient;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public void setGroupingSymbol(String groupingSymbol) {
        this.groupingSymbol = groupingSymbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isLenientStringToNumber() {
        return this.lenientStringToNumber;
    }

    public void setLenientStringToNumber(boolean lenientStringToNumber) {
        this.lenientStringToNumber = lenientStringToNumber;
    }

    public String getDateFormatLocale() {
        return this.dateFormatLocale;
    }

    public void setDateFormatLocale(String dateFormatLocale) {
        this.dateFormatLocale = dateFormatLocale;
    }

    public String getDateFormatTimeZone() {
        return this.dateFormatTimeZone;
    }

    public void setDateFormatTimeZone(String dateFormatTimeZone) {
        this.dateFormatTimeZone = dateFormatTimeZone;
    }
}

