/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mergerows;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.mergerows.MergeRowsMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MergeRowsDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = MergeRowsMeta.class;
    public static final String STRING_SORT_WARNING_PARAMETER = "MergeRowsSortWarning";
    private CCombo wReference;
    private CCombo wCompare;
    private Text wFlagField;
    private TableView wKeys;
    private TableView wValues;
    private final MergeRowsMeta input;

    public MergeRowsDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (MergeRowsMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MergeRowsDialog.Shell.Label", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        Button wbKeys = new Button((Composite)this.shell, 8);
        wbKeys.setText(BaseMessages.getString(PKG, (String)"MergeRowsDialog.KeyFields.Button", (String[])new String[0]));
        FormData fdbKeys = new FormData();
        fdbKeys.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        fdbKeys.left = new FormAttachment(0, 0);
        fdbKeys.right = new FormAttachment(50, -margin);
        wbKeys.setLayoutData((Object)fdbKeys);
        wbKeys.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeRowsDialog.this.getKeys();
            }
        });
        Button wbValues = new Button((Composite)this.shell, 8);
        wbValues.setText(BaseMessages.getString(PKG, (String)"MergeRowsDialog.ValueFields.Button", (String[])new String[0]));
        FormData fdbValues = new FormData();
        fdbValues.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        fdbValues.left = new FormAttachment(50, 0);
        fdbValues.right = new FormAttachment(100, 0);
        wbValues.setLayoutData((Object)fdbValues);
        wbValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeRowsDialog.this.getValues();
            }
        });
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"MergeRowsDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        String[] previousTransforms = this.pipelineMeta.getPrevTransformNames(this.transformName);
        Label wlReference = new Label((Composite)this.shell, 131072);
        wlReference.setText(BaseMessages.getString(PKG, (String)"MergeRowsDialog.Reference.Label", (String[])new String[0]));
        this.props.setLook((Control)wlReference);
        FormData fdlReference = new FormData();
        fdlReference.left = new FormAttachment(0, 0);
        fdlReference.right = new FormAttachment(middle, -margin);
        fdlReference.top = new FormAttachment((Control)this.wTransformName, margin);
        wlReference.setLayoutData((Object)fdlReference);
        this.wReference = new CCombo((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wReference);
        if (previousTransforms != null) {
            this.wReference.setItems(previousTransforms);
        }
        this.wReference.addModifyListener(lsMod);
        FormData fdReference = new FormData();
        fdReference.left = new FormAttachment(middle, 0);
        fdReference.top = new FormAttachment((Control)this.wTransformName, margin);
        fdReference.right = new FormAttachment(100, 0);
        this.wReference.setLayoutData((Object)fdReference);
        Label wlCompare = new Label((Composite)this.shell, 131072);
        wlCompare.setText(BaseMessages.getString(PKG, (String)"MergeRowsDialog.Compare.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCompare);
        FormData fdlCompare = new FormData();
        fdlCompare.left = new FormAttachment(0, 0);
        fdlCompare.right = new FormAttachment(middle, -margin);
        fdlCompare.top = new FormAttachment((Control)this.wReference, margin);
        wlCompare.setLayoutData((Object)fdlCompare);
        this.wCompare = new CCombo((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wCompare);
        if (previousTransforms != null) {
            this.wCompare.setItems(previousTransforms);
        }
        this.wCompare.addModifyListener(lsMod);
        FormData fdCompare = new FormData();
        fdCompare.top = new FormAttachment((Control)this.wReference, margin);
        fdCompare.left = new FormAttachment(middle, 0);
        fdCompare.right = new FormAttachment(100, 0);
        this.wCompare.setLayoutData((Object)fdCompare);
        Label wlFlagfield = new Label((Composite)this.shell, 131072);
        wlFlagfield.setText(BaseMessages.getString(PKG, (String)"MergeRowsDialog.FlagField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFlagfield);
        FormData fdlFlagfield = new FormData();
        fdlFlagfield.left = new FormAttachment(0, 0);
        fdlFlagfield.right = new FormAttachment(middle, -margin);
        fdlFlagfield.top = new FormAttachment((Control)this.wCompare, margin);
        wlFlagfield.setLayoutData((Object)fdlFlagfield);
        this.wFlagField = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFlagField);
        this.wFlagField.addModifyListener(lsMod);
        FormData fdFlagfield = new FormData();
        fdFlagfield.top = new FormAttachment((Control)this.wCompare, margin);
        fdFlagfield.left = new FormAttachment(middle, 0);
        fdFlagfield.right = new FormAttachment(100, 0);
        this.wFlagField.setLayoutData((Object)fdFlagfield);
        Label wlKeys = new Label((Composite)this.shell, 0);
        wlKeys.setText(BaseMessages.getString(PKG, (String)"MergeRowsDialog.Keys.Label", (String[])new String[0]));
        this.props.setLook((Control)wlKeys);
        FormData fdlKeys = new FormData();
        fdlKeys.left = new FormAttachment(0, 0);
        fdlKeys.top = new FormAttachment((Control)this.wFlagField, margin);
        wlKeys.setLayoutData((Object)fdlKeys);
        int nrKeyRows = this.input.getKeyFields() != null ? this.input.getKeyFields().length : 1;
        ColumnInfo[] ciKeys = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MergeRowsDialog.ColumnInfo.KeyField", (String[])new String[0]), 1, false)};
        this.wKeys = new TableView(this.variables, (Composite)this.shell, 68354, ciKeys, nrKeyRows, lsMod, this.props);
        FormData fdKeys = new FormData();
        fdKeys.top = new FormAttachment((Control)wlKeys, margin);
        fdKeys.left = new FormAttachment(0, 0);
        fdKeys.bottom = new FormAttachment((Control)wbKeys, -margin);
        fdKeys.right = new FormAttachment(50, -margin);
        this.wKeys.setLayoutData((Object)fdKeys);
        Label wlValues = new Label((Composite)this.shell, 0);
        wlValues.setText(BaseMessages.getString(PKG, (String)"MergeRowsDialog.Values.Label", (String[])new String[0]));
        this.props.setLook((Control)wlValues);
        FormData fdlValues = new FormData();
        fdlValues.left = new FormAttachment(50, 0);
        fdlValues.top = new FormAttachment((Control)this.wFlagField, margin);
        wlValues.setLayoutData((Object)fdlValues);
        int nrValueRows = this.input.getValueFields() != null ? this.input.getValueFields().length : 1;
        ColumnInfo[] ciValues = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MergeRowsDialog.ColumnInfo.ValueField", (String[])new String[0]), 1, false)};
        this.wValues = new TableView(this.variables, (Composite)this.shell, 68354, ciValues, nrValueRows, lsMod, this.props);
        FormData fdValues = new FormData();
        fdValues.top = new FormAttachment((Control)wlValues, margin);
        fdValues.left = new FormAttachment(50, 0);
        fdValues.bottom = new FormAttachment((Control)wbValues, -margin);
        fdValues.right = new FormAttachment(100, 0);
        this.wValues.setLayoutData((Object)fdValues);
        this.getData();
        this.input.setChanged(this.backupChanged);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        TableItem item;
        int i;
        List infoStreams = this.input.getTransformIOMeta().getInfoStreams();
        this.wReference.setText(Const.NVL((String)((IStream)infoStreams.get(0)).getTransformName(), (String)""));
        this.wCompare.setText(Const.NVL((String)((IStream)infoStreams.get(1)).getTransformName(), (String)""));
        if (this.input.getFlagField() != null) {
            this.wFlagField.setText(this.input.getFlagField());
        }
        for (i = 0; i < this.input.getKeyFields().length; ++i) {
            item = this.wKeys.table.getItem(i);
            if (this.input.getKeyFields()[i] == null) continue;
            item.setText(1, this.input.getKeyFields()[i]);
        }
        for (i = 0; i < this.input.getValueFields().length; ++i) {
            item = this.wValues.table.getItem(i);
            if (this.input.getValueFields()[i] == null) continue;
            item.setText(1, this.input.getValueFields()[i]);
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        List infoStreams = this.input.getTransformIOMeta().getInfoStreams();
        ((IStream)infoStreams.get(0)).setTransformMeta(this.pipelineMeta.findTransform(this.wReference.getText()));
        ((IStream)infoStreams.get(1)).setTransformMeta(this.pipelineMeta.findTransform(this.wCompare.getText()));
        this.input.setFlagField(this.wFlagField.getText());
        int nrKeys = this.wKeys.nrNonEmpty();
        int nrValues = this.wValues.nrNonEmpty();
        this.input.allocate(nrKeys, nrValues);
        for (i = 0; i < nrKeys; ++i) {
            item = this.wKeys.getNonEmpty(i);
            this.input.getKeyFields()[i] = item.getText(1);
        }
        for (i = 0; i < nrValues; ++i) {
            item = this.wValues.getNonEmpty(i);
            this.input.getValueFields()[i] = item.getText(1);
        }
        this.transformName = this.wTransformName.getText();
        if (nrKeys > 0 && "Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"MergeRowsDialog.MergeRowsWarningDialog.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MergeRowsDialog.MergeRowsWarningDialog.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 8, new String[]{BaseMessages.getString(PKG, (String)"MergeRowsDialog.MergeRowsWarningDialog.Option1", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"MergeRowsDialog.MergeRowsWarningDialog.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y")));
            md.open();
            this.props.setCustomParameter(STRING_SORT_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
        }
        this.dispose();
    }

    private void getKeys() {
        try {
            IRowMeta prev;
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.wReference.getText());
            if (transformMeta != null && (prev = this.pipelineMeta.getTransformFields(this.variables, transformMeta)) != null) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)prev, (TableView)this.wKeys, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MergeRowsDialog.ErrorGettingFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MergeRowsDialog.ErrorGettingFields.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void getValues() {
        try {
            IRowMeta prev;
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.wReference.getText());
            if (transformMeta != null && (prev = this.pipelineMeta.getTransformFields(this.variables, transformMeta)) != null) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)prev, (TableView)this.wValues, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MergeRowsDialog.ErrorGettingFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MergeRowsDialog.ErrorGettingFields.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }
}

