/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mergerows;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopRowException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.mergerows.MergeRows;
import org.apache.hop.pipeline.transforms.mergerows.MergeRowsData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="MergeRows.Injection.")
@Transform(id="MergeRows", image="mergerows.svg", name="i18n::MergeRows.Name", description="i18n::MergeRows.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Joins", keywords={"i18n::MergeRowsMeta.keyword"}, documentationUrl="/pipeline/transforms/mergerows.html")
public class MergeRowsMeta
extends BaseTransformMeta<MergeRows, MergeRowsData> {
    private static final Class<?> PKG = MergeRowsMeta.class;
    @Injection(name="FLAG_FIELD")
    private String flagField;
    @Injection(name="KEY_FIELDS")
    private String[] keyFields;
    @Injection(name="VALUE_FIELDS")
    private String[] valueFields;

    public String[] getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(String[] keyFields) {
        this.keyFields = keyFields;
    }

    public String[] getValueFields() {
        return this.valueFields;
    }

    public void setValueFields(String[] valueFields) {
        this.valueFields = valueFields;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public String getFlagField() {
        return this.flagField;
    }

    public void setFlagField(String flagField) {
        this.flagField = flagField;
    }

    public void allocate(int nrKeys, int nrValues) {
        this.keyFields = new String[nrKeys];
        this.valueFields = new String[nrValues];
    }

    public Object clone() {
        MergeRowsMeta retval = (MergeRowsMeta)((Object)super.clone());
        int nrKeys = this.keyFields.length;
        int nrValues = this.valueFields.length;
        retval.allocate(nrKeys, nrValues);
        System.arraycopy(this.keyFields, 0, retval.keyFields, 0, nrKeys);
        System.arraycopy(this.valueFields, 0, retval.valueFields, 0, nrValues);
        return retval;
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder();
        retval.append("    <keys>" + Const.CR);
        for (i = 0; i < this.keyFields.length; ++i) {
            retval.append("      " + XmlHandler.addTagValue((String)"key", (String)this.keyFields[i]));
        }
        retval.append("    </keys>" + Const.CR);
        retval.append("    <values>" + Const.CR);
        for (i = 0; i < this.valueFields.length; ++i) {
            retval.append("      " + XmlHandler.addTagValue((String)"value", (String)this.valueFields[i]));
        }
        retval.append("    </values>" + Const.CR);
        retval.append(XmlHandler.addTagValue((String)"flag_field", (String)this.flagField));
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        retval.append(XmlHandler.addTagValue((String)"reference", (String)((IStream)infoStreams.get(0)).getTransformName()));
        retval.append(XmlHandler.addTagValue((String)"compare", (String)((IStream)infoStreams.get(1)).getTransformName()));
        retval.append("    <compare>" + Const.CR);
        retval.append("    </compare>" + Const.CR);
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            int i;
            Node keysnode = XmlHandler.getSubNode((Node)transformNode, (String)"keys");
            Node valuesnode = XmlHandler.getSubNode((Node)transformNode, (String)"values");
            int nrKeys = XmlHandler.countNodes((Node)keysnode, (String)"key");
            int nrValues = XmlHandler.countNodes((Node)valuesnode, (String)"value");
            this.allocate(nrKeys, nrValues);
            for (i = 0; i < nrKeys; ++i) {
                Node keynode = XmlHandler.getSubNodeByNr((Node)keysnode, (String)"key", (int)i);
                this.keyFields[i] = XmlHandler.getNodeValue((Node)keynode);
            }
            for (i = 0; i < nrValues; ++i) {
                Node valuenode = XmlHandler.getSubNodeByNr((Node)valuesnode, (String)"value", (int)i);
                this.valueFields[i] = XmlHandler.getNodeValue((Node)valuenode);
            }
            this.flagField = XmlHandler.getTagValue((Node)transformNode, (String)"flag_field");
            List infoStreams = this.getTransformIOMeta().getInfoStreams();
            IStream referenceStream = (IStream)infoStreams.get(0);
            IStream compareStream = (IStream)infoStreams.get(1);
            compareStream.setSubject(XmlHandler.getTagValue((Node)transformNode, (String)"compare"));
            referenceStream.setSubject(XmlHandler.getTagValue((Node)transformNode, (String)"reference"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"MergeRowsMeta.Exception.UnableToLoadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.flagField = "flagfield";
        this.allocate(0, 0);
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        for (IStream stream : infoStreams) {
            stream.setTransformMeta(TransformMeta.findTransform(transforms, (String)stream.getSubject()));
        }
    }

    public boolean chosesTargetTransforms() {
        return false;
    }

    public String[] getTargetTransforms() {
        return null;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (info != null) {
            boolean found = false;
            for (int i = 0; i < info.length && !found; ++i) {
                if (info[i] == null) continue;
                r.mergeRowMeta(info[i], name);
                found = true;
            }
        }
        if (Utils.isEmpty((CharSequence)this.flagField)) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"MergeRowsMeta.Exception.FlagFieldNotSpecified", (String[])new String[0]));
        }
        ValueMetaString flagFieldValue = new ValueMetaString(this.flagField);
        flagFieldValue.setOrigin(name);
        r.addValueMeta((IValueMeta)flagFieldValue);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        IStream referenceStream = (IStream)infoStreams.get(0);
        IStream compareStream = (IStream)infoStreams.get(1);
        if (referenceStream.getTransformName() != null && compareStream.getTransformName() != null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MergeRowsMeta.CheckResult.SourceTransformsOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else if (referenceStream.getTransformName() == null && compareStream.getTransformName() == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MergeRowsMeta.CheckResult.SourceTransformsMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MergeRowsMeta.CheckResult.OneSourceTransformMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        IRowMeta referenceRowMeta = null;
        IRowMeta compareRowMeta = null;
        try {
            referenceRowMeta = pipelineMeta.getPrevTransformFields(variables, referenceStream.getTransformName());
            compareRowMeta = pipelineMeta.getPrevTransformFields(variables, compareStream.getTransformName());
        }
        catch (HopTransformException kse) {
            new CheckResult(4, BaseMessages.getString(PKG, (String)"MergeRowsMeta.CheckResult.ErrorGettingPrevTransformFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
        }
        if (referenceRowMeta != null && compareRowMeta != null) {
            boolean rowsMatch = false;
            try {
                MergeRows.checkInputLayoutValid(referenceRowMeta, compareRowMeta);
                rowsMatch = true;
            }
            catch (HopRowException kre) {
                rowsMatch = false;
            }
            if (rowsMatch) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MergeRowsMeta.CheckResult.RowDefinitionMatch", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MergeRowsMeta.CheckResult.RowDefinitionNotMatch", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"MergeRowsMeta.InfoStream.FirstStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"MergeRowsMeta.InfoStream.SecondStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void resetTransformIoMeta() {
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }
}

