/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ProfileTokenVault;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import com.ibm.as400.security.auth.ProfileTokenProvider;
import java.io.Serializable;

class ManagedProfileTokenVault
extends ProfileTokenVault
implements Cloneable,
Serializable {
    private static final int REFRESH_TOKEN_EVERY_TIME = -1;
    private static final int MIN_TOKEN_REFRESH_TIME_INTERVAL = 30;
    private static final int MAX_TOKEN_REFRESH_TIME_INTERVAL = 3540;
    private ProfileTokenProvider tokenProvider_;
    private ProfileTokenCredential profileToken_;
    private int refreshThreshold_;

    protected ManagedProfileTokenVault(ProfileTokenProvider profileTokenProvider) {
        this(profileTokenProvider, -1);
    }

    protected ManagedProfileTokenVault(ProfileTokenProvider profileTokenProvider, int n) {
        try {
            this.profileToken_ = profileTokenProvider.create();
            this.encodedCredential_ = this.store(this.profileToken_.getToken());
            this.initRefreshThreshold(n == -1 ? this.profileToken_.getTimeoutInterval() / 2 : n);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Error while created ManagedProfileTokenVault.", (Throwable)aS400SecurityException);
        }
        this.tokenProvider_ = profileTokenProvider;
    }

    private ManagedProfileTokenVault() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        ManagedProfileTokenVault managedProfileTokenVault = (ManagedProfileTokenVault)super.clone();
        ManagedProfileTokenVault managedProfileTokenVault2 = this;
        synchronized (managedProfileTokenVault2) {
            managedProfileTokenVault.refreshThreshold_ = this.refreshThreshold_;
            managedProfileTokenVault.tokenProvider_ = this.tokenProvider_;
            try {
                ProfileTokenCredential profileTokenCredential;
                managedProfileTokenVault.profileToken_ = profileTokenCredential = this.tokenProvider_.create();
                managedProfileTokenVault.encodedCredential_ = this.store(profileTokenCredential.getToken());
            }
            catch (AS400SecurityException aS400SecurityException) {
                Trace.log(2, "Error while cloning ManagedProfileTokenVault.", (Throwable)aS400SecurityException);
            }
            return managedProfileTokenVault;
        }
    }

    protected synchronized void empty() {
        super.empty();
        this.disposeOfToken();
    }

    protected synchronized byte[] getClearCredential() {
        if (this.isEmpty()) {
            this.buildToken();
            return this.resolve(this.encodedCredential_);
        }
        if (!this.profileToken_.isCurrent()) {
            this.buildToken();
            return this.resolve(this.encodedCredential_);
        }
        try {
            if (this.isTimeForRefresh() && this.profileToken_.isRenewable()) {
                this.profileToken_.refresh();
                this.encodedCredential_ = this.store(this.profileToken_.getToken());
            }
        }
        catch (Exception exception) {
            if (Trace.traceOn_) {
                Trace.log(1, "Error while refreshing profile token.", (Throwable)exception);
            }
            this.buildToken();
        }
        return this.resolve(this.encodedCredential_);
    }

    protected synchronized void forceRefresh() {
        if (this.isEmpty() || !this.profileToken_.isRenewable()) {
            this.buildToken();
            return;
        }
        try {
            this.profileToken_.refresh();
            this.encodedCredential_ = this.store(this.profileToken_.getToken());
        }
        catch (Exception exception) {
            if (Trace.traceOn_) {
                Trace.log(1, "Error while forcefully refreshing profile token.", (Throwable)exception);
            }
            this.buildToken();
        }
    }

    protected synchronized boolean isEmpty() {
        boolean bl = super.isEmpty();
        if (bl && this.profileToken_ != null) {
            throw new IllegalStateException("Credential vault is empty, but profile token is not null");
        }
        return bl;
    }

    private void initRefreshThreshold(int n) {
        if (n < 30 || n > 3540) {
            throw new IllegalArgumentException("Refresh threshold must between 30 and 3540 seconds");
        }
        this.refreshThreshold_ = n;
    }

    private void buildToken() {
        try {
            this.disposeOfToken();
            this.profileToken_ = this.tokenProvider_.create();
            this.encodedCredential_ = this.store(this.profileToken_.getToken());
        }
        catch (Exception exception) {
            if (Trace.traceOn_) {
                Trace.log(1, "Error while building profile token.", (Throwable)exception);
            }
            this.disposeOfToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeOfToken() {
        try {
            if (this.profileToken_ != null) {
                this.profileToken_.destroy();
            }
        }
        catch (Exception exception) {
            Trace.log(2, "Error while disposing of profile token.", (Throwable)exception);
        }
        finally {
            this.profileToken_ = null;
            this.encodedCredential_ = null;
        }
    }

    private boolean isTimeForRefresh() throws AS400SecurityException {
        if (this.refreshThreshold_ == -1) {
            return true;
        }
        if (this.profileToken_ == null) {
            return true;
        }
        return this.profileToken_.getTimeToExpiration() < this.refreshThreshold_;
    }
}

