/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.flattener;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.flattener.Flattener;
import org.apache.hop.pipeline.transforms.flattener.FlattenerData;
import org.w3c.dom.Node;

@Transform(id="Flattener,Flatterner", image="flattener.svg", name="i18n::RowFlattener.Name", description="i18n::RowFlattener.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::FlattenerMeta.keyword"}, documentationUrl="/pipeline/transforms/rowflattener.html")
public class FlattenerMeta
extends BaseTransformMeta<Flattener, FlattenerData> {
    private static final Class<?> PKG = FlattenerMeta.class;
    private String fieldName;
    private String[] targetField;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getTargetField() {
        return this.targetField;
    }

    public void setTargetField(String[] targetField) {
        this.targetField = targetField;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int nrFields) {
        this.targetField = new String[nrFields];
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void setDefault() {
        int nrFields = 0;
        this.allocate(nrFields);
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.fieldName != null && this.fieldName.length() > 0) {
            int idx = row.indexOfValue(this.fieldName);
            if (idx < 0) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"FlattenerMeta.Exception.UnableToLocateFieldInInputFields", (String[])new String[]{this.fieldName}));
            }
            IValueMeta v = row.getValueMeta(idx);
            row.removeValueMeta(idx);
            for (int i = 0; i < this.targetField.length; ++i) {
                IValueMeta value = v.clone();
                value.setName(this.targetField[i]);
                value.setOrigin(name);
                row.addValueMeta(value);
            }
        } else {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"FlattenerMeta.Exception.FlattenFieldRequired", (String[])new String[0]));
        }
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.fieldName = XmlHandler.getTagValue((Node)transformNode, (String)"field_name");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.targetField[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"FlattenerMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("      " + XmlHandler.addTagValue((String)"field_name", (String)this.fieldName));
        retval.append("      <fields>" + Const.CR);
        for (int i = 0; i < this.targetField.length; ++i) {
            retval.append("        <field>" + Const.CR);
            retval.append("          " + XmlHandler.addTagValue((String)"name", (String)this.targetField[i]));
            retval.append("          </field>" + Const.CR);
        }
        retval.append("        </fields>" + Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FlattenerMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FlattenerMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }
}

