/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.datastore.v1.Entity;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.Value;
import com.google.datastore.v1.client.DatastoreHelper;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowToEntity
extends PTransform<PCollection<Row>, PCollection<Entity>> {
    private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized String> keySupplier;
    private final @UnknownKeyFor @NonNull @Initialized String kind;
    private final @UnknownKeyFor @NonNull @Initialized String keyField;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(RowToEntity.class);

    private RowToEntity(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized String> keySupplier, @UnknownKeyFor @NonNull @Initialized String kind, @UnknownKeyFor @NonNull @Initialized String keyField) {
        this.keySupplier = keySupplier;
        this.kind = kind;
        this.keyField = keyField;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Entity> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
        boolean isFieldPresent = input.getSchema().getFieldNames().contains(this.keyField);
        if (isFieldPresent) {
            if (!input.getSchema().getField(this.keyField).getType().getTypeName().equals((Object)Schema.TypeName.BYTES)) {
                throw new IllegalStateException("Field `" + this.keyField + "` should of type `VARBINARY`. Please change the type or specify a field to write the KEY value from via TableProperties.");
            }
            LOG.info("Field to use as Entity KEY is set to: `" + this.keyField + "`.");
        }
        return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new RowToEntityConverter(isFieldPresent)));
    }

    public static @UnknownKeyFor @NonNull @Initialized RowToEntity create(@UnknownKeyFor @NonNull @Initialized String keyField, @UnknownKeyFor @NonNull @Initialized String kind) {
        return new RowToEntity((Supplier<String> & Serializable)() -> UUID.randomUUID().toString(), kind, keyField);
    }

    public static @UnknownKeyFor @NonNull @Initialized RowToEntity createTest(@UnknownKeyFor @NonNull @Initialized String keyString, @UnknownKeyFor @NonNull @Initialized String keyField, @UnknownKeyFor @NonNull @Initialized String kind) {
        return new RowToEntity((Supplier<String> & Serializable)() -> keyString, kind, keyField);
    }

    class RowToEntityConverter
    extends DoFn<Row, Entity> {
        private final @UnknownKeyFor @NonNull @Initialized boolean useNonRandomKey;

        RowToEntityConverter(boolean useNonRandomKey) {
            this.useNonRandomKey = useNonRandomKey;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            Row row = (Row)context.element();
            Schema schemaWithoutKeyField = Schema.builder().addFields(row.getSchema().getFields().stream().filter(field -> !field.getName().equals(RowToEntity.this.keyField)).collect(Collectors.toList())).build();
            Entity.Builder entityBuilder = this.constructEntityFromRow(schemaWithoutKeyField, row);
            entityBuilder.setKey(this.constructKeyFromRow(row));
            context.output((Object)entityBuilder.build());
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Entity.Builder constructEntityFromRow(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Row row) {
            Entity.Builder entityBuilder = Entity.newBuilder();
            for (Schema.Field field : schema.getFields()) {
                Value val = this.mapObjectToValue(row.getValue(field.getName()));
                entityBuilder.putProperties(field.getName(), val);
            }
            return entityBuilder;
        }

        private @UnknownKeyFor @NonNull @Initialized Key constructKeyFromRow(@UnknownKeyFor @NonNull @Initialized Row row) {
            if (!this.useNonRandomKey) {
                return DatastoreHelper.makeKey((Object[])new Object[]{RowToEntity.this.kind, RowToEntity.this.keySupplier.get()}).build();
            }
            byte[] keyBytes = row.getBytes(RowToEntity.this.keyField);
            try {
                return Key.parseFrom((byte[])keyBytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException("Failed to parse DataStore key from bytes.");
            }
        }

        private @UnknownKeyFor @NonNull @Initialized Value mapObjectToValue(@UnknownKeyFor @NonNull @Initialized Object value) {
            if (value == null) {
                return Value.newBuilder().build();
            }
            if (Boolean.class.equals(value.getClass())) {
                return DatastoreHelper.makeValue((boolean)((Boolean)value)).build();
            }
            if (Byte.class.equals(value.getClass())) {
                return DatastoreHelper.makeValue((long)((Byte)value).byteValue()).build();
            }
            if (Long.class.equals(value.getClass())) {
                return DatastoreHelper.makeValue((long)((Long)value)).build();
            }
            if (Short.class.equals(value.getClass())) {
                return DatastoreHelper.makeValue((long)((Short)value).shortValue()).build();
            }
            if (Integer.class.equals(value.getClass())) {
                return DatastoreHelper.makeValue((long)((Integer)value).intValue()).build();
            }
            if (Double.class.equals(value.getClass())) {
                return DatastoreHelper.makeValue((double)((Double)value)).build();
            }
            if (Float.class.equals(value.getClass())) {
                return DatastoreHelper.makeValue((double)((Float)value).floatValue()).build();
            }
            if (String.class.equals(value.getClass())) {
                return DatastoreHelper.makeValue((String)((String)value)).build();
            }
            if (Instant.class.equals(value.getClass())) {
                return DatastoreHelper.makeValue((Date)((Instant)value).toDate()).build();
            }
            if (byte[].class.equals(value.getClass())) {
                return DatastoreHelper.makeValue((ByteString)ByteString.copyFrom((byte[])((byte[])value))).build();
            }
            if (value instanceof Row) {
                Row row = (Row)value;
                return DatastoreHelper.makeValue((Entity.Builder)this.constructEntityFromRow(row.getSchema(), row)).build();
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                List arrayValues = collection.stream().map(this::mapObjectToValue).collect(Collectors.toList());
                return DatastoreHelper.makeValue(arrayValues).build();
            }
            throw new IllegalStateException("No conversion exists from type: " + value.getClass() + " to DataStove Value.");
        }
    }
}

