/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchemaRetrievalException;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSourceDef;
import org.apache.beam.sdk.io.gcp.spanner.StructUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SpannerQuerySourceDef
implements SpannerSourceDef {
    private final @UnknownKeyFor @NonNull @Initialized SpannerConfig config;
    private final @UnknownKeyFor @NonNull @Initialized Statement query;

    static @UnknownKeyFor @NonNull @Initialized SpannerQuerySourceDef create(@UnknownKeyFor @NonNull @Initialized SpannerConfig config, @UnknownKeyFor @NonNull @Initialized Statement query) {
        return new SpannerQuerySourceDef(config, query);
    }

    private SpannerQuerySourceDef(@UnknownKeyFor @NonNull @Initialized SpannerConfig config, @UnknownKeyFor @NonNull @Initialized Statement query) {
        this.config = config;
        this.query = query;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema getBeamSchema() {
        Schema beamSchema;
        try (SpannerAccessor spannerAccessor = SpannerAccessor.getOrCreate(this.config);
             ReadContext readContext = spannerAccessor.getDatabaseClient().singleUse();){
            ResultSet result = readContext.analyzeQuery(this.query, ReadContext.QueryAnalyzeMode.PLAN);
            result.next();
            beamSchema = StructUtils.structTypeToBeamRowSchema(result.getMetadata().getRowType(), true);
        }
        catch (Exception e) {
            throw new SpannerSchemaRetrievalException("Exception while trying to retrieve schema", e);
        }
        return beamSchema;
    }
}

