/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

class DBCellRenderer
extends DefaultTableCellRenderer {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";

    public DBCellRenderer() {
        this(2);
    }

    public DBCellRenderer(int horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
        this.setBorder(new EmptyBorder(0, 5, 0, 5));
    }

    String getHexDigits(byte[] data) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int leftDigitValue = data[i] >>> 4 & 0xF;
            int rightDigitValue = data[i] & 0xF;
            char rightDigit = rightDigitValue < 10 ? (char)(48 + rightDigitValue) : (char)(rightDigitValue - 10 + 65);
            char leftDigit = leftDigitValue < 10 ? (char)(48 + leftDigitValue) : (char)(leftDigitValue - 10 + 65);
            result.append(leftDigit);
            result.append(rightDigit);
        }
        return result.toString();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int rowIndex, int columnIndex) {
        String v = this.getText(value);
        this.setText(v);
        return super.getTableCellRendererComponent(table, v, selected, hasFocus, rowIndex, columnIndex);
    }

    public String getText(Object value) {
        if (value == null) {
            return "-";
        }
        if (value instanceof byte[]) {
            return this.getHexDigits((byte[])value);
        }
        return value.toString();
    }
}

