/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class SqlStatementsDialog
extends Dialog {
    private static final Class<?> PKG = SqlStatementsDialog.class;
    public static final ILoggingObject loggingObject = new SimpleLoggingObject("SQL Statements Dialog", LoggingObjectType.HOP_GUI, null);
    public static final String CONST_SQLSTATEMENT_DIALOG_ERROR_TITLE = "SQLStatementDialog.Error.Title";
    private final List<SqlStatement> stats;
    private TableView wFields;
    private Shell shell;
    private final PropsUi props;
    private Color red;
    private String transformName;
    private IVariables variables;

    public SqlStatementsDialog(Shell parent, IVariables variables, int style, List<SqlStatement> stats) {
        super(parent, style);
        this.stats = stats;
        this.props = PropsUi.getInstance();
        this.variables = variables;
        this.transformName = null;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.red = display.getSystemColor(3);
        this.shell = new Shell(parent, 3184);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageDatabase());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Title", (String[])new String[0]));
        int margin = PropsUi.getMargin();
        Button wExec = new Button((Composite)this.shell, 8);
        wExec.setText(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Button.ExecSQL", (String[])new String[0]));
        wExec.addListener(13, e -> this.exec());
        Button wEdit = new Button((Composite)this.shell, 8);
        wEdit.setText(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Button.EditTransform", (String[])new String[0]));
        wEdit.addListener(13, e -> this.edit());
        Button wView = new Button((Composite)this.shell, 8);
        wView.setText(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Button.ViewSql", (String[])new String[0]));
        wView.addListener(13, e -> this.view());
        Button wClose = new Button((Composite)this.shell, 8);
        wClose.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        wClose.addListener(13, e -> this.close());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wExec, wEdit, wView, wClose}, margin, null);
        int nrCols = 4;
        int nrRows = this.stats.size();
        ColumnInfo[] columns = new ColumnInfo[nrCols];
        columns[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SQLStatementDialog.TableCol.TransformName", (String[])new String[0]), 1, false, true);
        columns[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SQLStatementDialog.TableCol.Connection", (String[])new String[0]), 1, false, true);
        columns[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SQLStatementDialog.TableCol.SQL", (String[])new String[0]), 1, false, true);
        columns[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SQLStatementDialog.TableCol.Error", (String[])new String[0]), 1, false, true);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, columns, nrRows, true, null, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)wExec, -2 * margin);
        this.wFields.setLayoutData(fdFields);
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.exec(), c -> this.close());
        return this.transformName;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        for (int i = 0; i < this.stats.size(); ++i) {
            SqlStatement stat = this.stats.get(i);
            TableItem ti = this.wFields.table.getItem(i);
            String name = stat.getTransformName();
            DatabaseMeta dbinfo = stat.getDatabase();
            String sql = stat.getSql();
            String error = stat.getError();
            if (name != null) {
                ti.setText(1, name);
            }
            if (dbinfo != null) {
                ti.setText(2, dbinfo.getName());
            }
            if (sql != null) {
                ti.setText(3, sql);
            }
            if (error != null) {
                ti.setText(4, error);
            }
            Color col = ti.getBackground();
            if (stat.hasError()) {
                col = this.red;
            }
            ti.setBackground(col);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    private String getSql() {
        int i;
        StringBuilder sql = new StringBuilder();
        int[] idx = this.wFields.table.getSelectionIndices();
        if (idx.length == 0) {
            idx = new int[this.stats.size()];
            for (i = 0; i < this.stats.size(); ++i) {
                idx[i] = i;
            }
        }
        for (i = 0; i < idx.length; ++i) {
            SqlStatement stat = this.stats.get(idx[i]);
            DatabaseMeta di = stat.getDatabase();
            if (i > 0) {
                sql.append("-------------------------------------------------------------------------------------------").append(Const.CR);
            }
            sql.append(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Log.Transform", (String[])new String[]{stat.getTransformName()}));
            sql.append(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Log.Connection", (String[])new String[]{di != null ? di.getName() : BaseMessages.getString(PKG, (String)"SQLStatementDialog.Log.Undefined", (String[])new String[0])}));
            if (stat.hasSql()) {
                sql.append("-- SQL                  : ");
                sql.append(stat.getSql()).append(Const.CR);
            }
            if (!stat.hasError()) continue;
            sql.append(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Log.Error", (String[])new String[]{stat.getError()}));
        }
        return sql.toString();
    }

    private void view() {
        String sql = this.getSql();
        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"SQLStatementDialog.ViewSql.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SQLStatementDialog.ViewSql.Message", (String[])new String[0]), sql, true);
        etd.setReadOnly();
        etd.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec() {
        SqlStatement stat;
        int i;
        int[] idx = this.wFields.table.getSelectionIndices();
        if (idx.length == 0) {
            idx = new int[this.stats.size()];
            for (int i2 = 0; i2 < this.stats.size(); ++i2) {
                idx[i2] = i2;
            }
        }
        int errors = 0;
        for (i = 0; i < idx.length; ++i) {
            stat = this.stats.get(idx[i]);
            if (!stat.hasError()) continue;
            ++errors;
        }
        if (errors == 0) {
            for (i = 0; i < idx.length; ++i) {
                stat = this.stats.get(idx[i]);
                DatabaseMeta databaseMeta = stat.getDatabase();
                if (databaseMeta == null || stat.hasError()) continue;
                Database db = new Database(loggingObject, this.variables, databaseMeta);
                try {
                    db.connect();
                    try {
                        db.execStatements(stat.getSql());
                    }
                    catch (HopDatabaseException dbe) {
                        ++errors;
                        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_SQLSTATEMENT_DIALOG_ERROR_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)"SQLStatementDialog.Error.CouldNotExec", (String[])new String[]{stat.getSql()}), (Exception)((Object)dbe));
                    }
                    continue;
                }
                catch (HopDatabaseException dbe) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_SQLSTATEMENT_DIALOG_ERROR_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)"SQLStatementDialog.Error.CouldNotConnect", (String[])new String[]{databaseMeta == null ? "" : databaseMeta.getName()}), (Exception)((Object)dbe));
                    continue;
                }
                finally {
                    db.disconnect();
                }
            }
            if (errors == 0) {
                MessageBox mb = new MessageBox(this.shell, 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Success.Message", (String[])new String[]{Integer.toString(idx.length)}));
                mb.setText(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Success.Title", (String[])new String[0]));
                mb.open();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SQLStatementDialog.Error.Message", (String[])new String[]{Integer.toString(errors)}));
            mb.setText(BaseMessages.getString(PKG, (String)CONST_SQLSTATEMENT_DIALOG_ERROR_TITLE, (String[])new String[0]));
            mb.open();
        }
    }

    private void edit() {
        int idx = this.wFields.table.getSelectionIndex();
        if (idx >= 0) {
            this.transformName = this.wFields.table.getItem(idx).getText(1);
            this.dispose();
        } else {
            this.transformName = null;
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.OriginTransform.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.OriginTransform.Message", (String[])new String[0]));
            mb.open();
        }
    }

    private void close() {
        this.dispose();
    }
}

