/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.Serializable;
import java.util.Random;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashMultiset;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Multiset;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class TupleTag<@UnknownKeyFor V>
implements Serializable {
    static final @UnknownKeyFor @NonNull @Initialized Random RANDOM = new Random(0L);
    private static final @UnknownKeyFor @NonNull @Initialized Multiset<@UnknownKeyFor @NonNull @Initialized String> staticInits = HashMultiset.create();
    final @UnknownKeyFor @NonNull @Initialized String id;
    final @UnknownKeyFor @NonNull @Initialized boolean generated;

    public TupleTag() {
        this(TupleTag.genId(), true);
    }

    public TupleTag(@UnknownKeyFor @NonNull @Initialized String id) {
        this(id, false);
    }

    public @UnknownKeyFor @NonNull @Initialized String getId() {
        return this.id;
    }

    public @UnknownKeyFor @NonNull @Initialized String getOutName(@UnknownKeyFor @NonNull @Initialized int outIndex) {
        if (this.generated) {
            return "out" + outIndex;
        }
        return this.id;
    }

    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<V> getTypeDescriptor() {
        return new TypeDescriptor<V>(this.getClass()){};
    }

    static synchronized @UnknownKeyFor @NonNull @Initialized String genId() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement frame : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!"<clinit>".equals(frame.getMethodName())) continue;
            int counter = staticInits.add((Object)frame.getClassName(), 1);
            return frame.getClassName() + "#" + counter;
        }
        String nonce = Long.toHexString(RANDOM.nextLong());
        String caller = stackTrace.length >= 4 ? stackTrace[3].getClassName() + "." + stackTrace[3].getMethodName() + ":" + stackTrace[3].getLineNumber() : "unknown";
        return caller + "#" + nonce;
    }

    private TupleTag(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized boolean generated) {
        this.id = id;
        this.generated = generated;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object that) {
        if (that instanceof TupleTag) {
            return this.id.equals(((TupleTag)that).id);
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.id.hashCode();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "Tag<" + this.id + ">";
    }
}

