/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph.shortestpath;

import java.util.LinkedList;
import org.psjava.algo.graph.shortestpath.AllPairShortestPath;
import org.psjava.algo.graph.shortestpath.AllPairShortestPathResult;
import org.psjava.ds.graph.AllEdgeInGraph;
import org.psjava.ds.graph.DirectedWeightedEdge;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.map.MutableMap;
import org.psjava.ds.numbersystrem.AddableNumberSystem;
import org.psjava.goods.GoodMutableMapFactory;
import org.psjava.util.AssertStatus;
import org.psjava.util.Pair;

public class FloydWarshallAlgorithm {
    public static AllPairShortestPath getInstance() {
        return new AllPairShortestPath(){

            @Override
            public <V, W, E extends DirectedWeightedEdge<V, W>> AllPairShortestPathResult<V, W, E> calc(Graph<V, E> graph, AddableNumberSystem<W> ns) {
                MutableMap status = GoodMutableMapFactory.getInstance().create();
                for (Object v1 : graph.getVertices()) {
                    for (Object v2 : graph.getVertices()) {
                        status.add(Pair.create(v1, v2), new Status());
                    }
                }
                for (Object v : graph.getVertices()) {
                    ((Status)status.get(Pair.create(v, v))).distance = ns.getZero();
                }
                for (DirectedWeightedEdge edge : AllEdgeInGraph.wrap(graph)) {
                    Status s = (Status)status.get(Pair.create(edge.from(), edge.to()));
                    if (s.distance != null && ns.compare(s.distance, edge.weight()) <= 0) continue;
                    s.distance = edge.weight();
                    s.directEdge = edge;
                }
                for (Object k : graph.getVertices()) {
                    for (Object i : graph.getVertices()) {
                        for (Object j : graph.getVertices()) {
                            Status i2k = (Status)status.get(Pair.create(i, k));
                            Status k2j = (Status)status.get(Pair.create(k, j));
                            if (i2k.distance == null || k2j.distance == null) continue;
                            W newd = ns.add(i2k.distance, k2j.distance);
                            Status s = (Status)status.get(Pair.create(i, j));
                            if (s.distance != null && ns.compare(s.distance, newd) <= 0) continue;
                            s.distance = newd;
                            s.next = k;
                        }
                    }
                }
                for (Object k : graph.getVertices()) {
                    AssertStatus.assertTrue(!ns.isNegative(((Status)status.get(Pair.create(k, k))).distance), "contains negative cycle");
                }
                return FloydWarshallAlgorithm.createResult(status);
            }
        };
    }

    private static <V, W, E> AllPairShortestPathResult<V, W, E> createResult(final MutableMap<Pair<V, V>, Status<V, E, W>> status) {
        return new AllPairShortestPathResult<V, W, E>(){

            @Override
            public Iterable<E> getPath(V from, V to) {
                this.assertReachable(from, to);
                LinkedList list = new LinkedList();
                this.getPathRecursively(list, from, to);
                return list;
            }

            private void getPathRecursively(LinkedList<E> list, V from, V to) {
                if (!from.equals(to)) {
                    Status s = (Status)status.get(Pair.create(from, to));
                    if (s.next == null) {
                        list.add(s.directEdge);
                    } else {
                        this.getPathRecursively(list, from, s.next);
                        this.getPathRecursively(list, s.next, to);
                    }
                }
            }

            @Override
            public W getDistance(V from, V to) {
                this.assertReachable(from, to);
                return ((Status)status.get(Pair.create(from, to))).distance;
            }

            private void assertReachable(V from, V to) {
                AssertStatus.assertTrue(this.isReachable(from, to), "not reachable");
            }

            @Override
            public boolean isReachable(V from, V to) {
                Status s = (Status)status.getOrNull(Pair.create(from, to));
                AssertStatus.assertTrue(s != null, "not valid vertex");
                return s.distance != null;
            }
        };
    }

    private FloydWarshallAlgorithm() {
    }

    private static class Status<V, E, W> {
        W distance = null;
        V next = null;
        E directEdge = null;

        private Status() {
        }
    }
}

