/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageParser;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.ParsingException;

public class HttpParser
extends MessageParser {
    private int initialState;
    private int cs;
    private long position;
    private boolean finished;
    private byte[] buf = new byte[256];
    private int bufPos = 0;
    private int endOfText;
    private int major;
    private int minor;
    private int status;
    private String reason;
    private String method;
    private String target;
    private String name;
    private Map<String, List<String>> headerMap;
    private static final byte[] _http_actions = HttpParser.init__http_actions_0();
    private static final short[] _http_key_offsets = HttpParser.init__http_key_offsets_0();
    private static final char[] _http_trans_keys = HttpParser.init__http_trans_keys_0();
    private static final byte[] _http_single_lengths = HttpParser.init__http_single_lengths_0();
    private static final byte[] _http_range_lengths = HttpParser.init__http_range_lengths_0();
    private static final short[] _http_index_offsets = HttpParser.init__http_index_offsets_0();
    private static final byte[] _http_trans_targs = HttpParser.init__http_trans_targs_0();
    private static final byte[] _http_trans_actions = HttpParser.init__http_trans_actions_0();
    private static final byte[] _http_eof_actions = HttpParser.init__http_eof_actions_0();
    static final int http_start = 1;
    static final int http_first_final = 85;
    static final int http_error = 0;
    static final int http_en_http_request = 20;
    static final int http_en_http_response = 43;
    static final int http_en_http_request_lenient = 67;
    static final int http_en_http_response_lenient = 1;

    public HttpParser() {
        this.reset();
    }

    public void reset() {
        this.cs = 1;
        this.bufPos = 0;
        if (this.buf.length > 8192) {
            this.buf = new byte[256];
        }
        this.major = 0;
        this.minor = 0;
        this.status = 0;
        this.reason = null;
        this.method = null;
        this.target = null;
        this.name = null;
        this.headerMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        this.endOfText = 0;
        this.position = 0L;
        this.finished = false;
        this.cs = this.initialState;
    }

    public MessageHeaders headers() {
        return new MessageHeaders(this.headerMap);
    }

    public MessageVersion version() {
        return new MessageVersion("HTTP", this.major, this.minor);
    }

    public int status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public String target() {
        return this.target;
    }

    public String method() {
        return this.method;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isError() {
        return this.cs == 0;
    }

    public void strictRequest() {
        this.initialState = this.cs = 20;
    }

    public void strictResponse() {
        this.initialState = this.cs = 43;
    }

    public void lenientRequest() {
        this.initialState = this.cs = 67;
    }

    public void lenientResponse() {
        this.initialState = this.cs = 1;
    }

    /*
     * Unable to fully structure code
     */
    public void parse(ByteBuffer data) {
        if (data == null) {
            p = 0;
            pe = 0;
            eof = 0;
        } else {
            p = data.position();
            pe = data.limit();
            eof = -1;
        }
        _trans = 0;
        _goto_targ = 0;
        block26: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block26;
                    }
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block26;
                    }
                }
                case 1: {
                    _keys = HttpParser._http_key_offsets[this.cs];
                    _trans = HttpParser._http_index_offsets[this.cs];
                    _klen = HttpParser._http_single_lengths[this.cs];
                    if (_klen <= 0) ** GOTO lbl39
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if ((data.get(p) & 255) < HttpParser._http_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if ((data.get(p) & 255) > HttpParser._http_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl53
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl39:
                    // 2 sources

                    if ((_klen = HttpParser._http_range_lengths[this.cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if ((data.get(p) & 255) < HttpParser._http_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if ((data.get(p) & 255) > HttpParser._http_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl53
                        }
                        _trans += _klen;
                    }
lbl53:
                    // 5 sources

                    this.cs = HttpParser._http_trans_targs[_trans];
                    if (HttpParser._http_trans_actions[_trans] != 0) {
                        _acts = HttpParser._http_trans_actions[_trans];
                        _nacts = HttpParser._http_actions[_acts++];
                        while (_nacts-- > 0) {
                            switch (HttpParser._http_actions[_acts++]) {
                                case 0: {
                                    this.push(data.get(p));
                                    break;
                                }
                                case 1: {
                                    this.major = this.major * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 2: {
                                    this.minor = this.minor * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 3: {
                                    this.status = this.status * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 4: {
                                    this.endOfText = this.bufPos;
                                    break;
                                }
                                case 5: {
                                    this.method = new String(this.buf, 0, this.bufPos, StandardCharsets.US_ASCII);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 6: {
                                    this.reason = new String(this.buf, 0, this.bufPos, StandardCharsets.ISO_8859_1);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 7: {
                                    this.target = new String(this.buf, 0, this.bufPos, StandardCharsets.ISO_8859_1);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 8: {
                                    this.finished = true;
                                    ++p;
                                    _goto_targ = 5;
                                    continue block26;
                                }
                                case 9: {
                                    if (this.bufPos <= 0) break;
                                    this.bufPos = this.endOfText;
                                    this.push((byte)32);
                                    break;
                                }
                                case 10: {
                                    this.name = new String(this.buf, 0, this.bufPos, StandardCharsets.US_ASCII).trim();
                                    this.bufPos = 0;
                                    break;
                                }
                                case 11: {
                                    value = new String(this.buf, 0, this.endOfText, StandardCharsets.ISO_8859_1);
                                    this.headerMap.computeIfAbsent(this.name, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parse$0(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(value);
                                    this.bufPos = 0;
                                    this.endOfText = 0;
                                }
                            }
                        }
                    }
                }
                case 2: {
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block26;
                    }
                    if (++p != pe) {
                        _goto_targ = 1;
                        continue block26;
                    }
                }
                case 4: {
                    if (p != eof) break block26;
                    __acts = HttpParser._http_eof_actions[this.cs];
                    __nacts = HttpParser._http_actions[__acts++];
                    while (__nacts-- > 0) {
                        switch (HttpParser._http_actions[__acts++]) {
                            case 4: {
                                this.endOfText = this.bufPos;
                                break;
                            }
                            case 8: {
                                this.finished = true;
                                ++p;
                                _goto_targ = 5;
                                continue block26;
                            }
                            case 9: {
                                if (this.bufPos <= 0) break;
                                this.bufPos = this.endOfText;
                                this.push((byte)32);
                                break;
                            }
                            case 11: {
                                value = new String(this.buf, 0, this.endOfText, StandardCharsets.ISO_8859_1);
                                this.headerMap.computeIfAbsent(this.name, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parse$1(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(value);
                                this.bufPos = 0;
                                this.endOfText = 0;
                            }
                        }
                    }
                    break block26;
                }
            }
            break;
        }
        if (data != null) {
            this.position += (long)(p - data.position());
            data.position(p);
        }
    }

    public void parse(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        this.parse(channel, buffer, null);
    }

    void parse(ReadableByteChannel channel, ByteBuffer buffer, WritableByteChannel copyTo) throws IOException {
        block3: {
            int n;
            do {
                ByteBuffer copy = buffer.duplicate();
                long buffOffset = (long)buffer.position() - this.position;
                this.parse(buffer);
                if (copyTo != null) {
                    copy.limit(buffer.position());
                    copyTo.write(copy);
                }
                if (this.isFinished()) break block3;
                if (this.isError()) {
                    throw new ParsingException("invalid HTTP message at byte position " + this.position + ": " + HttpParser.getErrorContext(buffer.duplicate(), (int)(buffOffset + this.position), 40));
                }
                buffer.compact();
                n = channel.read(buffer);
                buffer.flip();
            } while (n >= 0);
            this.parse(null);
        }
    }

    private void push(byte b) {
        if (this.bufPos >= this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
        }
        this.buf[this.bufPos++] = b;
    }

    private static byte[] init__http_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 2, 4, 0, 2, 9, 0, 2, 11, 0, 2, 11, 8, 2, 11, 10, 3, 4, 11, 8, 3, 9, 11, 8};
    }

    private static short[] init__http_key_offsets_0() {
        return new short[]{0, 0, 1, 2, 3, 4, 5, 7, 9, 12, 14, 16, 19, 22, 26, 30, 32, 34, 41, 43, 44, 59, 75, 87, 100, 101, 102, 103, 104, 105, 107, 108, 110, 111, 112, 128, 129, 145, 152, 153, 171, 178, 185, 192, 193, 194, 195, 196, 197, 199, 200, 202, 203, 205, 207, 209, 210, 216, 217, 233, 234, 250, 257, 258, 276, 283, 290, 297, 312, 328, 331, 334, 337, 341, 345, 347, 349, 353, 354, 355, 356, 357, 359, 360, 362, 365, 370, 374, 378, 382, 387, 391, 391, 391, 391, 396, 400, 404, 408, 413, 417};
    }

    private static char[] init__http_trans_keys_0() {
        return new char[]{'H', 'T', 'T', 'P', '/', '0', '9', ' ', '.', ' ', '0', '9', '0', '9', '0', '9', '\n', '\r', ' ', '\n', '\r', ':', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '\n', '\r', '\n', '\r', '\t', '\n', '\r', ' ', '~', '\u0080', '\u00ff', '0', '9', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '!', '=', '_', '~', '$', ';', '?', 'Z', 'a', 'z', '\u0080', '\u00ff', ' ', '!', '=', '_', '~', '$', ';', '?', 'Z', 'a', 'z', '\u0080', '\u00ff', 'H', 'T', 'T', 'P', '/', '0', '9', '.', '0', '9', '\r', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '!', ':', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\n', '\t', '\r', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', 'H', 'T', 'T', 'P', '/', '0', '9', '.', '0', '9', ' ', '0', '9', '0', '9', '0', '9', ' ', '\t', '\r', ' ', '~', '\u0080', '\u00ff', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '!', ':', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\n', '\t', '\r', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '\r', ' ', '\n', '\r', ' ', '\n', '\r', ':', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '\n', '\r', '\n', '\r', '\n', '\r', ' ', 'H', 'T', 'T', 'P', '/', '0', '9', '.', '0', '9', '\n', '\r', ' ', '\t', '\n', '\r', ' ', ':', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', ':', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', ':', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', ':', '\t', '\n', '\r', ' ', '\u0000'};
    }

    private static byte[] init__http_single_lengths_0() {
        return new byte[]{0, 1, 1, 1, 1, 1, 0, 2, 1, 0, 0, 3, 3, 4, 4, 2, 2, 3, 0, 1, 3, 4, 4, 5, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 4, 1, 4, 3, 1, 6, 3, 3, 3, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 2, 1, 4, 1, 4, 3, 1, 6, 3, 3, 3, 3, 4, 3, 3, 3, 4, 4, 2, 2, 4, 1, 1, 1, 1, 0, 1, 0, 3, 5, 4, 4, 4, 5, 4, 0, 0, 0, 5, 4, 4, 4, 5, 4, 0};
    }

    private static byte[] init__http_range_lengths_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 2, 1, 0, 6, 6, 4, 4, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 6, 0, 6, 2, 0, 6, 2, 2, 2, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 2, 0, 6, 0, 6, 2, 0, 6, 2, 2, 2, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static short[] init__http_index_offsets_0() {
        return new short[]{0, 0, 2, 4, 6, 8, 10, 12, 15, 18, 20, 22, 26, 30, 35, 40, 43, 46, 52, 54, 56, 66, 77, 86, 96, 98, 100, 102, 104, 106, 108, 110, 112, 114, 116, 127, 129, 140, 146, 148, 161, 167, 173, 179, 181, 183, 185, 187, 189, 191, 193, 195, 197, 199, 201, 203, 205, 210, 212, 223, 225, 236, 242, 244, 257, 263, 269, 275, 285, 296, 300, 304, 308, 313, 318, 321, 324, 329, 331, 333, 335, 337, 339, 341, 343, 347, 353, 358, 363, 368, 374, 379, 380, 381, 382, 388, 393, 398, 403, 409, 414};
    }

    private static byte[] init__http_trans_targs_0() {
        return new byte[]{2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 18, 0, 8, 9, 0, 10, 0, 11, 0, 85, 16, 17, 0, 0, 0, 86, 12, 14, 89, 13, 14, 87, 14, 0, 14, 14, 87, 91, 15, 0, 85, 16, 0, 17, 85, 16, 17, 17, 0, 19, 0, 8, 0, 21, 21, 21, 21, 21, 21, 21, 21, 21, 0, 22, 21, 21, 21, 21, 21, 21, 21, 21, 21, 0, 23, 23, 23, 23, 23, 23, 23, 23, 0, 24, 23, 23, 23, 23, 23, 23, 23, 23, 0, 25, 0, 26, 0, 27, 0, 28, 0, 29, 0, 30, 0, 31, 0, 32, 0, 33, 0, 34, 0, 35, 36, 36, 36, 36, 36, 36, 36, 36, 36, 0, 92, 0, 36, 37, 36, 36, 36, 36, 36, 36, 36, 36, 0, 37, 38, 37, 41, 41, 0, 39, 0, 40, 35, 40, 36, 36, 36, 36, 36, 36, 36, 36, 36, 0, 40, 38, 40, 41, 41, 0, 42, 38, 42, 41, 41, 0, 42, 38, 42, 41, 41, 0, 44, 0, 45, 0, 46, 0, 47, 0, 48, 0, 49, 0, 50, 0, 51, 0, 52, 0, 53, 0, 54, 0, 55, 0, 56, 0, 56, 57, 56, 56, 0, 58, 0, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 0, 93, 0, 60, 61, 60, 60, 60, 60, 60, 60, 60, 60, 0, 61, 62, 61, 65, 65, 0, 63, 0, 64, 59, 64, 60, 60, 60, 60, 60, 60, 60, 60, 60, 0, 64, 62, 64, 65, 65, 0, 66, 62, 66, 65, 65, 0, 66, 62, 66, 65, 65, 0, 68, 68, 68, 68, 68, 68, 68, 68, 68, 0, 69, 68, 68, 68, 68, 68, 68, 68, 68, 68, 0, 0, 0, 69, 70, 94, 75, 76, 70, 0, 0, 95, 71, 73, 98, 72, 73, 96, 73, 0, 73, 73, 96, 100, 74, 0, 94, 75, 0, 94, 75, 76, 77, 0, 78, 0, 79, 0, 80, 0, 81, 0, 82, 0, 83, 0, 84, 0, 94, 75, 84, 0, 0, 91, 15, 0, 86, 12, 86, 89, 13, 86, 87, 88, 89, 13, 88, 87, 88, 89, 13, 88, 87, 90, 91, 15, 90, 86, 12, 90, 89, 13, 90, 87, 0, 0, 0, 0, 100, 74, 0, 95, 71, 95, 98, 72, 95, 96, 97, 98, 72, 97, 96, 97, 98, 72, 97, 96, 99, 100, 74, 99, 95, 71, 99, 98, 72, 99, 96, 0, 0};
    }

    private static byte[] init__http_trans_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 7, 0, 7, 0, 7, 0, 0, 0, 0, 0, 0, 0, 21, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 17, 0, 0, 0, 0, 0, 1, 13, 13, 1, 1, 0, 5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 15, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 17, 0, 1, 21, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 23, 0, 31, 31, 31, 31, 31, 31, 31, 31, 31, 0, 0, 19, 0, 28, 28, 0, 25, 9, 25, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 5, 0, 0, 0, 7, 0, 7, 0, 7, 0, 0, 0, 1, 13, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 17, 0, 1, 21, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 23, 0, 31, 31, 31, 31, 31, 31, 31, 31, 31, 0, 0, 19, 0, 28, 28, 0, 25, 9, 25, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 15, 15, 15, 1, 0, 0, 21, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 17, 0, 0, 21, 1, 0, 0, 1, 0, 1, 25, 9, 25, 25, 1, 1, 0, 1, 1, 1, 0, 34, 23, 0, 37, 31, 0, 19, 28, 0, 28, 0, 0, 0, 0, 17, 0, 0, 21, 1, 0, 0, 1, 0, 1, 25, 9, 25, 25, 1, 1, 0, 1, 1, 1, 0, 34, 23, 0, 37, 31, 0, 19, 28, 0, 28, 0, 0};
    }

    private static byte[] init__http_eof_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 34, 40, 34, 34, 44, 0, 0, 0, 17, 34, 40, 34, 34, 44, 0};
    }

    private static /* synthetic */ List lambda$parse$1(String n) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$parse$0(String n) {
        return new ArrayList();
    }
}

