/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.GroupSelector;
import com.dropbox.core.v2.team.IncludeMembersArg;
import com.dropbox.core.v2.teamcommon.GroupManagementType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class GroupUpdateArgs
extends IncludeMembersArg {
    @Nonnull
    protected final GroupSelector group;
    @Nullable
    protected final String newGroupName;
    @Nullable
    protected final String newGroupExternalId;
    @Nullable
    protected final GroupManagementType newGroupManagementType;

    public GroupUpdateArgs(@Nonnull GroupSelector group, boolean returnMembers, @Nullable String newGroupName, @Nullable String newGroupExternalId, @Nullable GroupManagementType newGroupManagementType) {
        super(returnMembers);
        if (group == null) {
            throw new IllegalArgumentException("Required value for 'group' is null");
        }
        this.group = group;
        this.newGroupName = newGroupName;
        this.newGroupExternalId = newGroupExternalId;
        this.newGroupManagementType = newGroupManagementType;
    }

    public GroupUpdateArgs(@Nonnull GroupSelector group) {
        this(group, true, null, null, null);
    }

    @Nonnull
    public GroupSelector getGroup() {
        return this.group;
    }

    @Override
    public boolean getReturnMembers() {
        return this.returnMembers;
    }

    @Nullable
    public String getNewGroupName() {
        return this.newGroupName;
    }

    @Nullable
    public String getNewGroupExternalId() {
        return this.newGroupExternalId;
    }

    @Nullable
    public GroupManagementType getNewGroupManagementType() {
        return this.newGroupManagementType;
    }

    public static Builder newBuilder(GroupSelector group) {
        return new Builder(group);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.group, this.newGroupName, this.newGroupExternalId, this.newGroupManagementType});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupUpdateArgs other = (GroupUpdateArgs)obj;
            return (this.group == other.group || this.group.equals(other.group)) && this.returnMembers == other.returnMembers && (this.newGroupName == other.newGroupName || this.newGroupName != null && this.newGroupName.equals(other.newGroupName)) && (this.newGroupExternalId == other.newGroupExternalId || this.newGroupExternalId != null && this.newGroupExternalId.equals(other.newGroupExternalId)) && (this.newGroupManagementType == other.newGroupManagementType || this.newGroupManagementType != null && this.newGroupManagementType.equals((Object)other.newGroupManagementType));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GroupUpdateArgs> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupUpdateArgs value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("group");
            GroupSelector.Serializer.INSTANCE.serialize(value.group, g);
            g.writeFieldName("return_members");
            StoneSerializers.boolean_().serialize((Boolean)value.returnMembers, g);
            if (value.newGroupName != null) {
                g.writeFieldName("new_group_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.newGroupName, g);
            }
            if (value.newGroupExternalId != null) {
                g.writeFieldName("new_group_external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.newGroupExternalId, g);
            }
            if (value.newGroupManagementType != null) {
                g.writeFieldName("new_group_management_type");
                StoneSerializers.nullable(GroupManagementType.Serializer.INSTANCE).serialize(value.newGroupManagementType, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GroupUpdateArgs deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            GroupManagementType f_newGroupManagementType;
            String f_newGroupExternalId;
            String f_newGroupName;
            Boolean f_returnMembers;
            GroupSelector f_group;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_group = null;
                f_returnMembers = true;
                f_newGroupName = null;
                f_newGroupExternalId = null;
                f_newGroupManagementType = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("group".equals(field)) {
                        f_group = GroupSelector.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("return_members".equals(field)) {
                        f_returnMembers = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("new_group_name".equals(field)) {
                        f_newGroupName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("new_group_external_id".equals(field)) {
                        f_newGroupExternalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("new_group_management_type".equals(field)) {
                        f_newGroupManagementType = StoneSerializers.nullable(GroupManagementType.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_group == null) {
                    throw new JsonParseException(p, "Required field \"group\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GroupUpdateArgs value = new GroupUpdateArgs(f_group, f_returnMembers, f_newGroupName, f_newGroupExternalId, f_newGroupManagementType);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final GroupSelector group;
        protected boolean returnMembers;
        protected String newGroupName;
        protected String newGroupExternalId;
        protected GroupManagementType newGroupManagementType;

        protected Builder(GroupSelector group) {
            if (group == null) {
                throw new IllegalArgumentException("Required value for 'group' is null");
            }
            this.group = group;
            this.returnMembers = true;
            this.newGroupName = null;
            this.newGroupExternalId = null;
            this.newGroupManagementType = null;
        }

        public Builder withReturnMembers(Boolean returnMembers) {
            this.returnMembers = returnMembers != null ? returnMembers : true;
            return this;
        }

        public Builder withNewGroupName(String newGroupName) {
            this.newGroupName = newGroupName;
            return this;
        }

        public Builder withNewGroupExternalId(String newGroupExternalId) {
            this.newGroupExternalId = newGroupExternalId;
            return this;
        }

        public Builder withNewGroupManagementType(GroupManagementType newGroupManagementType) {
            this.newGroupManagementType = newGroupManagementType;
            return this;
        }

        public GroupUpdateArgs build() {
            return new GroupUpdateArgs(this.group, this.returnMembers, this.newGroupName, this.newGroupExternalId, this.newGroupManagementType);
        }
    }
}

