/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.ignite.client.ClientOperationType;
import org.apache.ignite.client.IgniteClientConfiguration;
import org.apache.ignite.client.IgniteClientConnectionException;
import org.apache.ignite.client.RetryPolicy;
import org.apache.ignite.internal.client.ClientChannel;
import org.apache.ignite.internal.client.ClientChannelConfiguration;
import org.apache.ignite.internal.client.ClientChannelFactory;
import org.apache.ignite.internal.client.ClientFutureUtils;
import org.apache.ignite.internal.client.ClientMetricSource;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.HostAndPort;
import org.apache.ignite.internal.client.PayloadReader;
import org.apache.ignite.internal.client.PayloadWriter;
import org.apache.ignite.internal.client.RetryPolicyContextImpl;
import org.apache.ignite.internal.client.io.ClientConnectionMultiplexer;
import org.apache.ignite.internal.client.io.netty.NettyClientConnectionMultiplexer;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public final class ReliableChannel
implements AutoCloseable {
    private final ClientChannelFactory chFactory;
    private final ClientMetricSource metrics;
    private volatile List<ClientChannelHolder> channels;
    private volatile int defaultChIdx = -1;
    private final AtomicInteger curChIdx = new AtomicInteger();
    private final IgniteClientConfiguration clientCfg;
    private final Map<String, ClientChannelHolder> nodeChannelsByName = new ConcurrentHashMap<String, ClientChannelHolder>();
    private final AtomicBoolean scheduledChannelsReinit = new AtomicBoolean();
    private volatile boolean closed;
    private final ArrayList<Runnable> chFailLsnrs = new ArrayList();
    private final ReadWriteLock curChannelsGuard = new ReentrantReadWriteLock();
    private final ClientConnectionMultiplexer connMgr;
    private final IgniteLogger log;
    private volatile String[] prevHostAddrs;
    private final AtomicLong partitionAssignmentTimestamp = new AtomicLong();
    private final HybridTimestampTracker observableTimeTracker;
    private final AtomicReference<UUID> clusterId = new AtomicReference();
    @Nullable
    private ScheduledExecutorService streamerFlushExecutor;

    ReliableChannel(ClientChannelFactory chFactory, IgniteClientConfiguration clientCfg, ClientMetricSource metrics, HybridTimestampTracker observableTimeTracker) {
        this.clientCfg = Objects.requireNonNull(clientCfg, "clientCfg");
        this.chFactory = Objects.requireNonNull(chFactory, "chFactory");
        this.log = ClientUtils.logger(clientCfg, ReliableChannel.class);
        this.metrics = metrics;
        this.observableTimeTracker = Objects.requireNonNull(observableTimeTracker, "observableTime");
        this.connMgr = new NettyClientConnectionMultiplexer(metrics);
        this.connMgr.start(clientCfg);
    }

    @Override
    public synchronized void close() throws Exception {
        this.closed = true;
        List<ClientChannelHolder> holders = this.channels;
        ArrayList<ManuallyCloseable> closeables = new ArrayList<ManuallyCloseable>();
        if (holders != null) {
            for (ClientChannelHolder hld : holders) {
                closeables.add(hld::close);
            }
        }
        closeables.add(this.connMgr::stop);
        closeables.add(() -> IgniteUtils.shutdownAndAwaitTermination(this.streamerFlushExecutor, 10L, TimeUnit.SECONDS));
        IgniteUtils.closeAllManually(closeables);
    }

    public ClientMetricSource metrics() {
        return this.metrics;
    }

    public List<ClusterNode> connections() {
        ArrayList<ClusterNode> res = new ArrayList<ClusterNode>(this.channels.size());
        for (ClientChannelHolder holder : this.nodeChannelsByName.values()) {
            ClientChannel ch;
            CompletableFuture<ClientChannel> chFut = holder.chFut;
            if (chFut == null || (ch = ClientFutureUtils.getNowSafe(chFut)) == null || ch.closed()) continue;
            res.add(ch.protocolContext().clusterNode());
        }
        return res;
    }

    public IgniteClientConfiguration configuration() {
        return this.clientCfg;
    }

    public long observableTimestamp() {
        return HybridTimestamp.hybridTimestampToLong(this.observableTimeTracker.get());
    }

    public List<ClientChannel> channels() {
        ArrayList<ClientChannel> res = new ArrayList<ClientChannel>(this.channels.size());
        for (ClientChannelHolder holder : this.nodeChannelsByName.values()) {
            ClientChannel ch;
            CompletableFuture<ClientChannel> chFut = holder.chFut;
            if (chFut == null || (ch = ClientFutureUtils.getNowSafe(chFut)) == null || ch.closed()) continue;
            res.add(ch);
        }
        return res;
    }

    public <T> CompletableFuture<T> serviceAsync(int opCode, @Nullable PayloadWriter payloadWriter, @Nullable PayloadReader<T> payloadReader, @Nullable String preferredNodeName, @Nullable RetryPolicy retryPolicyOverride, boolean expectNotifications) {
        return ClientFutureUtils.doWithRetryAsync(() -> this.getChannelAsync(preferredNodeName).thenCompose(ch -> this.serviceAsyncInternal(opCode, payloadWriter, payloadReader, expectNotifications, (ClientChannel)ch)), null, ctx -> this.shouldRetry(opCode, (ClientFutureUtils.RetryContext)ctx, retryPolicyOverride));
    }

    public <T> CompletableFuture<T> serviceAsync(int opCode, PayloadWriter payloadWriter, @Nullable PayloadReader<T> payloadReader) {
        return this.serviceAsync(opCode, payloadWriter, payloadReader, null, null, false);
    }

    public <T> CompletableFuture<T> serviceAsync(int opCode, PayloadReader<T> payloadReader) {
        return this.serviceAsync(opCode, null, payloadReader, null, null, false);
    }

    private <T> CompletableFuture<T> serviceAsyncInternal(int opCode, @Nullable PayloadWriter payloadWriter, @Nullable PayloadReader<T> payloadReader, boolean expectNotifications, ClientChannel ch) {
        return ch.serviceAsync(opCode, payloadWriter, payloadReader, expectNotifications).whenComplete((res, err) -> {
            if (err != null && ReliableChannel.unwrapConnectionException(err) != null) {
                this.onChannelFailure(ch);
            }
        });
    }

    private CompletableFuture<ClientChannel> getChannelAsync(@Nullable String preferredNodeName) {
        ClientChannelHolder holder;
        if (preferredNodeName != null && (holder = this.nodeChannelsByName.get(preferredNodeName)) != null) {
            return holder.getOrCreateChannelAsync().thenCompose(ch -> {
                if (ch != null) {
                    return CompletableFuture.completedFuture(ch);
                }
                return this.getDefaultChannelAsync();
            });
        }
        ClientChannel nextCh = this.getNextChannelWithoutReconnect();
        if (nextCh != null) {
            return CompletableFuture.completedFuture(nextCh);
        }
        return this.getDefaultChannelAsync();
    }

    private static Map<InetSocketAddress, Integer> parsedAddresses(String[] addrs) {
        if (addrs == null || addrs.length == 0) {
            throw new IgniteException(ErrorGroups.Client.CONFIGURATION_ERR, "Empty addresses");
        }
        ArrayList<HostAndPort> ranges = new ArrayList<HostAndPort>(addrs.length);
        for (String a2 : addrs) {
            ranges.add(HostAndPort.parse(a2, 10800, "Failed to parse Ignite server address"));
        }
        return ranges.stream().map(p -> InetSocketAddress.createUnresolved(p.host(), p.port())).collect(Collectors.toMap(a -> a, a -> 1, Integer::sum));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollCurrentChannel(ClientChannelHolder hld) {
        this.curChannelsGuard.writeLock().lock();
        try {
            int idx = this.defaultChIdx;
            List<ClientChannelHolder> holders = this.channels;
            ClientChannelHolder dfltHld = holders.get(idx);
            if (dfltHld == hld) {
                this.defaultChIdx = ++idx >= holders.size() ? 0 : idx;
            }
        }
        finally {
            this.curChannelsGuard.writeLock().unlock();
        }
    }

    private void onChannelFailure(ClientChannel ch) {
        this.onChannelFailure(this.channels.get(this.defaultChIdx), ch);
    }

    private void onChannelFailure(ClientChannelHolder hld, @Nullable ClientChannel ch) {
        this.chFailLsnrs.forEach(Runnable::run);
        this.rollCurrentChannel(hld);
        if (this.scheduledChannelsReinit.get()) {
            this.channelsInitAsync();
        }
    }

    public void addChannelFailListener(Runnable chFailLsnr) {
        this.chFailLsnrs.add(chFailLsnr);
    }

    private boolean shouldStopChannelsReinit() {
        return this.scheduledChannelsReinit.get() || this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean initChannelHolders() {
        List<ClientChannelHolder> holders = this.channels;
        this.scheduledChannelsReinit.set(false);
        Map<InetSocketAddress, Integer> newAddrs = null;
        if (this.clientCfg.addressesFinder() != null) {
            Object[] hostAddrs = this.clientCfg.addressesFinder().getAddresses();
            if (hostAddrs.length == 0) {
                throw new IgniteException(ErrorGroups.Client.CONFIGURATION_ERR, "Empty addresses");
            }
            if (!Arrays.equals(hostAddrs, this.prevHostAddrs)) {
                newAddrs = ReliableChannel.parsedAddresses((String[])hostAddrs);
                this.prevHostAddrs = hostAddrs;
            }
        } else if (holders == null) {
            newAddrs = ReliableChannel.parsedAddresses(this.clientCfg.addresses());
        }
        if (newAddrs == null) {
            return true;
        }
        HashMap<InetSocketAddress, ClientChannelHolder> curAddrs = new HashMap<InetSocketAddress, ClientChannelHolder>();
        HashSet<InetSocketAddress> allAddrs = new HashSet<InetSocketAddress>(newAddrs.keySet());
        if (holders != null) {
            for (int i = 0; i < holders.size(); ++i) {
                ClientChannelHolder h2 = holders.get(i);
                curAddrs.put(h2.chCfg.getAddress(), h2);
                allAddrs.add(h2.chCfg.getAddress());
            }
        }
        ArrayList<ClientChannelHolder> reinitHolders = new ArrayList<ClientChannelHolder>();
        int dfltChannelIdx = -1;
        ClientChannelHolder currDfltHolder = null;
        int idx = this.defaultChIdx;
        if (idx != -1) {
            currDfltHolder = holders.get(idx);
        }
        for (InetSocketAddress addr : allAddrs) {
            int i;
            ClientChannelHolder hld;
            if (this.shouldStopChannelsReinit()) {
                return false;
            }
            if (!newAddrs.containsKey(addr)) {
                ((ClientChannelHolder)curAddrs.get(addr)).close();
                continue;
            }
            if (!curAddrs.containsKey(addr)) {
                hld = new ClientChannelHolder(new ClientChannelConfiguration(this.clientCfg, addr));
                for (i = 0; i < newAddrs.get(addr); ++i) {
                    reinitHolders.add(hld);
                }
                continue;
            }
            hld = (ClientChannelHolder)curAddrs.get(addr);
            for (i = 0; i < newAddrs.get(addr); ++i) {
                reinitHolders.add(hld);
            }
            if (hld != currDfltHolder) continue;
            dfltChannelIdx = reinitHolders.size() - 1;
        }
        if (dfltChannelIdx == -1) {
            dfltChannelIdx = 0;
        }
        this.curChannelsGuard.writeLock().lock();
        try {
            this.channels = reinitHolders;
            this.defaultChIdx = dfltChannelIdx;
        }
        finally {
            this.curChannelsGuard.writeLock().unlock();
        }
        return true;
    }

    CompletableFuture<ClientChannel> channelsInitAsync() {
        if (!this.initChannelHolders()) {
            return CompletableFutures.nullCompletedFuture();
        }
        CompletableFuture<ClientChannel> fut = this.getDefaultChannelAsync();
        fut.thenAccept(unused -> ForkJoinPool.commonPool().submit(this::initAllChannelsAsync));
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ClientChannel getNextChannelWithoutReconnect() {
        this.curChannelsGuard.readLock().lock();
        try {
            int startIdx = this.curChIdx.incrementAndGet();
            for (int i = 0; i < this.channels.size(); ++i) {
                ClientChannel ch;
                int nextIdx = Math.abs(startIdx + i) % this.channels.size();
                ClientChannelHolder hld = this.channels.get(nextIdx);
                ClientChannel clientChannel = ch = hld == null ? null : hld.getNow();
                if (ch == null) continue;
                ClientChannel clientChannel2 = ch;
                return clientChannel2;
            }
        }
        finally {
            this.curChannelsGuard.readLock().unlock();
        }
        return null;
    }

    private CompletableFuture<ClientChannel> getDefaultChannelAsync() {
        return ClientFutureUtils.doWithRetryAsync(() -> {
            ClientChannelHolder hld;
            this.curChannelsGuard.readLock().lock();
            try {
                hld = this.channels.get(this.defaultChIdx);
            }
            finally {
                this.curChannelsGuard.readLock().unlock();
            }
            return hld.getOrCreateChannelAsync();
        }, Objects::nonNull, ctx -> this.shouldRetry(ClientOperationType.CHANNEL_CONNECT, (ClientFutureUtils.RetryContext)ctx, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<ClientChannel> getCurChannelAsync() {
        if (this.closed) {
            return CompletableFuture.failedFuture(new IgniteClientConnectionException(ErrorGroups.Client.CONNECTION_ERR, "ReliableChannel is closed", null));
        }
        this.curChannelsGuard.readLock().lock();
        try {
            ClientChannelHolder hld = this.channels.get(this.defaultChIdx);
            if (hld == null) {
                CompletableFuture<ClientChannel> completableFuture = CompletableFutures.nullCompletedFuture();
                return completableFuture;
            }
            CompletableFuture<ClientChannel> fut = hld.getOrCreateChannelAsync();
            CompletableFuture<ClientChannel> completableFuture = fut == null ? CompletableFutures.nullCompletedFuture() : fut;
            return completableFuture;
        }
        finally {
            this.curChannelsGuard.readLock().unlock();
        }
    }

    private boolean shouldRetry(int opCode, ClientFutureUtils.RetryContext ctx, @Nullable RetryPolicy retryPolicyOverride) {
        ClientOperationType opType = ClientUtils.opCodeToClientOperationType(opCode);
        boolean res = this.shouldRetry(opType, ctx, retryPolicyOverride);
        if (this.log.isDebugEnabled()) {
            if (res) {
                this.log.debug("Retrying operation [opCode=" + opCode + ", opType=" + String.valueOf((Object)opType) + ", attempt=" + ctx.attempt + ", lastError=" + String.valueOf(ctx.lastError()) + "]", new Object[0]);
            } else {
                this.log.debug("Not retrying operation [opCode=" + opCode + ", opType=" + String.valueOf((Object)opType) + ", attempt=" + ctx.attempt + ", lastError=" + String.valueOf(ctx.lastError()) + "]", new Object[0]);
            }
        }
        if (res) {
            this.metrics.requestsRetriedIncrement();
        }
        return res;
    }

    private boolean shouldRetry(@Nullable ClientOperationType opType, ClientFutureUtils.RetryContext ctx, @Nullable RetryPolicy retryPolicyOverride) {
        RetryPolicy plc;
        Throwable err = ctx.lastError();
        if (err == null) {
            return opType == ClientOperationType.CHANNEL_CONNECT && ctx.attempt < 16;
        }
        IgniteClientConnectionException exception = ReliableChannel.unwrapConnectionException(err);
        if (exception == null) {
            return false;
        }
        if (exception.code() == ErrorGroups.Client.CLUSTER_ID_MISMATCH_ERR) {
            return false;
        }
        if (opType == null) {
            return ctx.attempt < 16;
        }
        RetryPolicy retryPolicy = plc = retryPolicyOverride != null ? retryPolicyOverride : this.clientCfg.retryPolicy();
        if (plc == null) {
            return false;
        }
        RetryPolicyContextImpl retryPolicyContext = new RetryPolicyContextImpl(this.clientCfg, opType, ctx.attempt, exception);
        return plc.shouldRetry(retryPolicyContext);
    }

    private void initAllChannelsAsync() {
        List<ClientChannelHolder> holders = this.channels;
        ArrayList<CompletableFuture<ClientChannel>> futs = new ArrayList<CompletableFuture<ClientChannel>>(holders.size());
        for (ClientChannelHolder hld : holders) {
            if (this.closed) {
                return;
            }
            try {
                futs.add(hld.getOrCreateChannelAsync());
            }
            catch (Exception e) {
                this.log.warn("Failed to establish connection to " + String.valueOf(hld.chCfg.getAddress()) + ": " + e.getMessage(), (Throwable)e);
            }
        }
        long interval = this.clientCfg.backgroundReconnectInterval();
        if (interval > 0L && !this.closed) {
            CompletableFuture.allOf((CompletableFuture[])futs.toArray(CompletableFuture[]::new)).whenCompleteAsync((res, err) -> this.initAllChannelsAsync(), CompletableFuture.delayedExecutor(interval, TimeUnit.MILLISECONDS));
        }
    }

    private void onObservableTimestampReceived(long newTs) {
        this.observableTimeTracker.update(HybridTimestamp.nullableHybridTimestamp(newTs));
    }

    private void onPartitionAssignmentChanged(long timestamp) {
        this.partitionAssignmentTimestamp.updateAndGet(curTs -> Math.max(curTs, timestamp));
    }

    public long partitionAssignmentTimestamp() {
        return this.partitionAssignmentTimestamp.get();
    }

    public synchronized ScheduledExecutorService streamerFlushExecutor() {
        if (this.streamerFlushExecutor == null) {
            this.streamerFlushExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("client-data-streamer-flush-" + this.hashCode(), ClientUtils.logger(this.clientCfg, ReliableChannel.class)));
        }
        return this.streamerFlushExecutor;
    }

    @Nullable
    private static IgniteClientConnectionException unwrapConnectionException(Throwable err) {
        if (!((err = ExceptionUtils.unwrapCause(err)) instanceof IgniteClientConnectionException)) {
            return null;
        }
        return (IgniteClientConnectionException)err;
    }

    class ClientChannelHolder {
        private final ClientChannelConfiguration chCfg;
        @Nullable
        private volatile CompletableFuture<ClientChannel> chFut;
        private volatile ClusterNode serverNode;
        private volatile boolean close;

        private ClientChannelHolder(ClientChannelConfiguration chCfg) {
            this.chCfg = chCfg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompletableFuture<ClientChannel> getOrCreateChannelAsync() {
            if (this.close) {
                return CompletableFutures.nullCompletedFuture();
            }
            CompletionStage<ClientChannel> chFut0 = this.chFut;
            if (this.isFutureInProgressOrDoneAndChannelOpen((CompletableFuture<ClientChannel>)chFut0)) {
                return chFut0;
            }
            ClientChannelHolder clientChannelHolder = this;
            synchronized (clientChannelHolder) {
                if (this.close) {
                    return CompletableFutures.nullCompletedFuture();
                }
                chFut0 = this.chFut;
                if (this.isFutureInProgressOrDoneAndChannelOpen((CompletableFuture<ClientChannel>)chFut0)) {
                    return chFut0;
                }
                CompletableFuture<ClientChannel> createFut = ReliableChannel.this.chFactory.create(this.chCfg, ReliableChannel.this.connMgr, ReliableChannel.this.metrics, x$0 -> ReliableChannel.this.onPartitionAssignmentChanged((long)x$0), x$0 -> ReliableChannel.this.onObservableTimestampReceived((long)x$0));
                chFut0 = createFut.thenApply(ch -> {
                    UUID currentClusterId = ch.protocolContext().clusterId();
                    UUID oldClusterId = ReliableChannel.this.clusterId.compareAndExchange(null, currentClusterId);
                    List<UUID> validClusterIds = ch.protocolContext().clusterIds();
                    if (oldClusterId != null && !validClusterIds.contains(oldClusterId)) {
                        try {
                            ch.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new IgniteClientConnectionException(ErrorGroups.Client.CLUSTER_ID_MISMATCH_ERR, "Cluster ID mismatch: expected=" + String.valueOf(oldClusterId) + ", actual=" + String.join((CharSequence)(", " + String.valueOf(validClusterIds)), new CharSequence[0]), ch.endpoint());
                    }
                    ClusterNode newNode = ch.protocolContext().clusterNode();
                    ReliableChannel.this.nodeChannelsByName.put(newNode.name(), this);
                    ClusterNode oldServerNode = this.serverNode;
                    if (oldServerNode != null && !oldServerNode.id().equals(newNode.id())) {
                        ReliableChannel.this.nodeChannelsByName.remove(oldServerNode.name(), this);
                    }
                    this.serverNode = newNode;
                    return ch;
                });
                ((CompletableFuture)chFut0).exceptionally(err -> {
                    this.closeChannel();
                    ReliableChannel.this.onChannelFailure(this, null);
                    ReliableChannel.this.log.warn("Failed to establish connection to " + String.valueOf(this.chCfg.getAddress()) + ": " + err.getMessage(), (Throwable)err);
                    return null;
                });
                this.chFut = chFut0;
                return chFut0;
            }
        }

        @Nullable
        private ClientChannel getNow() {
            if (this.close) {
                return null;
            }
            CompletableFuture<ClientChannel> f = this.chFut;
            if (f == null) {
                return null;
            }
            ClientChannel ch = ClientFutureUtils.getNowSafe(f);
            if (ch == null || ch.closed()) {
                return null;
            }
            return ch;
        }

        private synchronized void closeChannel() {
            CompletableFuture<ClientChannel> ch0 = this.chFut;
            if (ch0 != null) {
                ch0.thenAccept(c -> {
                    try {
                        c.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                ClusterNode oldServerNode = this.serverNode;
                if (oldServerNode != null) {
                    ReliableChannel.this.nodeChannelsByName.remove(oldServerNode.name(), this);
                }
                this.chFut = null;
            }
        }

        void close() {
            this.close = true;
            ClusterNode oldServerNode = this.serverNode;
            if (oldServerNode != null) {
                ReliableChannel.this.nodeChannelsByName.remove(oldServerNode.name(), this);
            }
            this.closeChannel();
        }

        private boolean isFutureInProgressOrDoneAndChannelOpen(@Nullable CompletableFuture<ClientChannel> f) {
            if (f == null || f.isCompletedExceptionally()) {
                return false;
            }
            if (!f.isDone()) {
                return true;
            }
            ClientChannel ch = ClientFutureUtils.getNowSafe(f);
            return ch != null && !ch.closed();
        }
    }
}

