/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.sse.Event;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.util.KotlinExecutableMethodUtils;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.Route;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface RouteInfo<R>
extends AnnotationMetadataProvider {
    public ReturnType<? extends R> getReturnType();

    default public Argument<?> getBodyType() {
        ReturnType<R> returnType = this.getReturnType();
        if (returnType.isAsyncOrReactive()) {
            Argument reactiveType = returnType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            if (HttpResponse.class.isAssignableFrom(reactiveType.getType())) {
                reactiveType = reactiveType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            }
            return reactiveType;
        }
        if (HttpResponse.class.isAssignableFrom(returnType.getType())) {
            Argument responseType = returnType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            if (responseType.isAsyncOrReactive()) {
                return responseType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            }
            return responseType;
        }
        return returnType.asArgument();
    }

    public Class<?> getDeclaringType();

    default public List<MediaType> getProduces() {
        Object[] types = MediaType.of((CharSequence[])this.getAnnotationMetadata().stringValues(Produces.class));
        Optional firstTypeVariable = this.getReturnType().getFirstTypeVariable();
        if (firstTypeVariable.isPresent() && Event.class.isAssignableFrom(((Argument)firstTypeVariable.get()).getType())) {
            return Collections.singletonList(MediaType.TEXT_EVENT_STREAM_TYPE);
        }
        if (ArrayUtils.isNotEmpty((Object[])types)) {
            return Collections.unmodifiableList(Arrays.asList(types));
        }
        return Route.DEFAULT_PRODUCES;
    }

    default public List<MediaType> getConsumes() {
        Object[] types = MediaType.of((CharSequence[])this.getAnnotationMetadata().stringValues(Consumes.class));
        if (ArrayUtils.isNotEmpty((Object[])types)) {
            return Collections.unmodifiableList(Arrays.asList(types));
        }
        return Collections.emptyList();
    }

    default public boolean isSuspended() {
        return this.getReturnType().isSuspended();
    }

    default public boolean isReactive() {
        return this.getReturnType().isReactive();
    }

    default public boolean isSingleResult() {
        ReturnType<R> returnType = this.getReturnType();
        return returnType.isSingleResult() || this.isReactive() && returnType.getFirstTypeVariable().filter(t -> HttpResponse.class.isAssignableFrom(t.getType())).isPresent() || returnType.isAsync() || returnType.isSuspended();
    }

    default public boolean isSpecifiedSingle() {
        return this.getReturnType().isSpecifiedSingle();
    }

    default public boolean isCompletable() {
        return this.getReturnType().isCompletable();
    }

    default public boolean isAsync() {
        return this.getReturnType().isAsync();
    }

    default public boolean isAsyncOrReactive() {
        return this.getReturnType().isAsyncOrReactive();
    }

    default public boolean isVoid() {
        if (this.getReturnType().isVoid()) {
            return true;
        }
        if (this instanceof MethodBasedRouteMatch && this.isSuspended()) {
            return KotlinExecutableMethodUtils.isKotlinFunctionReturnTypeUnit((ExecutableMethod)((MethodBasedRouteMatch)this).getExecutableMethod());
        }
        return false;
    }

    default public boolean isErrorRoute() {
        return false;
    }

    @NonNull
    default public HttpStatus findStatus(HttpStatus defaultStatus) {
        return this.getAnnotationMetadata().enumValue(Status.class, HttpStatus.class).orElse(defaultStatus);
    }

    default public boolean isWebSocketRoute() {
        return this.getAnnotationMetadata().hasAnnotation("io.micronaut.websocket.annotation.OnMessage");
    }
}

