/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class ObjectIdGenUpdateEntry
implements UpdateEntry {
    public static final CatalogObjectSerializer<ObjectIdGenUpdateEntry> SERIALIZER = new ObjectIdGenUpdateEntrySerializer();
    private final int delta;

    public ObjectIdGenUpdateEntry(int delta) {
        this.delta = delta;
    }

    public int delta() {
        return this.delta;
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, long causalityToken) {
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState() + this.delta, catalog.zones(), catalog.schemas(), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.ID_GENERATOR.id();
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class ObjectIdGenUpdateEntrySerializer
    implements CatalogObjectSerializer<ObjectIdGenUpdateEntry> {
        private ObjectIdGenUpdateEntrySerializer() {
        }

        @Override
        public ObjectIdGenUpdateEntry readFrom(IgniteDataInput input) throws IOException {
            int delta = input.readVarIntAsInt();
            return new ObjectIdGenUpdateEntry(delta);
        }

        @Override
        public void writeTo(ObjectIdGenUpdateEntry entry, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)entry.delta());
        }
    }
}

