/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.DataRegion;
import org.apache.ignite.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointManager;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointState;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.util.GradualTaskExecutor;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryDataRegion;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.StoragePartitionMeta;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryStorageEngineView;
import org.apache.ignite.internal.storage.pagememory.index.hash.PageMemoryHashIndexStorage;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite.internal.storage.pagememory.index.sorted.PageMemorySortedIndexStorage;
import org.apache.ignite.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.pagememory.mv.BlobStorage;
import org.apache.ignite.internal.storage.pagememory.mv.ConsistentGradualTaskExecutor;
import org.apache.ignite.internal.storage.pagememory.mv.RenewablePartitionStorageState;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite.internal.storage.pagememory.mv.gc.GcQueue;
import org.apache.ignite.internal.storage.util.LocalLocker;
import org.apache.ignite.internal.storage.util.StorageState;
import org.apache.ignite.internal.storage.util.StorageUtils;
import org.apache.ignite.internal.util.ByteUtils;
import org.jetbrains.annotations.Nullable;

public class PersistentPageMemoryMvPartitionStorage
extends AbstractPageMemoryMvPartitionStorage {
    private final CheckpointManager checkpointManager;
    private final CheckpointTimeoutLock checkpointTimeoutLock;
    private volatile StoragePartitionMeta meta;
    private final CheckpointListener checkpointListener;
    private volatile BlobStorage blobStorage;
    private final ReadWriteLock replicationProtocolGroupConfigReadWriteLock = new ReentrantReadWriteLock();
    private final ReadWriteLock primaryReplicaMetaReadWriteLock = new ReentrantReadWriteLock();
    private String primaryReplicaNodeName;

    public PersistentPageMemoryMvPartitionStorage(PersistentPageMemoryTableStorage tableStorage, int partitionId, StoragePartitionMeta meta, FreeListImpl freeList, VersionChainTree versionChainTree, IndexMetaTree indexMetaTree, GcQueue gcQueue, ExecutorService destructionExecutor) {
        super(partitionId, tableStorage, new RenewablePartitionStorageState(tableStorage, partitionId, versionChainTree, freeList, indexMetaTree, gcQueue), destructionExecutor);
        this.checkpointManager = tableStorage.engine().checkpointManager();
        this.checkpointTimeoutLock = this.checkpointManager.checkpointTimeoutLock();
        PersistentPageMemoryDataRegion dataRegion = tableStorage.dataRegion();
        this.meta = meta;
        this.checkpointListener = new CheckpointListener(){

            public void beforeCheckpointBegin(CheckpointProgress progress, @Nullable Executor exec) throws IgniteInternalCheckedException {
                PersistentPageMemoryMvPartitionStorage.this.syncMetadataOnCheckpoint(exec);
            }

            public void onMarkCheckpointBegin(CheckpointProgress progress, @Nullable Executor exec) throws IgniteInternalCheckedException {
                PersistentPageMemoryMvPartitionStorage.this.syncMetadataOnCheckpoint(exec);
            }
        };
        this.checkpointManager.addCheckpointListener(this.checkpointListener, (DataRegion)dataRegion);
        this.blobStorage = new BlobStorage((ReuseList)freeList, dataRegion.pageMemory(), tableStorage.getTableId(), partitionId, (IoStatisticsHolder)IoStatisticsHolderNoOp.INSTANCE);
    }

    @Override
    protected GradualTaskExecutor createGradualTaskExecutor(ExecutorService threadPool) {
        return new ConsistentGradualTaskExecutor(this, threadPool);
    }

    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        LocalLocker locker = (LocalLocker)THREAD_LOCAL_LOCKER.get();
        if (locker != null) {
            return (V)closure.execute((MvPartitionStorage.Locker)locker);
        }
        return (V)this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
            LocalLocker locker0 = new LocalLocker(this.lockByRowId);
            this.checkpointTimeoutLock.checkpointReadLock();
            THREAD_LOCAL_LOCKER.set(locker0);
            try {
                Object object = closure.execute((MvPartitionStorage.Locker)locker0);
                return object;
            }
            finally {
                THREAD_LOCAL_LOCKER.set(null);
                locker0.unlockAll();
                this.checkpointTimeoutLock.checkpointReadUnlock();
            }
        });
    }

    public CompletableFuture<Void> flush(boolean trigger) {
        return this.busy(() -> {
            CheckpointProgress scheduledCheckpoint;
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
            CheckpointProgress lastCheckpoint = this.checkpointManager.lastCheckpointProgress();
            if (!trigger) {
                scheduledCheckpoint = this.checkpointManager.scheduleCheckpoint(Integer.MAX_VALUE, "subscribe to next checkpoint");
            } else if (lastCheckpoint != null && this.meta.metaSnapshot(lastCheckpoint.id()).lastAppliedIndex() == this.meta.lastAppliedIndex()) {
                scheduledCheckpoint = lastCheckpoint;
            } else {
                PersistentPageMemoryTableStorage persistentTableStorage = (PersistentPageMemoryTableStorage)this.tableStorage;
                PersistentPageMemoryStorageEngineView engineCfg = (PersistentPageMemoryStorageEngineView)persistentTableStorage.engine().configuration().value();
                int checkpointDelayMillis = engineCfg.checkpoint().checkpointDelayMillis();
                scheduledCheckpoint = this.checkpointManager.scheduleCheckpoint((long)checkpointDelayMillis, "Triggered by replicator");
            }
            return scheduledCheckpoint.futureFor(CheckpointState.FINISHED);
        });
    }

    public long lastAppliedIndex() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
            return this.meta.lastAppliedIndex();
        });
    }

    public long lastAppliedTerm() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
            return this.meta.lastAppliedTerm();
        });
    }

    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.lastAppliedBusy(lastAppliedIndex, lastAppliedTerm);
            return null;
        });
    }

    private void lastAppliedBusy(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        this.updateMeta((lastCheckpointId, meta) -> meta.lastApplied(lastCheckpointId, lastAppliedIndex, lastAppliedTerm));
    }

    private void updateMeta(MetaUpdateClosure closure) {
        assert (this.checkpointTimeoutLock.checkpointLockIsHeldByThread());
        CheckpointProgress lastCheckpoint = this.checkpointManager.lastCheckpointProgress();
        UUID lastCheckpointId = lastCheckpoint == null ? null : lastCheckpoint.id();
        closure.update(lastCheckpointId, this.meta);
        this.checkpointManager.markPartitionAsDirty(this.tableStorage.dataRegion(), this.tableStorage.getTableId(), this.partitionId);
    }

    public byte @Nullable [] committedGroupConfiguration() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
            try {
                this.replicationProtocolGroupConfigReadWriteLock.readLock().lock();
                try {
                    long configFirstPageId = this.meta.lastReplicationProtocolGroupConfigFirstPageId();
                    if (configFirstPageId == 0L) {
                        byte[] byArray = null;
                        return byArray;
                    }
                    byte[] byArray = this.blobStorage.readBlob(this.meta.lastReplicationProtocolGroupConfigFirstPageId());
                    return byArray;
                }
                finally {
                    this.replicationProtocolGroupConfigReadWriteLock.readLock().unlock();
                }
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Failed to read group config: [tableId={}, partitionId={}]", (Throwable)e, new Object[]{this.tableStorage.getTableId(), this.partitionId});
            }
        });
    }

    public void committedGroupConfiguration(byte[] config) {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.committedGroupConfigurationBusy(config);
            return null;
        });
    }

    public void updateLease(long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.updateLeaseBusy(leaseStartTime, primaryReplicaNodeId, primaryReplicaNodeName);
            return null;
        });
    }

    private void updateLeaseBusy(long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        this.updateMeta((lastCheckpointId, meta) -> {
            this.primaryReplicaMetaReadWriteLock.writeLock().lock();
            try {
                if (leaseStartTime <= meta.leaseStartTime()) {
                    return;
                }
                meta.primaryReplicaNodeId(lastCheckpointId, primaryReplicaNodeId);
                if (meta.primaryReplicaNodeNameFirstPageId() == 0L) {
                    long primaryReplicaNodeNameFirstPageId = this.blobStorage.addBlob(ByteUtils.stringToBytes((String)primaryReplicaNodeName));
                    meta.primaryReplicaNodeNameFirstPageId(lastCheckpointId, primaryReplicaNodeNameFirstPageId);
                } else {
                    this.blobStorage.updateBlob(meta.primaryReplicaNodeNameFirstPageId(), ByteUtils.stringToBytes((String)primaryReplicaNodeName));
                }
                meta.updateLease(lastCheckpointId, leaseStartTime);
                this.primaryReplicaNodeName = primaryReplicaNodeName;
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Cannot save lease meta: [tableId={}, partitionId={}]", (Throwable)e, new Object[]{this.tableStorage.getTableId(), this.partitionId});
            }
            finally {
                this.primaryReplicaMetaReadWriteLock.writeLock().unlock();
            }
        });
    }

    public long leaseStartTime() {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            return this.meta.leaseStartTime();
        });
    }

    @Nullable
    public UUID primaryReplicaNodeId() {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            return this.meta.primaryReplicaNodeId();
        });
    }

    @Nullable
    public String primaryReplicaNodeName() {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.primaryReplicaMetaReadWriteLock.readLock().lock();
            try {
                long primaryReplicaNodeNameFirstPageId22;
                if (this.primaryReplicaNodeName == null && (primaryReplicaNodeNameFirstPageId22 = this.meta.primaryReplicaNodeNameFirstPageId()) != 0L) {
                    this.primaryReplicaNodeName = ByteUtils.stringFromBytes((byte[])this.blobStorage.readBlob(primaryReplicaNodeNameFirstPageId22));
                }
                String primaryReplicaNodeNameFirstPageId22 = this.primaryReplicaNodeName;
                return primaryReplicaNodeNameFirstPageId22;
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Failed to read primary replica node name: [tableId={}, partitionId={}]", (Throwable)e, new Object[]{this.tableStorage.getTableId(), this.partitionId});
            }
            finally {
                this.primaryReplicaMetaReadWriteLock.readLock().unlock();
            }
        });
    }

    private void committedGroupConfigurationBusy(byte[] groupConfigBytes) {
        this.updateMeta((lastCheckpointId, meta) -> {
            this.replicationProtocolGroupConfigReadWriteLock.writeLock().lock();
            try {
                if (meta.lastReplicationProtocolGroupConfigFirstPageId() == 0L) {
                    long configPageId = this.blobStorage.addBlob(groupConfigBytes);
                    meta.lastReplicationProtocolGroupConfigFirstPageId(lastCheckpointId, configPageId);
                } else {
                    this.blobStorage.updateBlob(meta.lastReplicationProtocolGroupConfigFirstPageId(), groupConfigBytes);
                }
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Cannot save committed group configuration: [tableId={}, partitionId={}]", (Throwable)e, new Object[]{this.tableStorage.getTableId(), this.partitionId});
            }
            finally {
                this.replicationProtocolGroupConfigReadWriteLock.writeLock().unlock();
            }
        });
    }

    @Override
    public PageMemoryHashIndexStorage getOrCreateHashIndex(StorageHashIndexDescriptor indexDescriptor) {
        return (PageMemoryHashIndexStorage)this.runConsistently(locker -> super.getOrCreateHashIndex(indexDescriptor));
    }

    @Override
    public PageMemorySortedIndexStorage getOrCreateSortedIndex(StorageSortedIndexDescriptor indexDescriptor) {
        return (PageMemorySortedIndexStorage)this.runConsistently(locker -> super.getOrCreateSortedIndex(indexDescriptor));
    }

    @Override
    protected List<AutoCloseable> getResourcesToClose() {
        List<AutoCloseable> resourcesToClose = super.getResourcesToClose();
        resourcesToClose.add(() -> this.checkpointManager.removeCheckpointListener(this.checkpointListener));
        RenewablePartitionStorageState localState = this.renewableState;
        resourcesToClose.add(() -> ((FreeListImpl)localState.freeList()).close());
        resourcesToClose.add(() -> ((BlobStorage)this.blobStorage).close());
        return resourcesToClose;
    }

    private void syncMetadataOnCheckpoint(@Nullable Executor executor) {
        RenewablePartitionStorageState localState = this.renewableState;
        if (executor == null) {
            this.busySafe(() -> this.saveFreeListMetadataBusy(localState));
        } else {
            executor.execute(() -> this.busySafe(() -> this.saveFreeListMetadataBusy(localState)));
        }
    }

    @Override
    public void lastAppliedOnRebalance(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
        this.lastAppliedBusy(lastAppliedIndex, lastAppliedTerm);
    }

    public void updateDataStructures(StoragePartitionMeta meta, FreeListImpl freeList, VersionChainTree versionChainTree, IndexMetaTree indexMetaTree, GcQueue gcQueue) {
        StorageUtils.throwExceptionIfStorageNotInCleanupOrRebalancedState((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
        this.meta = meta;
        this.blobStorage = new BlobStorage((ReuseList)freeList, this.tableStorage.dataRegion().pageMemory(), this.tableStorage.getTableId(), this.partitionId, (IoStatisticsHolder)IoStatisticsHolderNoOp.INSTANCE);
        this.updateRenewableState(versionChainTree, freeList, indexMetaTree, gcQueue);
    }

    @Override
    List<AutoCloseable> getResourcesToCloseOnCleanup() {
        RenewablePartitionStorageState localState = this.renewableState;
        return List.of(() -> ((FreeListImpl)localState.freeList()).close(), () -> ((VersionChainTree)localState.versionChainTree()).close(), () -> ((IndexMetaTree)localState.indexMetaTree()).close(), () -> ((GcQueue)localState.gcQueue()).close(), () -> ((BlobStorage)this.blobStorage).close());
    }

    @Override
    public void committedGroupConfigurationOnRebalance(byte[] config) {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
        this.committedGroupConfigurationBusy(config);
    }

    @Override
    public void updateLeaseOnRebalance(long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
        this.updateLeaseBusy(leaseStartTime, primaryReplicaNodeId, primaryReplicaNodeName);
    }

    private void saveFreeListMetadataBusy(RenewablePartitionStorageState localState) {
        try {
            localState.freeList().saveMetadata();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Failed to save free list metadata: [{}]", (Throwable)e, new Object[]{this.createStorageInfo()});
        }
    }

    public long estimatedSize() {
        return this.meta.estimatedSize();
    }

    @Override
    public void incrementEstimatedSize() {
        this.updateMeta((lastCheckpointId, meta) -> meta.incrementEstimatedSize(lastCheckpointId));
    }

    @Override
    public void decrementEstimatedSize() {
        this.updateMeta((lastCheckpointId, meta) -> meta.decrementEstimatedSize(lastCheckpointId));
    }

    @FunctionalInterface
    private static interface MetaUpdateClosure {
        public void update(UUID var1, StoragePartitionMeta var2);
    }
}

