/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v5;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.inbox.storage.proto.LWT;
import org.apache.bifromq.mqtt.spi.IUserPropsCustomizer;
import org.apache.bifromq.mqtt.spi.UserProperty;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.QoS;
import org.apache.bifromq.type.StringPair;
import org.apache.bifromq.type.UserProperties;

public class MQTT5MessageUtils {
    public static MqttPropertiesBuilder mqttProps() {
        return new MqttPropertiesBuilder();
    }

    public static MqttProperties.UserProperties toMqttUserProps(UserProperties userProperties) {
        MqttProperties.UserProperties userProps = new MqttProperties.UserProperties();
        for (StringPair stringPair : userProperties.getUserPropertiesList()) {
            userProps.add(stringPair.getKey(), stringPair.getValue());
        }
        return userProps;
    }

    public static UserProperties toUserProperties(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.toUserPropertiesBuilder(mqttProperties).build();
    }

    private static UserProperties.Builder toUserPropertiesBuilder(MqttProperties mqttProperties) {
        UserProperties.Builder userPropsBuilder = UserProperties.newBuilder();
        List userPropertyList = mqttProperties.getProperties(MqttProperties.MqttPropertyType.USER_PROPERTY.value());
        if (!userPropertyList.isEmpty()) {
            userPropertyList.forEach(up -> userPropsBuilder.addUserProperties(StringPair.newBuilder().setKey(((MqttProperties.StringPair)up.value()).key).setValue(((MqttProperties.StringPair)up.value()).value).build()));
        }
        return userPropsBuilder;
    }

    public static boolean isUTF8Payload(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.packetFormatIndicator(mqttProperties).map(i -> i == 1).orElse(false);
    }

    public static Optional<Integer> receiveMaximum(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.integerMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.RECEIVE_MAXIMUM);
    }

    public static Optional<Integer> topicAliasMaximum(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.integerMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.TOPIC_ALIAS_MAXIMUM);
    }

    public static Optional<Integer> subscriptionIdentifier(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.integerMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER);
    }

    public static Optional<Integer> maximumPacketSize(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.integerMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.MAXIMUM_PACKET_SIZE);
    }

    public static Optional<Integer> topicAlias(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.integerMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.TOPIC_ALIAS);
    }

    static Optional<Integer> packetFormatIndicator(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.integerMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR);
    }

    public static Optional<Integer> messageExpiryInterval(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.integerMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.PUBLICATION_EXPIRY_INTERVAL);
    }

    public static Optional<String> contentType(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.stringMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.CONTENT_TYPE);
    }

    public static Optional<String> responseTopic(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.stringMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.RESPONSE_TOPIC);
    }

    public static Optional<String> authMethod(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.stringMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.AUTHENTICATION_METHOD);
    }

    public static Optional<ByteString> authData(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.binaryMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.AUTHENTICATION_DATA);
    }

    public static boolean requestResponseInformation(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.integerMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.REQUEST_RESPONSE_INFORMATION).orElse(0) == 1;
    }

    public static boolean requestProblemInformation(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.integerMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.REQUEST_PROBLEM_INFORMATION).orElse(1) == 1;
    }

    public static Optional<String> reasonString(MqttProperties mqttProperties) {
        return MQTT5MessageUtils.stringMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.REASON_STRING);
    }

    static Optional<Integer> integerMqttProperty(MqttProperties mqttProperties, MqttProperties.MqttPropertyType type) {
        return Optional.ofNullable((MqttProperties.IntegerProperty)mqttProperties.getProperty(type.value())).map(MqttProperties.MqttProperty::value);
    }

    static Optional<String> stringMqttProperty(MqttProperties mqttProperties, MqttProperties.MqttPropertyType type) {
        return Optional.ofNullable((MqttProperties.StringProperty)mqttProperties.getProperty(type.value())).map(MqttProperties.MqttProperty::value);
    }

    static Optional<ByteString> binaryMqttProperty(MqttProperties mqttProperties, MqttProperties.MqttPropertyType type) {
        return Optional.ofNullable((MqttProperties.BinaryProperty)mqttProperties.getProperty(type.value())).map(MqttProperties.MqttProperty::value).map(UnsafeByteOperations::unsafeWrap);
    }

    static LWT toWillMessage(MqttConnectMessage connMsg, ClientInfo clientInfo, IUserPropsCustomizer userPropsCustomizer) {
        String willTopic = connMsg.payload().willTopic();
        QoS willQoS = QoS.forNumber((int)connMsg.variableHeader().willQos());
        ByteString willPayload = UnsafeByteOperations.unsafeWrap((byte[])connMsg.payload().willMessageInBytes());
        long now = HLC.INST.get();
        Iterable extraUserProps = userPropsCustomizer.inbound(willTopic, willQoS, willPayload, clientInfo, now);
        LWT.Builder lwtBuilder = LWT.newBuilder().setTopic(connMsg.payload().willTopic()).setDelaySeconds(MQTT5MessageUtils.integerMqttProperty(connMsg.payload().willProperties(), MqttProperties.MqttPropertyType.WILL_DELAY_INTERVAL).orElse(0).intValue());
        Message willMsg = MQTT5MessageUtils.toMessage(0L, QoS.forNumber((int)connMsg.variableHeader().willQos()), connMsg.variableHeader().isWillRetain(), connMsg.payload().willProperties(), UnsafeByteOperations.unsafeWrap((byte[])connMsg.payload().willMessageInBytes()), now, extraUserProps);
        return lwtBuilder.setMessage(willMsg).build();
    }

    static Message toMessage(MqttPublishMessage pubMsg, ClientInfo publisher, IUserPropsCustomizer userPropsCustomizer) {
        String topic = pubMsg.variableHeader().topicName();
        QoS pubQoS = QoS.forNumber((int)pubMsg.fixedHeader().qosLevel().value());
        ByteString payload = ByteString.copyFrom((ByteBuffer)pubMsg.payload().nioBuffer());
        long now = HLC.INST.get();
        Iterable extraUserProps = userPropsCustomizer.inbound(topic, pubQoS, payload, publisher, now);
        long pubMsgId = pubMsg.variableHeader().packetId();
        boolean isRetain = pubMsg.fixedHeader().isRetain();
        MqttProperties mqttProperties = pubMsg.variableHeader().properties();
        return MQTT5MessageUtils.toMessage(pubMsgId, pubQoS, isRetain, mqttProperties, payload, now, extraUserProps);
    }

    static Message toMessage(long packetId, QoS pubQoS, boolean isRetain, MqttProperties mqttProperties, ByteString payload, long hlc, Iterable<UserProperty> extraUserProps) {
        Message.Builder msgBuilder = Message.newBuilder().setMessageId(packetId).setPubQoS(pubQoS).setPayload(payload).setTimestamp(hlc).setExpiryInterval(MQTT5MessageUtils.messageExpiryInterval(mqttProperties).orElse(Integer.MAX_VALUE).intValue()).setIsRetain(isRetain);
        MQTT5MessageUtils.packetFormatIndicator(mqttProperties).ifPresent(integer -> msgBuilder.setIsUTF8String(integer == 1));
        MQTT5MessageUtils.contentType(mqttProperties).ifPresent(arg_0 -> ((Message.Builder)msgBuilder).setContentType(arg_0));
        MQTT5MessageUtils.responseTopic(mqttProperties).ifPresent(arg_0 -> ((Message.Builder)msgBuilder).setResponseTopic(arg_0));
        Optional<ByteString> correlationData = MQTT5MessageUtils.binaryMqttProperty(mqttProperties, MqttProperties.MqttPropertyType.CORRELATION_DATA);
        correlationData.ifPresent(arg_0 -> ((Message.Builder)msgBuilder).setCorrelationData(arg_0));
        UserProperties.Builder userPropertiesBuilder = MQTT5MessageUtils.toUserPropertiesBuilder(mqttProperties);
        extraUserProps.forEach(pair -> userPropertiesBuilder.addUserProperties(StringPair.newBuilder().setKey(pair.key()).setValue(pair.value()).build()));
        UserProperties userProperties = userPropertiesBuilder.build();
        if (userProperties.getUserPropertiesCount() > 0) {
            msgBuilder.setUserProperties(userProperties);
        }
        return msgBuilder.build();
    }

    public static class MqttPropertiesBuilder {
        private final MqttProperties mqttProperties = new MqttProperties();

        public MqttPropertiesBuilder addSubscriptionIdentifier(int value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(value)));
            return this;
        }

        public MqttPropertiesBuilder addReceiveMaximum(int value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.RECEIVE_MAXIMUM.value(), Integer.valueOf(value)));
            return this;
        }

        public MqttPropertiesBuilder addTopicAliasMaximum(int value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.TOPIC_ALIAS_MAXIMUM.value(), Integer.valueOf(value)));
            return this;
        }

        public MqttPropertiesBuilder addMaximumPacketSize(int value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.MAXIMUM_PACKET_SIZE.value(), Integer.valueOf(value)));
            return this;
        }

        public MqttPropertiesBuilder addSessionExpiryInterval(int value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL.value(), Integer.valueOf(value)));
            return this;
        }

        public MqttPropertiesBuilder addServerKeepAlive(int value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SERVER_KEEP_ALIVE.value(), Integer.valueOf(value)));
            return this;
        }

        public MqttPropertiesBuilder addServerReference(String value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.SERVER_REFERENCE.value(), value));
            return this;
        }

        public MqttPropertiesBuilder addTopicAlias(int value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.TOPIC_ALIAS.value(), Integer.valueOf(value)));
            return this;
        }

        public MqttPropertiesBuilder addUserProperty(String key, String value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty(key, value));
            return this;
        }

        public MqttPropertiesBuilder addUserProperties(UserProperties userProperties) {
            userProperties.getUserPropertiesList().forEach(pair -> this.addUserProperty(pair.getKey(), pair.getValue()));
            return this;
        }

        public MqttPropertiesBuilder addPayloadFormatIndicator(int value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(value)));
            return this;
        }

        public MqttPropertiesBuilder addContentType(String value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.CONTENT_TYPE.value(), value));
            return this;
        }

        public MqttPropertiesBuilder addResponseTopic(String value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.RESPONSE_TOPIC.value(), value));
            return this;
        }

        public MqttPropertiesBuilder addCorrelationData(ByteString value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.BinaryProperty(MqttProperties.MqttPropertyType.CORRELATION_DATA.value(), value.toByteArray()));
            return this;
        }

        public MqttPropertiesBuilder addReasonString(String value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.REASON_STRING.value(), value));
            return this;
        }

        public MqttPropertiesBuilder addAuthMethod(String value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.AUTHENTICATION_METHOD.value(), value));
            return this;
        }

        public MqttPropertiesBuilder addAuthData(ByteString value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.BinaryProperty(MqttProperties.MqttPropertyType.AUTHENTICATION_DATA.value(), value.toByteArray()));
            return this;
        }

        public MqttPropertiesBuilder addRequestResponseInformation(boolean value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.REQUEST_RESPONSE_INFORMATION.value(), Integer.valueOf(value ? 1 : 0)));
            return this;
        }

        public MqttPropertiesBuilder addRequestProblemInformation(boolean value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.REQUEST_PROBLEM_INFORMATION.value(), Integer.valueOf(value ? 1 : 0)));
            return this;
        }

        public MqttPropertiesBuilder addMessageExpiryInterval(int value) {
            this.mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PUBLICATION_EXPIRY_INTERVAL.value(), Integer.valueOf(value)));
            return this;
        }

        public MqttProperties build() {
            return this.mqttProperties;
        }

        @Generated
        private MqttPropertiesBuilder() {
        }
    }
}

