/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import jakarta.ws.rs.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.apiserver.http.AnnotationUtil;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;
import org.apache.bifromq.apiserver.http.IHTTPRouteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPRouteMap
implements IHTTPRouteMap {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HTTPRouteMap.class);
    private static final IHTTPRequestHandler NO_ROUTE_HANDLER = (reqId, httpRequest) -> CompletableFuture.completedFuture(new DefaultFullHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.BAD_REQUEST, Unpooled.EMPTY_BUFFER));
    private final Map<String, Map<HttpMethod, IHTTPRequestHandler>> routeMap = new HashMap<String, Map<HttpMethod, IHTTPRequestHandler>>();

    public HTTPRouteMap(Collection<? extends IHTTPRequestHandler> handlers) {
        for (IHTTPRequestHandler iHTTPRequestHandler : handlers) {
            Path route = iHTTPRequestHandler.getClass().getAnnotation(Path.class);
            if (route != null) {
                Map methodsMap = this.routeMap.computeIfAbsent(route.value(), k -> new HashMap());
                HttpMethod method = AnnotationUtil.getHTTPMethod(iHTTPRequestHandler.getClass());
                if (method != null) {
                    IHTTPRequestHandler prev = methodsMap.put(method, iHTTPRequestHandler);
                    assert (prev == null) : "Path conflict: " + route.value();
                    continue;
                }
                log.warn("No http method specified for http request handler: {}", (Object)iHTTPRequestHandler.getClass().getName());
                continue;
            }
            log.warn("No Route annotation found for HTTPRequestHandler: {}", (Object)iHTTPRequestHandler.getClass().getName());
        }
    }

    @Override
    public IHTTPRequestHandler getHandler(HttpRequest req) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(req.uri());
        return this.routeMap.getOrDefault(queryStringDecoder.path(), Collections.emptyMap()).getOrDefault(req.method(), NO_ROUTE_HANDLER);
    }
}

