/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.memory;

import com.google.protobuf.ByteString;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bifromq.basekv.localengine.IKVSpaceEpoch;
import org.pcollections.HashPMap;
import org.pcollections.HashTreePMap;
import org.pcollections.TreePMap;

class InMemKVSpaceEpoch
implements IKVSpaceEpoch {
    private final AtomicReference<HashPMap<ByteString, ByteString>> metadataMap;
    private final AtomicReference<TreePMap<ByteString, ByteString>> dataMap;
    private final AtomicLong totalDataBytes;

    InMemKVSpaceEpoch() {
        this.metadataMap = new AtomicReference<HashPMap>(HashTreePMap.empty());
        this.dataMap = new AtomicReference<TreePMap>(TreePMap.empty((Comparator)ByteString.unsignedLexicographicalComparator()));
        this.totalDataBytes = new AtomicLong(0L);
    }

    InMemKVSpaceEpoch(InMemKVSpaceEpoch overlay) {
        this.metadataMap = new AtomicReference<HashPMap<ByteString, ByteString>>(overlay.metadataMap.get());
        this.dataMap = new AtomicReference<TreePMap<ByteString, ByteString>>(overlay.dataMap.get());
        this.totalDataBytes = new AtomicLong(overlay.totalDataBytes.get());
    }

    Map<ByteString, ByteString> metadataMap() {
        return (Map)this.metadataMap.get();
    }

    NavigableMap<ByteString, ByteString> dataMap() {
        return (NavigableMap)this.dataMap.get();
    }

    long totalDataBytes() {
        return this.totalDataBytes.get();
    }

    void setMetadata(ByteString key, ByteString value) {
        this.metadataMap.updateAndGet(m -> m.plus((Object)key, (Object)value));
    }

    void removeMetadata(ByteString key) {
        this.metadataMap.updateAndGet(m -> m.minus((Object)key));
    }

    void putData(ByteString key, ByteString value) {
        TreePMap<ByteString, ByteString> current = this.dataMap.get();
        ByteString old = (ByteString)current.get((Object)key);
        long oldBytes = old == null ? 0L : (long)key.size() + (long)old.size();
        long newBytes = (long)key.size() + (long)value.size();
        this.totalDataBytes.addAndGet(newBytes - oldBytes);
        this.dataMap.set((TreePMap<ByteString, ByteString>)current.plus((Object)key, (Object)value));
    }

    void removeData(ByteString key) {
        TreePMap<ByteString, ByteString> current = this.dataMap.get();
        ByteString old = (ByteString)current.get((Object)key);
        if (old != null) {
            this.totalDataBytes.addAndGet(-((long)key.size() + (long)old.size()));
            this.dataMap.set((TreePMap<ByteString, ByteString>)current.minus((Object)key));
        }
    }
}

